/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.util.Enumeration;
import javax.swing.table.DefaultTableModel;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.LinorgFieldView;

public class ImdiFieldViewTableModel
extends DefaultTableModel {
    private ImdiTableModel imdiTableModel;
    Class[] types = new Class[]{String.class, Boolean.class, Boolean.class, Boolean.class};
    private int showOnlyEnabledCount = -1;
    private final int showOnlyColumn = 1;
    private final int fieldNameColumn = 0;
    private final int hideColumn = 2;

    public ImdiFieldViewTableModel(ImdiTableModel localImdiTableModel) {
        this.imdiTableModel = localImdiTableModel;
        this.setColumnIdentifiers(new String[]{"Column Name", "Show Only", "Hide"});
        LinorgFieldView currentView = this.imdiTableModel.getFieldView();
        if (currentView != null) {
            Enumeration knownColumnNames = currentView.getKnownColumns();
            while (knownColumnNames.hasMoreElements()) {
                String currentFieldName = knownColumnNames.nextElement().toString();
                this.addRow(new Object[]{currentFieldName, currentView.isShowOnlyColumn(currentFieldName), currentView.isHiddenColumn(currentFieldName)});
            }
        }
    }

    public Class getColumnClass(int columnIndex) {
        return this.types[columnIndex];
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 2) {
            if (this.showOnlyEnabledCount < 0) {
                this.showOnlyEnabledCount = 0;
                for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                    if (!this.getValueAt(rowCounter, 1).equals(true)) continue;
                    ++this.showOnlyEnabledCount;
                }
            }
            return this.showOnlyEnabledCount == 0;
        }
        return column == 1 || column == 2;
    }

    public void setValueAt(Object aValue, int row, int column) {
        super.setValueAt(aValue, row, column);
        this.showOnlyEnabledCount = -1;
        boolean booleanState = aValue.equals(true);
        String targetColumnName = this.getValueAt(row, 0).toString();
        switch (column) {
            case 1: {
                if (booleanState) {
                    this.imdiTableModel.getFieldView().addShowOnlyColumn(targetColumnName);
                    break;
                }
                this.imdiTableModel.getFieldView().removeShowOnlyColumn(targetColumnName);
                break;
            }
            case 2: {
                if (booleanState) {
                    this.imdiTableModel.getFieldView().addHiddenColumn(targetColumnName);
                    break;
                }
                this.imdiTableModel.getFieldView().removeHiddenColumn(targetColumnName);
                break;
            }
            case 4: {
                if (booleanState) {
                    this.imdiTableModel.getFieldView().addAlwaysShowColumn(targetColumnName);
                    break;
                }
                this.imdiTableModel.getFieldView().removeAlwaysShowColumn(targetColumnName);
            }
        }
        this.imdiTableModel.requestReloadTableData();
        this.fireTableStructureChanged();
    }
}

