/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.net.URI;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.XsdChecker;
import nl.mpi.arbil.data.ImdiTreeObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImdiLoader {
    private boolean continueThread = true;
    public boolean schemaCheckLocalFiles = false;
    private Vector<ImdiTreeObject> imdiRemoteNodesToInit = new Vector();
    private Vector<ImdiTreeObject> imdiLocalNodesToInit = new Vector();
    private Hashtable<String, ImdiTreeObject> imdiHashTable = new Hashtable();
    private Vector<ImdiTreeObject> nodesNeedingSave = new Vector();
    int imdiFilesLoaded = 0;
    int remoteImdiFilesLoaded = 0;
    private static ImdiLoader singleInstance = null;

    public static synchronized ImdiLoader getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ImdiLoader();
        }
        return singleInstance;
    }

    private ImdiLoader() {
        int threadCounter;
        System.out.println("ImdiLoader init");
        this.schemaCheckLocalFiles = LinorgSessionStorage.getSingleInstance().loadBoolean("schemaCheckLocalFiles", this.schemaCheckLocalFiles);
        this.continueThread = true;
        for (threadCounter = 0; threadCounter < 6; ++threadCounter) {
            new Thread("ImdiLoader-remote-" + threadCounter){

                public void run() {
                    this.setPriority(4);
                    while (ImdiLoader.this.continueThread) {
                        try {
                            1.sleep(500L);
                        }
                        catch (InterruptedException ie) {
                            GuiHelper.linorgBugCatcher.logError(ie);
                        }
                        ImdiTreeObject currentImdiObject = ImdiLoader.this.getNodeFromQueue(ImdiLoader.this.imdiRemoteNodesToInit);
                        while (currentImdiObject != null) {
                            if (currentImdiObject != null) {
                                System.out.println("run RemoteImdiLoader processing: " + currentImdiObject.getUrlString());
                                currentImdiObject.loadImdiDom();
                                currentImdiObject.updateLoadingState(-1);
                                currentImdiObject.clearIcon();
                                currentImdiObject.clearChildIcons();
                                ++ImdiLoader.this.remoteImdiFilesLoaded;
                                currentImdiObject.notifyLoaded();
                            }
                            currentImdiObject = ImdiLoader.this.getNodeFromQueue(ImdiLoader.this.imdiRemoteNodesToInit);
                        }
                    }
                }
            }.start();
        }
        for (threadCounter = 0; threadCounter < 6; ++threadCounter) {
            new Thread("ImdiLoader-local-" + threadCounter){

                public void run() {
                    this.setPriority(4);
                    while (ImdiLoader.this.continueThread) {
                        try {
                            2.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            GuiHelper.linorgBugCatcher.logError(ie);
                        }
                        ImdiTreeObject currentImdiObject = ImdiLoader.this.getNodeFromQueue(ImdiLoader.this.imdiLocalNodesToInit);
                        while (currentImdiObject != null) {
                            System.out.println("run LocalImdiLoader processing: " + currentImdiObject.getUrlString());
                            ProgressMonitor progressMonitor = new ProgressMonitor(LinorgWindowManager.getSingleInstance().desktopPane, null, "Adding", 0, 100);
                            if (currentImdiObject.getNeedsSaveToDisk()) {
                                currentImdiObject.saveChangesToCache(false);
                            }
                            currentImdiObject.loadImdiDom();
                            if (ImdiLoader.this.schemaCheckLocalFiles) {
                                if (currentImdiObject.isMetaDataNode()) {
                                    XsdChecker xsdChecker = new XsdChecker();
                                    String checkerResult = xsdChecker.simpleCheck(currentImdiObject.getFile(), currentImdiObject.getURI());
                                    currentImdiObject.hasSchemaError = checkerResult != null;
                                }
                            } else {
                                currentImdiObject.hasSchemaError = false;
                            }
                            currentImdiObject.updateLoadingState(-1);
                            currentImdiObject.clearIcon();
                            currentImdiObject.clearChildIcons();
                            ++ImdiLoader.this.imdiFilesLoaded;
                            System.out.println("remoteImdiFilesLoaded: " + ImdiLoader.this.remoteImdiFilesLoaded + " imdiFilesLoaded: " + ImdiLoader.this.imdiFilesLoaded);
                            progressMonitor.close();
                            currentImdiObject.lockedByLoadingThread = false;
                            currentImdiObject.notifyLoaded();
                            currentImdiObject = ImdiLoader.this.getNodeFromQueue(ImdiLoader.this.imdiLocalNodesToInit);
                        }
                    }
                }
            }.start();
        }
    }

    private synchronized void addNodeToQueue(ImdiTreeObject nodeToAdd) {
        if (ImdiTreeObject.isStringLocal(nodeToAdd.getUrlString())) {
            if (!this.imdiLocalNodesToInit.contains(nodeToAdd)) {
                this.imdiLocalNodesToInit.addElement(nodeToAdd);
            }
        } else if (!this.imdiRemoteNodesToInit.contains(nodeToAdd)) {
            this.imdiRemoteNodesToInit.addElement(nodeToAdd);
        }
    }

    private synchronized ImdiTreeObject getNodeFromQueue(Vector<ImdiTreeObject> imdiNodesQueue) {
        if (imdiNodesQueue.size() > 0) {
            ImdiTreeObject tempImdiObject = imdiNodesQueue.remove(0);
            if (tempImdiObject.lockedByLoadingThread) {
                imdiNodesQueue.add(tempImdiObject);
                return null;
            }
            tempImdiObject.lockedByLoadingThread = true;
            return tempImdiObject;
        }
        return null;
    }

    public ImdiTreeObject getImdiObjectWithoutLoading(URI localUri) {
        ImdiTreeObject currentImdiObject = null;
        if (localUri != null && (currentImdiObject = this.imdiHashTable.get((localUri = ImdiTreeObject.normaliseURI(localUri)).toString())) == null) {
            currentImdiObject = new ImdiTreeObject(localUri);
            this.imdiHashTable.put(localUri.toString(), currentImdiObject);
        }
        return currentImdiObject;
    }

    public ImdiTreeObject getImdiObject(Object registeringObject, URI localUri) {
        ImdiTreeObject currentImdiObject = null;
        if (localUri != null && localUri.toString().length() > 0) {
            currentImdiObject = this.getImdiObjectWithoutLoading(localUri);
            if (!currentImdiObject.getParentDomNode().imdiDataLoaded && !currentImdiObject.isLoading()) {
                if (ImdiTreeObject.isStringImdiChild(currentImdiObject.getUrlString())) {
                    currentImdiObject.getParentDomNode();
                } else if (ImdiTreeObject.isPathMetadata(currentImdiObject.getUrlString()) || ImdiTreeObject.isPathHistoryFile(currentImdiObject.getUrlString())) {
                    currentImdiObject.updateLoadingState(1);
                    this.addNodeToQueue(currentImdiObject);
                    System.out.println("+imdiHashTable.size: " + this.imdiHashTable.size());
                } else if (!ImdiTreeObject.isPathMetadata(currentImdiObject.getUrlString())) {
                    // empty if block
                }
            }
            currentImdiObject.registerContainer(registeringObject);
        }
        return currentImdiObject;
    }

    public void releaseImdiObject(URI localUri) {
        localUri = ImdiTreeObject.normaliseURI(localUri);
        System.out.println("-imdiHashTable.size: " + this.imdiHashTable.size());
    }

    public ImdiTreeObject getImdiObjectOnlyIfLoaded(URI imdiUri) {
        imdiUri = ImdiTreeObject.normaliseURI(imdiUri);
        return this.imdiHashTable.get(imdiUri.toString());
    }

    public void requestReloadOnlyIfLoaded(URI imdiUri) {
        ImdiTreeObject currentImdiObject = this.imdiHashTable.get((imdiUri = ImdiTreeObject.normaliseURI(imdiUri)).toString());
        if (currentImdiObject != null) {
            this.requestReload(currentImdiObject);
        }
    }

    public void requestReload(ImdiTreeObject currentImdiObject) {
        if (currentImdiObject.isImdiChild()) {
            currentImdiObject = currentImdiObject.getParentDomNode();
        }
        this.removeNodesNeedingSave(currentImdiObject);
        this.addNodeToQueue(currentImdiObject);
    }

    public void requestReloadAllNodes() {
        for (ImdiTreeObject currentImdiObject : this.imdiHashTable.values()) {
            this.requestReload(currentImdiObject);
        }
    }

    protected void finalize() throws Throwable {
        this.continueThread = false;
        super.finalize();
    }

    public void addNodeNeedingSave(ImdiTreeObject nodeToSave) {
        if (!this.nodesNeedingSave.contains(nodeToSave)) {
            System.out.println("addNodeNeedingSave: " + nodeToSave);
            this.nodesNeedingSave.add(nodeToSave.getParentDomNode());
        }
    }

    public void removeNodesNeedingSave(ImdiTreeObject savedNode) {
        System.out.println("removeNodesNeedingSave: " + savedNode);
        this.nodesNeedingSave.remove(savedNode.getParentDomNode());
    }

    public ImdiTreeObject[] getNodesNeedSave() {
        return this.nodesNeedingSave.toArray(new ImdiTreeObject[0]);
    }

    public boolean nodesNeedSave() {
        return this.nodesNeedingSave.size() > 0;
    }

    public synchronized void saveNodesNeedingSave(boolean updateIcons) {
        while (this.nodesNeedingSave.size() > 0) {
            ImdiTreeObject currentNode = this.nodesNeedingSave.remove(0);
            if (currentNode == null) continue;
            currentNode.saveChangesToCache(updateIcons);
            if (!updateIcons) continue;
            this.requestReload(currentNode);
        }
    }
}

