/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Scanner;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.data.ImdiTreeObject;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsdChecker
extends JSplitPane {
    JTextPane outputPane = new JTextPane();
    JTextPane fileViewPane = new JTextPane();
    StyledDocument doc;
    Style styleFatalError;
    Style styleError;
    Style styleWarning;
    Style styleNormal;
    boolean encounteredAdditionalErrors;
    String reportedError = "";

    public XsdChecker() {
        this.setOrientation(0);
        this.setTopComponent(new JScrollPane(this.outputPane));
        this.setBottomComponent(new JScrollPane(this.fileViewPane));
        this.doc = this.outputPane.getStyledDocument();
        this.styleNormal = this.outputPane.addStyle("Normal", null);
        StyleConstants.setForeground(this.styleNormal, Color.BLACK);
        this.styleWarning = this.outputPane.addStyle("Warning", null);
        StyleConstants.setForeground(this.styleWarning, new Color(0, 153, 0));
        this.styleError = this.outputPane.addStyle("Error", null);
        StyleConstants.setForeground(this.styleError, Color.BLUE);
        this.styleFatalError = this.outputPane.addStyle("FatalError", null);
        StyleConstants.setForeground(this.styleFatalError, Color.RED);
    }

    private Validator createValidator(URL schemaFile) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(schemaFile);
        return schema.newValidator();
    }

    private URL getXsd(File imdiFile) {
        String nameSpaceURI = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(imdiFile);
            String[] schemaLocation = document.getDocumentElement().getAttributes().getNamedItem("xsi:schemaLocation").getNodeValue().split("\\s");
            if (schemaLocation != null && schemaLocation.length > 0) {
                nameSpaceURI = schemaLocation[schemaLocation.length - 1];
            }
            System.out.println("getNamespaceURI: " + document.getFirstChild().getNamespaceURI());
            System.out.println("getBaseURI: " + document.getFirstChild().getBaseURI());
            System.out.println("getLocalName: " + document.getFirstChild().getLocalName());
            System.out.println("toString: " + document.getFirstChild().toString());
            System.out.println("getAttribute: " + document.getDocumentElement().getAttribute("xmlns"));
            System.out.println("getNamespaceURI: " + document.getDocumentElement().getNamespaceURI());
        }
        catch (IOException iOException) {
            GuiHelper.linorgBugCatcher.logError(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            GuiHelper.linorgBugCatcher.logError(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            GuiHelper.linorgBugCatcher.logError(sAXException);
        }
        System.out.println("nameSpaceURI: " + nameSpaceURI);
        int daysTillExpire = 15;
        File schemaFile = null;
        if (nameSpaceURI != null && nameSpaceURI.toLowerCase().startsWith("http:/")) {
            schemaFile = LinorgSessionStorage.getSingleInstance().updateCache(nameSpaceURI, daysTillExpire);
        }
        if (nameSpaceURI != null && nameSpaceURI.toLowerCase().startsWith("file:/")) {
            try {
                schemaFile = new File(new URI(nameSpaceURI));
            }
            catch (URISyntaxException ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
        if (schemaFile == null || !schemaFile.exists()) {
            schemaFile = LinorgSessionStorage.getSingleInstance().updateCache("http://www.mpi.nl/IMDI/Schema/IMDI_3.0.xsd", daysTillExpire);
        }
        URL schemaURL = null;
        if (schemaFile.exists()) {
            try {
                schemaURL = schemaFile.toURL();
            }
            catch (Exception e) {
                System.out.println("error getting xsd from the server: " + e.getMessage());
            }
        }
        if (schemaURL == null) {
            schemaURL = this.getClass().getResource("/nl/mpi/arbil/resources/IMDI/FallBack/IMDI_3.0.xsd");
        }
        return schemaURL;
    }

    private void alternateCheck(File imdiFile) throws Exception {
        URL schemaURL = this.getXsd(imdiFile);
        this.doc.insertString(this.doc.getLength(), "using schema file: " + schemaURL.getFile() + "\n\n", this.styleNormal);
        StreamSource xmlFile = new StreamSource(imdiFile);
        Validator validator = this.createValidator(schemaURL);
        class CustomErrorHandler
        implements ErrorHandler {
            File imdiFile;

            public CustomErrorHandler(File imdiFileLocal) {
                this.imdiFile = imdiFileLocal;
            }

            private String getLine(int lineNumber) {
                try {
                    String returnText = "";
                    Scanner scanner = new Scanner(this.imdiFile);
                    for (int lineCounter = 0; lineCounter < lineNumber - 1; ++lineCounter) {
                        returnText = scanner.nextLine();
                    }
                    return lineNumber - 1 + ": " + returnText + "\n" + lineNumber + ": " + scanner.nextLine() + "\n" + (lineNumber + 1) + ": " + scanner.nextLine();
                }
                catch (FileNotFoundException fileNotFoundException) {
                    GuiHelper.linorgBugCatcher.logError(fileNotFoundException);
                    return fileNotFoundException.getMessage();
                }
            }

            public void warning(SAXParseException exception) throws SAXException {
                try {
                    XsdChecker.this.doc.insertString(XsdChecker.this.doc.getLength(), "warning: " + exception.getMessage() + "\nline: " + exception.getLineNumber() + " col: " + exception.getColumnNumber() + "\n" + this.getLine(exception.getLineNumber()) + "\n", XsdChecker.this.styleWarning);
                }
                catch (BadLocationException badLocationException) {
                    GuiHelper.linorgBugCatcher.logError(badLocationException);
                }
            }

            public void error(SAXParseException exception) throws SAXException {
                try {
                    XsdChecker.this.doc.insertString(XsdChecker.this.doc.getLength(), "error: " + exception.getMessage() + "\nline: " + exception.getLineNumber() + " col: " + exception.getColumnNumber() + "\n" + this.getLine(exception.getLineNumber()) + "\n", XsdChecker.this.styleError);
                }
                catch (BadLocationException badLocationException) {
                    GuiHelper.linorgBugCatcher.logError(badLocationException);
                }
            }

            public void fatalError(SAXParseException exception) throws SAXException {
                try {
                    XsdChecker.this.doc.insertString(XsdChecker.this.doc.getLength(), "fatalError: " + exception.getMessage() + "\nline: " + exception.getLineNumber() + " col: " + exception.getColumnNumber() + "\n" + this.getLine(exception.getLineNumber()) + "\n", XsdChecker.this.styleError);
                }
                catch (BadLocationException badLocationException) {
                    GuiHelper.linorgBugCatcher.logError(badLocationException);
                }
            }
        }
        CustomErrorHandler errorHandler = new CustomErrorHandler(imdiFile);
        validator.setErrorHandler(errorHandler);
        try {
            validator.validate(xmlFile);
        }
        catch (SAXException e) {
            System.out.println(xmlFile.getSystemId() + " is NOT valid");
            System.out.println("Reason: " + e.getLocalizedMessage());
            this.doc.insertString(this.doc.getLength(), xmlFile.getSystemId() + " is NOT valid\n", this.styleError);
            this.doc.insertString(this.doc.getLength(), "Reason: " + e.getLocalizedMessage() + "\n", this.styleError);
        }
    }

    public String simpleCheck(File imdiFile, URI sourceFile) {
        URL schemaURL = this.getXsd(imdiFile);
        StreamSource xmlFile = new StreamSource(imdiFile);
        try {
            Validator validator = this.createValidator(schemaURL);
            validator.validate(xmlFile);
            return null;
        }
        catch (Exception e) {
            String messageString = "Error validating " + sourceFile + "\n" + "Reason: " + e.getLocalizedMessage() + "\n";
            return messageString;
        }
    }

    public void checkXML(ImdiTreeObject imdiObject) {
        this.encounteredAdditionalErrors = false;
        try {
            this.doc.insertString(this.doc.getLength(), "Checking the IMDI file conformance to the XSD\nThere are three types or messages: ", this.styleNormal);
            this.doc.insertString(this.doc.getLength(), "Message, ", this.styleWarning);
            this.doc.insertString(this.doc.getLength(), "Errors, ", this.styleError);
            this.doc.insertString(this.doc.getLength(), "and ", this.styleNormal);
            this.doc.insertString(this.doc.getLength(), "Fatal Errors.\n\n", this.styleFatalError);
            this.alternateCheck(imdiObject.getFile());
            try {
                this.fileViewPane.setPage(imdiObject.getURI().toURL());
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
        catch (Exception ex) {
            this.encounteredAdditionalErrors = true;
            this.reportedError = ex.getMessage();
            System.out.println(ex.getMessage());
        }
        try {
            if (this.encounteredAdditionalErrors) {
                this.doc.insertString(this.doc.getLength(), "\n" + this.reportedError + "\n", this.styleFatalError);
            }
            this.doc.insertString(this.doc.getLength(), "\nDone.\n", this.styleWarning);
        }
        catch (Exception ex) {
            System.out.println("error: " + ex.getMessage());
        }
    }
}

