/*
 * Decompiled with CFR 0.152.
 */
package mpi.bcarchive.typecheck;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CharSetCheck {
    public static boolean isASCII(byte[] input, int size) {
        if (input == null) {
            return false;
        }
        if (input.length < size) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            int ch = input[i] & 0xFF;
            if (ch <= 127 && (ch >= 32 || ch == 9 || ch == 10 || ch == 13)) continue;
            return false;
        }
        return true;
    }

    public static String charClasses(byte[] input, int size) {
        String result = "";
        int lineLen = 0;
        int quoteWin = 0;
        int punctWin = 0;
        int textWin = 0;
        int otherWin = 0;
        int nowinOdd = 0;
        int russianOdd = 0;
        int utfLatin = 0;
        int niceCtrl = 0;
        int badCtrl = 0;
        int allLatin = 0;
        int moreLatin = 0;
        int otherLatin = 0;
        if (input == null) {
            return result;
        }
        if (size < 1 || input.length < size) {
            size = input.length;
        }
        int previous = 0;
        int n = 0;
        block12: for (int i = 0; i < size; ++i) {
            previous = n;
            n = input[i] & 0xFF;
            ++lineLen;
            if (n > 31 && n < 127) continue;
            if (n == 13 || n == 10) {
                lineLen = 0;
            }
            if (n == 13 || n == 10 || n == 9) continue;
            if (n >= 128 && n <= 154 && lineLen < 6) {
                ++russianOdd;
            }
            if (n >= 128 && n < 192 && previous >= 193 && previous <= 195) {
                ++utfLatin;
                continue;
            }
            switch (n) {
                case 145: 
                case 146: 
                case 147: 
                case 148: {
                    ++quoteWin;
                    continue block12;
                }
                case 130: 
                case 132: 
                case 133: 
                case 136: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    ++punctWin;
                    continue block12;
                }
                case 138: 
                case 140: 
                case 154: 
                case 156: {
                    ++textWin;
                    continue block12;
                }
                case 131: 
                case 134: 
                case 135: 
                case 137: 
                case 153: 
                case 155: 
                case 159: {
                    ++otherWin;
                    continue block12;
                }
                case 128: 
                case 129: 
                case 141: 
                case 142: 
                case 143: 
                case 144: {
                    if (lineLen <= 5) continue block12;
                    ++nowinOdd;
                    continue block12;
                }
                case 157: 
                case 158: {
                    ++nowinOdd;
                    continue block12;
                }
                case 11: 
                case 12: 
                case 21: 
                case 27: {
                    ++niceCtrl;
                    continue block12;
                }
                case 127: {
                    ++badCtrl;
                    continue block12;
                }
                case 160: 
                case 167: 
                case 173: 
                case 194: 
                case 196: 
                case 201: 
                case 203: 
                case 206: 
                case 212: 
                case 214: 
                case 219: 
                case 220: 
                case 223: 
                case 226: 
                case 228: 
                case 233: 
                case 235: 
                case 244: 
                case 246: 
                case 252: {
                    ++allLatin;
                    continue block12;
                }
                case 176: 
                case 183: 
                case 192: 
                case 193: 
                case 195: 
                case 202: 
                case 205: 
                case 207: 
                case 218: 
                case 225: 
                case 227: 
                case 237: 
                case 243: 
                case 245: 
                case 250: 
                case 251: {
                    ++moreLatin;
                    continue block12;
                }
                default: {
                    if (n < 32) {
                        ++badCtrl;
                        continue block12;
                    }
                    if (n > 160) {
                        ++otherLatin;
                        continue block12;
                    }
                    ++otherWin;
                }
            }
        }
        if (quoteWin > 0 || punctWin > 0 || textWin > 0 || otherWin > 0) {
            result = result + " CP1252[";
            if (quoteWin > 0) {
                result = result + " quotes=" + quoteWin;
            }
            if (punctWin > 0) {
                result = result + " punct=" + punctWin;
            }
            if (textWin > 0) {
                result = result + " text=" + textWin;
            }
            if (otherWin > 0) {
                result = result + " other=" + otherWin;
            }
            result = result + " ]";
        }
        if (badCtrl > 0 || nowinOdd > 0) {
            result = result + " BADSTRANGE[";
            if (badCtrl > 0) {
                result = result + " ctrl=" + badCtrl;
            }
            if (nowinOdd > 0) {
                result = result + " other=" + nowinOdd;
            }
            result = result + " ]";
        }
        if (russianOdd > 0 || niceCtrl > 0) {
            result = result + " STRANGE[";
            if (russianOdd > 0) {
                result = result + " RussianShift=" + russianOdd;
            }
            if (niceCtrl > 0) {
                result = result + " BasicCtrl=" + niceCtrl;
            }
            result = result + " ]";
        }
        if (allLatin > 0 || moreLatin > 0 || otherLatin > 0) {
            result = result + " LATIN[";
            if (allLatin > 0) {
                result = result + " safe=" + allLatin;
            }
            if (moreLatin > 0) {
                result = result + " okay=" + moreLatin;
            }
            if (otherLatin > 0) {
                result = result + " other=" + otherLatin;
            }
            result = result + " ]";
        }
        if (utfLatin > 0) {
            result = result + " UTF8[ latin=" + utfLatin + " ]";
        }
        return result.trim();
    }

    public static String nonASCII(byte[] input, int size, boolean verbose) {
        int i;
        int i2;
        String result = "";
        int[] badCount = new int[256];
        for (i2 = 0; i2 < 256; ++i2) {
            badCount[i2] = 0;
        }
        if (input == null) {
            return result;
        }
        if (size < 1 || input.length < size) {
            size = input.length;
        }
        for (i2 = 0; i2 < size; ++i2) {
            int ch = input[i2] & 0xFF;
            if (ch <= 127 && (ch >= 32 || ch == 9 || ch == 10 || ch == 13)) continue;
            int n = ch;
            badCount[n] = badCount[n] + 1;
        }
        int badSlots = 0;
        for (i = 0; i < 256; ++i) {
            if (badCount[i] <= 0) continue;
            ++badSlots;
        }
        if (badSlots == 0) {
            return result;
        }
        result = "" + badSlots;
        for (i = 0; i < 256; ++i) {
            if (badCount[i] <= 0) continue;
            if (verbose) {
                result = result + " " + badCount[i] + "x";
            }
            result = i > 0 && i < 8 ? result + "'\\00" + i + "'" : (i > 7 && i < 64 ? result + "'\\0" + Integer.toOctalString(i) + "'" : result + "'\\" + Integer.toOctalString(i) + "'");
        }
        return result;
    }

    public static boolean isUTF8(byte[] input, int size) {
        if (input == null) {
            return false;
        }
        if (input.length < size) {
            return false;
        }
        int other = 0;
        for (int i = 0; i < size; ++i) {
            int val = input[i] & 0xFF;
            if (val > 239) {
                return false;
            }
            if (val > 223) {
                if (other > 0) {
                    return false;
                }
                other = 2;
                continue;
            }
            if (val > 191) {
                if (other > 0) {
                    return false;
                }
                other = 1;
                continue;
            }
            if (val > 127) {
                if (other < 1) {
                    return false;
                }
                --other;
                continue;
            }
            if (val < 32 && val != 9 && val != 10 && val != 13) {
                return false;
            }
            if (other <= 0) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Give input filename(s) as argument(s)...");
            System.exit(1);
        }
        byte[] header = new byte[0x1000000];
        for (int i = 0; i < args.length; ++i) {
            FileInputStream what = null;
            int loadedSize = 0;
            try {
                what = new FileInputStream(args[i]);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Could not open input file, error: " + fnfe + " for file: " + args[i]);
                continue;
            }
            try {
                loadedSize = what.read(header);
                what.close();
            }
            catch (IOException ioe) {
                System.out.println("Could not check input file, error: " + ioe + " for file: " + args[i]);
                try {
                    what.close();
                }
                catch (IOException ioe2) {}
                continue;
            }
            if (loadedSize == header.length) {
                System.out.println("Checked only first " + loadedSize + " bytes of: " + args[i]);
            }
            if (loadedSize == 0) {
                System.out.println("Empty: " + args[i]);
                continue;
            }
            if (CharSetCheck.isASCII(header, loadedSize)) {
                System.out.println("ASCII: " + args[i]);
                continue;
            }
            if (CharSetCheck.isUTF8(header, loadedSize)) {
                System.out.println("UTF-8: " + args[i]);
                continue;
            }
            String charInfo = CharSetCheck.charClasses(header, loadedSize);
            charInfo = charInfo + " [CHARS: " + CharSetCheck.nonASCII(header, loadedSize, true) + "]";
            System.out.println("Other: " + charInfo + " file: " + args[i]);
        }
    }
}

