/*
 * Decompiled with CFR 0.152.
 */
package mpi.bcarchive.typecheck;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import mpi.bcarchive.typecheck.CharSetCheck;
import mpi.bcarchive.typecheck.TypeDef;

public class FileType {
    static Hashtable typeLists = new Hashtable();
    Vector _knownTypes = new Vector();
    static final int _MinCheckSize = 32;
    static final int _BestCheckSize = 1024;
    public boolean _cmdlineMode = false;
    boolean _verbose = false;

    public void setVerbose(boolean v) {
        this._verbose = v;
    }

    public FileType() {
        this(new File("filetypes.txt"));
    }

    public FileType(File configFile) {
        if (typeLists.get(configFile) != null) {
            this._knownTypes = (Vector)typeLists.get(configFile);
            return;
        }
        InputStream is = null;
        try {
            is = new FileInputStream(configFile);
        }
        catch (FileNotFoundException fnfe) {
            // empty catch block
        }
        if (is == null && configFile.getName().equalsIgnoreCase("filetypes.txt")) {
            URL res = FileType.class.getResource("resources/filetypes.txt");
            try {
                is = res == null ? null : res.openStream();
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        if (is == null) {
            System.err.println("Error: Cannot load typechecker config file: " + configFile);
            throw new NullPointerException("Cannot load typechecker config file");
        }
        BufferedReader lines = new BufferedReader(new InputStreamReader(is));
        String line = "";
        while (line != null) {
            try {
                line = lines.readLine();
            }
            catch (IOException ioe) {
                line = null;
            }
            if (line == null || line.length() == 0 || line.startsWith("#")) continue;
            TypeDef type = null;
            String[] parts = line.split("\\s+", 4);
            if (parts.length != 4) {
                System.err.println("Magic line must have 4+ parts: " + line);
                continue;
            }
            String[] magic = parts[0].split(",");
            String[] extensions = parts[1].split(",");
            if ((magic.length & 1) != 0) {
                System.err.println("Each magic needs an offset: " + parts[0]);
                continue;
            }
            if (magic.length > 6) {
                System.err.println("Only first three magics used: " + parts[0]);
            }
            boolean caseInsensitive = magic[0].startsWith("-");
            try {
                int offset = Integer.parseInt(magic[0]);
                int offset2 = 0;
                int offset3 = 0;
                String magic2 = null;
                String magic3 = null;
                if (magic.length > 2) {
                    offset2 = Integer.parseInt(magic[2]);
                }
                if (offset2 < 0) {
                    offset2 = -offset2;
                }
                if (magic.length > 3) {
                    magic2 = this.parseEsc(magic[3]);
                }
                if (magic.length > 4) {
                    offset3 = Integer.parseInt(magic[4]);
                }
                if (offset3 < 0) {
                    offset3 = -offset3;
                }
                if (magic.length > 5) {
                    magic3 = this.parseEsc(magic[5]);
                }
                boolean good = parts[2].equalsIgnoreCase("GOOD");
                boolean badCodec = parts[2].equalsIgnoreCase("BADCODEC");
                type = new TypeDef(offset, this.parseEsc(magic[1]), caseInsensitive, extensions[0], good, badCodec, parts[3]);
                if (extensions.length > 1) {
                    for (int i = 1; i < extensions.length; ++i) {
                        type.registerExtension(extensions[i]);
                    }
                }
                if (magic.length > 2) {
                    type.moreConstraints(offset2, magic2, offset3, magic3);
                }
                this._knownTypes.add(type);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Magic ignored: " + parts[0] + " " + nfe);
            }
        }
        try {
            lines.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        typeLists.put(configFile, this._knownTypes);
    }

    public String parseEsc(String in) {
        if (in == null || in.indexOf(92) == -1) {
            return in;
        }
        StringBuffer outString = new StringBuffer(in.length());
        boolean esc = false;
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (esc) {
                switch (ch) {
                    case '\\': {
                        outString.append('\\');
                        break;
                    }
                    case 'r': {
                        outString.append('\r');
                        break;
                    }
                    case 'n': {
                        outString.append('\n');
                        break;
                    }
                    case '0': {
                        outString.append('\u0000');
                        break;
                    }
                    case '_': {
                        outString.append(' ');
                        break;
                    }
                    case 'x': {
                        try {
                            String hex = in.substring(i + 1, i + 3);
                            i += 2;
                            int num = Integer.parseInt(hex, 16);
                            outString.append((char)num);
                        }
                        catch (NumberFormatException e) {
                            outString.append("\\x??");
                        }
                        catch (ArrayIndexOutOfBoundsException e) {
                            outString.append("\\x??");
                        }
                        break;
                    }
                    default: {
                        outString.append("\\" + ch);
                    }
                }
                esc = false;
                continue;
            }
            if (ch == '\\') {
                esc = true;
                continue;
            }
            outString.append(ch);
        }
        if (esc) {
            outString.append('\\');
        }
        return outString.toString();
    }

    public static String resultToMimeType(String result) {
        String mpiType = FileType.resultToMPIType(result);
        if (mpiType == null) {
            return null;
        }
        StringTokenizer strtok = new StringTokenizer(mpiType, "/");
        if (!strtok.hasMoreTokens()) {
            return null;
        }
        String first = strtok.nextToken();
        if (!strtok.hasMoreTokens()) {
            return null;
        }
        String second = strtok.nextToken();
        if (second.equals("x-mpeg4")) {
            second = "mp4";
        }
        if (second.startsWith("x-mpeg")) {
            second = "mpeg";
        }
        if (!first.equals("text")) {
            return first + "/" + second;
        }
        if (second.endsWith("xml")) {
            second = "xml";
        }
        if (second.startsWith("x-")) {
            second = "plain";
        }
        return first + "/" + second;
    }

    public static String resultToMPIType(String result) {
        if (result == null || !result.startsWith("true ")) {
            return null;
        }
        StringTokenizer strtok = new StringTokenizer(result);
        strtok.nextToken();
        if (!strtok.hasMoreTokens()) {
            return null;
        }
        strtok.nextToken();
        if (!strtok.hasMoreTokens()) {
            return null;
        }
        return strtok.nextToken().trim();
    }

    public Collection getExtensionsForMPIType(String mpiType) {
        HashSet extensions = new HashSet();
        Iterator types = this._knownTypes.iterator();
        while (types.hasNext()) {
            String mpiType2;
            TypeDef type = (TypeDef)types.next();
            String description = type.getFormatName();
            int where = description.indexOf(" ");
            if (where < 0 || where > description.length()) {
                where = description.length();
            }
            if (!(mpiType2 = description.substring(0, where)).equals(mpiType)) continue;
            extensions.addAll(type.getValidExtensions());
        }
        return extensions;
    }

    public String checkStream(InputStream is, String name) throws IOException {
        byte[] header = new byte[1024];
        int loadedSize = 0;
        String ext = "none";
        boolean okay = false;
        String judgement = "UnknownType";
        String description = "could not determine file type";
        if (name != null) {
            int x = name.lastIndexOf(46);
            int y = name.lastIndexOf(47);
            int z = name.lastIndexOf(92);
            if (z < x && y < x && x != -1) {
                ext = name.substring(x + 1);
            }
        }
        if (name != null && "standard-session.cfg".equals(name)) {
            return "true MAGICNAME text/plain (magic filename standard-session.cfg, contents not checked)";
        }
        if (is == null) {
            Iterator types = this._knownTypes.iterator();
            while (types.hasNext()) {
                TypeDef type = (TypeDef)types.next();
                if (!type.isValidExtension(ext)) continue;
                return "true KNOWNEXTENSION " + type.getFormatName() + " (file contents not checked)";
            }
        }
        if ((loadedSize = is.available()) < 32 || (loadedSize = is.read(header)) < 32) {
            if (loadedSize > 0) {
                return "" + okay + " TooSmall file is too small to be analyzed, less than " + 32 + " bytes";
            }
            return "" + okay + " Empty file is empty";
        }
        String headerString = null;
        StringBuffer strBuf = new StringBuffer(loadedSize);
        for (int i = 0; i < loadedSize; ++i) {
            strBuf.append((char)(header[i] & 0xFF));
        }
        headerString = strBuf.toString();
        Iterator types = this._knownTypes.iterator();
        while (types.hasNext()) {
            TypeDef type = (TypeDef)types.next();
            if (!type.isFormat(headerString)) continue;
            String string = type.isGoodFormat() ? (type.isBadVariant() ? "BadVariant" : "ARCHIVABLE") : (judgement = "BadFormat");
            if (judgement.equals("ARCHIVABLE")) {
                okay = true;
            }
            description = type.getFormatName();
            if (!type.isGoodFormat()) {
                description = "bad file type: " + description;
            } else if (type.isBadVariant()) {
                description = "bad encoding or variant: " + description;
            }
            if (name != null) {
                if (!type.isValidExtension(ext)) {
                    judgement = okay ? "BadName" : judgement + "Renamed";
                    int where = description.indexOf(" ");
                    if (where < 0 || where > description.length()) {
                        where = description.length();
                    }
                    String mpiType = description.substring(0, where);
                    description = description + " File name extension: " + ext;
                    Iterator extIter = this.getExtensionsForMPIType(mpiType).iterator();
                    if (extIter.hasNext()) {
                        description = description + " Should be one of:";
                    }
                    while (extIter.hasNext()) {
                        description = description + " " + extIter.next();
                    }
                    okay = false;
                }
                if (this._cmdlineMode) {
                    System.out.println(judgement + " " + description + " file: " + name);
                }
            } else if (this._cmdlineMode) {
                System.out.println(judgement + " " + description + " (stream)");
            }
            if (!okay) continue;
            return "" + okay + " " + judgement + " " + description;
        }
        if (!judgement.equals("UnknownType")) {
            return "" + okay + " " + judgement + " " + description;
        }
        okay = false;
        if (CharSetCheck.isASCII(header, loadedSize)) {
            judgement = "ARCHIVABLE";
            description = "text/plain ASCII text";
            okay = true;
        } else if (CharSetCheck.isUTF8(header, loadedSize)) {
            judgement = "ARCHIVABLE";
            description = "text/plain UTF-8 text";
            okay = true;
        } else if (CharSetCheck.charClasses(header, loadedSize).indexOf("STRANGE") == -1) {
            String charInfo = CharSetCheck.charClasses(header, loadedSize);
            if (this._verbose && charInfo.indexOf("other") != -1) {
                charInfo = charInfo + " [CHARS: " + CharSetCheck.nonASCII(header, loadedSize, false) + "]";
            }
            if (charInfo.indexOf("CP1252") == -1) {
                judgement = "BadVariant";
                description = "maybe Latin text? Starts with: " + charInfo;
            } else {
                judgement = "BadVariant";
                description = "maybe Windows1252 text? Starts with: " + charInfo;
            }
            okay = false;
        } else if (CharSetCheck.charClasses(header, loadedSize).indexOf("BADSTRANGE") == -1) {
            String charInfo = CharSetCheck.charClasses(header, loadedSize);
            if (this._verbose && charInfo.indexOf("other") != -1) {
                charInfo = charInfo + " [CHARS: " + CharSetCheck.nonASCII(header, loadedSize, false) + "]";
            }
            judgement = "BadVariant";
            description = "maybe other text? Starts with: " + charInfo;
            okay = false;
        }
        if (!(!okay || name == null || ext.equals("txt") || ext.equals("tr") || ext.equals("1tr") || ext.equals("prt") || ext.equals("bio"))) {
            judgement = "BadName";
            description = description + " File name extension: " + ext + " Should be one of: txt tr 1tr prt bio";
            okay = false;
        }
        if (judgement.equals("UnknownType")) {
            int val = header[0] & 0xFF;
            int j = 0;
            for (int i = 0; i < loadedSize; ++i) {
                if ((header[i] & 0xFF) != val) continue;
                ++j;
            }
            if (j == loadedSize) {
                judgement = "SameByte";
                description = "dummy data?, first " + loadedSize + " bytes are all " + val;
            } else {
                int i;
                description = description + " Name: *." + ext + " Starts with:";
                String initialText = "";
                for (i = 0; i < loadedSize && i < 32; ++i) {
                    if (header[i] == 13 || header[i] == 10) {
                        initialText = initialText + " ";
                        continue;
                    }
                    if ((header[i] & 0xFF) < 32 || (header[i] & 0xFF) > 127) break;
                    initialText = initialText + (char)(header[i] & 0xFF);
                }
                if ((initialText = initialText.trim()).length() > 8) {
                    description = description + " '" + initialText + "'";
                } else {
                    for (i = 0; i < 8; ++i) {
                        val = header[i] & 0xFF;
                        description = description + " " + (val < 16 ? "0" : "") + Integer.toHexString(val);
                    }
                }
                description = description + "...";
            }
        }
        if (name != null) {
            if (this._cmdlineMode) {
                System.out.println(judgement + " " + description + " file: " + name);
            }
        } else if (this._cmdlineMode) {
            System.out.println(judgement + " " + description + " (stream)");
        }
        return "" + okay + " " + judgement + " " + description;
    }

    public static void main(String[] args) {
        FileType me = new FileType();
        me.setVerbose(false);
        if (args.length < 1) {
            System.out.println("Give input filename(s) as argument(s)...");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            FileInputStream what = null;
            try {
                what = new FileInputStream(args[i]);
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Could not open input file: " + args[i]);
                System.out.println("Reason: " + fnfe);
                continue;
            }
            me._cmdlineMode = true;
            try {
                String result = me.checkStream(what, args[i]);
                what.close();
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Could not check input file: " + args[i]);
                System.out.println("I/O Error: " + ioe);
                try {
                    what.close();
                    continue;
                }
                catch (IOException ioe2) {
                    // empty catch block
                }
            }
        }
    }
}

