/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgVersion;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiIcons {
    public ImageIcon linorgIcon;
    public ImageIcon serverIcon;
    public ImageIcon directoryIcon;
    public ImageIcon computerIcon;
    public ImageIcon loadingIcon;
    private ImageIcon localicon;
    private ImageIcon remoteicon;
    private ImageIcon localWithArchiveHandle;
    private ImageIcon writtenresourceIcon;
    private ImageIcon videoIcon;
    private ImageIcon audioIcon;
    public ImageIcon corpusnodeColorIcon;
    private ImageIcon missingRedIcon;
    private ImageIcon picturesIcon;
    private ImageIcon questionRedIcon;
    public ImageIcon dataIcon;
    private ImageIcon dataemptyIcon;
    public ImageIcon sessionColorIcon;
    public ImageIcon clarinIcon;
    public ImageIcon catalogueColorIcon;
    private ImageIcon exclamationBlueIcon;
    private ImageIcon exclamationRedIcon;
    private ImageIcon tickBlueIcon;
    private ImageIcon fileIcon;
    private ImageIcon tickGreenIcon;
    public ImageIcon favouriteIcon;
    public ImageIcon lockedIcon;
    public ImageIcon unLockedIcon;
    private static ImdiIcons singleInstance = null;

    public static synchronized ImdiIcons getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new ImdiIcons();
        }
        return singleInstance;
    }

    private ImdiIcons() {
        this.linorgIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/" + new LinorgVersion().applicationIconName));
        this.serverIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/server16x16.png"));
        this.directoryIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/directory16x16.png"));
        this.computerIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/computer16x16.png"));
        this.loadingIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/loading01.png"));
        this.localicon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/local.png"));
        this.remoteicon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/remote.png"));
        this.localWithArchiveHandle = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/localarchivehandle.png"));
        this.writtenresourceIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/writtenresource.png"));
        this.videoIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/video.png"));
        this.audioIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/audio.png"));
        this.corpusnodeColorIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/corpusnode_color.png"));
        this.missingRedIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/notfound.png"));
        this.picturesIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/pictures.png"));
        this.questionRedIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/question-red.png"));
        this.dataIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/data.png"));
        this.dataemptyIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/dataempty.png"));
        this.sessionColorIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/session_color.png"));
        this.clarinIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/clarinE.png"));
        this.catalogueColorIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/catalogue.png"));
        this.exclamationBlueIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/exclamation-blue.png"));
        this.exclamationRedIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/exclamation-red.png"));
        this.tickBlueIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/tick-blue.png"));
        this.fileIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/file.png"));
        this.tickGreenIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/tick-green.png"));
        this.favouriteIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/favourite.png"));
        this.lockedIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/lock.png"));
        this.unLockedIcon = new ImageIcon(ImdiIcons.class.getResource("/nl/mpi/arbil/resources/icons/unlock.png"));
    }

    public ImageIcon getIconForImdi(ImdiTreeObject[] imdiObjectArray) {
        int currentIconXPosition = 0;
        int width = 0;
        int heightMax = 0;
        for (ImdiTreeObject currentImdi : imdiObjectArray) {
            width += currentImdi.getIcon().getIconWidth();
            int height = currentImdi.getIcon().getIconHeight();
            if (heightMax >= height) continue;
            heightMax = height;
        }
        BufferedImage bufferedImage = new BufferedImage(width, heightMax, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics().create();
        for (ImdiTreeObject childImdiObject : imdiObjectArray) {
            ImageIcon currentIcon = childImdiObject.getIcon();
            currentIcon.paintIcon(null, g2d, currentIconXPosition, 0);
            currentIconXPosition += currentIcon.getIconWidth();
        }
        g2d.dispose();
        return new ImageIcon(bufferedImage);
    }

    public ImageIcon compositIcons(Object[] iconArray) {
        int widthTotal = 0;
        int heightMax = 0;
        for (Object currentIcon : iconArray) {
            int width = ((Icon)currentIcon).getIconWidth();
            int height = ((Icon)currentIcon).getIconHeight();
            if (currentIcon != this.missingRedIcon) {
                widthTotal += width;
            }
            if (heightMax >= height) continue;
            heightMax = height;
        }
        int currentIconXPosition = 0;
        BufferedImage bufferedImage = new BufferedImage(widthTotal, heightMax, 2);
        Graphics2D g2d = (Graphics2D)bufferedImage.getGraphics().create();
        for (Object currentIcon : iconArray) {
            int yPos = (heightMax - ((Icon)currentIcon).getIconHeight()) / 2;
            if (currentIcon != this.missingRedIcon) {
                ((Icon)currentIcon).paintIcon(null, g2d, currentIconXPosition, yPos);
                currentIconXPosition += ((Icon)currentIcon).getIconWidth();
                continue;
            }
            ((Icon)currentIcon).paintIcon(null, g2d, currentIconXPosition - this.missingRedIcon.getIconWidth(), yPos);
        }
        g2d.dispose();
        return new ImageIcon(bufferedImage);
    }

    public ImageIcon getIconForImdi(ImdiTreeObject imdiObject) {
        Vector<Icon> iconsVector = new Vector<Icon>();
        if (imdiObject.isLoading() || imdiObject.getParentDomNode().isMetaDataNode() && !imdiObject.getParentDomNode().imdiDataLoaded) {
            iconsVector.add(this.loadingIcon);
        }
        if (imdiObject.isLocal()) {
            if (imdiObject.isMetaDataNode()) {
                if (imdiObject.matchesRemote == 0) {
                    if (!imdiObject.hasArchiveHandle) {
                        iconsVector.add(this.localicon);
                    } else {
                        iconsVector.add(this.localWithArchiveHandle);
                    }
                } else {
                    iconsVector.add(this.remoteicon);
                }
            }
        } else {
            iconsVector.add(this.remoteicon);
        }
        if (imdiObject.resourceFileServerResponse == 200) {
            iconsVector.add(this.unLockedIcon);
        } else if (imdiObject.resourceFileServerResponse == 302) {
            iconsVector.add(this.lockedIcon);
        }
        String mimeTypeForNode = imdiObject.getAnyMimeType();
        if (mimeTypeForNode != null) {
            if ((mimeTypeForNode = mimeTypeForNode.toLowerCase()).contains("audio")) {
                iconsVector.add(this.audioIcon);
            } else if (mimeTypeForNode.contains("video")) {
                iconsVector.add(this.videoIcon);
            } else if (mimeTypeForNode.contains("image")) {
                iconsVector.add(this.picturesIcon);
            } else if (mimeTypeForNode.contains("text")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("xml")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("chat")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("pdf")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("kml")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("manual/mediafile")) {
                iconsVector.add(this.picturesIcon);
            } else if (mimeTypeForNode.contains("manual/writtenresource")) {
                iconsVector.add(this.writtenresourceIcon);
            } else if (mimeTypeForNode.contains("unspecified") || mimeTypeForNode.length() == 0) {
                iconsVector.add(this.fileIcon);
            } else if (mimeTypeForNode.length() > 0) {
                iconsVector.add(this.questionRedIcon);
                GuiHelper.linorgBugCatcher.logError(mimeTypeForNode, new Exception("Icon not found for file type: " + mimeTypeForNode));
            }
        } else if (imdiObject.hasResource()) {
            iconsVector.add(this.fileIcon);
        } else if (imdiObject.isMetaDataNode()) {
            if (imdiObject.isImdiChild()) {
                if (imdiObject.isEmptyMetaNode()) {
                    iconsVector.add(this.dataemptyIcon);
                } else {
                    iconsVector.add(this.dataIcon);
                }
            } else if (imdiObject.isSession()) {
                iconsVector.add(this.sessionColorIcon);
            } else if (imdiObject.isCatalogue()) {
                iconsVector.add(this.catalogueColorIcon);
            } else if (imdiObject.isCorpus()) {
                iconsVector.add(this.corpusnodeColorIcon);
            } else if (imdiObject.isCmdiMetaDataNode()) {
                iconsVector.add(this.clarinIcon);
            } else if (imdiObject.imdiDataLoaded) {
                iconsVector.add(this.fileIcon);
            }
        } else if (imdiObject.isDirectory()) {
            iconsVector.add(UIManager.getIcon("FileView.directoryIcon"));
        } else {
            iconsVector.add(this.fileIcon);
        }
        if (imdiObject.fileNotFound || imdiObject.resourceFileNotFound()) {
            iconsVector.add(this.missingRedIcon);
        }
        if (!imdiObject.isMetaDataNode() && imdiObject.matchesInCache + imdiObject.matchesRemote > 0) {
            if (imdiObject.matchesRemote > 0) {
                iconsVector.add(this.tickGreenIcon);
            } else {
                iconsVector.add(this.tickBlueIcon);
            }
        }
        if (imdiObject.isFavorite()) {
            iconsVector.add(this.favouriteIcon);
        }
        if (imdiObject.hasHistory()) {
            iconsVector.add(this.exclamationBlueIcon);
        }
        if (imdiObject.getNeedsSaveToDisk()) {
            iconsVector.add(this.exclamationRedIcon);
        }
        return this.compositIcons(iconsVector.toArray());
    }
}

