/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ContextMenu;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiChildCellEditor;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiFieldViewTable;
import nl.mpi.arbil.ImdiFieldViews;
import nl.mpi.arbil.ImdiTableCellRenderer;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.JListToolTip;
import nl.mpi.arbil.LinorgSplitPanel;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiTable
extends JTable {
    public ImdiTableModel imdiTableModel;
    JListToolTip listToolTip = new JListToolTip();
    int lastColumnCount = -1;
    int lastRowCount = -1;
    int lastColumnPreferedWidth = 0;
    int totalPreferedWidth = 0;

    public ImdiTable(ImdiTableModel localImdiTableModel, String frameTitle) {
        this.imdiTableModel = localImdiTableModel;
        this.imdiTableModel.setShowIcons(true);
        this.setModel(this.imdiTableModel);
        this.setName(frameTitle);
        this.setCellSelectionEnabled(true);
        this.setSelectionMode(2);
        this.setGridColor(Color.LIGHT_GRAY);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                this.checkTableHeaderPopup(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                this.checkTableHeaderPopup(evt);
            }

            public void mouseClicked(MouseEvent evt) {
                System.out.println("mouseClicked");
                System.out.println("table header click");
                if (evt.getButton() == 1) {
                    ImdiTable.this.imdiTableModel.sortByColumn(ImdiTable.this.convertColumnIndexToModel(((JTableHeader)evt.getComponent()).columnAtPoint(new Point(evt.getX(), evt.getY()))));
                }
                this.checkTableHeaderPopup(evt);
            }

            private void checkTableHeaderPopup(MouseEvent evt) {
                if (!ImdiTable.this.imdiTableModel.hideContextMenuAndStatusBar && evt.isPopupTrigger()) {
                    int targetColumn = ImdiTable.this.convertColumnIndexToModel(((JTableHeader)evt.getComponent()).columnAtPoint(new Point(evt.getX(), evt.getY())));
                    System.out.println("columnIndex: " + targetColumn);
                    JPopupMenu popupMenu = new JPopupMenu();
                    if (targetColumn != 0) {
                        JMenuItem hideColumnMenuItem = new JMenuItem("Hide Column: \"" + ImdiTable.this.imdiTableModel.getColumnName(targetColumn) + "\"");
                        hideColumnMenuItem.setActionCommand("" + targetColumn);
                        hideColumnMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                try {
                                    ImdiTable.this.imdiTableModel.hideColumn(Integer.parseInt(e.getActionCommand()));
                                }
                                catch (Exception ex) {
                                    GuiHelper.linorgBugCatcher.logError(ex);
                                }
                            }
                        });
                        popupMenu.add(hideColumnMenuItem);
                    }
                    if (ImdiTable.this.imdiTableModel.horizontalView) {
                        JMenuItem showChildNodesMenuItem = new JMenuItem();
                        showChildNodesMenuItem.setText("Show Child Nodes");
                        showChildNodesMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent evt) {
                                try {
                                    ImdiTable.this.showRowChildData();
                                }
                                catch (Exception ex) {
                                    GuiHelper.linorgBugCatcher.logError(ex);
                                }
                            }
                        });
                        popupMenu.add(showChildNodesMenuItem);
                    }
                    JMenuItem saveViewMenuItem = new JMenuItem("Save Current Column View");
                    saveViewMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                String fieldViewName = JOptionPane.showInputDialog(null, "Enter a name to save this Column View as", "Save Column View", -1);
                                if (fieldViewName != null && !ImdiFieldViews.getSingleInstance().addImdiFieldView(fieldViewName, ImdiTable.this.imdiTableModel.getFieldView())) {
                                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("A Column View with the same name already exists, nothing saved", "Save Column View");
                                }
                            }
                            catch (Exception ex) {
                                GuiHelper.linorgBugCatcher.logError(ex);
                            }
                        }
                    });
                    popupMenu.add(saveViewMenuItem);
                    JMenuItem editViewMenuItem = new JMenuItem("Edit this Column View");
                    editViewMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                ImdiFieldViewTable fieldViewTable = new ImdiFieldViewTable(ImdiTable.this.imdiTableModel);
                                JDialog editViewsDialog = new JDialog(JOptionPane.getFrameForComponent(LinorgWindowManager.getSingleInstance().linorgFrame), true);
                                editViewsDialog.setTitle("Editing Current Column View");
                                JScrollPane js = new JScrollPane(fieldViewTable);
                                editViewsDialog.getContentPane().add(js);
                                editViewsDialog.setBounds(50, 50, 600, 400);
                                editViewsDialog.setVisible(true);
                            }
                            catch (Exception ex) {
                                GuiHelper.linorgBugCatcher.logError(ex);
                            }
                        }
                    });
                    popupMenu.add(editViewMenuItem);
                    JMenuItem showOnlyCurrentViewMenuItem = new JMenuItem("Show Only Current Columns");
                    showOnlyCurrentViewMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            try {
                                ImdiTable.this.imdiTableModel.showOnlyCurrentColumns();
                            }
                            catch (Exception ex) {
                                GuiHelper.linorgBugCatcher.logError(ex);
                            }
                        }
                    });
                    popupMenu.add(showOnlyCurrentViewMenuItem);
                    JMenu fieldViewsMenuItem = new JMenu("Apply Saved Column View");
                    ButtonGroup viewMenuButtonGroup = new ButtonGroup();
                    Enumeration savedViewsEnum = ImdiFieldViews.getSingleInstance().getSavedFieldViewLables();
                    while (savedViewsEnum.hasMoreElements()) {
                        String currentViewLabel = savedViewsEnum.nextElement().toString();
                        JMenuItem viewLabelMenuItem = new JMenuItem();
                        viewMenuButtonGroup.add(viewLabelMenuItem);
                        viewLabelMenuItem.setText(currentViewLabel);
                        viewLabelMenuItem.setName(currentViewLabel);
                        viewLabelMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent evt) {
                                try {
                                    ImdiTable.this.imdiTableModel.setCurrentView(ImdiFieldViews.getSingleInstance().getView(((Component)evt.getSource()).getName()));
                                }
                                catch (Exception ex) {
                                    GuiHelper.linorgBugCatcher.logError(ex);
                                }
                            }
                        });
                        fieldViewsMenuItem.add(viewLabelMenuItem);
                    }
                    popupMenu.add(fieldViewsMenuItem);
                    JMenuItem copyEmbedTagMenuItem = new JMenuItem("Copy Table For Website");
                    copyEmbedTagMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            ImdiTable sizedComponent = ImdiTable.this;
                            Container currentComponent = ImdiTable.this;
                            while (currentComponent.getParent() != null) {
                                if (!((currentComponent = currentComponent.getParent()) instanceof LinorgSplitPanel)) continue;
                                sizedComponent = currentComponent;
                            }
                            ImdiTable.this.imdiTableModel.copyHtmlEmbedTagToClipboard(((Component)sizedComponent).getHeight(), ((Component)sizedComponent).getWidth());
                        }
                    });
                    popupMenu.add(copyEmbedTagMenuItem);
                    popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ImdiTable.this.checkPopup(evt, true);
            }

            public void mouseReleased(MouseEvent evt) {
                ImdiTable.this.checkPopup(evt, true);
            }
        });
    }

    public void checkPopup(MouseEvent evt, boolean checkSelection) {
        System.out.println("checkPopup");
        if (!this.imdiTableModel.hideContextMenuAndStatusBar && evt.isPopupTrigger()) {
            Point p = evt.getPoint();
            int clickedRow = this.rowAtPoint(p);
            int clickedColumn = this.columnAtPoint(p);
            boolean clickedRowAlreadySelected = this.isRowSelected(clickedRow);
            if (!(!checkSelection || evt.isShiftDown() || evt.isControlDown() || evt.isPopupTrigger() && clickedRowAlreadySelected || !(clickedRow > -1 & clickedRow > -1))) {
                this.getSelectionModel().clearSelection();
                this.changeSelection(clickedRow, clickedColumn, false, evt.isShiftDown());
            }
        }
        if (evt.isPopupTrigger()) {
            TableCellEditor tableCellEditor = this.getCellEditor();
            if (tableCellEditor != null) {
                tableCellEditor.stopCellEditing();
            }
            ContextMenu.getSingleInstance().showTreePopup(evt.getSource(), evt.getX(), evt.getY());
        }
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.getPreferredSize().height < this.getParent().getHeight();
    }

    public JToolTip createToolTip() {
        this.listToolTip.updateList();
        return this.listToolTip;
    }

    public boolean isCellEditable(int row, int column) {
        Object cellValue = this.imdiTableModel.getValueAt(row, this.convertColumnIndexToModel(column));
        return cellValue instanceof Object[] || cellValue instanceof ImdiField;
    }

    public TableCellEditor getCellEditor(int row, int viewcolumn) {
        int modelcolumn = this.convertColumnIndexToModel(viewcolumn);
        Object cellField = this.getModel().getValueAt(row, modelcolumn);
        return new ImdiChildCellEditor();
    }

    public ImdiTableCellRenderer getCellRenderer(int row, int viewcolumn) {
        int modelcolumn = this.convertColumnIndexToModel(viewcolumn);
        ImdiTableCellRenderer imdiCellRenderer = new ImdiTableCellRenderer();
        imdiCellRenderer.setBackground(this.imdiTableModel.getCellColour(row, modelcolumn));
        return imdiCellRenderer;
    }

    public void showRowChildData() {
        Object[] possibilities = ((ImdiTableModel)this.getModel()).getChildNames();
        String selectionResult = (String)JOptionPane.showInputDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Select the child node type to display", "Show child nodes", -1, null, possibilities, null);
        if (selectionResult != null && selectionResult.length() > 0) {
            ((ImdiTableModel)this.getModel()).addChildTypeToDisplay(selectionResult);
        }
    }

    public void doLayout() {
        super.doLayout();
        this.setColumnWidths();
    }

    public void setColumnWidths() {
        boolean resizeColumns = this.lastColumnCount != this.getModel().getColumnCount() || this.lastRowCount != this.getModel().getRowCount();
        this.lastColumnCount = this.getModel().getColumnCount();
        this.lastRowCount = this.getModel().getRowCount();
        int maxColumnWidth = 300;
        int minWidth = 50;
        int parentWidth = this.getParent().getWidth();
        if (this.getRowCount() > 0 && this.getColumnCount() > 2) {
            if (resizeColumns) {
                this.setAutoResizeMode(0);
                FontMetrics fontMetrics = this.getGraphics().getFontMetrics();
                ImdiTableCellRenderer imdiCellRenderer = new ImdiTableCellRenderer();
                int totalColumnWidth = 0;
                int columnCount = this.getColumnModel().getColumnCount();
                for (int columnCounter = 0; columnCounter < columnCount; ++columnCounter) {
                    int currentWidth = minWidth;
                    for (int rowCounter = 0; rowCounter < this.getRowCount(); ++rowCounter) {
                        imdiCellRenderer.setValue(this.imdiTableModel.getValueAt(rowCounter, this.convertColumnIndexToModel(columnCounter)));
                        String currentCellString = imdiCellRenderer.getText();
                        int requiredWidth = fontMetrics.stringWidth(currentCellString);
                        if (currentWidth >= requiredWidth) continue;
                        currentWidth = requiredWidth;
                    }
                    if (currentWidth > maxColumnWidth) {
                        currentWidth = maxColumnWidth;
                    }
                    this.getColumnModel().getColumn(columnCounter).setPreferredWidth(currentWidth);
                    totalColumnWidth += currentWidth;
                    this.lastColumnPreferedWidth = currentWidth;
                }
                this.totalPreferedWidth = totalColumnWidth;
                if (parentWidth > totalColumnWidth) {
                    this.setAutoResizeMode(2);
                } else {
                    this.setAutoResizeMode(0);
                }
            } else if (this.getParent() != null) {
                boolean lastcolumnSquished;
                int lastColumnWidth = this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1).getWidth();
                int totalColWidth = this.getColumnModel().getTotalColumnWidth();
                boolean bl = lastcolumnSquished = lastColumnWidth < minWidth;
                if (parentWidth > totalColWidth) {
                    this.setAutoResizeMode(2);
                } else if (parentWidth < totalColWidth) {
                    this.setAutoResizeMode(0);
                } else if (lastcolumnSquished) {
                    this.setAutoResizeMode(0);
                    this.getColumnModel().getColumn(this.getColumnModel().getColumnCount() - 1).setPreferredWidth(this.lastColumnPreferedWidth);
                }
            }
        } else {
            this.setAutoResizeMode(4);
        }
    }

    public String getToolTipText(MouseEvent e) {
        String tip = null;
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex);
        if (rowIndex >= 0 && colIndex >= 0) {
            tip = this.getValueAt(rowIndex, colIndex).toString();
            this.listToolTip.setTartgetObject(this.getValueAt(rowIndex, colIndex));
        } else {
            this.listToolTip.setTartgetObject(null);
        }
        return tip;
    }

    public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
        if (this.imdiTableModel.horizontalView) {
            boolean rowSelection = this.imdiTableModel.getValueAt(rowIndex, columnIndex) instanceof ImdiTreeObject;
            if (!this.imdiTableModel.horizontalView) {
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(false);
            } else if (rowSelection) {
                System.out.println("set row select mode");
                this.getSelectionModel().setSelectionMode(2);
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(false);
            } else {
                System.out.println("set cell select mode");
                this.setRowSelectionAllowed(true);
                this.setColumnSelectionAllowed(true);
                this.getSelectionModel().setSelectionMode(1);
            }
            System.out.println("coll select mode: " + this.getColumnSelectionAllowed());
            System.out.println("cell select mode: " + this.getCellSelectionEnabled());
            System.out.println("getSelectionMode: " + this.getSelectionModel().getSelectionMode());
            super.changeSelection(rowIndex, columnIndex, toggle, extend);
        } else {
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            Toolkit.getDefaultToolkit().getSystemEventQueue();
            AWTEvent currentEvent = EventQueue.getCurrentEvent();
            System.out.println("currentEvent: " + currentEvent);
            if (currentEvent instanceof KeyEvent && currentEvent != null) {
                System.out.println("is KeyEvent");
                KeyEvent nextPress = (KeyEvent)currentEvent;
                if (nextPress.isShiftDown()) {
                    System.out.println("VK_SHIFT");
                    if (--rowIndex < 0) {
                        rowIndex = this.getRowCount() - 1;
                    }
                }
            }
            System.out.println("rowIndex: " + rowIndex);
            super.changeSelection(rowIndex, 1, toggle, extend);
        }
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){

            public String getToolTipText(MouseEvent e) {
                Object tip = null;
                Point p = e.getPoint();
                int index = this.columnModel.getColumnIndexAtX(p.x);
                return ImdiTable.this.getColumnName(index);
            }
        };
    }

    public void copySelectedTableRowsToClipBoard() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length > 0) {
            System.out.println("coll select mode: " + this.getColumnSelectionAllowed());
            System.out.println("cell select mode: " + this.getCellSelectionEnabled());
            if (this.getCellSelectionEnabled()) {
                System.out.println("cell select mode");
                ImdiField[] selectedFields = this.getSelectedFields();
                if (selectedFields != null) {
                    this.imdiTableModel.copyImdiFields(selectedFields);
                }
            } else {
                System.out.println("row select mode");
                this.imdiTableModel.copyImdiRows(selectedRows);
            }
        } else {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Nothing selected to copy", "Table Copy");
        }
    }

    public void startLongFieldEditorForSelectedFields() {
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length > 0) {
            int[] selectedCols;
            if (this.getCellSelectionEnabled()) {
                selectedCols = this.getSelectedColumns();
            } else {
                selectedCols = new int[this.getColumnCount()];
                for (int colCounter = 0; colCounter < selectedCols.length; ++colCounter) {
                    selectedCols[colCounter] = colCounter;
                }
            }
            for (int currentRow : selectedRows) {
                for (int currentCol : selectedCols) {
                    Object currentCellValue = this.getValueAt(currentRow, currentCol);
                    if (!(currentCellValue instanceof ImdiField) && !(currentCellValue instanceof ImdiField[])) continue;
                    new ImdiChildCellEditor().startLongfieldEditor(this, currentCellValue, false, currentRow, currentCol);
                }
            }
        }
    }

    public ImdiField[] getSelectedFields() {
        HashSet<ImdiField> selectedFields = new HashSet<ImdiField>();
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length > 0) {
            int[] selectedCols;
            if (this.getCellSelectionEnabled()) {
                selectedCols = this.getSelectedColumns();
            } else {
                selectedCols = new int[this.getColumnCount()];
                for (int colCounter = 0; colCounter < selectedCols.length; ++colCounter) {
                    selectedCols[colCounter] = colCounter;
                }
            }
            for (int currentRow : selectedRows) {
                for (int currentCol : selectedCols) {
                    if (this.getValueAt(currentRow, currentCol) instanceof ImdiField) {
                        selectedFields.add((ImdiField)this.getValueAt(currentRow, currentCol));
                        continue;
                    }
                    if (!(this.getValueAt(currentRow, currentCol) instanceof ImdiField[])) continue;
                    for (ImdiField currentField : (ImdiField[])this.getValueAt(currentRow, currentCol)) {
                        selectedFields.add(currentField);
                    }
                }
            }
            return selectedFields.toArray(new ImdiField[0]);
        }
        return null;
    }

    public void pasteIntoSelectedTableRowsFromClipBoard() {
        ImdiField[] selectedFields = this.getSelectedFields();
        if (selectedFields != null) {
            String pasteResult = this.imdiTableModel.pasteIntoImdiFields(selectedFields);
            if (pasteResult != null) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue(pasteResult, "Paste into Table");
            }
        } else {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("No rows selected", "Paste into Table");
        }
    }

    public void viewSelectedTableRows() {
        int[] selectedRows = this.getSelectedRows();
        LinorgWindowManager.getSingleInstance().openFloatingTableOnce(this.imdiTableModel.getSelectedImdiNodes(selectedRows), null);
    }

    public ImdiTreeObject getImdiNodeForSelection() {
        Object cellValue = this.imdiTableModel.getValueAt(this.getSelectedRow(), this.getSelectedColumn());
        ImdiTreeObject cellImdiNode = null;
        if (cellValue instanceof ImdiField) {
            cellImdiNode = ((ImdiField)cellValue).parentImdi;
        } else if (cellValue instanceof ImdiField[]) {
            cellImdiNode = ((ImdiField[])cellValue)[0].parentImdi;
        } else if (cellValue instanceof ImdiTreeObject) {
            cellImdiNode = (ImdiTreeObject)cellValue;
        } else if (cellValue instanceof ImdiTreeObject[]) {
            cellImdiNode = ((ImdiTreeObject[])cellValue)[0];
        }
        return cellImdiNode;
    }

    public ImdiTreeObject[] getSelectedRowsFromTable() {
        int[] selectedRows = this.getSelectedRows();
        return this.imdiTableModel.getSelectedImdiNodes(selectedRows);
    }

    public void hideSelectedColumnsFromTable() {
        int[] selectedColumns = this.getSelectedColumns();
        Integer[] selectedModelColumns = new Integer[selectedColumns.length];
        for (int columnCounter = 0; columnCounter < selectedColumns.length; ++columnCounter) {
            selectedModelColumns[columnCounter] = this.convertColumnIndexToModel(selectedColumns[columnCounter]);
        }
        Arrays.sort(selectedModelColumns, Collections.reverseOrder());
        Integer[] arr$ = selectedModelColumns;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            int selectedModelCol = arr$[i$];
            this.imdiTableModel.hideColumn(selectedModelCol);
        }
    }

    public void removeSelectedRowsFromTable() {
        int[] selectedRows = this.getSelectedRows();
        this.imdiTableModel.removeImdiRows(selectedRows);
    }

    public void highlightMatchingRows() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow == -1) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("No rows have been selected", "Highlight Matching Rows");
            return;
        }
        Vector foundRows = this.imdiTableModel.getMatchingRows(selectedRow);
        this.getSelectionModel().setSelectionMode(2);
        this.getSelectionModel().clearSelection();
        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Found " + foundRows.size() + " matching rows", "Highlight Matching Rows");
        for (int foundCount = 0; foundCount < foundRows.size(); ++foundCount) {
            for (int coloumCount = 0; coloumCount < this.getColumnCount(); ++coloumCount) {
                this.getSelectionModel().addSelectionInterval((Integer)foundRows.get(foundCount), (Integer)foundRows.get(foundCount));
            }
        }
    }
}

