/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.io.File;
import java.net.URI;
import java.util.Enumeration;
import java.util.Vector;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;

public class LinorgFavourites {
    private static LinorgFavourites singleInstance = null;

    public static synchronized LinorgFavourites getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new LinorgFavourites();
        }
        return singleInstance;
    }

    public void convertOldFormatLocationLists() {
        try {
            File oldLocationsFile = new File(LinorgSessionStorage.getSingleInstance().storageDirectory, "locationsList");
            File oldFavouritesFile = new File(LinorgSessionStorage.getSingleInstance().storageDirectory, "selectedFavourites");
            if (oldLocationsFile.exists()) {
                Vector locationsList = (Vector)LinorgSessionStorage.getSingleInstance().loadObject("locationsList");
                if (oldFavouritesFile.exists()) {
                    Vector userFavouritesStrings = (Vector)LinorgSessionStorage.getSingleInstance().loadObject("selectedFavourites");
                    locationsList.addAll(userFavouritesStrings);
                    LinorgSessionStorage.getSingleInstance().saveStringArray("locationsList", locationsList.toArray(new String[0]));
                    oldFavouritesFile.deleteOnExit();
                }
                if (null == LinorgSessionStorage.getSingleInstance().loadStringArray("locationsList")) {
                    LinorgSessionStorage.getSingleInstance().saveStringArray("locationsList", locationsList.toArray(new String[0]));
                }
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public boolean toggleFavouritesList(ImdiTreeObject[] imdiObjectArray, boolean setAsTempate) {
        System.out.println("toggleFavouriteList: " + setAsTempate);
        if (setAsTempate) {
            boolean selectionNeedsSave = false;
            for (ImdiTreeObject currentImdiObject : imdiObjectArray) {
                if (!currentImdiObject.getNeedsSaveToDisk()) continue;
                selectionNeedsSave = true;
            }
            if (selectionNeedsSave) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Changes must be saved before adding to the favourites.", "Add Favourites");
                return false;
            }
        }
        for (ImdiTreeObject currentImdiObject : imdiObjectArray) {
            if (currentImdiObject.isEmptyMetaNode()) {
                setAsTempate = false;
            }
            if (setAsTempate) {
                this.addAsFavourite(currentImdiObject.getURI());
                continue;
            }
            this.removeFromFavourites(currentImdiObject.getURI());
        }
        return true;
    }

    private void addAsFavourite(URI imdiUri) {
        try {
            File destinationFile = File.createTempFile("fav-", ".imdi", LinorgSessionStorage.getSingleInstance().getFavouritesDir());
            ImdiTreeObject.getMetadataUtils(imdiUri.toString()).copyMetadataFile(imdiUri, destinationFile, null, true);
            URI copiedFileURI = destinationFile.toURI();
            String uriString = copiedFileURI.toString().split("#")[0];
            if (imdiUri.getFragment() != null) {
                uriString = uriString + "#" + imdiUri.getFragment();
            }
            URI favouriteUri = new URI(uriString);
            TreeHelper.getSingleInstance().addLocation(favouriteUri);
            TreeHelper.getSingleInstance().applyRootLocations();
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    private void removeFromFavourites(URI imdiUri) {
        TreeHelper.getSingleInstance().removeLocation(imdiUri);
        TreeHelper.getSingleInstance().applyRootLocations();
    }

    public Enumeration listFavouritesFor(Object targetNodeUserObject) {
        System.out.println("listFavouritesFor: " + targetNodeUserObject);
        Vector<String[]> validFavourites = new Vector<String[]>();
        if (targetNodeUserObject instanceof ImdiTreeObject) {
            ImdiTreeObject targetImdiObject = (ImdiTreeObject)targetNodeUserObject;
            boolean targetIsCorpus = targetImdiObject.isCorpus();
            boolean targetIsSession = targetImdiObject.isSession();
            boolean targetIsImdiChild = targetImdiObject.isImdiChild();
            for (ImdiTreeObject currentFavouritesObject : TreeHelper.getSingleInstance().favouriteNodes) {
                boolean addThisFavourites = false;
                if (targetIsCorpus && !currentFavouritesObject.isImdiChild()) {
                    addThisFavourites = true;
                } else if (targetIsSession && currentFavouritesObject.isImdiChild()) {
                    addThisFavourites = ImdiSchema.getSingleInstance().nodeCanExistInNode(targetImdiObject, currentFavouritesObject);
                } else if (targetIsImdiChild && currentFavouritesObject.isImdiChild()) {
                    addThisFavourites = ImdiSchema.getSingleInstance().nodeCanExistInNode(targetImdiObject, currentFavouritesObject);
                }
                if (!addThisFavourites) continue;
                validFavourites.add(new String[]{currentFavouritesObject.toString(), currentFavouritesObject.getUrlString()});
            }
        }
        return validFavourites.elements();
    }

    public String getNodeType(ImdiTreeObject favouriteImdiObject, ImdiTreeObject targetImdiObject) {
        String returnValue;
        String favouriteXmlPath = favouriteImdiObject.getURI().getFragment();
        String targetXmlPath = targetImdiObject.getURI().getFragment();
        System.out.println("getNodeType: \nfavouriteXmlPath: " + favouriteXmlPath + "\ntargetXmlPath:" + targetXmlPath);
        if (favouriteImdiObject.isSession()) {
            returnValue = ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Session";
        } else if (favouriteImdiObject.isCorpus()) {
            returnValue = ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Corpus";
        } else if (favouriteImdiObject.isImdiChild()) {
            if (targetXmlPath == null) {
                returnValue = favouriteXmlPath.replaceAll("\\(\\d*?\\)$", "");
            } else {
                System.out.println("targetXmlPath: " + targetXmlPath);
                System.out.println("favouriteXmlPath: " + favouriteXmlPath);
                favouriteXmlPath = favouriteXmlPath.replaceAll("\\(\\d*?\\)$", "");
                String[] splitFavouriteXmlPath = favouriteXmlPath.split("\\)");
                String[] splitTargetXmlPath = targetXmlPath.split("\\)");
                System.out.println("splitFavouriteXmlPath: " + splitFavouriteXmlPath.length + " splitTargetXmlPath: " + splitTargetXmlPath.length);
                returnValue = "";
                for (int partCounter = 0; partCounter < splitFavouriteXmlPath.length; ++partCounter) {
                    returnValue = splitTargetXmlPath.length > partCounter ? returnValue.concat(splitTargetXmlPath[partCounter] + ")") : returnValue.concat(splitFavouriteXmlPath[partCounter] + ")");
                }
                returnValue = returnValue.replaceAll("\\)$", "");
                returnValue = returnValue.replaceAll("\\(\\d*?$", "");
            }
        } else {
            returnValue = null;
        }
        System.out.println("getNodeTypeReturnValue: " + returnValue);
        return returnValue;
    }
}

