/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgJournal;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.clarin.FieldUpdateRequest;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiTreeObject;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CmdiComponentBuilder {
    public Document getDocument(URI inputUri) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = inputUri == null ? documentBuilder.newDocument() : documentBuilder.parse(inputUri.toString());
        return document;
    }

    public void savePrettyFormatting(Document document, File outputFile) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
            StreamResult xmlOutput = new StreamResult(fileOutputStream);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(dOMSource, xmlOutput);
            xmlOutput.getOutputStream().close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GuiHelper.linorgBugCatcher.logError(illegalArgumentException);
        }
        catch (TransformerException transformerException) {
            GuiHelper.linorgBugCatcher.logError(transformerException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            System.out.println(transformerFactoryConfigurationError.getMessage());
        }
        catch (FileNotFoundException notFoundException) {
            GuiHelper.linorgBugCatcher.logError(notFoundException);
        }
        catch (IOException iOException) {
            GuiHelper.linorgBugCatcher.logError(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertResourceProxy(ImdiTreeObject imdiTreeObject, ImdiTreeObject resourceNode) {
        Object object = imdiTreeObject.domLockObject;
        synchronized (object) {
            String targetXmlPath = imdiTreeObject.getURI().getFragment();
            if (targetXmlPath == null) {
                targetXmlPath = ".CMD.Components." + imdiTreeObject.getParentDomNode().nodeTemplate.loadedTemplateName;
            }
            System.out.println("insertResourceProxy: " + targetXmlPath);
            String resourceProxyId = UUID.randomUUID().toString();
            try {
                SchemaType schemaType = this.getFirstSchemaType(imdiTreeObject.getNodeTemplate().templateFile);
                Document targetDocument = this.getDocument(imdiTreeObject.getURI());
                try {
                    try {
                        Node documentNode = this.selectSingleNode(targetDocument, targetXmlPath);
                        Node previousRefNode = documentNode.getAttributes().getNamedItem("ref");
                        if (previousRefNode != null) {
                            String previousRefValue = documentNode.getAttributes().getNamedItem("ref").getNodeValue();
                        }
                        ((Element)documentNode).setAttribute("ref", resourceProxyId);
                    }
                    catch (TransformerException exception) {
                        GuiHelper.linorgBugCatcher.logError(exception);
                        return null;
                    }
                    Node addedResourceNode = this.insertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, ".CMD.Resources.ResourceProxyList", ".CMD.Resources.ResourceProxyList.ResourceProxy");
                    addedResourceNode.getAttributes().getNamedItem("id").setNodeValue(resourceProxyId);
                    for (Node childNode = addedResourceNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                        String localName = childNode.getNodeName();
                        if ("ResourceType".equals(localName)) {
                            childNode.setTextContent(resourceNode.mpiMimeType);
                        }
                        if (!"ResourceRef".equals(localName)) continue;
                        childNode.setTextContent(resourceNode.getUrlString());
                    }
                }
                catch (Exception exception) {
                    GuiHelper.linorgBugCatcher.logError(exception);
                    return null;
                }
                imdiTreeObject.bumpHistory();
                this.savePrettyFormatting(targetDocument, imdiTreeObject.getFile());
            }
            catch (IOException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            catch (ParserConfigurationException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            catch (SAXException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            return imdiTreeObject.getURI();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChildNodes(ImdiTreeObject imdiTreeObject, String[] nodePaths) {
        Object object = imdiTreeObject.domLockObject;
        synchronized (object) {
            System.out.println("removeChildNodes: " + imdiTreeObject);
            File cmdiNodeFile = imdiTreeObject.getFile();
            try {
                Document targetDocument = this.getDocument(imdiTreeObject.getURI());
                ArrayList<Node> selectedNodes = new ArrayList<Node>();
                for (String currentNodePath : nodePaths) {
                    System.out.println("removeChildNodes: " + currentNodePath);
                    Node documentNode = this.selectSingleNode(targetDocument, currentNodePath);
                    selectedNodes.add(documentNode);
                }
                for (Node currentNode : selectedNodes) {
                    currentNode.getParentNode().removeChild(currentNode);
                }
                imdiTreeObject.bumpHistory();
                this.savePrettyFormatting(targetDocument, cmdiNodeFile);
                for (String currentNodePath : nodePaths) {
                }
                return true;
            }
            catch (ParserConfigurationException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
            catch (SAXException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
            catch (IOException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
            catch (TransformerException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setFieldValues(ImdiTreeObject imdiTreeObject, FieldUpdateRequest[] fieldUpdates) {
        Object object = imdiTreeObject.domLockObject;
        synchronized (object) {
            System.out.println("setFieldValues: " + imdiTreeObject);
            File cmdiNodeFile = imdiTreeObject.getFile();
            try {
                Document targetDocument = this.getDocument(imdiTreeObject.getURI());
                for (FieldUpdateRequest currentFieldUpdate : fieldUpdates) {
                    Node languageNode;
                    System.out.println("currentFieldUpdate: " + currentFieldUpdate.fieldPath);
                    Node documentNode = this.selectSingleNode(targetDocument, currentFieldUpdate.fieldPath);
                    NamedNodeMap attributesMap = documentNode.getAttributes();
                    if (!currentFieldUpdate.fieldOldValue.equals(documentNode.getTextContent())) {
                        GuiHelper.linorgBugCatcher.logError(new Exception("expecting '" + currentFieldUpdate.fieldOldValue + "' not '" + documentNode.getTextContent() + "' in " + currentFieldUpdate.fieldPath));
                        return false;
                    }
                    documentNode.setTextContent(currentFieldUpdate.fieldNewValue);
                    Node keyNameNode = attributesMap.getNamedItem("Name");
                    if (keyNameNode != null && currentFieldUpdate.keyNameValue != null) {
                        keyNameNode.setNodeValue(currentFieldUpdate.keyNameValue);
                    }
                    if ((languageNode = attributesMap.getNamedItem("LanguageId")) == null || currentFieldUpdate.fieldLanguageId == null) continue;
                    languageNode.setNodeValue(currentFieldUpdate.fieldLanguageId);
                }
                imdiTreeObject.bumpHistory();
                this.savePrettyFormatting(targetDocument, cmdiNodeFile);
                for (FieldUpdateRequest currentFieldUpdate : fieldUpdates) {
                    LinorgJournal.getSingleInstance().saveJournalEntry(imdiTreeObject.getUrlString(), currentFieldUpdate.fieldPath, currentFieldUpdate.fieldOldValue, currentFieldUpdate.fieldNewValue, "save");
                    if (currentFieldUpdate.fieldLanguageId != null) {
                        LinorgJournal.getSingleInstance().saveJournalEntry(imdiTreeObject.getUrlString(), currentFieldUpdate.fieldPath + ":LanguageId", currentFieldUpdate.fieldLanguageId, "", "save");
                    }
                    if (currentFieldUpdate.keyNameValue == null) continue;
                    LinorgJournal.getSingleInstance().saveJournalEntry(imdiTreeObject.getUrlString(), currentFieldUpdate.fieldPath + ":Name", currentFieldUpdate.keyNameValue, "", "save");
                }
                return true;
            }
            catch (ParserConfigurationException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
            catch (SAXException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
            catch (IOException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
            catch (TransformerException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
            }
            return false;
        }
    }

    public void testInsertFavouriteComponent() {
        try {
            ImdiTreeObject favouriteImdiTreeObject1 = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(new URI("file:/Users/petwit/.arbil/favourites/fav-784841449583527834.imdi#.METATRANSCRIPT.Session.MDGroup.Actors.Actor"));
            ImdiTreeObject favouriteImdiTreeObject2 = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(new URI("file:/Users/petwit/.arbil/favourites/fav-784841449583527834.imdi#.METATRANSCRIPT.Session.MDGroup.Actors.Actor(2)"));
            ImdiTreeObject destinationImdiTreeObject = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(new URI("file:/Users/petwit/.arbil/imdicache/20100527141926/20100527141926.imdi"));
            this.insertFavouriteComponent(destinationImdiTreeObject, favouriteImdiTreeObject1);
            this.insertFavouriteComponent(destinationImdiTreeObject, favouriteImdiTreeObject2);
        }
        catch (URISyntaxException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertFavouriteComponent(ImdiTreeObject destinationImdiTreeObject, ImdiTreeObject favouriteImdiTreeObject) {
        try {
            Document favouriteDocument;
            Object object = favouriteImdiTreeObject.domLockObject;
            synchronized (object) {
                favouriteDocument = this.getDocument(favouriteImdiTreeObject.getURI());
            }
            object = destinationImdiTreeObject.domLockObject;
            synchronized (object) {
                Node[] favouriteNodes;
                Document destinationDocument = this.getDocument(destinationImdiTreeObject.getURI());
                String favouriteXpath = favouriteImdiTreeObject.getURI().getFragment();
                String favouriteXpathTrimmed = favouriteXpath.replaceFirst("\\.[^(^.]+$", "");
                boolean onlySubNodes = !favouriteXpathTrimmed.equals(favouriteXpath);
                System.out.println("favouriteXpath: " + favouriteXpathTrimmed);
                Node selectedNode = this.selectSingleNode(favouriteDocument, favouriteXpathTrimmed);
                if (onlySubNodes) {
                    NodeList selectedNodeList = selectedNode.getChildNodes();
                    favouriteNodes = new Node[selectedNodeList.getLength()];
                    for (int nodeCounter = 0; nodeCounter < selectedNodeList.getLength(); ++nodeCounter) {
                        favouriteNodes[nodeCounter] = selectedNodeList.item(nodeCounter);
                    }
                } else {
                    favouriteNodes = new Node[]{selectedNode};
                }
                for (Node singleFavouriteNode : favouriteNodes) {
                    if (singleFavouriteNode.getNodeType() == 3) continue;
                    System.out.println("favouriteNode1: " + singleFavouriteNode.getLocalName());
                    System.out.println("favouriteNode2: " + singleFavouriteNode.getNodeValue());
                    System.out.println("favouriteNode3: " + singleFavouriteNode.getNodeName());
                }
            }
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (ParserConfigurationException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (SAXException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (TransformerException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI insertChildComponent(ImdiTreeObject imdiTreeObject, String targetXmlPath, String cmdiComponentId) {
        Object object = imdiTreeObject.domLockObject;
        synchronized (object) {
            System.out.println("insertChildComponent: " + cmdiComponentId);
            System.out.println("targetXmlPath: " + targetXmlPath);
            if (targetXmlPath == null) {
                targetXmlPath = cmdiComponentId.replaceAll("\\.[^.]+$", "");
            } else if (targetXmlPath.replaceAll("\\(\\d+\\)", "").length() == cmdiComponentId.length()) {
                targetXmlPath = targetXmlPath.replaceAll("\\.[^.]+$", "");
            }
            String[] cmdiComponentArray = cmdiComponentId.split("\\.");
            String[] targetXmlPathArray = targetXmlPath.replaceAll("\\(\\d+\\)", "").split("\\.");
            for (int pathPartCounter = targetXmlPathArray.length; pathPartCounter < cmdiComponentArray.length - 1; ++pathPartCounter) {
                System.out.println("adding missing path component: " + cmdiComponentArray[pathPartCounter]);
                targetXmlPath = targetXmlPath + "." + cmdiComponentArray[pathPartCounter];
            }
            System.out.println("trimmed targetXmlPath: " + targetXmlPath);
            String nodeFragment = "";
            try {
                SchemaType schemaType = this.getFirstSchemaType(imdiTreeObject.getNodeTemplate().templateFile);
                Document targetDocument = this.getDocument(imdiTreeObject.getURI());
                try {
                    Node AddedNode = this.insertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, targetXmlPath, cmdiComponentId);
                    nodeFragment = this.convertNodeToNodePath(targetDocument, AddedNode, targetXmlPath);
                }
                catch (Exception exception) {
                    GuiHelper.linorgBugCatcher.logError(exception);
                    return null;
                }
                imdiTreeObject.bumpHistory();
                this.savePrettyFormatting(targetDocument, imdiTreeObject.getFile());
            }
            catch (IOException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            catch (ParserConfigurationException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            catch (SAXException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            try {
                System.out.println("nodeFragment: " + nodeFragment);
                return new URI(imdiTreeObject.getURI().toString().split("#")[0] + "#" + nodeFragment);
            }
            catch (URISyntaxException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
        }
    }

    public void testRemoveArchiveHandles() {
        try {
            Document workingDocument = this.getDocument(new URI("http://corpus1.mpi.nl/qfs1/media-archive/Corpusstructure/MPI.imdi"));
            this.removeArchiveHandles(workingDocument);
            this.printoutDocument(workingDocument);
        }
        catch (Exception exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
    }

    private void removeArchiveHandles(Document targetDocument) {
        String handleXpath = "//*[@ArchiveHandle]";
        try {
            NodeList archiveHandleNodeList = XPathAPI.selectNodeList((Node)targetDocument, (String)handleXpath);
            for (int nodeCounter = 0; nodeCounter < archiveHandleNodeList.getLength(); ++nodeCounter) {
                Node archiveHandleNode = archiveHandleNodeList.item(nodeCounter);
                if (archiveHandleNode == null) continue;
                archiveHandleNode.getAttributes().getNamedItem("ArchiveHandle").setNodeValue("");
            }
        }
        catch (TransformerException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
    }

    private Node selectSingleNode(Document targetDocument, String targetXpath) throws TransformerException {
        String[] tempXpathArray;
        for (String tempXpath : tempXpathArray = new String[]{targetXpath.replaceAll("\\.", "/"), targetXpath.replaceAll("\\.", "/:")}) {
            tempXpath = tempXpath.replaceAll("\\(", "[");
            tempXpath = tempXpath.replaceAll("\\)", "]");
            System.out.println("tempXpath: " + tempXpath);
            Node returnNode = XPathAPI.selectSingleNode((Node)targetDocument, (String)tempXpath);
            if (returnNode == null) continue;
            return returnNode;
        }
        GuiHelper.linorgBugCatcher.logError(new Exception("Xpath issue, no node found for: " + targetXpath));
        return null;
    }

    private Node insertSectionToXpath(Document targetDocument, Node documentNode, SchemaType schemaType, String targetXpath, String xsdPath) throws Exception {
        System.out.println("insertSectionToXpath");
        System.out.println("xsdPath: " + xsdPath);
        System.out.println("targetXpath: " + targetXpath);
        SchemaProperty foundProperty = null;
        String strippedXpath = null;
        if (targetXpath == null) {
            documentNode = documentNode.getParentNode();
        } else {
            try {
                documentNode = this.selectSingleNode(targetDocument, targetXpath);
            }
            catch (TransformerException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            strippedXpath = targetXpath.replaceAll("\\(\\d+\\)", "");
        }
        System.out.println("strippedXpath: " + strippedXpath);
        for (String currentPathComponent : xsdPath.split("\\.")) {
            if (currentPathComponent.length() <= 0) continue;
            System.out.println("currentPathComponent: " + currentPathComponent);
            foundProperty = null;
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                String currentName = schemaProperty.getName().getLocalPart();
                if (!currentPathComponent.equals(currentName)) continue;
                foundProperty = schemaProperty;
                break;
            }
            if (foundProperty == null) {
                throw new Exception("failed to find the path in the schema: " + currentPathComponent);
            }
            schemaType = foundProperty.getType();
            System.out.println("foundProperty: " + foundProperty.getName().getLocalPart());
        }
        System.out.println("Adding destination sub nodes node to: " + documentNode.getLocalName());
        return this.constructXml(foundProperty, xsdPath, targetDocument, null, documentNode);
    }

    public String convertNodeToNodePath(Document targetDocument, Node documentNode, String targetXmlPath) {
        System.out.println("Calculating the added fragment");
        int siblingCouter = 1;
        for (Node siblingNode = documentNode.getPreviousSibling(); siblingNode != null; siblingNode = siblingNode.getPreviousSibling()) {
            if (!documentNode.getNodeName().equals(siblingNode.getNodeName())) continue;
            ++siblingCouter;
        }
        String nodeFragment = documentNode.getNodeName();
        String nodePathString = targetXmlPath + "." + nodeFragment + "(" + siblingCouter + ")";
        System.out.println("nodeFragment: " + nodePathString);
        System.out.println("targetXmlPath: " + targetXmlPath);
        return nodePathString;
    }

    public URI createComponentFile(URI cmdiNodeFile, URI xsdFile) {
        System.out.println("createComponentFile: " + cmdiNodeFile + " : " + xsdFile);
        try {
            Document workingDocument = this.getDocument(null);
            this.readSchema(workingDocument, xsdFile);
            this.savePrettyFormatting(workingDocument, new File(cmdiNodeFile));
        }
        catch (IOException e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        catch (ParserConfigurationException e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        catch (SAXException e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        return cmdiNodeFile;
    }

    private SchemaType getFirstSchemaType(File schemaFile) {
        try {
            FileInputStream inputStream = new FileInputStream(schemaFile);
            XmlOptions options = new XmlOptions();
            options.setCharacterEncoding("UTF-8");
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((InputStream)inputStream, (XmlOptions)options)}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), null);
            return sts.documentTypes()[0];
        }
        catch (IOException e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        catch (XmlException e) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not read the XML Schema", "Error inserting node");
            GuiHelper.linorgBugCatcher.logError((Exception)((Object)e));
        }
        return null;
    }

    private void readSchema(Document workingDocument, URI xsdFile) {
        File schemaFile = LinorgSessionStorage.getSingleInstance().updateCache(xsdFile.toString(), 5);
        SchemaType schemaType = this.getFirstSchemaType(schemaFile);
        this.constructXml(schemaType.getElementProperties()[0], "documentTypes", workingDocument, xsdFile.toString(), null);
    }

    private Element appendNode(Document workingDocument, String nameSpaceUri, Node parentElement, SchemaProperty schemaProperty) {
        Element currentElement = workingDocument.createElement(schemaProperty.getName().getLocalPart());
        SchemaType currentSchemaType = schemaProperty.getType();
        for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
            if (attributesProperty.getMinOccurs() == null || attributesProperty.getMinOccurs().equals(BigInteger.ZERO)) continue;
            currentElement.setAttribute(attributesProperty.getName().getLocalPart(), attributesProperty.getDefaultText());
        }
        if (parentElement == null) {
            currentElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            currentElement.setAttribute("xsi:schemaLocation", "http://www.clarin.eu/cmd " + nameSpaceUri);
            workingDocument.appendChild(currentElement);
        } else {
            parentElement.appendChild(currentElement);
        }
        return currentElement;
    }

    private Node constructXml(SchemaProperty currentSchemaProperty, String pathString, Document workingDocument, String nameSpaceUri, Node parentElement) {
        Element currentElement;
        Element returnNode = null;
        String currentPathString = pathString + "." + currentSchemaProperty.getName().getLocalPart();
        System.out.println("Found Element: " + currentPathString);
        SchemaType currentSchemaType = currentSchemaProperty.getType();
        returnNode = currentElement = this.appendNode(workingDocument, nameSpaceUri, parentElement, currentSchemaProperty);
        for (SchemaProperty schemaProperty : currentSchemaType.getElementProperties()) {
            if (schemaProperty.getMinOccurs() == null) continue;
            BigInteger addNodeCounter = BigInteger.ZERO;
            while (addNodeCounter.compareTo(schemaProperty.getMinOccurs()) < 0) {
                this.constructXml(schemaProperty, currentPathString, workingDocument, nameSpaceUri, currentElement);
                addNodeCounter = addNodeCounter.add(BigInteger.ONE);
            }
        }
        return returnNode;
    }

    private void printoutDocument(Document workingDocument) {
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer transformer = tranFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource src = new DOMSource(workingDocument);
            StreamResult dest = new StreamResult(System.out);
            transformer.transform(src, dest);
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
    }

    public void testWalk() {
        try {
            Document workingDocument = this.getDocument(null);
            this.readSchema(workingDocument, new URI("http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1264769926773/xsd"));
            this.printoutDocument(workingDocument);
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
    }

    public static void main(String[] args) {
        new CmdiComponentBuilder().testInsertFavouriteComponent();
    }
}

