/*
 * Decompiled with CFR 0.152.
 */
package mpi.bcarchive.spider;

import java.net.MalformedURLException;
import mpi.bcarchive.spider.IMDISpider;
import mpi.bcarchive.spider.TestHandler;
import mpi.util.OurURL;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class TestIMDISpider {
    static Logger logger = Logger.getRootLogger();

    public TestIMDISpider() {
        BasicConfigurator.configure();
        logger.setLevel(Level.INFO);
        logger.setLevel(Level.DEBUG);
        logger.debug((Object)("Logger name:" + logger.getName()));
    }

    public void runTest(OurURL url) {
        IMDISpider sp = new IMDISpider();
        TestHandler nh = new TestHandler();
        sp.run(url, nh, true);
        this.logCounts(sp);
    }

    public static void main(String[] args) {
        TestIMDISpider tester = new TestIMDISpider();
        if (args.length < 1) {
            System.err.println("Use: TestIMDISpider <imdi-file>");
            System.exit(1);
        }
        String myfile = args[0];
        OurURL url = null;
        if (myfile.indexOf(":") < 0) {
            myfile = "file:" + myfile;
        }
        try {
            url = new OurURL(myfile);
            tester.runTest(url);
        }
        catch (MalformedURLException mue) {
            logger.info((Object)("URL error: " + myfile));
        }
    }

    private void logCounts(IMDISpider sp) {
        logger.info((Object)("Corpus    IMDI     : " + sp.getCorpusCount()));
        logger.info((Object)("Session   IMDI     : " + sp.getSessionCount()));
        logger.info((Object)("Catalogue IMDI     : " + sp.getCatalogueCount()));
        logger.info((Object)("Media     Resource : " + sp.getMediaCount()));
        logger.info((Object)("Written   Resource : " + sp.getWrittenCount()));
        logger.info((Object)("Lexicon   Resource : " + sp.getLexiconCount()));
        logger.info((Object)("Info      Resource : " + sp.getInfoCount()));
    }
}

