/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import mpi.bcarchive.spider.IMDINode;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.UnknownNodeException;
import mpi.util.OurURL;
import org.apache.log4j.Logger;

public class ArchiveAccessContext {
    private static Logger logger = Logger.getLogger((String)ArchiveAccessContext.class.getName());
    public static final int NO_TRANSLATION = 0;
    public static final int FILE_UX_URL = 1;
    public static final int FILE_UNC_URL = 2;
    public static final int HTTP_URL = 3;
    protected static final int HANDLE_HOST = 4;
    protected static final int HANDLE_PREFIX = 5;
    protected static final int ARCHIVE_NAME = 6;
    public static final int TABLE_URL_CONTEXT = 3;
    public static final int DEFAULT_SERVER_ACCESS_CONTEXT = 3;
    private static final int file_url_context;
    public static final String[] aRootsPropertyNames;
    private static final String[] aRootsDefaults;
    private String[] aRoots = new String[7];
    private boolean defaultsActive = true;

    protected ArchiveAccessContext() {
    }

    public String getRoot(int context) {
        if (this.defaultsActive) {
            logger.warn((Object)("getRoot(" + context + ") - not configured, using defaults! = " + this.aRoots[context]));
        }
        if (context < 1 || context > 6) {
            return null;
        }
        return this.aRoots[context];
    }

    public String getHandleProxy() {
        return this.getRoot(4);
    }

    public String getHandlePrefix() {
        return this.getRoot(5);
    }

    public String getArchiveName() {
        return this.getRoot(6);
    }

    public static int getFileUrlContext() {
        return file_url_context;
    }

    public void updateRoot(int context, String root) throws MalformedURLException {
        if (context < 1 || context > 6) {
            logger.warn((Object)("updateRoot: attempt to update undefined entry " + context + " ignored. String was: " + root));
            return;
        }
        if (root == null) {
            root = aRootsDefaults[context];
        }
        if (root != null && root.indexOf("///") != -1) {
            root = root.replaceFirst("///", "/");
        }
        if (root != null && context < 4) {
            if (!root.endsWith("/") && !root.endsWith("\\")) {
                root = root + "/";
            }
            try {
                OurURL testURL = new OurURL(root);
            }
            catch (MalformedURLException murle) {
                logger.error((Object)("updateRoot: Invalid root URL: " + murle));
                throw murle;
            }
        }
        if (context == 5) {
            logger.debug((Object)("### updateRoot: aRoots[HANDLE_PREFIX]=" + root));
        }
        this.aRoots[context] = root;
        this.defaultsActive = false;
    }

    public boolean loadPropertyFile(String propertyFileName) {
        Properties aacProps = new Properties(System.getProperties());
        InputStream is = null;
        try {
            is = new File(propertyFileName).exists() ? new FileInputStream(propertyFileName) : this.getClass().getResourceAsStream("/" + propertyFileName);
            if (is == null) {
                logger.debug((Object)("could not find propertyfile: " + propertyFileName));
                return false;
            }
            aacProps.load(is);
            logger.info((Object)("loaded propertyfile: " + propertyFileName));
            is.close();
        }
        catch (Exception e) {
            logger.error((Object)("problem loading property file: " + propertyFileName + " " + e));
            return false;
        }
        int[] contexts = new int[]{1, 2, 3, 4, 5, 6};
        for (int i = 0; i < contexts.length; ++i) {
            int context = contexts[i];
            String root = aacProps.getProperty(aRootsPropertyNames[context], this.aRoots[context]);
            try {
                this.updateRoot(context, root);
                continue;
            }
            catch (MalformedURLException mue) {
                logger.warn((Object)("loadPropertyFile: Ignored invalid URL '" + root + "', context " + context));
            }
        }
        return true;
    }

    public OurURL fetchURL(IMDINode in, int accessContext, ArchiveObjectsDB ao) {
        OurURL url = in.getURL();
        String urid = in.getURID();
        OurURL resolved = null;
        if (urid == null) {
            return url;
        }
        if (urid.startsWith("hdl:")) {
            urid = urid.substring(4);
        }
        while (urid.startsWith("/")) {
            urid = urid.substring(1);
        }
        String nodeId = NodeIdUtils.handleToNodeId(urid, ao.getArchiveRoots().getHandlePrefix());
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.warn((Object)("Invalid URID for link: " + urid + " for " + url));
            return url;
        }
        try {
            resolved = ao.getObjectURL(nodeId, accessContext);
        }
        catch (UnknownNodeException une) {
            // empty catch block
        }
        if (resolved == null) {
            logger.warn((Object)("URID does not resolve: " + urid + " NodeId: " + nodeId));
            return url;
        }
        if (url == null) {
            logger.debug((Object)("$ URID link without URL: " + urid));
            return resolved;
        }
        if (url.sameFile(resolved)) {
            return url;
        }
        try {
            OurURL inContext = new OurURL(this.uriInContext(this.inTableContext(this.stringToURI(url.toString())).toString(), accessContext).toURL());
            if (inContext.sameFile(resolved)) {
                logger.debug((Object)("$ URID link matches after context fixup: " + urid + " for " + inContext));
                return inContext;
            }
        }
        catch (Exception e) {
            logger.warn((Object)("URID / URL comparison problem, exception: " + e));
        }
        logger.warn((Object)("URID / URL mismatch for link, using URID: " + urid + " is " + resolved + " not " + url));
        return resolved;
    }

    public OurURL toClassicURL(String urlspec, boolean force, ArchiveObjectsDB resolver) throws MalformedURLException {
        if (urlspec == null) {
            return null;
        }
        if (urlspec.startsWith("file:")) {
            return new OurURL(urlspec);
        }
        if (!urlspec.startsWith("hdl:")) {
            return new OurURL(urlspec);
        }
        String ourHandleHTTPProxy = this.getHandleProxy();
        String ourHandle = urlspec.substring(4);
        while (ourHandle.startsWith("/")) {
            ourHandle = ourHandle.substring(1);
        }
        if (force || ourHandleHTTPProxy == null || ourHandleHTTPProxy.equals("auto")) {
            if (resolver == null) {
                throw new MalformedURLException("no resolver - could not resolve handle: " + ourHandle);
            }
            try {
                return resolver.getObjectURL(ourHandle, 3);
            }
            catch (UnknownNodeException une) {
                logger.warn((Object)("toClassicURL: could not resolve handle: " + ourHandle + " error: " + une));
                throw new MalformedURLException("could not resolve handle: " + ourHandle + " error: " + une);
            }
        }
        return new OurURL(ourHandleHTTPProxy + ourHandle);
    }

    public URI inTableContext(URI uri) {
        if (uri == null) {
            return null;
        }
        int context = this.getAccessContextFromURI(uri.toString());
        try {
            uri = this.uriToTableContext(uri, context);
            return this.uriInContext(uri.toString(), 3);
        }
        catch (URISyntaxException use) {
            logger.warn((Object)("inTableContext: malformed URI: " + use));
            return uri;
        }
    }

    public URI mergeURI(String contextstr, String urlstr) throws URISyntaxException {
        try {
            if (urlstr == null || urlstr.equals("")) {
                return this.stringToURI(contextstr);
            }
            if (urlstr.startsWith("file:") || urlstr.startsWith("http:") || urlstr.startsWith("ftp:") || urlstr.startsWith("https:") || urlstr.indexOf(58) == -1) {
                OurURL merged = new OurURL(new OurURL(contextstr), urlstr);
                urlstr = merged.toString();
            }
            return this.stringToURI(urlstr);
        }
        catch (MalformedURLException mue) {
            logger.warn((Object)("mergeURI: Malformed URL: " + mue));
            throw new URISyntaxException(urlstr, "malformed URL");
        }
    }

    public URI stringToURI(String urlString) throws URISyntaxException {
        if (urlString == null) {
            return null;
        }
        int colon = urlString.indexOf(58);
        if (colon == -1) {
            throw new URISyntaxException(urlString, "URI is not absolute");
        }
        String urlstrSchema = urlString.substring(0, colon);
        String urlstrSSP = urlString.substring(colon + 1);
        String urlstrFragment = null;
        int fragment = urlstrSSP.indexOf(35);
        if (fragment != -1) {
            urlstrFragment = urlstrSSP.substring(fragment + 1).replaceAll(" ", "%20");
            urlstrSSP = urlstrSSP.substring(0, fragment);
        }
        return new URI(urlstrSchema, urlstrSSP.replaceAll(" ", "%20"), urlstrFragment);
    }

    protected URI uriToTableContext(URI uri, int context) {
        String myRoot;
        if (context == 0 || uri == null) {
            return uri;
        }
        if (!uri.isAbsolute()) {
            return null;
        }
        String urlstr = uri.toString();
        if (urlstr.indexOf("///") > -1) {
            urlstr = urlstr.replaceFirst("///", "/");
        }
        if ((myRoot = this.getRoot(context)) != null && urlstr.startsWith(myRoot)) {
            urlstr = urlstr.substring(myRoot.length());
        } else if (urlstr.startsWith("file") || urlstr.startsWith("/")) {
            logger.warn((Object)("uriToTableContext: Suspicious conversion: " + myRoot + " for " + urlstr));
        }
        try {
            if (this.getRoot(3) != null) {
                return this.mergeURI(this.getRoot(3), urlstr);
            }
            return uri;
        }
        catch (URISyntaxException use) {
            logger.warn((Object)("uriToTableContext: " + use));
            return uri;
        }
    }

    public URI uriInContext(String turl, int context) throws URISyntaxException {
        if (turl == null) {
            return null;
        }
        turl = turl.replaceAll(" ", "%20");
        if (context == 0 || context == -1) {
            return new URI(turl);
        }
        if (turl.indexOf("///") > -1) {
            turl = turl.replaceFirst("///", "/");
        }
        if (this.getRoot(3) != null && turl.startsWith(this.getRoot(3))) {
            turl = turl.substring(this.getRoot(3).length());
        } else if (turl.startsWith("file") || turl.startsWith("/")) {
            logger.warn((Object)("uriInContext: Suspicious conversion: " + this.getRoot(3) + " for " + turl));
        }
        if (this.getRoot(context) != null) {
            return this.mergeURI(this.getRoot(context), turl);
        }
        return new URI(turl);
    }

    public int getAccessContextFromURI(String urlstr) {
        if (urlstr == null) {
            return -1;
        }
        if (urlstr.startsWith("hdl:")) {
            return 0;
        }
        urlstr = urlstr.replaceFirst("///", "/");
        if (this.getRoot(2) != null && urlstr.startsWith(this.getRoot(2))) {
            return 2;
        }
        if (this.getRoot(1) != null && urlstr.startsWith(this.getRoot(1))) {
            return 1;
        }
        if (this.getRoot(3) != null && urlstr.startsWith(this.getRoot(3))) {
            return 3;
        }
        if (urlstr.startsWith("file:")) {
            return 0;
        }
        if (urlstr.startsWith("http:")) {
            return 0;
        }
        if (urlstr.startsWith("https:")) {
            return 0;
        }
        return -1;
    }

    public static void setLogger(Logger l) {
        logger = l;
    }

    static {
        aRootsPropertyNames = new String[]{"ERROR PROPERTY NAME", "UNIX_ARCHIVE_ROOT", "WINDOWS_ARCHIVE_ROOT", "HTTP_ARCHIVE_ROOT", "HANDLE_WEB_PROXY", "HANDLE_PREFIX", "ARCHIVE_NAME"};
        aRootsDefaults = new String[]{"ERROR ACCESS CONTEXT ROOT", "file:/UX_DEFAULT/", "file:\\UNC_DEFAULT\\", "http://HTTP_DEFAULT/", "http://hdl.handle.net/", null, null};
        file_url_context = System.getProperty("os.name").toLowerCase().startsWith("windows") ? 2 : 1;
    }
}

