/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.sql.SQLException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.swing.ProgressMonitor;
import mpi.bcarchive.spider.IMDIContentHandler;
import mpi.bcarchive.spider.IMDINode;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.CorpusStructureDBWrite;
import mpi.corpusstructure.CorpusStructureDBWriteImpl;
import mpi.corpusstructure.FileHandlers;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.UnknownNodeException;
import mpi.imdidb.IMDIDB;
import mpi.imdidb.IMDIDBImpl;
import mpi.metadata.search.index.MDIndexConfig;
import mpi.metadata.search.index.MDIndexer;
import mpi.util.DBConnection;
import mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ArchiveCrawler {
    private static Logger logger = Logger.getLogger((String)ArchiveCrawler.class.getName());
    private static boolean calledFromMain = false;
    private String ourhost;
    private String ourdomain;
    private CorpusStructureDB cs;
    private CorpusStructureDBWrite cswr;
    private ArchiveObjectsDB ao;
    private ArchiveObjectsDBWrite aowr;
    private ArchiveObjectsDBWrite aowr2;
    private boolean createFromScratch;
    private boolean daanHack;
    private FileHandlers handler;
    int linkRows;

    public ArchiveCrawler(String dbname, boolean simpleSearchIndex, String user, String passwd, OurURL topNodeURL, boolean bootstrap, boolean followHTTP, ProgressMonitor progressMonitor) throws IllegalStateException {
        this(dbname, simpleSearchIndex, user, passwd, topNodeURL, bootstrap, followHTTP, progressMonitor, null, followHTTP, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ArchiveCrawler(String dbname, boolean simpleSearchIndex, String user, String passwd, OurURL topNodeURL, boolean bootstrap, boolean followHTTP, ProgressMonitor progressMonitor, String mdSearchServletURL, boolean checkHTTP, boolean alwaysUpdateImdi) throws IllegalStateException {
        block162: {
            block163: {
                block160: {
                    block158: {
                        block157: {
                            super();
                            this.ourhost = null;
                            this.ourdomain = null;
                            this.cs = null;
                            this.cswr = null;
                            this.ao = null;
                            this.aowr = null;
                            this.aowr2 = null;
                            this.createFromScratch = false;
                            this.daanHack = false;
                            this.handler = null;
                            this.linkRows = 0;
                            aac = null;
                            topNodeId = null;
                            realDBName = null;
                            imdidb = null;
                            ArchiveCrawler.logger.debug((Object)("ArchiveCrawler: Starting: DB name=" + dbname + ", simple search index=" + simpleSearchIndex + ", DB user=" + user + ", DB pass=" + (passwd == null || passwd.length() == 0 ? "(none)" : "(hidden)") + ", top node URL=" + topNodeURL + ", bootstrap mode=" + bootstrap + ", follow HTTP links=" + followHTTP + ", check HTTP headers=" + checkHTTP + ", re-read unchanged files=" + alwaysUpdateImdi));
                            if (progressMonitor != null) {
                                progressMonitor.setProgress(1);
                                progressMonitor.setNote("Connecting ...");
                            }
                            if ((topNodeId = this.verifyTopNode(topNodeURL, dbname, bootstrap)) == null) {
                                ArchiveCrawler.logger.error((Object)("ArchiveCrawler: You cannot start at: " + topNodeURL));
                                throw new IllegalStateException("ArchiveCrawler: top node check failed (can be related to database connection troubles)");
                            }
                            csdbimplac = null;
                            try {
                                block166: {
                                    block168: {
                                        block167: {
                                            block156: {
                                                try {
                                                    imdidb = new IMDIDBImpl(dbname, bootstrap, user, passwd);
                                                }
                                                catch (Exception e) {
                                                    throw new IllegalStateException("ArchiveCrawler: cannot open IMDIDB: " + e);
                                                }
                                                csdbimplac = new CorpusStructureDBWriteImpl(dbname, bootstrap, user, passwd);
                                                if (ArchiveCrawler.calledFromMain) {
                                                    sth = new ShutdownThread(csdbimplac, imdidb, ArchiveCrawler.logger, ArchiveCrawler.calledFromMain);
                                                    Runtime.getRuntime().addShutdownHook(sth);
                                                }
                                                this.ao = csdbimplac;
                                                this.aowr = csdbimplac;
                                                realDBName = dbname;
                                                if (dbname.startsWith("java:comp/env")) {
                                                    try {
                                                        ctx = new InitialContext();
                                                        ds = (DataSource)ctx.lookup(dbname);
                                                        if (ds != null) {
                                                            conn = ds.getConnection();
                                                            realDBName = conn.getMetaData().getURL();
                                                            conn.close();
                                                            ArchiveCrawler.logger.info((Object)("ArchiveCrawler: Resolved: " + dbname + " to: " + realDBName));
                                                            break block156;
                                                        }
                                                        ArchiveCrawler.logger.warn((Object)("ArchiveCrawler: Cannot resolve: " + dbname));
                                                        if (!this.daanHack) break block156;
                                                        ArchiveCrawler.logger.error((Object)"ArchiveCrawler: Too dangerous to continue!");
                                                    }
                                                    catch (NamingException ne) {
                                                        ArchiveCrawler.logger.warn((Object)("ArchiveCrawler: Cannot resolve: " + dbname + " naming exception: " + ne));
                                                        break block156;
                                                    }
                                                    catch (SQLException sqle) {
                                                        ArchiveCrawler.logger.warn((Object)("ArchiveCrawler: Cannot resolve: " + dbname + " SQL exception: " + sqle));
                                                        break block156;
                                                    }
                                                    var33_25 = null;
                                                    if (ArchiveCrawler.calledFromMain) {
                                                        if (this.cswr != null) {
                                                            this.cswr.shutdown();
                                                        }
                                                        if (this.aowr != null) {
                                                            this.aowr.shutdown();
                                                        }
                                                        if (this.aowr2 != null) {
                                                            this.aowr2.shutdown();
                                                        }
                                                    }
                                                    if (this.cs != null) {
                                                        this.cs.close();
                                                    }
                                                    if (this.cswr != null) {
                                                        this.cswr.close();
                                                    }
                                                    if (this.ao != null) {
                                                        this.ao.close();
                                                    }
                                                    if (this.aowr != null) {
                                                        this.aowr.close();
                                                    }
                                                    if (this.aowr2 != null) {
                                                        this.aowr2.close();
                                                    }
                                                    if (imdidb == null) break block157;
                                                    imdidb.close();
                                                    break block157;
                                                }
                                            }
                                            if (!realDBName.startsWith("jdbc:postgresql")) break block167;
                                            if (this.daanHack) {
                                                ArchiveCrawler.logger.error((Object)"ArchiveCrawler: Too dangerous to continue!");
                                                break block158;
                                            }
                                            if (!bootstrap && this.ao.getArchiveRoots().getHandlePrefix() != null) {
                                                myProps = new Properties(System.getProperties());
                                                configFileName = myProps.getProperty("HandleSystemConfig");
                                                this.aowr2 = null;
                                                if (configFileName != null) {
                                                    ArchiveCrawler.logger.warn((Object)"ArchiveCrawler: Will not write through to Handle System, feature disabled");
                                                }
                                                if (this.aowr2 != null && this.aowr2.getStatus()) {
                                                    this.aowr2.setArchiveRoots(this.ao.getArchiveRoots());
                                                }
                                                break block168;
                                            } else {
                                                if (bootstrap) {
                                                    ArchiveCrawler.logger.warn((Object)"ArchiveCrawler: Bootstrap mode: Copy data to Handle System manually after crawling.");
                                                }
                                                if (this.ao.getArchiveRoots().getHandlePrefix() == null) {
                                                    ArchiveCrawler.logger.warn((Object)"ArchiveCrawler: No Handle System prefix configured, will not use URIDs");
                                                }
                                                this.aowr2 = null;
                                            }
                                            break block168;
                                        }
                                        ArchiveCrawler.logger.info((Object)"ArchiveCrawler: Non-PostgreSQL database: Data will not be copied to Handle System.");
                                        this.aowr2 = null;
                                        if (this.daanHack) {
                                            ArchiveCrawler.logger.error((Object)"ArchiveCrawler: We TRY to continue here, possibly HSQLDB bootstrapping, but this COULD delete all your data.");
                                        }
                                    }
                                    this.cs = csdbimplac;
                                    this.cswr = csdbimplac;
                                    aac = csdbimplac.getArchiveRoots();
                                    if (!(this.cs.getStatus() && this.ao.getStatus() && this.cswr.getStatus() && this.aowr.getStatus() && this.aowr.canWrite())) {
                                        ArchiveCrawler.logger.error((Object)"ArchiveCrawler: could not open corpusstructure / archiveobjects database");
                                        if (bootstrap == false) throw new IllegalStateException("ArchiveCrawler: could not initialize CS / AO database connections");
                                        System.exit(1);
                                        throw new IllegalStateException("ArchiveCrawler: could not initialize CS / AO database connections");
                                    }
                                    if (!imdidb.getStatus()) {
                                        ArchiveCrawler.logger.error((Object)"ArchiveCrawler: could not open IMDI database");
                                        if (bootstrap == false) throw new IllegalStateException("ArchiveCrawler: could not initialize IMDI database connections");
                                        System.exit(1);
                                        throw new IllegalStateException("ArchiveCrawler: could not initialize IMDI database connections");
                                    }
                                    if (this.ourhost == null || this.ourdomain == null) {
                                        block159: {
                                            httpRoot = aac.getRoot(3);
                                            try {
                                                if (httpRoot == null) {
                                                    throw new MalformedURLException("HTTP root not configured");
                                                }
                                                this.ourhost = new OurURL(httpRoot).getHost();
                                            }
                                            catch (MalformedURLException mue) {
                                                ArchiveCrawler.logger.error((Object)("ArchiveCrawler: Invalid archive access HTTP root: " + httpRoot));
                                                this.ourhost = "www.false.bad";
                                                if (topNodeURL.getProtocol().equals("file")) break block159;
                                                this.ourhost = topNodeURL.getHost();
                                                ArchiveCrawler.logger.info((Object)("Fallback for onsite-test: Using top node host: " + this.ourhost));
                                            }
                                        }
                                        this.ourdomain = this.ourhost.substring(this.ourhost.indexOf(".") + 1);
                                    }
                                    ArchiveCrawler.logger.info((Object)("Documents on " + this.ourhost + " or " + this.ourdomain + " are assumed to be on site"));
                                    accessContext = aac.getAccessContextFromURI(topNodeURL.toString());
                                    if (accessContext == 3) {
                                        ArchiveCrawler.logger.warn((Object)"ArchiveCrawler: Top node URL is in local HTTP space - better crawl in local file space");
                                    } else if (accessContext == 1) {
                                        ArchiveCrawler.logger.info((Object)"Top node URL is in local/Unix filesystem context");
                                    } else if (accessContext == 2) {
                                        ArchiveCrawler.logger.info((Object)"Top node URL is in Windows/Samba filesystem context");
                                    } else {
                                        if (accessContext != 0) throw new IllegalStateException("ArchiveCrawler: Top node URL context unsupported: " + accessContext);
                                        if ("http".equals(topNodeURL.getProtocol()) || "https".equals(topNodeURL.getProtocol())) {
                                            ArchiveCrawler.logger.warn((Object)"ArchiveCrawler: Top node URL is HTTP but not on our server - crawling external (sub)corpus?");
                                            accessContext = 3;
                                        } else if (realDBName.startsWith("jdbc:hsqldb") && "file".equals(topNodeURL.getProtocol())) {
                                            ArchiveCrawler.logger.warn((Object)"ArchiveCrawler: Top node URL is file but not in our root - crawling local (sub)corpus from browser?");
                                        } else {
                                            ArchiveCrawler.logger.error((Object)"ArchiveCrawler: Top node URL is neither HTTP nor in a known access context, rejected");
                                            throw new IllegalStateException("ArchiveCrawler: Top node URL context must be HTTP or (better) one of your file contexts");
                                        }
                                    }
                                    if (progressMonitor != null) {
                                        if (progressMonitor.isCanceled()) {
                                            break block160;
                                        }
                                        progressMonitor.setProgress(2);
                                        progressMonitor.setNote("Connected");
                                    }
                                    if ("true".equalsIgnoreCase((myProps = new Properties(System.getProperties())).getProperty("AllowAbsoluteFileURLs"))) {
                                        ArchiveCrawler.logger.info((Object)"ArchiveCrawler: Absolute file:-URLs enabled (not recommended)");
                                        this.handler = new FileHandlers(this.ourhost, this.ourdomain, accessContext, true, progressMonitor);
                                    } else {
                                        this.handler = new FileHandlers(this.ourhost, this.ourdomain, accessContext, false, progressMonitor);
                                    }
                                    this.handler.setHttpMode(followHTTP, checkHTTP);
                                    this.handler.setBootstrapMode(bootstrap, this.createFromScratch);
                                    this.handler.setDatabases(this.cs, this.ao, this.cswr, this.aowr, this.aowr2, imdidb);
                                    badIMDIHash = null;
                                    try {
                                        block161: {
                                            try {
                                                if (bootstrap) {
                                                    ArchiveCrawler.logger.info((Object)"ArchiveCrawler: STEP 1 skipped in bootstrap mode, no need to clear access rights");
                                                } else {
                                                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 1 " + new Date() + " Blocking all access rights below " + topNodeId));
                                                    try {
                                                        this.cswr.replaceDescendantAccessRights(topNodeId, "ignore", "nobody");
                                                    }
                                                    catch (UnknownNodeException une) {
                                                        ArchiveCrawler.logger.warn((Object)("ArchiveCrawler: could not reset access rights below node: " + topNodeId));
                                                    }
                                                    ArchiveCrawler.logger.info((Object)"ArchiveCrawler: Access rights reset to nobody.");
                                                }
                                                linkExists = bootstrap == false;
                                                ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 2 " + new Date() + " Recursive IMDI file processing starts at " + topNodeURL));
                                                topNodeURID = null;
                                                if (!bootstrap) {
                                                    if (this.ao.getArchiveRoots().getHandlePrefix() != null) {
                                                        topNodeURID = NodeIdUtils.nodeIdToHandle(topNodeId, this.ao.getArchiveRoots().getHandlePrefix());
                                                    }
                                                } else {
                                                    uridsInFile = false;
                                                    hasCorpusLinks = false;
                                                    imdiCH = new IMDIContentHandler();
                                                    if ("true".equalsIgnoreCase(myProps.getProperty("AllowAbsoluteFileURLs"))) {
                                                        imdiCH.setBlockAbsolute(false);
                                                    }
                                                    try {
                                                        imdiCH.clearLists();
                                                        imdiCH.parse(topNodeURL);
                                                    }
                                                    catch (SAXException saxe) {
                                                        ArchiveCrawler.logger.error((Object)("Cannot parse top IMDI file! SAX Error: " + saxe + " URL: " + topNodeURL), (Throwable)saxe);
                                                        throw new IllegalStateException("ArchiveCrawler: Cannot parse top IMDI file, cannot bootstrap");
                                                    }
                                                    catch (IOException ioe) {
                                                        ArchiveCrawler.logger.error((Object)("Cannot parse top IMDI file! I/O Error: " + ioe + " URL: " + topNodeURL), (Throwable)ioe);
                                                        throw new IllegalStateException("ArchiveCrawler: Cannot read top IMDI file, cannot bootstrap");
                                                    }
                                                    uridsInFile |= imdiCH.getURID() != null;
                                                    iIter = imdiCH.getCorpusLinks().iterator();
                                                    while (iIter.hasNext()) {
                                                        uridsInFile |= null != this.handler.fetchNodeId((IMDINode)iIter.next(), true);
                                                        hasCorpusLinks = true;
                                                    }
                                                    if (!hasCorpusLinks) {
                                                        ArchiveCrawler.logger.error((Object)("Top node must be a corpus node with some corpus links: " + topNodeURL));
                                                        throw new IllegalStateException("ArchiveCrawler: Top IMDI file contains no corpus links, bootstrap rejected");
                                                    }
                                                    iIter = imdiCH.getInfoNodes().iterator();
                                                    while (iIter.hasNext()) {
                                                        uridsInFile |= null != this.handler.fetchNodeId((IMDINode)iIter.next(), true);
                                                    }
                                                    iIter = null;
                                                    if (uridsInFile) {
                                                        if (this.ao.getArchiveRoots().getHandlePrefix() != null) {
                                                            topNodeURID = NodeIdUtils.nodeIdToHandle(topNodeId, this.ao.getArchiveRoots().getHandlePrefix());
                                                        }
                                                        if (topNodeURID == null) {
                                                            ArchiveCrawler.logger.error((Object)("Top node has URID but URIDs are disabled in configuration: " + imdiCH.getURID()));
                                                            throw new IllegalStateException("ArchiveCrawler: Top node has URID but URIDs are disabled in configuration: " + imdiCH.getURID());
                                                        }
                                                        ArchiveCrawler.logger.info((Object)"ArchiveCrawler: Bootstrap: Top node IMDI file contains URIDs, will re-use URIDs from files");
                                                        if (imdiCH.getURID() != null && !topNodeURID.equalsIgnoreCase(imdiCH.getURID().substring(imdiCH.getURID().lastIndexOf(":") + 1))) {
                                                            ArchiveCrawler.logger.error((Object)("Top node claims to have a non-top URID: " + imdiCH.getURID() + " (we expected: " + topNodeURID + ")"));
                                                            throw new IllegalStateException("ArchiveCrawler: Top node claims to have a non-top URID: " + imdiCH.getURID() + " (expected: " + topNodeURID + ")");
                                                        }
                                                    } else {
                                                        topNodeURID = null;
                                                        ArchiveCrawler.logger.info((Object)"ArchiveCrawler: Bootstrap: Top node IMDI file contains no URIDs yet, will allocate new URIDs");
                                                    }
                                                }
                                                topNode = new IMDINode(topNodeURL, null, null, topNodeURID);
                                                this.handler.handleIMDIFile(topNode, null, linkExists, alwaysUpdateImdi);
                                                childLinkHash = this.handler.getChildLinkHash();
                                                badIMDIHash = this.handler.getBadIMDIHash();
                                                nodeIdsToParseForMetadata = this.handler.getSessionsHash();
                                                if (!(this.cs.getStatus() && this.ao.getStatus() && this.cswr.getStatus() && this.aowr.getStatus() && imdidb.getStatus())) {
                                                    ArchiveCrawler.logger.error((Object)"ArchiveCrawler: Database problems encountered, aborting");
                                                    throw new IllegalStateException("ArchiveCrawler: database connection error (in handleIMDIFile?)");
                                                }
                                                if (bootstrap) {
                                                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 3 (bootstrap) " + new Date() + " About to write link structure to DB"));
                                                } else {
                                                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 3 (normal) " + new Date() + " About to clear read rights in DB"));
                                                }
                                                this.storeLinks(topNodeId, childLinkHash, bootstrap);
                                                if (bootstrap) {
                                                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 4 (bootstrap) " + new Date() + " Link structure stored."));
                                                } else {
                                                    try {
                                                        this.cswr.replaceDescendantAccessRights(topNodeId, "nobody", "cleared");
                                                    }
                                                    catch (UnknownNodeException une) {
                                                        ArchiveCrawler.logger.warn((Object)("ArchiveCrawler: could not clear access rights below node: " + topNodeId));
                                                    }
                                                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 4 (normal) " + new Date() + " Cleared read rights in DB"));
                                                }
                                                if (!(this.cs.getStatus() && this.ao.getStatus() && this.cswr.getStatus() && this.aowr.getStatus() && imdidb.getStatus())) {
                                                    ArchiveCrawler.logger.error((Object)"ArchiveCrawler: Database problems encountered, aborting");
                                                    throw new IllegalStateException("ArchiveCrawler: database connection error (in storeLinks?)");
                                                }
                                                ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 5a " + new Date() + " About to process metadata below node: " + topNodeId));
                                                this.processMetadata(bootstrap, nodeIdsToParseForMetadata, progressMonitor, imdidb);
                                                ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 6 " + new Date() + " Done with metadata processing"));
                                                if (mdSearchServletURL != null) {
                                                    csdbimplac.setSearchServletURL(mdSearchServletURL);
                                                    break block161;
                                                }
                                                if (!bootstrap) {
                                                    mdSearchServletURL = csdbimplac.getSearchServletURL();
                                                }
                                            }
                                            catch (OutOfMemoryError err) {
                                                ArchiveCrawler.logger.error((Object)("ArchiveCrawler: Out of Memory Error occured: " + err), (Throwable)err);
                                                throw new IllegalStateException("ArchiveCrawler: did not complete due to out of memory error");
                                            }
                                        }
                                        var27_48 = null;
                                    }
                                    catch (Throwable var26_50) {
                                        var27_49 = null;
                                        ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 7 " + new Date() + " Will create indexes and close corpusstructure DB"));
                                        csdbimplac.finishUpdate();
                                        ArchiveCrawler.logger.debug((Object)"ArchiveCrawler: after finishUpdate()");
                                        ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 8 " + new Date() + " About to close corpusstructure DB and write buffers"));
                                        if (this.aowr2 != null) {
                                            this.aowr2.close();
                                            this.aowr2 = null;
                                        }
                                        ArchiveCrawler.logger.debug((Object)"ArchiveCrawler: down");
                                        csdbimplac = null;
                                        throw var26_50;
                                    }
                                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 7 " + new Date() + " Will create indexes and close corpusstructure DB"));
                                    csdbimplac.finishUpdate();
                                    ArchiveCrawler.logger.debug((Object)"ArchiveCrawler: after finishUpdate()");
                                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 8 " + new Date() + " About to close corpusstructure DB and write buffers"));
                                    if (this.aowr2 != null) {
                                        this.aowr2.close();
                                        this.aowr2 = null;
                                    }
                                    ArchiveCrawler.logger.debug((Object)"ArchiveCrawler: down");
                                    csdbimplac = null;
                                    if (!badIMDIHash.isEmpty()) {
                                        ao = this.createReadOnlyDBImpl(dbname);
                                        this.logBadIMDI(ao, accessContext, badIMDIHash);
                                        ao.close();
                                    }
                                    if (!simpleSearchIndex) break block162;
                                    indexerServletURL = null;
                                    if (mdSearchServletURL == null && realDBName.startsWith("jdbc:postgresql")) {
                                        if (!bootstrap) {
                                            ArchiveCrawler.logger.error((Object)"ArchiveCrawler: Index update has to use SearchServletURL!");
                                            break block163;
                                        }
                                        ArchiveCrawler.logger.error((Object)"ArchiveCrawler: For central indexer the location of the SearchServletURL must be specified!");
                                        System.exit(0);
                                    }
                                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 98 " + new Date() + " About to create index"));
                                    if (mdSearchServletURL != null) {
                                        ao2 = null;
                                        try {
                                            try {
                                                ao2 = this.createReadOnlyDBImpl(dbname);
                                                indexStartNode = ao2.getObjectId(topNodeURL);
                                                ao2.close();
                                                ao2 = null;
                                                indexerServletURL = mdSearchServletURL.replaceAll("MDSearchServlet", "MDIndexerServlet");
                                                if (bootstrap || indexStartNode.equals(this.cs.getRootNodeId())) {
                                                    if (!bootstrap) {
                                                        ArchiveCrawler.logger.warn((Object)"ArchiveCrawler: Running indexer in bootstrap mode as top node == root node");
                                                    }
                                                    ArchiveCrawler.makeRemoteIndex(indexerServletURL, dbname, progressMonitor);
                                                } else {
                                                    ArchiveCrawler.updateRemoteIndex(indexStartNode, indexerServletURL, dbname, progressMonitor);
                                                }
                                            }
                                            catch (IOException ioe) {
                                                ArchiveCrawler.logger.error((Object)("Exception during remote index creation: " + ioe), (Throwable)ioe);
                                                var29_52 = null;
                                                if (ao2 == null) ** GOTO lbl377
                                                ao2.close();
                                            }
                                            var29_51 = null;
                                            if (ao2 == null) ** GOTO lbl377
                                            ao2.close();
                                        }
                                        catch (Throwable var28_54) {
                                            var29_53 = null;
                                            if (ao2 == null) throw var28_54;
                                            ao2.close();
                                            throw var28_54;
                                        }
                                    } else {
                                        csi = null;
                                        try {
                                            block165: {
                                                try {
                                                    csi = this.createReadOnlyDBImpl(dbname);
                                                    indexDir = MDIndexConfig.getIndexDir(dbname);
                                                    if (bootstrap) {
                                                        indexDirFile = new File(indexDir);
                                                        if (!indexDirFile.exists() && !indexDirFile.mkdirs()) {
                                                            ArchiveCrawler.logger.error((Object)("ArchiveCrawler: Failed to create index directory: " + indexDirFile));
                                                        }
                                                        if (indexDirFile.exists() && indexDirFile.isDirectory() && indexDirFile.canWrite()) {
                                                            MDIndexer.makeIndex(indexDir, csi, progressMonitor);
                                                            break block165;
                                                        } else {
                                                            ArchiveCrawler.logger.error((Object)("ArchiveCrawler: Cannot write to index directory: " + indexDirFile));
                                                        }
                                                        break block165;
                                                    }
                                                    MDIndexer.updateIndex(topNodeId, indexDir, csi, progressMonitor);
                                                }
                                                catch (Exception e) {
                                                    ArchiveCrawler.logger.error((Object)"Exception during metadata index creation: ", (Throwable)e);
                                                    var31_56 = null;
                                                    if (csi != null) {
                                                        csi.close();
                                                    }
                                                    break block166;
                                                }
                                            }
                                            var31_55 = null;
                                            if (csi == null) break block166;
                                        }
                                        catch (Throwable var30_58) {
                                            var31_57 = null;
                                            if (csi == null) throw var30_58;
                                            csi.close();
                                            throw var30_58;
                                        }
                                        csi.close();
                                    }
                                }
                                ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 99 " + new Date() + " Done with index creation"));
                                break block162;
                            }
                            catch (Throwable var32_59) {
                                var33_30 = null;
                                if (ArchiveCrawler.calledFromMain) {
                                    if (this.cswr != null) {
                                        this.cswr.shutdown();
                                    }
                                    if (this.aowr != null) {
                                        this.aowr.shutdown();
                                    }
                                    if (this.aowr2 != null) {
                                        this.aowr2.shutdown();
                                    }
                                }
                                if (this.cs != null) {
                                    this.cs.close();
                                }
                                if (this.cswr != null) {
                                    this.cswr.close();
                                }
                                if (this.ao != null) {
                                    this.ao.close();
                                }
                                if (this.aowr != null) {
                                    this.aowr.close();
                                }
                                if (this.aowr2 != null) {
                                    this.aowr2.close();
                                }
                                if (imdidb != null) {
                                    imdidb.close();
                                }
                                ArchiveCrawler.logger.info((Object)("ArchiveCrawler:  " + new Date() + " Database closed"));
                                throw var32_59;
                            }
                        }
                        ArchiveCrawler.logger.info((Object)("ArchiveCrawler:  " + new Date() + " Database closed"));
                        return;
                    }
                    var33_26 = null;
                    if (ArchiveCrawler.calledFromMain) {
                        if (this.cswr != null) {
                            this.cswr.shutdown();
                        }
                        if (this.aowr != null) {
                            this.aowr.shutdown();
                        }
                        if (this.aowr2 != null) {
                            this.aowr2.shutdown();
                        }
                    }
                    if (this.cs != null) {
                        this.cs.close();
                    }
                    if (this.cswr != null) {
                        this.cswr.close();
                    }
                    if (this.ao != null) {
                        this.ao.close();
                    }
                    if (this.aowr != null) {
                        this.aowr.close();
                    }
                    if (this.aowr2 != null) {
                        this.aowr2.close();
                    }
                    if (imdidb != null) {
                        imdidb.close();
                    }
                    ArchiveCrawler.logger.info((Object)("ArchiveCrawler:  " + new Date() + " Database closed"));
                    return;
                }
                var33_27 = null;
                if (ArchiveCrawler.calledFromMain) {
                    if (this.cswr != null) {
                        this.cswr.shutdown();
                    }
                    if (this.aowr != null) {
                        this.aowr.shutdown();
                    }
                    if (this.aowr2 != null) {
                        this.aowr2.shutdown();
                    }
                }
                if (this.cs != null) {
                    this.cs.close();
                }
                if (this.cswr != null) {
                    this.cswr.close();
                }
                if (this.ao != null) {
                    this.ao.close();
                }
                if (this.aowr != null) {
                    this.aowr.close();
                }
                if (this.aowr2 != null) {
                    this.aowr2.close();
                }
                if (imdidb != null) {
                    imdidb.close();
                }
                ArchiveCrawler.logger.info((Object)("ArchiveCrawler:  " + new Date() + " Database closed"));
                return;
            }
            var33_28 = null;
            if (ArchiveCrawler.calledFromMain) {
                if (this.cswr != null) {
                    this.cswr.shutdown();
                }
                if (this.aowr != null) {
                    this.aowr.shutdown();
                }
                if (this.aowr2 != null) {
                    this.aowr2.shutdown();
                }
            }
            if (this.cs != null) {
                this.cs.close();
            }
            if (this.cswr != null) {
                this.cswr.close();
            }
            if (this.ao != null) {
                this.ao.close();
            }
            if (this.aowr != null) {
                this.aowr.close();
            }
            if (this.aowr2 != null) {
                this.aowr2.close();
            }
            if (imdidb != null) {
                imdidb.close();
            }
            ArchiveCrawler.logger.info((Object)("ArchiveCrawler:  " + new Date() + " Database closed"));
            return;
        }
        var33_29 = null;
        if (ArchiveCrawler.calledFromMain) {
            if (this.cswr != null) {
                this.cswr.shutdown();
            }
            if (this.aowr != null) {
                this.aowr.shutdown();
            }
            if (this.aowr2 != null) {
                this.aowr2.shutdown();
            }
        }
        if (this.cs != null) {
            this.cs.close();
        }
        if (this.cswr != null) {
            this.cswr.close();
        }
        if (this.ao != null) {
            this.ao.close();
        }
        if (this.aowr != null) {
            this.aowr.close();
        }
        if (this.aowr2 != null) {
            this.aowr2.close();
        }
        if (imdidb != null) {
            imdidb.close();
        }
        ArchiveCrawler.logger.info((Object)("ArchiveCrawler:  " + new Date() + " Database closed"));
    }

    private CorpusStructureDBImpl createReadOnlyDBImpl(String dbname) {
        return new CorpusStructureDBImpl(dbname);
    }

    public static void makeRemoteIndex(String indexerServletURL, String dbname, ProgressMonitor progressMonitor) throws IOException {
        ArchiveCrawler.updateRemoteIndex(null, indexerServletURL, dbname, progressMonitor);
    }

    public static void updateRemoteIndex(String rootNodeId, String indexerServletURL, String dbname, ProgressMonitor progressMonitor) throws IOException {
        String line;
        String url = null;
        OurURL urlServlet = null;
        try {
            url = rootNodeId == null ? indexerServletURL + "?action=create&service=" + dbname : indexerServletURL + "?action=update&service=" + dbname + "&nodeid=" + URLEncoder.encode(rootNodeId, "UTF-8");
            urlServlet = new OurURL(url);
        }
        catch (UnsupportedEncodingException uee) {
            throw new IOException("updateRemoteIndex: UTF-8 not supported??");
        }
        catch (MalformedURLException mue) {
            throw new IOException("updateRemoteIndex: Invalid URL: " + url);
        }
        logger.info((Object)("Opening connection to URL: " + urlServlet));
        URLConnection servletConnection = urlServlet.openConnection();
        servletConnection.setDoInput(true);
        servletConnection.setDoOutput(false);
        servletConnection.setUseCaches(false);
        servletConnection.setRequestProperty("Content-Type", "text");
        InputStream instr = servletConnection.getInputStream();
        BufferedReader reader = new BufferedReader(new InputStreamReader(instr));
        while ((line = reader.readLine()) != null) {
            logger.debug((Object)line);
        }
        reader.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String verifyTopNode(OurURL topNodeURL, String dbname, boolean bootstrap) {
        String string;
        CorpusStructureDBImpl csdbiTest;
        block22: {
            block21: {
                String string2;
                block20: {
                    String string3;
                    block19: {
                        String string4;
                        block18: {
                            String string5;
                            block17: {
                                String string6;
                                block16: {
                                    logger.info((Object)("verifyTopNode: dbname=" + dbname + " topnode=" + topNodeURL));
                                    csdbiTest = null;
                                    try {
                                        block23: {
                                            String np;
                                            String vp;
                                            OurURL topTestURL = null;
                                            try {
                                                csdbiTest = this.createReadOnlyDBImpl(dbname);
                                                topTestURL = csdbiTest.getObjectURL(csdbiTest.getRootNodeId(), csdbiTest.getArchiveRoots().getAccessContextFromURI(topNodeURL.toString()));
                                            }
                                            catch (UnknownNodeException une) {
                                                logger.error((Object)("UNE at getObjectURL for root: " + csdbiTest.getRootNodeId() + " --> " + une));
                                            }
                                            catch (Exception e) {
                                                if (bootstrap) {
                                                    logger.warn((Object)"verifyTopNode(): error reading from CorpusStructureDBImpl probably bootstrapping with HSQLDB");
                                                    this.daanHack = true;
                                                    String string7 = NodeIdUtils.TONODEID(0);
                                                    Object var11_15 = null;
                                                    if (csdbiTest == null) return string7;
                                                    csdbiTest.close();
                                                    return string7;
                                                }
                                                logger.error((Object)("VerifyTopNode(): error reading from DB: " + e));
                                            }
                                            logger.debug((Object)("URL for root: " + csdbiTest.getRootNodeId() + " --> " + topTestURL));
                                            if (topTestURL == null) break block23;
                                            String topNodeId = csdbiTest.getObjectId(topNodeURL);
                                            if (topNodeId == null) {
                                                logger.error((Object)"ArchiveCrawler: Crawling must start at a known node!");
                                                logger.error((Object)"Consider crawling from a higher node.");
                                                string6 = null;
                                                Object var11_16 = null;
                                                if (csdbiTest == null) return string6;
                                                break block16;
                                            }
                                            if (bootstrap) {
                                                if (csdbiTest.getRootNodeId().equals(topNodeId)) {
                                                    logger.info((Object)"ArchiveCrawler: Bootstrap mode: Selected top node matches existing root node, good.");
                                                    string5 = topNodeId;
                                                    break block17;
                                                }
                                                logger.error((Object)("ArchiveCrawler: Bootstrap mode must start at the root node, in your context: " + topTestURL));
                                                logger.error((Object)("You selected another node, " + topNodeId + ", at: " + topNodeURL));
                                                logger.error((Object)("You can use the Mover to correct the URL of root node " + csdbiTest.getRootNodeId() + " first!"));
                                                string4 = null;
                                                break block18;
                                            }
                                            try {
                                                vp = csdbiTest.getCanonicalVPath(topNodeId);
                                                np = csdbiTest.getNamePath(topNodeId);
                                                if (vp == null || np == null) {
                                                    logger.error((Object)("Corpusstructure error, cannot start at this URL: " + topNodeURL));
                                                    string3 = null;
                                                    break block19;
                                                }
                                            }
                                            catch (UnknownNodeException une) {
                                                logger.error((Object)("ArchiveCrawler: Selected node " + topNodeId + " is not connected to the corpusstructure tree!"));
                                                logger.error((Object)("You cannot start at this URL: " + topNodeURL));
                                                logger.debug((Object)"Corpusstructure exception was: ", (Throwable)une);
                                                String string8 = null;
                                                Object var11_21 = null;
                                                if (csdbiTest == null) return string8;
                                                csdbiTest.close();
                                                return string8;
                                            }
                                            {
                                                logger.info((Object)("ArchiveCrawler: Will start at VPath:     " + vp));
                                                logger.info((Object)("ArchiveCrawler: Will start at name path: " + np));
                                                string2 = topNodeId;
                                            }
                                            break block20;
                                        }
                                        if (bootstrap) {
                                            logger.info((Object)("ArchiveCrawler: Bootstrap will CREATE root node: " + topNodeURL));
                                            this.createFromScratch = true;
                                            string = csdbiTest.getRootNodeId();
                                            break block21;
                                        }
                                        logger.error((Object)"ArchiveCrawler: Root node undefined, must use bootstrap mode!");
                                        string = null;
                                        break block22;
                                    }
                                    catch (Throwable throwable) {
                                        Object var11_24 = null;
                                        if (csdbiTest == null) throw throwable;
                                        csdbiTest.close();
                                        throw throwable;
                                    }
                                }
                                csdbiTest.close();
                                return string6;
                            }
                            Object var11_17 = null;
                            if (csdbiTest == null) return string5;
                            csdbiTest.close();
                            return string5;
                        }
                        Object var11_18 = null;
                        if (csdbiTest == null) return string4;
                        csdbiTest.close();
                        return string4;
                    }
                    Object var11_19 = null;
                    if (csdbiTest == null) return string3;
                    csdbiTest.close();
                    return string3;
                }
                Object var11_20 = null;
                if (csdbiTest == null) return string2;
                csdbiTest.close();
                return string2;
            }
            Object var11_22 = null;
            if (csdbiTest == null) return string;
            csdbiTest.close();
            return string;
        }
        Object var11_23 = null;
        if (csdbiTest == null) return string;
        csdbiTest.close();
        return string;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processMetadata(boolean bootstrap, Map nodeIdsToParseForMetadata, ProgressMonitor progressMonitor, IMDIDB imdidb) {
        block22: {
            block20: {
                block21: {
                    i = 0;
                    imax = 0;
                    try {
                        try {
                            count = 0;
                            sessions = nodeIdsToParseForMetadata.keySet().toArray(new String[0]);
                            imax = sessions.length;
                            ArchiveCrawler.logger.debug((Object)("ArchiveCrawler: processing metadata, number of sessions: " + imax));
                            if (progressMonitor != null) {
                                progressMonitor.setNote("Parsing IMDI Session files ...");
                            }
                            for (i = 0; i < imax; ++i) {
                                url = (OurURL)nodeIdsToParseForMetadata.get(sessions[i]);
                                try {
                                    if (!bootstrap) {
                                        try {
                                            imdidb.deleteIMDINode(sessions[i]);
                                        }
                                        catch (UnknownNodeException un) {
                                            // empty catch block
                                        }
                                    }
                                    if (progressMonitor == null) ** GOTO lbl34
                                    if (progressMonitor.isCanceled()) {
                                        un = false;
                                    }
                                    ** GOTO lbl-1000
                                }
                                catch (Exception e) {
                                    ArchiveCrawler.logger.error((Object)("ArchiveCrawler: processMetadata: IMDIDB Error accessing: " + url + ", " + e), (Throwable)e);
                                    continue;
                                }
                                var12_15 = null;
                                if (imdidb == null) break block20;
                                break block21;
lbl-1000:
                                // 1 sources

                                {
                                    progressMonitor.setProgress(50 + 50 * count / sessions.length);
                                    progressMonitor.setNote("Parsing IMDI Session file ..." + count++);
lbl34:
                                    // 2 sources

                                    ArchiveCrawler.logger.info((Object)("Adding metadata for: " + sessions[i] + " " + url));
                                    node = this.cs.getNode(sessions[i]);
                                    imdidb.addIMDINode(node, url);
                                }
                            }
                            break block22;
                        }
                        catch (OutOfMemoryError oome) {
                            ArchiveCrawler.logger.error((Object)("processMetadata aborted early: ran out of memory: " + oome), (Throwable)oome);
                            throw new NullPointerException("processMetadata aborted early: ran out of memory");
                        }
                    }
                    catch (Throwable var11_18) {
                        var12_17 = null;
                        if (imdidb != null) {
                            ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 5b " + new Date() + " About to create DB indexes and close IMDI DB"));
                            imdidb.flush();
                            imdidb.finishUpdate();
                        }
                        if (++i < imax) {
                            ArchiveCrawler.logger.error((Object)("processMetadata aborted at session " + i + " of " + imax));
                        }
                        ArchiveCrawler.logger.debug((Object)"processMetadata finalized");
                        throw var11_18;
                    }
                }
                ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 5b " + new Date() + " About to create DB indexes and close IMDI DB"));
                imdidb.flush();
                imdidb.finishUpdate();
            }
            if (++i < imax) {
                ArchiveCrawler.logger.error((Object)("processMetadata aborted at session " + i + " of " + imax));
            }
            ArchiveCrawler.logger.debug((Object)"processMetadata finalized");
            return un;
        }
        var12_16 = null;
        if (imdidb != null) {
            ArchiveCrawler.logger.info((Object)("ArchiveCrawler: STEP 5b " + new Date() + " About to create DB indexes and close IMDI DB"));
            imdidb.flush();
            imdidb.finishUpdate();
        }
        if (++i < imax) {
            ArchiveCrawler.logger.error((Object)("processMetadata aborted at session " + i + " of " + imax));
        }
        ArchiveCrawler.logger.debug((Object)"processMetadata finalized");
        return true;
    }

    private void logBadIMDI(ArchiveObjectsDB myAO, int accessContext, Hashtable badIMDIHash) {
        if (badIMDIHash.isEmpty()) {
            return;
        }
        Enumeration badIMDIEnum = badIMDIHash.keys();
        while (badIMDIEnum.hasMoreElements()) {
            String anIMDI = (String)badIMDIEnum.nextElement();
            OurURL imdiURL = null;
            try {
                imdiURL = myAO.getObjectURL(anIMDI, accessContext);
            }
            catch (UnknownNodeException une) {
                // empty catch block
            }
            logger.warn((Object)("IMDI " + anIMDI + " contains duplicate links. URL: " + imdiURL));
            HashSet duplicateChildren = (HashSet)badIMDIHash.get(anIMDI);
            for (String aChild : duplicateChildren) {
                OurURL childURL = null;
                try {
                    childURL = myAO.getObjectURL(aChild, accessContext);
                }
                catch (UnknownNodeException une) {
                    // empty catch block
                }
                logger.info((Object)("IMDI " + anIMDI + " has duplicate links to: " + aChild + " URL: " + childURL));
            }
        }
        badIMDIHash = null;
        badIMDIHash = new Hashtable();
    }

    private void storeLinks(String topNodeId, Hashtable childLinkHash, boolean bootstrap) {
        if (!bootstrap) {
            logger.info((Object)"ArchiveCrawler: storeLinks: already done while crawling, update mode");
            childLinkHash = null;
            childLinkHash = new Hashtable();
            return;
        }
        if (childLinkHash.isEmpty()) {
            return;
        }
        logger.info((Object)"ArchiveCrawler: storeLinks starting");
        this.putChildrenIntoDB(topNodeId, "", true, 0, childLinkHash);
        logger.info((Object)("ArchiveCrawler: storeLinks done, put " + this.linkRows + " links in the CorpusStructure table"));
        childLinkHash = null;
        childLinkHash = new Hashtable();
    }

    private void putChildrenIntoDB(String nodeId, String vp, boolean canonical, int level, Hashtable childLinkHash) {
        HashSet c = (HashSet)childLinkHash.get(nodeId);
        if (c != null) {
            if (level < 3) {
                logger.debug((Object)("putChildrenIntoDB: " + c.size() + " children at level " + level + " below " + nodeId));
            }
            for (String cid : c) {
                if (level < 2) {
                    logger.debug((Object)("putChildrenIntoDB: put " + cid + " subtree of level " + level + " below " + nodeId));
                }
                if (cid.startsWith("!")) {
                    cid = cid.substring(1);
                    this.putChildrenIntoDB(cid, vp + "/" + nodeId, false, level + 1, childLinkHash);
                    continue;
                }
                this.putChildrenIntoDB(cid, vp + "/" + nodeId, canonical, level + 1, childLinkHash);
            }
        }
        this.cswr.addCorpusStructureEntry(nodeId, vp, canonical);
        ++this.linkRows;
    }

    public static void main(String[] args) {
        boolean bootstrap = true;
        boolean followHTTP = false;
        boolean checkHTTP = false;
        boolean writeSearchIndex = true;
        boolean alwaysUpdateImdi = false;
        String searchServletURL = null;
        String user = null;
        String passwd = null;
        String dbname = args[0];
        int ai = 1;
        calledFromMain = true;
        if (args.length < 2) {
            logger.error((Object)"ArchiveCrawler: No arguments");
            System.out.println("ArchiveCrawler must have at least a dbname and a base URL or another option as arguments");
            System.exit(1);
        }
        while (ai < args.length) {
            if (args[ai].startsWith("-user")) {
                user = args[ai + 1];
                ai += 2;
                continue;
            }
            if (args[ai].startsWith("-passwd")) {
                passwd = args[ai + 1];
                ai += 2;
                continue;
            }
            if (args[ai].startsWith("-bootstrap")) {
                bootstrap = Boolean.valueOf(args[ai + 1]);
                ai += 2;
                continue;
            }
            if (args[ai].startsWith("-followHTTP")) {
                followHTTP = Boolean.valueOf(args[ai + 1]);
                ai += 2;
                continue;
            }
            if (args[ai].startsWith("-checkHTTP")) {
                checkHTTP = Boolean.valueOf(args[ai + 1]);
                ai += 2;
                continue;
            }
            if (args[ai].startsWith("-readAllIMDI")) {
                alwaysUpdateImdi = Boolean.valueOf(args[ai + 1]);
                ai += 2;
                continue;
            }
            if (args[ai].startsWith("-simpleSearchIndex")) {
                writeSearchIndex = Boolean.valueOf(args[ai + 1]);
                ai += 2;
                continue;
            }
            if (args[ai].startsWith("-searchServletURL")) {
                searchServletURL = args[ai + 1];
                ai += 2;
                continue;
            }
            if (args[ai].startsWith("-")) {
                System.out.println("Option not recognized: " + args[ai]);
                System.exit(1);
                continue;
            }
            OurURL url = null;
            try {
                url = new OurURL(args[ai]);
            }
            catch (MalformedURLException mue) {
                logger.error((Object)("ArchiveCrawler: Not an URL: " + args[ai]));
                System.out.println("Options: dbName [optional settings] startURL");
                System.exit(1);
            }
            try {
                new ArchiveCrawler(dbname, writeSearchIndex, user, passwd, url, bootstrap, followHTTP, null, searchServletURL, checkHTTP, alwaysUpdateImdi);
                System.exit(0);
            }
            catch (IllegalStateException ise) {
                System.out.println("Crawl failed to complete: " + ise);
                System.exit(1);
            }
        }
    }

    public String getLastErrorMessage() {
        return this.handler.getLastErrorMessage();
    }

    public static void setLogger(Logger l) {
        logger = l;
        DBConnection.setLogger(l);
        CorpusStructureDBImpl.setLogger(l);
        IMDIDBImpl.setLogger(l);
        FileHandlers.setLogger(l);
    }

    public static Logger getLogger() {
        return logger;
    }

    static class ShutdownThread
    extends Thread {
        CorpusStructureDBWriteImpl db = null;
        Logger logger = null;
        IMDIDB imdidb = null;
        boolean shutdown = false;

        ShutdownThread(CorpusStructureDBWriteImpl csdbwr, IMDIDB imdidbwr, Logger logger, boolean shutdown) {
            this.db = csdbwr;
            this.logger = logger;
            this.imdidb = imdidbwr;
            this.shutdown = shutdown;
        }

        public void run() {
            if (this.db != null) {
                this.logger.debug((Object)"ArchiveCrawler:ShutdownThread calling freeUpdateInProgressLock");
                this.db.freeUpdateInProgressLock();
            }
            if (this.shutdown && this.db != null && this.db.getStatus()) {
                this.db.shutdown();
            }
            if (this.db != null && this.db.getStatus()) {
                this.db.close();
            }
            if (this.imdidb != null && this.imdidb.getStatus()) {
                this.imdidb.close();
            }
            this.logger.debug((Object)("ArchiveCrawler:ShutdownThread: Closed " + (this.shutdown ? "and shut down" : "") + " databases"));
        }
    }
}

