/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;
import mpi.corpusstructure.AccessInfo;
import mpi.corpusstructure.ArchiveAccessContext;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.ArchiveObjectsDBImplHS;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.UnknownNodeException;
import mpi.corpusstructure.UpdateInProgressException;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AdminRecord;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.ClientSessionTracker;
import net.handle.hdllib.Common;
import net.handle.hdllib.CreateHandleRequest;
import net.handle.hdllib.DeleteHandleRequest;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.ModifyValueRequest;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SessionSetupInfo;
import net.handle.hdllib.Util;
import org.apache.log4j.Logger;

public class ArchiveObjectsDBWriteImplHS
extends ArchiveObjectsDBImplHS
implements ArchiveObjectsDBWrite,
ArchiveObjectsDB {
    public boolean _profiling = false;
    private SessionSetupInfo _sessionSetupInfo = null;
    private PublicKeyAuthenticationInfo _auth = null;
    private int handlesWritten = 0;
    private HandleValue adminValue = null;
    private static long beforeTime = 0L;

    public void setArchiveRoots(ArchiveAccessContext userAAC) {
        super.setArchiveRoots(userAAC);
        String prefix = userAAC.getHandlePrefix();
        this.adminValue = new HandleValue(100, Common.STD_TYPE_HSADMIN, Encoder.encodeAdminRecord((AdminRecord)new AdminRecord(Util.encodeString((String)("0.NA/" + prefix)), 200, false, false, false, false, true, true, true, true, false, false, false, false)));
    }

    public boolean canWrite() {
        return !this.sqlTroubles("canWrite");
    }

    private boolean sqlTroubles(String name) {
        if (this._auth != null) {
            return false;
        }
        if (this.sqlhs == null) {
            logger.error((Object)(name + ": No SQL connection, write access not possible"));
            return true;
        }
        if (this.useSQL) {
            if (this.readOnlySetting != null && !this.readOnlySetting.equalsIgnoreCase("no")) {
                logger.error((Object)(name + ": Write access not allowed in configuration file"));
                return true;
            }
            return false;
        }
        if ("ArchiveObjectsDBWriteImplHS".equals(name)) {
            logger.info((Object)(name + ": You have to set a locally homed prefix next to get write access."));
        } else {
            logger.error((Object)(name + ": Write access blocked until a locally homed prefix is selected"));
        }
        return true;
    }

    public ArchiveObjectsDBWriteImplHS(String authHandle, int authIndex, File keyFile, boolean translate) throws IOException {
        super(translate);
        ArchiveObjectsDBImplHS.setLogger(Logger.getLogger((String)ArchiveObjectsDBWriteImplHS.class.getName()));
        this._profiling = true;
        logger.info((Object)"ArchiveObjectsDBWriteImplHS trying to log in...");
        this.profile(null);
        FileInputStream iStream = new FileInputStream(keyFile);
        byte[] keydata = new byte[(int)keyFile.length()];
        for (int n = 0; n < keydata.length; ++n) {
            keydata[n] = (byte)iStream.read();
        }
        iStream.close();
        PrivateKey privkey = null;
        byte[] passphrase = null;
        try {
            if (Util.requiresSecretKey((byte[])keydata)) {
                passphrase = Util.getPassphrase((String)"Please enter privkey passphrase: ");
            }
            keydata = Util.decrypt((byte[])keydata, (byte[])passphrase);
            privkey = Util.getPrivateKeyFromBytes((byte[])keydata, (int)0);
        }
        catch (Exception e) {
            throw new IOException("Exception in key read: " + e);
        }
        if (passphrase != null) {
            for (int n = 0; n < passphrase.length; ++n) {
                passphrase[n] = -1;
            }
        }
        this._auth = new PublicKeyAuthenticationInfo(authHandle.getBytes("UTF8"), authIndex, privkey);
        try {
            this._sessionSetupInfo = new SessionSetupInfo((AuthenticationInfo)this._auth);
        }
        catch (Exception e) {
            throw new IOException("SessionSetupInfo Exception: " + e);
        }
        this._sessionSetupInfo.authenticated = false;
        this._sessionSetupInfo.encrypted = false;
        this.resolver.setSessionTracker(new ClientSessionTracker());
        this.resolver.getSessionTracker().setSessionSetupInfo(this._sessionSetupInfo);
        this.profile("handle-system-login-session");
        logger.info((Object)("ArchiveObjectsDBWriteImplHS logged in as " + authIndex + ":" + authHandle));
    }

    public ArchiveObjectsDBWriteImplHS(String configFile, boolean translate) {
        super(configFile, translate);
        ArchiveObjectsDBImplHS.setLogger(Logger.getLogger((String)ArchiveObjectsDBWriteImplHS.class.getName()));
        if (this.sqlhs == null) {
            logger.error((Object)"Must have SQL connection to write to the DB");
            super.close();
            return;
        }
        this.sqlTroubles("ArchiveObjectsDBWriteImplHS");
        if (this.useSQL) {
            this.setArchiveRoots(aac);
        }
    }

    public ArchiveObjectsDBWriteImplHS(String configFile) {
        super(configFile);
        ArchiveObjectsDBImplHS.setLogger(Logger.getLogger((String)ArchiveObjectsDBWriteImplHS.class.getName()));
        if (this.sqlhs == null) {
            logger.error((Object)"Must have SQL connection to write to the DB");
            super.close();
            return;
        }
        this.sqlTroubles("ArchiveObjectsDBWriteImplHS");
        if (this.useSQL) {
            this.setArchiveRoots(aac);
        }
    }

    public ArchiveObjectsDBWriteImplHS(String jdbcurl, String username, String password, String drivername) {
        super(jdbcurl, username, password, drivername);
        ArchiveObjectsDBImplHS.setLogger(Logger.getLogger((String)ArchiveObjectsDBWriteImplHS.class.getName()));
        if (this.sqlhs == null) {
            logger.error((Object)"Must have SQL connection to write to the DB");
            super.close();
            return;
        }
        this.sqlTroubles("ArchiveObjectsDBWriteImplHS");
        if (this.useSQL) {
            this.setArchiveRoots(aac);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void shutdown() {
        block16: {
            if (this._auth != null || this._sessionSetupInfo != null) {
                this._auth = null;
                this._sessionSetupInfo = null;
                logger.info((Object)"ArchiveObjectsDBWriteImplHS HS auth / session dropped");
            }
            if (this.db == null) {
                logger.info((Object)"ArchiveObjectsDBWriteImplHS already closed");
                return;
            }
            if (this.db.dbType == 2) {
                Statement statement;
                block15: {
                    statement = null;
                    statement = this.db.getConnection().createStatement();
                    statement.execute("SHUTDOWN COMPACT");
                    Object var4_2 = null;
                    if (statement == null) break block15;
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                statement = null;
                {
                    break block16;
                    catch (SQLException sqle) {
                        if (sqle.toString().indexOf("is shutdown") != -1) {
                            logger.info((Object)"database already shutdown");
                        } else {
                            logger.error((Object)"shutdown: SQLException: ", (Throwable)sqle);
                        }
                        Object var4_3 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        statement = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    throw throwable;
                }
            }
        }
        this.vacuumPostgreSQL(true);
    }

    public String newArchiveObject(String node, URI uri, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo, String checksum) throws UpdateInProgressException {
        if (this.sqlTroubles("newArchiveObject") || this.adminValue == null) {
            throw new UpdateInProgressException("newArchiveObject: invalid prefix active: " + (this.adminValue == null ? "(none set yet)" : aac.getHandlePrefix()));
        }
        String urlstr = uri.toString();
        Vector<HandleValue> values = new Vector<HandleValue>();
        Object troubles = null;
        String name = this.translateToHandle(node);
        if (name == null || !NodeIdUtils.handleToPrefix(name).equals(aac.getHandlePrefix())) {
            logger.error((Object)("newArchiveObject: Tried to create invalid handle named '" + name + "'"));
            throw new UpdateInProgressException("newArchiveObject: invalid handle name " + name);
        }
        if (urlstr.indexOf("///") != -1) {
            urlstr = urlstr.replaceFirst("///", "/");
        }
        values.add(this.adminValue);
        this.profile(null);
        values.add(new HandleValue(1, Common.STD_TYPE_URL, Util.encodeString((String)urlstr)));
        values.add(new HandleValue(2, Util.encodeString((String)"CRAWLTIME"), Util.encodeString((String)crawltime.toString())));
        if (size > 0L) {
            values.add(new HandleValue(3, Util.encodeString((String)"FILESIZE"), Util.encodeString((String)Long.toString(size))));
        }
        values.add(new HandleValue(4, Util.encodeString((String)"ONSITE"), Util.encodeString((String)Boolean.toString(onsite))));
        if (checksum != null) {
            values.add(new HandleValue(5, Util.encodeString((String)"CHECKSUM"), Util.encodeString((String)checksum)));
        }
        if (filetime != null) {
            values.add(new HandleValue(6, Util.encodeString((String)"FILETIME"), Util.encodeString((String)filetime.toString())));
        }
        if (ainfo != null) {
            if (ainfo.getCreator() != null) {
                values.add(new HandleValue(10, Util.encodeString((String)"CREATOR"), Util.encodeString((String)ainfo.getCreator())));
            }
            if (ainfo.getOwner() != null) {
                values.add(new HandleValue(11, Util.encodeString((String)"OWNER"), Util.encodeString((String)ainfo.getOwner())));
            }
            if (ainfo.getReadRights() != null) {
                values.add(new HandleValue(12, Util.encodeString((String)"READRIGHTS"), Util.encodeString((String)ainfo.getReadRights())));
            }
            if (ainfo.getWriteRights() != null) {
                values.add(new HandleValue(13, Util.encodeString((String)"WRITERIGHTS"), Util.encodeString((String)ainfo.getWriteRights())));
            }
        }
        this.writeHandle(name, values, false);
        return node;
    }

    public String newArchiveObject(URI uri, Timestamp crawltime, boolean onsite, long size, Timestamp filetime, AccessInfo ainfo) throws UpdateInProgressException {
        if (this.sqlTroubles("newArchiveObject")) {
            throw new UpdateInProgressException("newArchiveObject: invalid prefix active: " + aac.getHandlePrefix());
        }
        String handle = this.getObjectId(uri);
        String checksum = null;
        if (handle != null) {
            logger.error((Object)("newArchiveObject: This URI already belongs to handle: " + handle));
            return null;
        }
        Long now = new Long(System.currentTimeMillis());
        int node = (now.hashCode() ^ uri.hashCode()) & 0x3FFFFFFF | 0x40000000;
        String nodeId = NodeIdUtils.nodeToHandle(node, aac.getHandlePrefix());
        logger.warn((Object)("newArchiveObject: Allocated pseudorandom handle " + nodeId + " (node=" + node + ") for URI: " + uri));
        return this.newArchiveObject(nodeId, uri, crawltime, onsite, size, filetime, ainfo, checksum);
    }

    public boolean deleteArchiveObject(String nodeId) {
        if (this.sqlTroubles("deleteArchiveObject")) {
            return false;
        }
        String id = this.translateToHandle(nodeId);
        byte[] idEnc = Util.encodeString((String)id);
        this.vacuumPostgreSQL(false);
        try {
            if (this._auth != null) {
                DeleteHandleRequest dhReq = new DeleteHandleRequest(idEnc, (AuthenticationInfo)this._auth);
                AbstractResponse response = this.resolver.processRequest((AbstractRequest)dhReq);
                if (response.responseCode != 1) {
                    logger.error((Object)("deleteArchiveObject: Failed for: " + id + " Response: " + response));
                    return false;
                }
                return true;
            }
            return this.sqlhs.deleteHandle(idEnc);
        }
        catch (HandleException he) {
            if (he.getCode() == 9) {
                logger.warn((Object)("deleteArchiveObject: handle " + id + " does not exist"));
            } else {
                logger.error((Object)("deleteArchiveObject: " + id + " exception " + (Object)((Object)he)));
            }
            return false;
        }
    }

    public void setArchiveObjectFileInfo(String nodeId, long filesize, Timestamp filetime) throws UpdateInProgressException {
        if (this.sqlTroubles("setArchiveObjectFileInfo")) {
            throw new UpdateInProgressException("setArchiveObjectFileInfo: invalid prefix active: " + aac.getHandlePrefix());
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "FILESIZE");
        values = this.removeValues(values, "FILETIME");
        if (filesize > 0L) {
            values.add(new HandleValue(3, Util.encodeString((String)"FILESIZE"), Util.encodeString((String)Long.toString(filesize))));
        }
        if (filetime != null) {
            values.add(new HandleValue(6, Util.encodeString((String)"FILETIME"), Util.encodeString((String)filetime.toString())));
        }
        this.writeHandle(id, values, true);
    }

    public void setObjectCrawlTime(String nodeId, Timestamp time) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("setObjectCrawlTime")) {
            throw new UpdateInProgressException("setObjectCrawlTime: invalid prefix active: " + aac.getHandlePrefix());
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "CRAWLTIME");
        values.add(new HandleValue(2, Util.encodeString((String)"CRAWLTIME"), Util.encodeString((String)time.toString())));
        this.writeHandle(id, values, true);
    }

    public boolean moveArchiveObject(String nodeId, URI newUri) throws UpdateInProgressException {
        if (this.sqlTroubles("moveArchiveObject")) {
            return false;
        }
        String urlstr = newUri.toString();
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        if (urlstr.indexOf("///") != -1) {
            urlstr = urlstr.replaceFirst("///", "/");
        }
        values = this.removeValues(values, new String(Common.STD_TYPE_URL));
        values.add(new HandleValue(1, Common.STD_TYPE_URL, Util.encodeString((String)urlstr)));
        try {
            this.writeHandle(id, values, true);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setObjectAccessInfo(String nodeId, AccessInfo ai) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("setObjectAccessInfo")) {
            throw new UpdateInProgressException("setObjectAccessInfo: invalid prefix active: " + aac.getHandlePrefix());
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "CREATOR");
        values = this.removeValues(values, "OWNER");
        values = this.removeValues(values, "READRIGHTS");
        values = this.removeValues(values, "WRITERIGHTS");
        if (ai != null) {
            if (ai.getCreator() != null) {
                values.add(new HandleValue(10, Util.encodeString((String)"CREATOR"), Util.encodeString((String)ai.getCreator())));
            }
            if (ai.getOwner() != null) {
                values.add(new HandleValue(11, Util.encodeString((String)"OWNER"), Util.encodeString((String)ai.getOwner())));
            }
            if (ai.getReadRights() != null) {
                values.add(new HandleValue(12, Util.encodeString((String)"READRIGHTS"), Util.encodeString((String)ai.getReadRights())));
            }
            if (ai.getWriteRights() != null) {
                values.add(new HandleValue(13, Util.encodeString((String)"WRITERIGHTS"), Util.encodeString((String)ai.getWriteRights())));
            }
        }
        this.writeHandle(id, values, true);
    }

    public void setObjectChecksum(String nodeId, String checksum) throws UpdateInProgressException, UnknownNodeException {
        if (this.sqlTroubles("setObjectChecksum")) {
            throw new UpdateInProgressException("setObjectChecksum: invalid prefix active: " + aac.getHandlePrefix());
        }
        String id = this.translateToHandle(nodeId);
        Vector values = this.fetchHandleSQL(id, null);
        values = this.removeValues(values, "CHECKSUM");
        if (checksum != null) {
            values.add(new HandleValue(5, Util.encodeString((String)"CHECKSUM"), Util.encodeString((String)checksum)));
        }
        this.writeHandle(id, values, true);
    }

    private void profile(String label) {
        if (!this._profiling) {
            return;
        }
        long when = System.currentTimeMillis();
        if (label != null) {
            System.out.println("" + (when - beforeTime) + " msec for " + label);
        }
        beforeTime = when;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void vacuumPostgreSQL(boolean force) {
        block18: {
            if (this.db == null) {
                return;
            }
            ArchiveObjectsDBWriteImplHS archiveObjectsDBWriteImplHS = this;
            synchronized (archiveObjectsDBWriteImplHS) {
                ++this.handlesWritten;
                if ((this.handlesWritten & 0x3FFF) == 0) {
                    force = true;
                }
            }
            if (!force) {
                return;
            }
            if (this.db.dbType == 1) {
                Statement statement;
                block17: {
                    statement = null;
                    statement = this.db.getConnection().createStatement();
                    statement.execute("VACUUM ANALYZE HANDLES");
                    Object var5_5 = null;
                    if (statement == null) break block17;
                    try {
                        statement.close();
                    }
                    catch (SQLException e) {
                        // empty catch block
                    }
                }
                statement = null;
                {
                    break block18;
                    catch (SQLException sqle) {
                        logger.warn((Object)"vacuumPostgreSQL: SQLException: ", (Throwable)sqle);
                        Object var5_6 = null;
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        statement = null;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    throw throwable;
                }
            }
        }
    }

    private Vector removeValues(Vector values, String field) {
        Iterator iter = values.iterator();
        Vector<HandleValue> toBeRemoved = new Vector<HandleValue>();
        while (iter.hasNext()) {
            HandleValue hv = (HandleValue)iter.next();
            if (!hv.getTypeAsString().equals(field)) continue;
            toBeRemoved.add(hv);
        }
        if (toBeRemoved.size() > 1) {
            logger.warn((Object)("Removed " + toBeRemoved.size() + " values of type " + field + ":"));
            for (HandleValue hv : toBeRemoved) {
                logger.warn((Object)("Removed: " + field + " -> " + hv.getDataAsString()));
            }
        }
        values.removeAll(toBeRemoved);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeHandle(String name, Vector values, boolean rewrite) throws UpdateInProgressException {
        Object troubles;
        block15: {
            troubles = null;
            this.vacuumPostgreSQL(false);
            this.profile(null);
            byte[] nameEnc = Util.encodeString((String)name);
            try {
                block14: {
                    try {
                        HandleValue[] theValues = values.toArray(new HandleValue[0]);
                        if (this._auth != null) {
                            if (rewrite) {
                                ModifyValueRequest mvReq = new ModifyValueRequest(nameEnc, theValues, (AuthenticationInfo)this._auth);
                                AbstractResponse response = this.resolver.processRequest((AbstractRequest)mvReq);
                                if (response.responseCode != 1) {
                                    troubles = response.toString();
                                }
                            } else {
                                CreateHandleRequest chReq = new CreateHandleRequest(nameEnc, theValues, (AuthenticationInfo)this._auth);
                                AbstractResponse response = this.resolver.processRequest((AbstractRequest)chReq);
                                if (response.responseCode != 1) {
                                    troubles = response.toString();
                                }
                            }
                            break block14;
                        }
                        if (rewrite) {
                            this.sqlhs.updateValue(nameEnc, theValues);
                            break block14;
                        }
                        this.sqlhs.createHandle(nameEnc, theValues);
                    }
                    catch (HandleException he) {
                        if (he.getCode() == 5) {
                            logger.error((Object)("writeHandle: handle " + name + " already exists."));
                            troubles = new String("handle already exists: " + name);
                        } else {
                            logger.error((Object)("writeHandle: Could not create/update handle " + name + " reason: " + (Object)((Object)he)));
                            troubles = he;
                        }
                        Object var10_14 = null;
                        this.profile("create-handle");
                        break block15;
                    }
                    catch (Exception e) {
                        logger.error((Object)("writeHandle: exception: " + e));
                        troubles = e;
                        Object var10_15 = null;
                        this.profile("create-handle");
                    }
                }
                Object var10_13 = null;
                this.profile("create-handle");
            }
            catch (Throwable throwable) {
                Object var10_16 = null;
                this.profile("create-handle");
                throw throwable;
            }
        }
        if (troubles != null) {
            throw new UpdateInProgressException("writeHandle: " + troubles);
        }
    }
}

