/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import mpi.corpusstructure.AccessCheck;
import mpi.corpusstructure.ArchiveAccessContext;
import mpi.corpusstructure.ArchiveObjectsDBImpl;
import mpi.corpusstructure.CorpusNode;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.Node;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.ResAccessInfo;
import mpi.corpusstructure.UnknownNodeException;
import mpi.util.OurURL;
import org.apache.log4j.Logger;

public class CorpusStructureDBImpl
extends ArchiveObjectsDBImpl
implements CorpusStructureDB {
    protected static Logger logger = Logger.getLogger((String)CorpusStructureDBImpl.class.getName());
    protected static String CORPUSNODES = "CORPUSNODES";
    protected static String CORPUSSTRUCTURE = "CORPUSSTRUCTURE";
    protected static final String SEQ_NAME = "NODEID_SEQ";
    protected static String staticSyncFlag = "dummy";
    protected static final int vPathDepth = 3;
    private int vPathSearchDepth = 3;
    private static long cacheExpiryTime = 0L;
    private static Hashtable canonicalParentCache = new Hashtable();

    public int setSearchDepth(int depth) {
        if (depth > 3) {
            depth = 3;
        }
        if (depth < 0) {
            depth = 0;
        }
        this.vPathSearchDepth = depth;
        return this.vPathSearchDepth;
    }

    protected CorpusStructureDBImpl(Exception e) {
        super(e);
    }

    public CorpusStructureDBImpl(String dbname) {
        this(dbname, false, null, null);
    }

    public CorpusStructureDBImpl(String dbname, boolean bootstrapMode, String user, String passwd) {
        super(dbname, user, passwd);
        ArchiveObjectsDBImpl.setLogger(logger);
        if (bootstrapMode) {
            logger.error((Object)"CorpusStructureDBImpl: Only CorpusStructureDBWriteImpl supports bootstrap mode.");
            this.status = false;
            return;
        }
    }

    protected void cacheExpire(String childNodeId) {
        if (childNodeId != null) {
            canonicalParentCache.remove(childNodeId);
            return;
        }
        cacheExpiryTime = 0L;
    }

    public static void setLogger(Logger l) {
        logger = l;
        ArchiveObjectsDBImpl.setLogger(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public CorpusNode[] getDescendantResources(String nodeId, boolean onsiteOnly, String userToRead, String userToWrite) throws UnknownNodeException {
        SQLException e2222;
        CorpusNode[] corpusNodeArray;
        ResultSet rs;
        Statement statement;
        block31: {
            Hashtable retHash;
            block28: {
                SQLException e2222;
                CorpusNode[] corpusNodeArray2;
                block29: {
                    if (userToRead == null) {
                        userToRead = "ignore";
                    }
                    if (userToWrite == null) {
                        userToWrite = "ignore";
                    }
                    if (!this.statusLog("getDescendantResources")) {
                        return null;
                    }
                    if (!NodeIdUtils.isNodeId(nodeId)) {
                        logger.error((Object)("getDescendantResources: not a classic node id: " + nodeId));
                        throw new UnknownNodeException("getDescendantResources: invalid NodeId: " + nodeId);
                    }
                    String query = null;
                    String vPath = this.getCanonicalVPath(nodeId) + "/" + nodeId;
                    query = "SELECT * FROM " + CORPUSNODES + " AS CN";
                    query = query + " JOIN " + ARCHIVEOBJECTS + " AS AO ON CN.NODEID=AO.NODEID";
                    query = query + " JOIN " + CORPUSSTRUCTURE + " AS CS ON CN.NODEID=CS.NODEID";
                    query = query + " WHERE ( " + this.matchVPathColumnsSQL(vPath, false) + " )";
                    if (!userToRead.equals("ignore")) {
                        query = query + " AND " + AccessCheck.expressRights(userToRead, "READRIGHTS");
                    }
                    if (!userToWrite.equals("ignore")) {
                        query = query + " AND " + AccessCheck.expressRights(userToWrite, "WRITERIGHTS");
                    }
                    if (onsiteOnly) {
                        query = query + " AND AO.ONSITE = TRUE";
                    }
                    query = query + " AND (AO.SIZE > 0)";
                    query = query + " AND ( CN.NODETYPE = 4 OR CN.NODETYPE = 16 OR  CN.NODETYPE = 64 OR  CN.NODETYPE = 8 )";
                    statement = null;
                    rs = null;
                    logger.debug((Object)("## getDescendantResources: " + query));
                    statement = this.db.getConnection().createStatement();
                    rs = statement.executeQuery(query);
                    retHash = this.createCorpusNodesFromRS(rs);
                    if (retHash != null) break block28;
                    logger.debug((Object)("getDescendantResources: " + nodeId + " n=0 (NONE)"));
                    corpusNodeArray2 = null;
                    Object var14_14 = null;
                    if (statement == null) break block29;
                    try {
                        statement.close();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                }
                rs = null;
                return corpusNodeArray2;
            }
            Enumeration keyEnum = retHash.keys();
            while (keyEnum.hasMoreElements()) {
                String oneId = (String)keyEnum.nextElement();
                CorpusNode node = (CorpusNode)retHash.get(oneId);
                node.setCanonicalPath(this.getCanonicalVPath(oneId));
            }
            logger.debug((Object)("getDescendantResources: " + nodeId + " n=" + retHash.size()));
            corpusNodeArray = retHash.values().toArray(new CorpusNode[0]);
            Object var14_15 = null;
            if (statement == null) break block31;
            try {
                statement.close();
            }
            catch (SQLException e2222) {
                // empty catch block
            }
        }
        statement = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e2222) {
                // empty catch block
            }
        }
        rs = null;
        return corpusNodeArray;
        catch (SQLException e3) {
            SQLException e2222;
            CorpusNode[] corpusNodeArray3;
            block33: {
                try {
                    logger.error((Object)"getDescendantResources:", (Throwable)e3);
                    corpusNodeArray3 = null;
                    Object var14_16 = null;
                    if (statement == null) break block33;
                }
                catch (Throwable throwable) {
                    SQLException e2222;
                    Object var14_17 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException e2222) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2222) {
                    // empty catch block
                }
            }
            rs = null;
            return corpusNodeArray3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String getFieldFromId(String nodeId, String fieldName) throws UnknownNodeException {
        block29: {
            SQLException e2222;
            ResultSet rs;
            Statement statement;
            block27: {
                block24: {
                    SQLException e2222;
                    String string;
                    block25: {
                        if (!this.statusLog("getFieldFromId")) {
                            return null;
                        }
                        if (!NodeIdUtils.isNodeId(nodeId)) {
                            logger.error((Object)("getFieldFromId: not a classic node id: " + nodeId));
                            throw new UnknownNodeException("getFieldFromId: invalid NodeId: " + nodeId);
                        }
                        if (!("format".equalsIgnoreCase(fieldName) || "name".equalsIgnoreCase(fieldName) || "title".equalsIgnoreCase(fieldName))) {
                            logger.error((Object)("getFieldFromId: not a valid corpusnodes varchar field: " + fieldName));
                            throw new UnknownNodeException("getFieldFromId: invalid fieldName: " + fieldName);
                        }
                        statement = null;
                        rs = null;
                        String cmd = "SELECT " + fieldName + " FROM " + CORPUSNODES + " WHERE NODEID = " + NodeIdUtils.TOINT(nodeId);
                        statement = this.db.getConnection().createStatement();
                        rs = statement.executeQuery(cmd);
                        if (!rs.next()) break block24;
                        string = (String)rs.getObject(1);
                        Object var8_8 = null;
                        if (statement == null) break block25;
                        try {
                            statement.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    return string;
                }
                this.throwUnknownNodeException("getFieldFromId", "", nodeId);
                Object var8_9 = null;
                if (statement == null) break block27;
                try {
                    statement.close();
                }
                catch (SQLException e2222) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2222) {
                    // empty catch block
                }
            }
            rs = null;
            {
                break block29;
                catch (SQLException e3) {
                    SQLException e2222;
                    logger.error((Object)"getFieldFromId: ", (Throwable)e3);
                    Object var8_10 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                }
            }
            catch (Throwable throwable) {
                SQLException e2222;
                Object var8_11 = null;
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                }
                rs = null;
                throw throwable;
            }
        }
        return null;
    }

    public String[] getSessions(String nodeId) throws UnknownNodeException {
        return this.getSelfOrSubNodesOfType(nodeId, 1);
    }

    public String[] getSessionsAndCatalogues(String nodeId) {
        return this.getSelfOrSubNodesOfType(nodeId, 129);
    }

    private String[] getSelfOrSubNodesOfType(String nodeId, int types) throws UnknownNodeException {
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("getSessions: not a classic node id: " + nodeId));
            throw new UnknownNodeException("getSessions: invalid NodeId: " + nodeId);
        }
        Node node = this.getNode(nodeId);
        String[] myself = new String[]{nodeId};
        if (node.getNodeType() == (types & node.getNodeType())) {
            return myself;
        }
        if (node.getNodeType() != 2) {
            return new String[0];
        }
        return this.getDescendants(nodeId, types, "*");
    }

    public int countDescendants(String nodeId, String userid, int type, boolean onlyOnSite, String[] formats, boolean distinct) throws UnknownNodeException {
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("countSessions: not a classic node id: " + nodeId));
            throw new UnknownNodeException("countSessions: invalid NodeId: " + nodeId);
        }
        Node node = this.getNode(nodeId);
        String[] countsAsString = this.getDescendantsOrCount(nodeId, type, formats, userid, onlyOnSite, true, distinct);
        if (countsAsString == null && countsAsString.length != 1) {
            throw new UnknownNodeException("countSessions: getDescendantsOrCount failed for NodeId: " + nodeId);
        }
        try {
            return Integer.parseInt(countsAsString[0]);
        }
        catch (NumberFormatException nfe) {
            throw new UnknownNodeException("countSessions: getDescendantsOrCount failed for NodeId: " + nodeId + " Exception: " + nfe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] getResourcesFromArchive(int nodeType, String[] formats, String user, boolean onlyAvailable, boolean onlyOnsite) {
        SQLException e22222;
        String[] stringArray;
        ResultSet rs;
        Statement statement;
        block59: {
            block56: {
                SQLException e22222;
                String[] stringArray2;
                block57: {
                    TreeSet<String> hs;
                    block53: {
                        SQLException e22222;
                        String[] stringArray3;
                        block54: {
                            String nq;
                            if (!this.statusLog("getResourcesFromArchive")) {
                                return null;
                            }
                            logger.debug((Object)("getResourcesFromArchive: nodeType=" + nodeType + ", formats=" + formats[0] + ", user=" + user));
                            if (user.equals("*")) {
                                user = "ignore";
                            }
                            String query = "SELECT CN.NODEID FROM " + CORPUSNODES + " AS CN";
                            if (onlyOnsite || onlyAvailable || !"ignore".equals(user)) {
                                query = query + " JOIN " + ARCHIVEOBJECTS + " AS AO ON CN.NODEID = AO.NODEID";
                            }
                            query = query + " WHERE";
                            String fmtq = "";
                            if (formats != null && formats[0] != null && !formats[0].equals("*")) {
                                fmtq = fmtq + " ( ";
                                for (int i = 0; i < formats.length; ++i) {
                                    String gfmt = this.glob(formats[i]);
                                    if (i != 0) {
                                        fmtq = fmtq + " OR ";
                                    }
                                    fmtq = gfmt.equals(formats[i]) ? fmtq + " CN.FORMAT = '" + gfmt + "'" : fmtq + " CN.FORMAT LIKE '" + gfmt + "'";
                                }
                                fmtq = fmtq + " )";
                            }
                            String typeq = "";
                            if (nodeType != -1) {
                                String add = "";
                                if ((nodeType & 2) == 2) {
                                    add = add + " CN.NODETYPE  = 2";
                                }
                                if ((nodeType & 0x80) == 128) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " CN.NODETYPE = 128";
                                }
                                if ((nodeType & 1) == 1) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " CN.NODETYPE = 1";
                                }
                                if ((nodeType & 4) == 4) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " CN.NODETYPE = 4";
                                }
                                if ((nodeType & 0x10) == 16) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " CN.NODETYPE = 16";
                                }
                                if ((nodeType & 8) == 8) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " CN.NODETYPE = 8";
                                }
                                if ((nodeType & 0x40) == 64) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " CN.NODETYPE = 64";
                                }
                                if (!add.equals("")) {
                                    typeq = typeq + " ( " + add + " )";
                                }
                            }
                            if (!(nq = fmtq).equals("") && !typeq.equals("")) {
                                nq = nq + " AND";
                            }
                            if (!(nq = nq + typeq).equals("")) {
                                query = query + nq + " AND";
                            }
                            if (!"ignore".equals(user)) {
                                query = query + " ( " + AccessCheck.expressRights(user, "AO.READRIGHTS") + " ) AND";
                            }
                            if (onlyOnsite) {
                                query = query + " ( AO.ONSITE = TRUE ) AND";
                            }
                            if (onlyAvailable) {
                                query = query + " (AO.SIZE > 0) AND";
                            }
                            if (query.endsWith("AND")) {
                                query = query.substring(0, query.length() - 4);
                            }
                            if (query.endsWith("WHERE")) {
                                query = query.substring(0, query.length() - 5);
                            }
                            logger.debug((Object)("### getResourcesFromArchive: " + query));
                            statement = null;
                            rs = null;
                            hs = new TreeSet<String>(new ArchiveObjectsDBImpl.NodeIdComparator());
                            statement = this.db.getConnection().createStatement();
                            rs = statement.executeQuery(query);
                            while (rs.next()) {
                                hs.add(NodeIdUtils.TONODEID(rs.getInt("NODEID")));
                            }
                            if (hs.size() != 0) break block53;
                            logger.debug((Object)"getResourcesFromArchive: n=0 (NONE)");
                            stringArray3 = new String[]{};
                            Object var15_19 = null;
                            if (statement == null) break block54;
                            try {
                                statement.close();
                            }
                            catch (SQLException e22222) {
                                // empty catch block
                            }
                        }
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e22222) {
                                // empty catch block
                            }
                        }
                        statement = null;
                        rs = null;
                        return stringArray3;
                    }
                    if (hs.size() == 0) break block56;
                    logger.debug((Object)("getResourcesFromArchive: n=" + hs.size()));
                    stringArray2 = hs.toArray(new String[0]);
                    Object var15_20 = null;
                    if (statement == null) break block57;
                    try {
                        statement.close();
                    }
                    catch (SQLException e22222) {
                        // empty catch block
                    }
                }
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e22222) {
                        // empty catch block
                    }
                }
                statement = null;
                rs = null;
                return stringArray2;
            }
            logger.debug((Object)"getResourcesFromArchive: n=0 (NONE)");
            stringArray = new String[]{};
            Object var15_21 = null;
            if (statement == null) break block59;
            try {
                statement.close();
            }
            catch (SQLException e22222) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e22222) {
                // empty catch block
            }
        }
        statement = null;
        rs = null;
        return stringArray;
        catch (SQLException e3) {
            SQLException e22222;
            String[] stringArray4;
            block61: {
                try {
                    logger.error((Object)"getResourcesFromArchive:", (Throwable)e3);
                    stringArray4 = null;
                    Object var15_22 = null;
                    if (statement == null) break block61;
                }
                catch (Throwable throwable) {
                    SQLException e22222;
                    Object var15_23 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e22222) {
                            // empty catch block
                        }
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e22222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    rs = null;
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException e22222) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e22222) {
                    // empty catch block
                }
            }
            statement = null;
            rs = null;
            return stringArray4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public List getResourcesAccessInfo() {
        SQLException e222;
        Vector<ResAccessInfo> vector;
        ResultSet rs;
        Statement stmt;
        Hashtable<String, String> aclgroups;
        Vector<ResAccessInfo> result;
        block25: {
            logger.debug((Object)"## getResourcesAccessInfo: retrieving access information for all ACL-managed resources");
            if (!this.statusLog("getResourcesAccessInfo")) {
                return null;
            }
            result = null;
            aclgroups = new Hashtable<String, String>();
            stmt = null;
            rs = null;
            stmt = this.db.getConnection().createStatement();
            rs = stmt.executeQuery("SELECT MD5, ACLSTRING FROM accessgroups");
            while (rs.next()) {
                aclgroups.put(rs.getString("MD5"), rs.getString("ACLSTRING"));
            }
            stmt.close();
            rs.close();
            stmt = this.db.getConnection().createStatement();
            String query = new StringBuffer("SELECT CN.NODEID, AO.READRIGHTS, AO.WRITERIGHTS, AO.URL FROM ").append(CORPUSNODES).append(" AS CN ").append(" JOIN ").append(ARCHIVEOBJECTS).append(" AS AO ON CN.NODEID = AO.NODEID ").append(" WHERE (CN.NODETYPE = ").append(4).append(" OR  CN.NODETYPE = ").append(16).append(" OR  CN.NODETYPE = ").append(64).append(" OR  CN.NODETYPE = ").append(8).append(") ").append(" AND (AO.ONSITE = TRUE) AND (AO.SIZE > 0) ").toString();
            rs = stmt.executeQuery(query);
            result = new Vector<ResAccessInfo>();
            while (rs.next()) {
                String nodeID = NodeIdUtils.TONODEID(rs.getInt(1));
                ArchiveAccessContext aac = this.getArchiveRoots();
                try {
                    String writerights;
                    URI rawURI = aac.stringToURI(rs.getString(4));
                    rawURI = aac.uriInContext(rawURI.toString(), aac.getFileUrlContext());
                    OurURL ourl = new OurURL(rawURI.toString().replaceAll("%20", " "));
                    String readrights = (String)aclgroups.get(rs.getString(2));
                    if (readrights == null) {
                        logger.error((Object)("getResourcesAccessInfo: No readrights group definition for " + rs.getString(2) + " at " + nodeID));
                        readrights = "nobody";
                    }
                    if ((writerights = (String)aclgroups.get(rs.getString(3))) == null) {
                        logger.error((Object)("getResourcesAccessInfo: No writerights group definition for " + rs.getString(3) + " at " + nodeID));
                        writerights = "nobody";
                    }
                    ResAccessInfo data = new ResAccessInfo(nodeID, ourl, readrights, writerights);
                    result.add(data);
                }
                catch (URISyntaxException use) {
                    logger.error((Object)("getResourcesAccessInfo: Item skipped, bad URI: " + nodeID + " " + use));
                }
                catch (MalformedURLException mue) {
                    logger.error((Object)("getResourcesAccessInfo: Item skipped, bad URL: " + nodeID + " " + mue));
                }
                catch (NullPointerException npe) {
                    logger.error((Object)("getResourcesAccessInfo: Item skipped, no URL: " + nodeID));
                }
            }
            vector = result;
            Object var14_17 = null;
            if (stmt == null) break block25;
            try {
                stmt.close();
            }
            catch (SQLException e222) {
                // empty catch block
            }
        }
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e222) {
                // empty catch block
            }
        }
        aclgroups.clear();
        return vector;
        catch (SQLException sqlE) {
            SQLException e222;
            block27: {
                try {
                    logger.error((Object)"getResourcesAccessInfo: sql failure during retrieving AO access info for all resources", (Throwable)sqlE);
                    Object var14_18 = null;
                    if (stmt == null) break block27;
                }
                catch (Throwable throwable) {
                    SQLException e222;
                    Object var14_19 = null;
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e222) {
                            // empty catch block
                        }
                    }
                    aclgroups.clear();
                    throw throwable;
                }
                try {
                    stmt.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            aclgroups.clear();
            {
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Node getNode(String nodeId) throws UnknownNodeException {
        block34: {
            block33: {
                block27: {
                    block32: {
                        block25: {
                            block26: {
                                if (!this.statusLog("getNode")) {
                                    return null;
                                }
                                if (!NodeIdUtils.isNodeId(nodeId)) {
                                    CorpusStructureDBImpl.logger.error((Object)("getNode: not a classic node id: " + nodeId));
                                    throw new UnknownNodeException("getNode: invalid NodeId: " + nodeId);
                                }
                                query = "SELECT * FROM " + CorpusStructureDBImpl.CORPUSNODES + " WHERE NODEID = " + NodeIdUtils.TOINT(nodeId);
                                statement = null;
                                rs = null;
                                try {
                                    try {
                                        statement = this.db.getConnection().createStatement();
                                        rs = statement.executeQuery(query);
                                        while (rs.next()) {
                                            node = this.createNodeFromRS(rs);
                                            if (node == null) continue;
                                            var6_6 = node;
                                            var9_9 = null;
                                            if (statement == null) break block25;
                                            break block26;
                                        }
                                        this.throwUnknownNodeException("getNode", "", nodeId);
                                        var6_7 = null;
                                        break block27;
                                    }
                                    catch (SQLException e) {
                                        CorpusStructureDBImpl.logger.error((Object)"getNode:", (Throwable)e);
                                        var7_17 = null;
                                        var9_11 = null;
                                        if (statement != null) {
                                            try {
                                                statement.close();
                                            }
                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                        statement = null;
                                        if (rs != null) {
                                            try {
                                                rs.close();
                                            }
                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                        rs = null;
                                        return var7_17;
                                    }
                                }
                                catch (Throwable var8_18) {
                                    block31: {
                                        block30: {
                                            var9_12 = null;
                                            if (statement != null) {
                                                ** try [egrp 2[TRYBLOCK] [6 : 217->226)] { 
lbl52:
                                                // 1 sources

                                                statement.close();
                                                break block30;
lbl54:
                                                // 1 sources

                                                catch (SQLException e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        statement = null;
                                        if (rs != null) {
                                            ** try [egrp 3[TRYBLOCK] [7 : 235->245)] { 
lbl60:
                                            // 1 sources

                                            rs.close();
                                            break block31;
lbl62:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    rs = null;
                                    throw var8_18;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [6 : 217->226)] { 
lbl69:
                            // 1 sources

                            statement.close();
                            break block25;
lbl71:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        statement = null;
                        if (rs != null) {
                            ** try [egrp 3[TRYBLOCK] [7 : 235->245)] { 
lbl77:
                            // 1 sources

                            rs.close();
                            break block32;
lbl79:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    rs = null;
                    return var6_6;
                }
                var9_10 = null;
                if (statement != null) {
                    ** try [egrp 2[TRYBLOCK] [6 : 217->226)] { 
lbl88:
                    // 1 sources

                    statement.close();
                    break block33;
lbl90:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            statement = null;
            if (rs != null) {
                ** try [egrp 3[TRYBLOCK] [7 : 235->245)] { 
lbl96:
                // 1 sources

                rs.close();
                break block34;
lbl98:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        rs = null;
        return var6_7;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CorpusNode getCorpusNode(String nodeId) throws UnknownNodeException {
        block32: {
            block31: {
                block26: {
                    block30: {
                        block24: {
                            block25: {
                                if (!this.statusLog("getCorpusNode")) {
                                    return null;
                                }
                                if (!NodeIdUtils.isNodeId(nodeId)) {
                                    CorpusStructureDBImpl.logger.error((Object)("getCorpusNode: not a classic node id: " + nodeId));
                                    throw new UnknownNodeException("getCorpusNode: invalid NodeId: " + nodeId);
                                }
                                statement = null;
                                rs = null;
                                try {
                                    try {
                                        statement = this.db.getConnection().createStatement();
                                        rs = statement.executeQuery("SELECT * FROM " + CorpusStructureDBImpl.CORPUSNODES + " AS CN " + "JOIN " + CorpusStructureDBImpl.CORPUSSTRUCTURE + " AS CS ON CN.NODEID = CS.NODEID " + "WHERE CN.NODEID = " + NodeIdUtils.TOINT(nodeId));
                                        while (rs.next()) {
                                            node = this.createCorpusNodeFromRS(rs);
                                            if (node == null) continue;
                                            node.setCanonicalPath(this.getCanonicalVPath(nodeId));
                                            var5_5 = node;
                                            var7_8 = null;
                                            if (statement == null) break block24;
                                            break block25;
                                        }
                                        this.throwUnknownNodeException("getCorpusNode()", "", nodeId);
                                        var5_6 = null;
                                        break block26;
                                    }
                                    catch (SQLException e) {
                                        CorpusStructureDBImpl.logger.error((Object)"getCorpusNode():", (Throwable)e);
                                        var7_10 = null;
                                        if (statement != null) {
                                            try {
                                                statement.close();
                                            }
                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                        statement = null;
                                        if (rs == null) return null;
                                        try {
                                            rs.close();
                                            return null;
                                        }
                                        catch (SQLException e) {
                                            // empty catch block
                                        }
                                        return null;
                                    }
                                }
                                catch (Throwable var6_16) {
                                    block29: {
                                        block28: {
                                            var7_11 = null;
                                            if (statement != null) {
                                                ** try [egrp 2[TRYBLOCK] [6 : 239->248)] { 
lbl49:
                                                // 1 sources

                                                statement.close();
                                                break block28;
lbl51:
                                                // 1 sources

                                                catch (SQLException e) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        statement = null;
                                        if (rs != null) {
                                            ** try [egrp 3[TRYBLOCK] [7 : 256->265)] { 
lbl57:
                                            // 1 sources

                                            rs.close();
                                            break block29;
lbl59:
                                            // 1 sources

                                            catch (SQLException e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    rs = null;
                                    throw var6_16;
                                }
                            }
                            ** try [egrp 2[TRYBLOCK] [6 : 239->248)] { 
lbl66:
                            // 1 sources

                            statement.close();
                            break block24;
lbl68:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                        statement = null;
                        if (rs != null) {
                            ** try [egrp 3[TRYBLOCK] [7 : 256->265)] { 
lbl74:
                            // 1 sources

                            rs.close();
                            break block30;
lbl76:
                            // 1 sources

                            catch (SQLException e) {
                                // empty catch block
                            }
                        }
                    }
                    rs = null;
                    return var5_5;
                }
                var7_9 = null;
                if (statement != null) {
                    ** try [egrp 2[TRYBLOCK] [6 : 239->248)] { 
lbl85:
                    // 1 sources

                    statement.close();
                    break block31;
lbl87:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                }
            }
            statement = null;
            if (rs != null) {
                ** try [egrp 3[TRYBLOCK] [7 : 256->265)] { 
lbl93:
                // 1 sources

                rs.close();
                break block32;
lbl95:
                // 1 sources

                catch (SQLException e) {
                    // empty catch block
                }
            }
        }
        rs = null;
        return var5_6;
    }

    public String getRootNodeId() {
        return NodeIdUtils.TONODEID(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] getSubnodes(String nodeId) throws UnknownNodeException {
        SQLException e2222;
        String[] stringArray;
        ResultSet rs;
        Statement statement;
        String query;
        block26: {
            block23: {
                SQLException e2222;
                String[] stringArray2;
                block24: {
                    if (!this.statusLog("getSubnodes")) {
                        return null;
                    }
                    if (!NodeIdUtils.isNodeId(nodeId)) {
                        logger.error((Object)("getSubnodes: not a classic node id: " + nodeId));
                        throw new UnknownNodeException("getSubnodes: invalid NodeId: " + nodeId);
                    }
                    String app = "'/" + nodeId + "'";
                    String vp = this.getCanonicalVPath(nodeId) + "/" + nodeId;
                    query = "SELECT * FROM " + CORPUSSTRUCTURE + " WHERE VPATH = '" + vp + "'";
                    TreeSet<String> results = new TreeSet<String>(new ArchiveObjectsDBImpl.NodeIdComparator());
                    statement = null;
                    rs = null;
                    statement = this.db.getConnection().createStatement();
                    rs = statement.executeQuery(query);
                    while (rs.next()) {
                        results.add(NodeIdUtils.TONODEID(rs.getInt("NODEID")));
                    }
                    if (results.size() == 0) break block23;
                    stringArray2 = results.toArray(new String[0]);
                    Object var11_11 = null;
                    if (statement == null) break block24;
                    try {
                        statement.close();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                }
                rs = null;
                return stringArray2;
            }
            stringArray = new String[]{};
            Object var11_12 = null;
            if (statement == null) break block26;
            try {
                statement.close();
            }
            catch (SQLException e2222) {
                // empty catch block
            }
        }
        statement = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e2222) {
                // empty catch block
            }
        }
        rs = null;
        return stringArray;
        catch (SQLException e3) {
            SQLException e2222;
            String[] stringArray3;
            block28: {
                try {
                    logger.error((Object)("getSubnodes: ERROR sql=" + query), (Throwable)e3);
                    stringArray3 = null;
                    Object var11_13 = null;
                    if (statement == null) break block28;
                }
                catch (Throwable throwable) {
                    SQLException e2222;
                    Object var11_14 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException e2222) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2222) {
                    // empty catch block
                }
            }
            rs = null;
            return stringArray3;
        }
    }

    public String[] getParentNodes(String nodeId) throws UnknownNodeException {
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("getParentNodes: not a classic node id: " + nodeId));
            throw new UnknownNodeException("getParentNodes: invalid NodeId: " + nodeId);
        }
        String[] vPaths = this.getVPaths(nodeId);
        TreeSet<String> parentHS = new TreeSet<String>(new ArchiveObjectsDBImpl.NodeIdComparator());
        for (int i = 0; i < vPaths.length; ++i) {
            if (vPaths[i] == null || vPaths[i].equals("")) {
                return null;
            }
            parentHS.add(vPaths[i].substring(vPaths[i].lastIndexOf(47) + 1));
        }
        return parentHS.toArray(new String[0]);
    }

    public String[] getDescendants(String nodeId, int nodeType, String format) throws UnknownNodeException {
        String[] fmts = new String[]{format};
        return this.getDescendants(nodeId, nodeType, fmts);
    }

    public String[] getDescendants(String nodeId, int nodeType, String[] formats) throws UnknownNodeException {
        String user = "*";
        return this.getDescendants(nodeId, nodeType, formats, user, false);
    }

    public String[] getDescendants(String nodeId, int nodeType, String[] formats, String user, boolean onlyOnsite) throws UnknownNodeException {
        return this.getDescendantsOrCount(nodeId, nodeType, formats, user, onlyOnsite, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String[] getDescendantsOrCount(String nodeId, int nodeType, String[] formats, String user, boolean onlyOnsite, boolean count, boolean distinct) throws UnknownNodeException {
        SQLException e22222;
        String[] stringArray;
        ResultSet rs;
        Statement statement;
        block68: {
            block65: {
                SQLException e22222;
                String[] stringArray2;
                block66: {
                    TreeSet<String> hs;
                    block62: {
                        SQLException e22222;
                        String[] stringArray3;
                        block63: {
                            String nq;
                            String dst;
                            if (nodeId == null || !NodeIdUtils.isNodeId(nodeId)) {
                                logger.error((Object)("getDescendants: not a classic node id: " + nodeId + " nodeType=" + nodeType + " user=" + user + " ..."));
                                throw new UnknownNodeException("getDescendants: invalid NodeId: " + nodeId);
                            }
                            String string = dst = distinct ? "DISTINCT " : "";
                            if ("*".equals(user)) {
                                user = "ignore";
                            }
                            if (formats != null && (formats[0] == null || formats[0].equals("*"))) {
                                formats = null;
                            }
                            if (!this.statusLog("getDescendants")) {
                                return new String[0];
                            }
                            if (formats != null) {
                                logger.debug((Object)("getDescendants: nodeType=" + nodeType + ", formats[0]=" + formats[0] + ", user=" + user));
                            } else {
                                logger.debug((Object)("getDescendants: nodeType=" + nodeType + ", all formats, user=" + user));
                            }
                            String query = null;
                            String vPath = this.getCanonicalVPath(nodeId) + "/" + nodeId;
                            String vq = "SELECT NODEID FROM " + CORPUSSTRUCTURE + " WHERE " + this.matchVPathColumnsSQL(vPath, false);
                            vPath = null;
                            if (nodeType != -1 || formats != null) {
                                query = count ? "SELECT COUNT ( " + dst + CORPUSNODES + ".NODEID ) FROM " + CORPUSNODES : "SELECT " + CORPUSNODES + ".NODEID FROM " + CORPUSNODES;
                                if (onlyOnsite || !"ignore".equals(user)) {
                                    query = query + " JOIN ARCHIVEOBJECTS ON " + CORPUSNODES + ".NODEID = " + ARCHIVEOBJECTS + ".NODEID";
                                }
                            } else if (onlyOnsite || !"ignore".equals(user)) {
                                query = count ? "SELECT COUNT ( " + dst + ARCHIVEOBJECTS + ".NODEID ) FROM " + ARCHIVEOBJECTS : "SELECT " + ARCHIVEOBJECTS + ".NODEID FROM " + ARCHIVEOBJECTS;
                            }
                            if (query == null) {
                                query = vq;
                                if (count) {
                                    query = query.replaceFirst("NODEID", "COUNT ( " + dst + "NODEID )");
                                }
                            } else {
                                query = onlyOnsite || !"ignore".equals(user) ? query + " WHERE " + ARCHIVEOBJECTS + ".NODEID IN (" + vq + ") AND" : query + " WHERE " + CORPUSNODES + ".NODEID IN (" + vq + ") AND";
                            }
                            String fmtq = "";
                            if (formats != null) {
                                fmtq = fmtq + "( ";
                                for (int i = 0; i < formats.length; ++i) {
                                    String gfmt = this.glob(formats[i]);
                                    if (i != 0) {
                                        fmtq = fmtq + " OR ";
                                    }
                                    fmtq = gfmt.equals(formats[i]) ? fmtq + " FORMAT = '" + gfmt + "'" : fmtq + " FORMAT LIKE '" + gfmt + "'";
                                }
                                fmtq = fmtq + " )";
                            }
                            String typeq = "";
                            if (nodeType != -1) {
                                String add = "";
                                if ((nodeType & 2) == 2) {
                                    add = add + " NODETYPE  = 2";
                                }
                                if ((nodeType & 0x80) == 128) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " NODETYPE = 128";
                                }
                                if ((nodeType & 1) == 1) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " NODETYPE = 1";
                                }
                                if ((nodeType & 4) == 4) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " NODETYPE = 4";
                                }
                                if ((nodeType & 0x10) == 16) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " NODETYPE = 16";
                                }
                                if ((nodeType & 8) == 8) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " NODETYPE = 8";
                                }
                                if ((nodeType & 0x40) == 64) {
                                    if (!add.equals("")) {
                                        add = add + " OR ";
                                    }
                                    add = add + " NODETYPE = 64";
                                }
                                if (!add.equals("")) {
                                    typeq = "( " + add + " )";
                                }
                            }
                            if (!(nq = fmtq).equals("") && !typeq.equals("")) {
                                nq = nq + " AND ";
                            }
                            if (!(nq = nq + typeq).equals("")) {
                                query = query + " " + nq + " AND";
                            }
                            if (!"ignore".equals(user)) {
                                query = query + " ( " + AccessCheck.expressRights(user, "READRIGHTS") + " ) AND";
                            }
                            if (onlyOnsite) {
                                query = query + " ( ONSITE = TRUE ) AND";
                            }
                            if (query.endsWith("AND")) {
                                query = query.substring(0, query.length() - 3);
                            }
                            query = query.trim();
                            logger.debug((Object)("### getDescendants: " + query));
                            statement = null;
                            rs = null;
                            hs = new TreeSet<String>(new ArchiveObjectsDBImpl.NodeIdComparator());
                            statement = this.db.getConnection().createStatement();
                            rs = statement.executeQuery(query);
                            while (rs.next()) {
                                if (count) {
                                    hs.add("" + rs.getInt(1));
                                    continue;
                                }
                                hs.add(NodeIdUtils.TONODEID(rs.getInt(1)));
                            }
                            if (hs.size() != 0) break block62;
                            logger.debug((Object)"getDescendants: n=0 (NONE)");
                            stringArray3 = new String[]{};
                            Object var20_24 = null;
                            if (statement == null) break block63;
                            try {
                                statement.close();
                            }
                            catch (SQLException e22222) {
                                // empty catch block
                            }
                        }
                        statement = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e22222) {
                                // empty catch block
                            }
                        }
                        rs = null;
                        return stringArray3;
                    }
                    if (hs.size() == 0) break block65;
                    logger.debug((Object)("getDescendants: n=" + hs.size()));
                    stringArray2 = hs.toArray(new String[0]);
                    Object var20_25 = null;
                    if (statement == null) break block66;
                    try {
                        statement.close();
                    }
                    catch (SQLException e22222) {
                        // empty catch block
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e22222) {
                        // empty catch block
                    }
                }
                rs = null;
                return stringArray2;
            }
            logger.debug((Object)"getDescendants: n=0 (NONE)");
            stringArray = new String[]{};
            Object var20_26 = null;
            if (statement == null) break block68;
            try {
                statement.close();
            }
            catch (SQLException e22222) {
                // empty catch block
            }
        }
        statement = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e22222) {
                // empty catch block
            }
        }
        rs = null;
        return stringArray;
        catch (SQLException e3) {
            SQLException e22222;
            String[] stringArray4;
            block70: {
                try {
                    logger.error((Object)"getDescendants:", (Throwable)e3);
                    stringArray4 = new String[]{};
                    Object var20_27 = null;
                    if (statement == null) break block70;
                }
                catch (Throwable throwable) {
                    SQLException e22222;
                    Object var20_28 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e22222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e22222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException e22222) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e22222) {
                    // empty catch block
                }
            }
            rs = null;
            return stringArray4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected String[] getVPaths(String nodeId) throws UnknownNodeException {
        SQLException e2222;
        String[] vPath;
        ResultSet rs;
        Statement statement;
        block27: {
            Vector<String[]> results;
            block24: {
                SQLException e2222;
                block25: {
                    if (!this.statusLog("getVPaths")) {
                        return null;
                    }
                    if (!NodeIdUtils.isNodeId(nodeId)) {
                        logger.error((Object)("getVPaths: not a classic node id: " + nodeId));
                        throw new UnknownNodeException("getVPaths: invalid NodeId: " + nodeId);
                    }
                    results = new Vector<String[]>();
                    statement = null;
                    rs = null;
                    String cmd = "SELECT * FROM " + CORPUSSTRUCTURE + " WHERE NODEID = " + NodeIdUtils.TOINT(nodeId);
                    statement = this.db.getConnection().createStatement();
                    rs = statement.executeQuery(cmd);
                    while (rs.next()) {
                        vPath = this.getVPathFromRS(rs);
                        if (rs.getBoolean("CANONICAL")) {
                            results.insertElementAt(vPath, 0);
                            continue;
                        }
                        results.add(vPath);
                    }
                    if (results.size() != 0) break block24;
                    this.throwUnknownNodeException("getVPaths", "", nodeId);
                    vPath = null;
                    Object var9_8 = null;
                    if (statement == null) break block25;
                    try {
                        statement.close();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                }
                statement = null;
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException e2222) {
                        // empty catch block
                    }
                }
                rs = null;
                return vPath;
            }
            vPath = results.toArray(new String[0]);
            Object var9_9 = null;
            if (statement == null) break block27;
            try {
                statement.close();
            }
            catch (SQLException e2222) {
                // empty catch block
            }
        }
        statement = null;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e2222) {
                // empty catch block
            }
        }
        rs = null;
        return vPath;
        catch (SQLException e3) {
            SQLException e2222;
            String[] stringArray;
            block29: {
                try {
                    logger.error((Object)"getVPaths: ", (Throwable)e3);
                    stringArray = null;
                    Object var9_10 = null;
                    if (statement == null) break block29;
                }
                catch (Throwable throwable) {
                    SQLException e2222;
                    Object var9_11 = null;
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    statement = null;
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException e2222) {
                            // empty catch block
                        }
                    }
                    rs = null;
                    throw throwable;
                }
                try {
                    statement.close();
                }
                catch (SQLException e2222) {
                    // empty catch block
                }
            }
            statement = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e2222) {
                    // empty catch block
                }
            }
            rs = null;
            return stringArray;
        }
    }

    public String getCanonicalVPath(String nodeId) throws UnknownNodeException {
        if (!this.statusLog("getCanonicalVPath")) {
            return null;
        }
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("getCanonicalVPath: not a classic node id: " + nodeId));
            throw new UnknownNodeException("getCanonicalVPath: invalid NodeId: " + nodeId);
        }
        long time = System.currentTimeMillis();
        if (time > cacheExpiryTime - 50000L && canonicalParentCache.size() > 100000) {
            cacheExpiryTime = 0L;
        }
        if (time > cacheExpiryTime) {
            canonicalParentCache.clear();
            cacheExpiryTime = time + 60000L;
        }
        String pathFromCache = "";
        String canParent = nodeId;
        while (!canParent.equals(this.getRootNodeId())) {
            canParent = this.getCanonicalParent(canParent);
            pathFromCache = "/" + canParent + pathFromCache;
        }
        return pathFromCache;
    }

    public String getCanonicalParent(String nodeId) throws UnknownNodeException {
        if (nodeId.equals(this.getRootNodeId())) {
            logger.debug((Object)"getCanonicalParent called for root node?");
            return "";
        }
        String knownParent = (String)canonicalParentCache.get(nodeId);
        if (knownParent != null) {
            return knownParent;
        }
        String[] parents = new String[]{};
        try {
            parents = this.getParentNodes(nodeId);
        }
        catch (UnknownNodeException une) {
            // empty catch block
        }
        if (parents.length == 0) {
            throw new UnknownNodeException("No canonical parent for unlinked node: " + nodeId);
        }
        if (parents.length == 1) {
            canonicalParentCache.put(nodeId, parents[0]);
            return parents[0];
        }
        URI childURI = this.getObjectURI(nodeId);
        if (childURI == null) {
            logger.error((Object)("getCanonicalParent: Node has no URI, picking any parent as canonical: " + nodeId));
            canonicalParentCache.put(nodeId, parents[0]);
            return parents[0];
        }
        String childURIstring = childURI.toString();
        String bestParent = parents[0];
        int longestMatch = 0;
        int lowestMatch = Integer.MAX_VALUE;
        for (int i = 0; i < parents.length; ++i) {
            int compareMatch;
            URI parentURI = this.getObjectURI(parents[i]);
            if (parentURI == null) continue;
            String parentURIstring = parentURI.toString();
            int compareSize = parentURIstring.length();
            if (childURIstring.length() < compareSize) {
                compareSize = childURIstring.length();
            }
            if (compareSize < longestMatch) continue;
            int matchNodeNr = NodeIdUtils.TOINT(parents[i]);
            for (compareMatch = 0; compareMatch < compareSize && parentURIstring.charAt(compareMatch) == childURIstring.charAt(compareMatch); ++compareMatch) {
            }
            if (compareMatch == longestMatch) {
                if (matchNodeNr >= lowestMatch) continue;
                bestParent = parents[i];
                lowestMatch = matchNodeNr;
                continue;
            }
            if (compareMatch <= longestMatch) continue;
            longestMatch = compareMatch;
            bestParent = parents[i];
            lowestMatch = matchNodeNr;
        }
        canonicalParentCache.put(nodeId, bestParent);
        return bestParent;
    }

    public String getNamePath(String nodeId) throws UnknownNodeException {
        if (!NodeIdUtils.isNodeId(nodeId)) {
            logger.error((Object)("getNamePath: not a classic node id: " + nodeId));
            throw new UnknownNodeException("getNamePath: invalid NodeId: " + nodeId);
        }
        return this.translateToNamePath(new String[]{nodeId})[0];
    }

    public String[] translateToNamePath(String[] nodeids) throws UnknownNodeException {
        Hashtable<String, String> nameHash = new Hashtable<String, String>();
        nameHash.put("", "");
        Vector<String> results = new Vector<String>();
        int cnt1 = 0;
        int cnt2 = 0;
        for (int i = 0; i < nodeids.length; ++i) {
            String appendstr = null;
            try {
                String cvPath = this.getCanonicalVPath(nodeids[i]);
                String[] ancestors = cvPath.split("/");
                appendstr = this.getNode(nodeids[i]).getName();
                if (ancestors.length > 0) {
                    String[] names = new String[ancestors.length];
                    String namepath = "";
                    String np = "";
                    for (int j = ancestors.length - 1; j >= 0; --j) {
                        String name;
                        if (ancestors[j] == null) {
                            logger.warn((Object)("translateToNamePath: got null for ancestor " + j + " in: " + cvPath));
                            continue;
                        }
                        namepath = (String)nameHash.get(ancestors[j]);
                        if (namepath != null) {
                            appendstr = namepath + '/' + appendstr;
                            ++cnt1;
                            np = namepath;
                            break;
                        }
                        names[j] = name = this.getNode(ancestors[j]).getName();
                        appendstr = name + "/" + appendstr;
                        ++cnt2;
                    }
                    for (int k = j + 1; k < ancestors.length; ++k) {
                        np = np + "/" + names[k];
                        nameHash.put(ancestors[k], np);
                    }
                }
                results.add(appendstr);
                continue;
            }
            catch (UnknownNodeException e) {
                logger.error((Object)("translateToNamePath: encountered unknown node: " + e));
                results.add(null);
            }
        }
        if (nodeids.length > 1) {
            logger.debug((Object)("translateToNamePath: lookups=" + cnt2 + " cached=" + cnt1));
        }
        return results.toArray(new String[0]);
    }

    public String resolveNameInAnnotationContext(String annotationNodeId, String name, String function) throws UnknownNodeException {
        if (!NodeIdUtils.isNodeId(annotationNodeId)) {
            logger.error((Object)("resolveNameInAnnotationContext: not a classic node id: " + annotationNodeId + " name=" + name + " function=" + function));
            throw new UnknownNodeException("resolveNameInAnnotationContext: invalid NodeId: " + annotationNodeId);
        }
        String[] sessionNodeIds = this.getParentNodes(annotationNodeId);
        return this.resolveNameInSessionContext(sessionNodeIds[0], name, null);
    }

    public String resolveNameInSessionContext(String sessionNodeId, String name, String function) {
        if (!NodeIdUtils.isNodeId(sessionNodeId)) {
            logger.error((Object)("resolveNameInSessionContext: not a classic node id: " + sessionNodeId + " name=" + name + " function=" + function));
            throw new UnknownNodeException("resolveNameInSessionContext: invalid NodeId: " + sessionNodeId);
        }
        String[] c = this.getSubnodes(sessionNodeId);
        Node[] nodes = new Node[c.length];
        for (int i = 0; i < c.length; ++i) {
            nodes[i] = this.getNode(c[i]);
            String nodeName = nodes[i].getName();
            if (nodeName == null || !nodeName.trim().equalsIgnoreCase(name)) continue;
            return c[i];
        }
        return null;
    }

    public String getSearchServletURL() {
        return this.getAdminKey("MDSearchServletURL");
    }

    public String matchVPathColumnsSQL(String vPath, boolean exact) throws UnknownNodeException {
        if (vPath == null) {
            vPath = "";
        }
        String[] ids = vPath.split("/");
        for (int i = 1; i < ids.length; ++i) {
            if (ids[i].length() <= 0 || NodeIdUtils.isNodeId(ids[i])) continue;
            logger.error((Object)"vPath must consist of classic node IDs");
            throw new UnknownNodeException("matchVPathColumnsSQL: invalid path: " + vPath);
        }
        if (exact) {
            return "VPATH = '" + vPath + "'";
        }
        if (ids.length <= 1) {
            return "TRUE";
        }
        if (this.vPathSearchDepth >= ids.length - 1) {
            String query = "";
            for (int i = ids.length - 1; i > 0; --i) {
                if (!query.equals("")) {
                    query = query + " AND ";
                }
                query = query + "VPATH" + (i - 1) + " = " + NodeIdUtils.TOINT(ids[i]);
            }
            return query;
        }
        String vPath2 = vPath + "/ZZZ";
        return "( VPATH BETWEEN '" + vPath + "' AND '" + vPath2 + "' )";
    }

    private CorpusNode createCorpusNodeFromRS(ResultSet rs) {
        CorpusNode node = null;
        String vpath = null;
        try {
            node = new CorpusNode(NodeIdUtils.TONODEID(rs.getInt("NODEID")), rs.getInt("NODETYPE"), rs.getString("FORMAT"), rs.getString("NAME"), rs.getString("TITLE"));
            vpath = rs.getString("VPATH");
            node.addVPath(vpath);
            if (rs.getBoolean("CANONICAL")) {
                node.setCanonicalPath(vpath);
            }
            while (rs.next()) {
                vpath = rs.getString("VPATH");
                node.addVPath(vpath);
                if (!rs.getBoolean("CANONICAL")) continue;
                node.setCanonicalPath(vpath);
            }
            return node;
        }
        catch (SQLException sqle) {
            logger.error((Object)"createCorpusNodeFromRS: ", (Throwable)sqle);
        }
        catch (Exception e) {
            logger.error((Object)"createCorpusNodeFromRS: ", (Throwable)e);
        }
        return null;
    }

    private Node createNodeFromRS(ResultSet rs) {
        Node node = null;
        try {
            node = new Node(NodeIdUtils.TONODEID(rs.getInt("NODEID")), rs.getInt("NODETYPE"), rs.getString("FORMAT"), rs.getString("NAME"), rs.getString("TITLE"));
            return node;
        }
        catch (SQLException sqle) {
            logger.error((Object)"createNodeFromRS: ", (Throwable)sqle);
        }
        catch (Exception e) {
            logger.error((Object)"createNodeFromRS: ", (Throwable)e);
        }
        return null;
    }

    private Hashtable createCorpusNodesFromRS(ResultSet rs) {
        String vPath = null;
        Hashtable<String, CorpusNode> nodesHash = new Hashtable<String, CorpusNode>();
        try {
            while (rs.next()) {
                String nodeId = NodeIdUtils.TONODEID(rs.getInt("NODEID"));
                CorpusNode node = (CorpusNode)nodesHash.get(nodeId);
                if (node == null) {
                    node = new CorpusNode(nodeId, rs.getInt("NODETYPE"), rs.getString("FORMAT"), rs.getString("NAME"), rs.getString("TITLE"));
                    vPath = rs.getString("VPATH");
                    node.addVPath(vPath);
                    if (rs.getBoolean("CANONICAL")) {
                        node.setCanonicalPath(vPath);
                    }
                    nodesHash.put(nodeId, node);
                    continue;
                }
                if (rs.getBoolean("CANONICAL")) {
                    node.setCanonicalPath(vPath);
                }
                node.addVPath(rs.getString("VPATH"));
            }
            return nodesHash;
        }
        catch (SQLException sqle) {
            logger.error((Object)"createCorpusNodesFromRS: ", (Throwable)sqle);
        }
        catch (Exception e) {
            logger.error((Object)"createCorpusNodesFromRS: ", (Throwable)e);
        }
        return null;
    }

    private String getVPathFromRS(ResultSet rs) {
        Object vPath = null;
        try {
            return rs.getString("VPATH");
        }
        catch (SQLException sqle) {
            logger.error((Object)"getVPathFromRS: ", (Throwable)sqle);
        }
        catch (Exception e) {
            logger.error((Object)"getVPathFromRS: ", (Throwable)e);
        }
        return null;
    }

    private String glob(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(92) != -1 || s.indexOf(39) != -1) {
            return "INVALID";
        }
        String ns = s.replace('*', '%');
        ns = ns.replace('?', '_');
        return ns;
    }

    protected boolean statusLog(String method) {
        boolean okay = this.getStatus();
        if (!okay) {
            logger.error((Object)("CorpusStructureDBImpl." + method + ": DB / object status is false"));
        }
        return okay;
    }
}

