/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.UnknownNodeException;
import mpi.corpusstructure.UpdateInProgressException;
import mpi.util.OurURL;
import org.apache.log4j.Logger;

public class Mover {
    private static Logger logger = Logger.getLogger((String)Mover.class.getName());
    protected static boolean verbose = true;

    public static File fileOf(String fileName) {
        File myFile = null;
        if (fileName.startsWith("http:") || fileName.startsWith("ftp:") || fileName.startsWith("https:")) {
            return null;
        }
        if (fileName.startsWith("file:")) {
            OurURL fileURL = null;
            if (fileName.indexOf("///") != -1) {
                fileName = fileName.replaceFirst("///", "/");
            }
            try {
                fileURL = new OurURL(fileName);
            }
            catch (MalformedURLException mue) {
                logger.warn((Object)("fileOf: MalformedURL: error=" + mue + " url=" + fileName));
                return null;
            }
            fileName = fileURL.getFile();
        }
        if (!(myFile = new File(fileName)).isAbsolute()) {
            myFile = myFile.getAbsoluteFile();
        }
        return myFile;
    }

    public static boolean copyFile(File source, File target) {
        FileOutputStream outStream;
        FileInputStream inStream;
        byte[] buffer = new byte[65536];
        int howmuch = 0;
        if (buffer == null) {
            logger.error((Object)"copyFile: Out of memory");
            return false;
        }
        try {
            inStream = new FileInputStream(source);
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)("copyFile: Input file not found: " + source + " error: " + fnfe));
            return false;
        }
        catch (SecurityException se) {
            logger.error((Object)("copyFile: No Java permission to access source: " + source + " error: " + se));
            return false;
        }
        try {
            outStream = new FileOutputStream(target);
        }
        catch (FileNotFoundException fnfe) {
            logger.error((Object)("copyFile: Output file cannot be written: " + target + " error: " + fnfe));
            try {
                inStream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return false;
        }
        catch (SecurityException se) {
            logger.error((Object)("copyFile: No Java permission to access target: " + target + " error: " + se));
            try {
                inStream.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return false;
        }
        try {
            howmuch = inStream.read(buffer);
            while (howmuch != -1) {
                outStream.write(buffer, 0, howmuch);
                howmuch = inStream.read(buffer);
            }
        }
        catch (IOException ioe) {
            logger.error((Object)("copyFile: I/O error: " + ioe + " source=" + source + " target=" + target));
            try {
                inStream.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            try {
                outStream.close();
            }
            catch (IOException ioe2) {
                // empty catch block
            }
            return false;
        }
        try {
            inStream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            outStream.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return true;
    }

    public static boolean moveFile(File source, File target, boolean simulate) {
        block23: {
            Object nodeId = null;
            OurURL sourceURL = null;
            OurURL targetURL = null;
            if (!source.isAbsolute()) {
                source = source.getAbsoluteFile();
            }
            if (!target.isAbsolute()) {
                target = target.getAbsoluteFile();
            }
            try {
                sourceURL = new OurURL(source.toURL());
            }
            catch (MalformedURLException mue) {
                logger.error((Object)("moveFile: Cannot create URL of source: " + source));
                return false;
            }
            try {
                targetURL = new OurURL(target.toURL());
            }
            catch (MalformedURLException mue) {
                logger.error((Object)("moveFile: Cannot create URL of target: " + target));
                return false;
            }
            try {
                File targetDir = target.getParentFile();
                if (targetDir == null || !targetDir.canWrite()) {
                    logger.error((Object)("moveFile: target directory is not writeable, target: " + target));
                    return false;
                }
                File sourceDir = source.getParentFile();
                if (sourceDir == null || !sourceDir.canWrite()) {
                    logger.error((Object)("moveFile: source directory is not writeable, source: " + source));
                    return false;
                }
                if (!source.exists()) {
                    logger.error((Object)("moveFile: source does not exist: " + source));
                    return false;
                }
                if (source.isDirectory()) {
                    logger.error((Object)("moveFile: source is a directory: " + source));
                    return false;
                }
                if (!source.canRead()) {
                    logger.error((Object)("moveFile: source must be readable: " + source));
                    return false;
                }
                if (target.exists()) {
                    logger.error((Object)("moveFile: Will not overwrite existing target: " + target));
                    return false;
                }
                if (simulate) {
                    logger.debug((Object)("moveFile simulation: " + source + " --> " + target));
                    return true;
                }
                if (source.renameTo(target)) break block23;
                logger.debug((Object)"moveFile: Using copyFile...");
                try {
                    if (!target.createNewFile()) {
                        logger.error((Object)("moveFile: Could not create target: " + target));
                        return false;
                    }
                }
                catch (IOException ioe) {
                    logger.error((Object)("moveFile: Could not create target: " + target + " error: " + ioe));
                    return false;
                }
                if (!Mover.copyFile(source, target)) {
                    return false;
                }
                long whence = source.lastModified();
                if (whence == 0L) {
                    logger.warn((Object)("moveFile: Timestamp unknown for source: " + source));
                } else if (!target.setLastModified(whence)) {
                    logger.warn((Object)("moveFile: Could not set target timestamp for: " + target));
                }
                if (!source.delete()) {
                    logger.warn((Object)("moveFile: Copy to target worked, but could not delete source: " + source));
                }
            }
            catch (SecurityException se) {
                logger.error((Object)("moveFile: Java does not have permission to rename file: " + source + "  to  " + target));
                return false;
            }
        }
        return true;
    }

    public static boolean moveURI(URI sourceURI, URI targetURI, boolean simulate, ArchiveObjectsDBWrite aodbwr) {
        if (aodbwr == null || sourceURI == null || targetURI == null) {
            return false;
        }
        if (!sourceURI.isAbsolute()) {
            logger.error((Object)("moveURI: source URI is not absolute, must specify schema/protocol: " + sourceURI));
            return false;
        }
        if (!targetURI.isAbsolute()) {
            logger.error((Object)("moveURI: target URI is not absolute, must specify schema/protocol: " + targetURI));
            return false;
        }
        sourceURI = aodbwr.getArchiveRoots().inTableContext(sourceURI);
        targetURI = aodbwr.getArchiveRoots().inTableContext(targetURI);
        String nodeId = aodbwr.getObjectId(sourceURI);
        if (nodeId == null) {
            logger.debug((Object)("moveURI: Source is not known to database of " + aodbwr.getClass().toString() + ": " + sourceURI));
            return false;
        }
        try {
            targetURI = aodbwr.getArchiveRoots().stringToURI(targetURI.toString());
            if (simulate) {
                if (verbose) {
                    logger.debug((Object)("moveURI simulation: NodeId=" + nodeId + ", source=" + sourceURI + " target=" + targetURI));
                }
                return true;
            }
            if (verbose) {
                logger.debug((Object)("moveURI: NodeId=" + nodeId + ", source=" + sourceURI + " target=" + targetURI));
            }
            if (!aodbwr.moveArchiveObject(nodeId, targetURI)) {
                logger.error((Object)("moveURI: Could not update URL for node: " + nodeId + " target=" + targetURI));
                return false;
            }
            return true;
        }
        catch (URISyntaxException use) {
            logger.error((Object)("moveURI: Could not update URL for node: not a valid URI: " + nodeId + " target=" + targetURI));
        }
        catch (UpdateInProgressException uipe) {
            logger.error((Object)("moveURI: Could not update URL for node, update in progress: " + nodeId + " target=" + targetURI));
        }
        catch (UnknownNodeException une) {
            logger.error((Object)("moveURI: Unexpected database update error: Node unknown: " + nodeId + " target=" + targetURI));
        }
        return false;
    }

    public static boolean moveURImulti(URI sourceURI, URI targetURI, boolean simulate, Vector aodbWriters) {
        Vector<ArchiveObjectsDBWrite> movedOkay = new Vector<ArchiveObjectsDBWrite>();
        Enumeration aodbwrEnum = aodbWriters.elements();
        int success = 0;
        int writers = 0;
        while (aodbwrEnum.hasMoreElements()) {
            ArchiveObjectsDBWrite aodbwr = (ArchiveObjectsDBWrite)aodbwrEnum.nextElement();
            if (aodbwr == null) continue;
            if (Mover.moveURI(sourceURI, targetURI, simulate, aodbwr)) {
                ++success;
                movedOkay.add(aodbwr);
            }
            ++writers;
        }
        if (success == 0) {
            logger.info((Object)("moveURImulti: File was not known to ANY database: " + targetURI));
            return false;
        }
        if (success != writers) {
            if (simulate) {
                logger.warn((Object)("moveURImulti simulation: ONLY " + success + " OUT OF " + writers + " databases now know " + targetURI));
            } else {
                logger.warn((Object)("moveURImulti: ONLY " + success + " OUT OF " + writers + " databases now know " + targetURI));
            }
            if (!Mover.moveURImulti(targetURI, sourceURI, simulate, movedOkay)) {
                logger.warn((Object)"moveURImulti: Could not undo the move everywhere!");
            }
            return false;
        }
        if (verbose) {
            if (simulate) {
                logger.debug((Object)("moveURImulti simulation: all " + writers + " databases now know " + targetURI));
            } else {
                logger.debug((Object)("moveURImulti: all " + writers + " databases now know " + targetURI));
            }
        }
        return true;
    }
}

