/*
 * Decompiled with CFR 0.152.
 */
package mpi.imdidb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import mpi.imdidb.IMDIRdbModel;
import org.apache.log4j.Logger;

public class IMDIQueryToSQL {
    private Logger logger = Logger.getLogger((String)this.getClass().getName());
    private static final String tablePFX = "IMDIMD_";
    private static int NUMERIC = 1;
    private static int STRING = 2;
    private static int DATE = 3;
    private static int AGE = 4;

    public String IMDIqueryToSQL(String query) {
        String[] queryArray = IMDIQueryToSQL.tokenizeQuery(query);
        return this.IMDIqueryToSQL(queryArray);
    }

    public String IMDIqueryToSQL(String[] queries) throws IllegalArgumentException {
        int i;
        ArrayList<String> fromList = new ArrayList<String>();
        ArrayList valueList = new ArrayList();
        ArrayList joinList = new ArrayList();
        boolean actorQuery = false;
        String sqlline = "SELECT DISTINCT ";
        try {
            ArrayList<IMDISearchQuery> searchQueries = new ArrayList<IMDISearchQuery>();
            for (int i2 = 0; i2 < queries.length; ++i2) {
                System.out.println("IMDIQueryToSQL: " + queries[i2]);
                IMDISearchQuery q = new IMDISearchQuery(queries[i2]);
                actorQuery = actorQuery || q.hasActorTable();
                String mainTable = q.getMainTable();
                if (!fromList.contains(mainTable)) {
                    fromList.add(mainTable);
                    if (fromList.size() > 1) {
                        sqlline = sqlline + ", ";
                    }
                    sqlline = sqlline + mainTable + ".NODEID, " + mainTable + ".NAME";
                }
                searchQueries.add(q);
            }
            if (actorQuery) {
                sqlline = sqlline + ", IMDIMD_ACTOR.CODE";
            }
            this.decodeQueryParts(fromList, valueList, joinList, searchQueries);
        }
        catch (Exception e) {
            this.logger.error((Object)("decodeIMDIqueryLine: Exception caught: " + e), (Throwable)e);
            throw new IllegalArgumentException("Invalid query");
        }
        sqlline = sqlline + " FROM ";
        for (i = 0; i < fromList.size(); ++i) {
            if (i != 0) {
                sqlline = sqlline + ", ";
            }
            sqlline = sqlline + fromList.get(i);
        }
        sqlline = sqlline + " WHERE ";
        for (i = 0; i < joinList.size(); ++i) {
            sqlline = sqlline + joinList.get(i) + " AND ";
        }
        for (i = 0; i < valueList.size(); ++i) {
            sqlline = sqlline + valueList.get(i) + " AND ";
        }
        if (sqlline.endsWith(" AND ")) {
            sqlline = sqlline.substring(0, sqlline.length() - 5);
        }
        sqlline = sqlline.replaceAll(".Id1", ".NODEID");
        sqlline = actorQuery ? "SELECT NODEID, CODE FROM (" + sqlline + ") AS tmp ORDER BY NAME" : "SELECT NODEID FROM (" + sqlline + ") AS tmp ORDER BY NAME";
        this.logger.info((Object)sqlline);
        return sqlline;
    }

    private void decodeQueryParts(List fromList, List valueList, List joinList, List searchQueries) {
        HashMap<String, String> usedTableMap = new HashMap<String, String>();
        ArrayList<String> oldTables = new ArrayList<String>();
        for (IMDISearchQuery query : searchQueries) {
            ArrayList tables = new ArrayList();
            ArrayList ids = new ArrayList();
            String value = this.decodeIMDIqueryLine(query, tables, ids);
            ArrayList<String> idtables = new ArrayList<String>();
            idtables.add(query.getMainTable());
            for (int i = 0; i < tables.size(); ++i) {
                String ctable = (String)tables.get(i);
                String id = (String)ids.get(i);
                ArrayList<String> neqtables = new ArrayList<String>();
                if (oldTables.contains(ctable)) {
                    if (usedTableMap.get(ctable + id) == null) {
                        String js;
                        neqtables.add(ctable);
                        String nctable = ctable + "1";
                        int k = 2;
                        while (oldTables.contains(nctable)) {
                            neqtables.add(nctable);
                            nctable = ctable + Integer.toString(k);
                            ++k;
                        }
                        fromList.add(ctable + " " + nctable);
                        if (i == tables.size() - 1) {
                            value = IMDIQueryToSQL.replace(value, ctable, nctable);
                        }
                        int j = i + 1;
                        int n = i + 2;
                        for (k = 0; k < neqtables.size(); ++k) {
                            js = nctable + ".Id" + n + "!=" + neqtables.get(k) + ".Id" + n;
                            joinList.add(js);
                        }
                        while (j > 0) {
                            js = nctable + ".Id" + j + "=" + idtables.get(j - 1) + ".Id" + j;
                            joinList.add(js);
                            --j;
                        }
                        idtables.add(nctable);
                        usedTableMap.put(ctable + id, nctable);
                        oldTables.add(nctable);
                        continue;
                    }
                    String nctable = (String)usedTableMap.get(ctable + id);
                    idtables.add(nctable);
                    if (i != tables.size() - 1) continue;
                    value = IMDIQueryToSQL.replace(value, ctable, nctable);
                    continue;
                }
                fromList.add(ctable);
                for (int j = i + 1; j > 0; --j) {
                    String js = ctable + ".Id" + j + "=" + idtables.get(j - 1) + ".Id" + j;
                    joinList.add(js);
                }
                oldTables.add(ctable);
                usedTableMap.put(ctable + id, ctable);
                idtables.add(ctable);
            }
            valueList.add(value);
        }
    }

    public static String[] tokenizeQuery(String query) {
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(query, "\n");
        while (st.hasMoreTokens()) {
            String qline = st.nextToken();
            lines.add(qline);
        }
        String[] queryArray = lines.toArray(new String[0]);
        return queryArray;
    }

    private static String replace(String s, String name, String newName) {
        String r = new String(s);
        int start = r.indexOf(name);
        while (start > -1) {
            r = r.substring(0, start) + newName + r.substring(start + name.length());
            start = r.indexOf(name, start + newName.length());
        }
        return r;
    }

    private String decodeIMDIqueryLine(IMDISearchQuery query, List tables, List ids) throws IllegalArgumentException {
        String result = null;
        String columnName = "";
        String keyname = "";
        String value = query.getValue();
        String[] elements = query.getElements();
        String element = elements[0];
        String currentTable = tablePFX + element;
        String path = element;
        for (int i = 1; i < elements.length; ++i) {
            element = elements[i];
            if (element.indexOf(40) != -1 || element.equalsIgnoreCase("Anonyms")) {
                String id;
                String cleanToken;
                int brid = element.indexOf(40);
                if (brid != -1) {
                    cleanToken = element.substring(0, brid);
                    id = element.substring(brid + 1, brid + 2);
                } else {
                    cleanToken = element;
                    id = "-1";
                }
                currentTable = tablePFX + IMDIRdbModel.toTableName(element, path);
                path = path + "." + cleanToken;
                tables.add(currentTable);
                ids.add(id);
                continue;
            }
            if (i == elements.length - 1) {
                if (element.equals("Key")) {
                    keyname = value.substring(2, value.indexOf(44) - 1).trim();
                    value = value.substring(value.indexOf(44) + 2, value.length() - 2).trim();
                    currentTable = tablePFX + IMDIRdbModel.toTableName(element, path);
                    tables.add(currentTable);
                    ids.add("-1");
                } else if (IMDIRdbModel.elementCanOccurMultipleTimes(path, element)) {
                    currentTable = tablePFX + IMDIRdbModel.toTableName(element, path);
                    tables.add(currentTable);
                    if (!ids.isEmpty()) {
                        ids.add(ids.get(ids.size() - 1));
                    } else {
                        ids.add("-1");
                    }
                    columnName = IMDIRdbModel.toColumnName(element, path);
                } else {
                    columnName = IMDIRdbModel.toColumnName(element, path);
                }
                int valueType = IMDIQueryToSQL.getValueType(element);
                if (value.length() > 0 && (value.charAt(0) == '=' || value.charAt(0) == '<' || value.charAt(0) == '>')) {
                    valueType = NUMERIC;
                }
                if (valueType == STRING) {
                    if (currentTable.endsWith("Keys")) {
                        result = IMDIQueryToSQL.toGlobbedQuery(currentTable + ".Name", keyname) + " AND " + IMDIQueryToSQL.toGlobbedQuery(currentTable + ".Value", value);
                    } else {
                        result = IMDIQueryToSQL.toGlobbedQuery(currentTable + "." + columnName, value);
                        if ("".equals(value)) {
                            result = result + " OR " + currentTable + "." + columnName + " is NULL";
                        }
                    }
                } else if (valueType == NUMERIC || valueType == AGE || valueType == DATE) {
                    String wstr = currentTable + "." + columnName;
                    int iamp = (value = IMDIQueryToSQL.debrace(value)).indexOf("&&");
                    if (iamp == -1) {
                        iamp = value.length();
                    }
                    if (value.charAt(0) == '=') {
                        wstr = wstr + " = " + IMDIQueryToSQL.quotedNumberToString(value.substring(1, iamp), valueType);
                    } else if (value.charAt(0) == '<') {
                        wstr = wstr + " < " + IMDIQueryToSQL.quotedNumberToString(value.substring(1, iamp), valueType);
                    } else if (value.charAt(0) == '>') {
                        wstr = wstr + " > " + IMDIQueryToSQL.quotedNumberToString(value.substring(1, iamp), valueType);
                    }
                    if (iamp != value.length()) {
                        wstr = wstr + " AND " + currentTable + "." + columnName;
                        if ((value = value.substring(iamp + 2).trim()).charAt(0) == '=') {
                            wstr = wstr + " = " + IMDIQueryToSQL.quotedNumberToString(value.substring(1), valueType);
                        } else if (value.charAt(0) == '<') {
                            wstr = wstr + " < " + IMDIQueryToSQL.quotedNumberToString(value.substring(1), valueType);
                        } else if (value.charAt(0) == '>') {
                            wstr = wstr + " > " + IMDIQueryToSQL.quotedNumberToString(value.substring(1), valueType);
                        }
                    }
                    result = wstr;
                }
                return result;
            }
            path = path + "." + element;
        }
        if (result == null) {
            throw new NullPointerException("Query cannot be decoded query =" + query);
        }
        return null;
    }

    private static String quotedNumberToString(String s, int type) {
        String v = IMDIQueryToSQL.dedequote(s);
        if (type == AGE) {
            return IMDIRdbModel.agePeriodToFloat(v).toString();
        }
        if (type == DATE) {
            return IMDIRdbModel.datePeriodToFloat(v).toString();
        }
        throw new IllegalArgumentException("Unknown quoted number type");
    }

    private static String dedequote(String s) {
        s = s.trim();
        while (s.startsWith("\"") && s.endsWith("\"")) {
            s = s.substring(1, s.length() - 1).trim();
        }
        return s;
    }

    private static String debrace(String s) {
        s = s.trim();
        while (s.startsWith("{") && s.endsWith("}")) {
            s = s.substring(1, s.length() - 1).trim();
        }
        return s;
    }

    private static int getValueType(String element) {
        if (element.endsWith("Age")) {
            return AGE;
        }
        if (element.endsWith("Date")) {
            return DATE;
        }
        if (element.equals("???")) {
            return NUMERIC;
        }
        return STRING;
    }

    private static String toGlobbedQuery(String column, String value) {
        value = value.toLowerCase();
        if ((value = IMDIQueryToSQL.escapeSql(value)).indexOf(95) != -1) {
            value = IMDIQueryToSQL.replace(value, "_", "\\_");
        }
        if (value.indexOf(37) != -1) {
            value = IMDIQueryToSQL.replace(value, "%", "\\%");
        }
        if (value.indexOf(42) != -1 || value.indexOf(63) != -1) {
            value = IMDIQueryToSQL.replace(value, "*", "%");
            if ("%".equals(value = IMDIQueryToSQL.replace(value, "?", "_"))) {
                return "TRUE";
            }
            return "LOWER(" + column + ") LIKE '" + value + "'";
        }
        return "LOWER(" + column + ")='" + value + "'";
    }

    private static String escapeSql(String value) {
        String result = value.replace("'", "''");
        return result.replace("\\", "\\\\");
    }

    private class IMDISearchQuery {
        private final String query;
        private String value;
        private String[] elements;
        private String path;

        IMDISearchQuery(String imdiAdvancedQuery) {
            this.query = imdiAdvancedQuery;
            int index = this.query.indexOf(61);
            this.path = this.query.substring(0, index);
            this.value = IMDIQueryToSQL.dedequote(this.query.substring(index + 1));
            this.elements = this.path.split("[.]");
        }

        public String getMainTable() {
            return IMDIQueryToSQL.tablePFX + this.elements[0];
        }

        public String getValue() {
            return this.value;
        }

        public String[] getElements() {
            return this.elements;
        }

        public String toString() {
            return this.query;
        }

        public boolean hasActorTable() {
            return this.path.toUpperCase().contains("ACTOR");
        }
    }
}

