/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.index;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import javax.swing.ProgressMonitor;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mpi.corpusstructure.ArchiveAccessContext;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.Node;
import mpi.metadata.search.index.MDAnalyzer;
import mpi.metadata.search.index.MDIndexerContentHandler;
import org.apache.log4j.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class MDIndexer {
    private static final String tmp = "-tmp";
    private static XMLReader xmlReader = null;
    private static final Logger logger = Logger.getLogger(MDIndexer.class);
    private static final Hashtable urlTable = new Hashtable();

    public static boolean isLocked(String indexDir) {
        boolean isLocked = true;
        try {
            isLocked = IndexReader.indexExists((String)indexDir) && (IndexReader.isLocked((String)indexDir) || IndexReader.indexExists((String)(indexDir + tmp)) && IndexReader.isLocked((String)(indexDir + tmp)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return isLocked;
    }

    public static String getStatus(String indexDir) {
        StringBuffer sb;
        block8: {
            sb = new StringBuffer();
            try {
                if (IndexReader.indexExists((String)indexDir)) {
                    if (MDIndexer.isLocked(indexDir)) {
                        sb.append("Indexer is busy.");
                        break block8;
                    }
                    sb.append("Last modified: " + new Date(IndexReader.lastModified((String)indexDir)) + "\n");
                    sb.append("Number of indexed documents: " + IndexReader.open((String)indexDir).numDocs());
                    File dateFile = new File(indexDir, "databasecreationdate");
                    if (dateFile.exists()) {
                        try {
                            BufferedReader reader = new BufferedReader(new FileReader(dateFile));
                            sb.append("\nStored creation time of source data base: " + reader.readLine());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!MDIndexer.testWriteAccess(indexDir + tmp)) {
                        sb.append("\nNo write access for " + indexDir + tmp + "!");
                    }
                    break block8;
                }
                sb.append("No index found.");
            }
            catch (Exception e) {
                sb.append("\n" + e.getMessage());
            }
        }
        return sb.toString();
    }

    public static void addToIndex(String rootNodeId, String indexDir, CorpusStructureDBImpl corpusStructureDB) throws Exception {
        MDIndexer.addToIndex(rootNodeId, indexDir, corpusStructureDB, null);
    }

    public static void addToIndex(String rootNodeId, String indexDir, CorpusStructureDBImpl corpusStructureDB, ProgressMonitor progressMonitor) throws Exception {
        if (rootNodeId == null) {
            throw new Exception("No root node specified");
        }
        MDIndexer.makeIndex(rootNodeId, indexDir, corpusStructureDB, progressMonitor, false);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.out.println("Usage: MDIndexer corpusStructureDB [rootNodeId]");
        }
        String rootNodeId = args.length > 1 ? args[1] : null;
        CorpusStructureDBImpl defaultCorpusStructure = null;
        String indexFileName = "MDSimpleSearchIndex";
        try {
            defaultCorpusStructure = new CorpusStructureDBImpl(args[0]);
            MDIndexer.makeIndex(rootNodeId, indexFileName, defaultCorpusStructure);
            defaultCorpusStructure.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void makeIndex(CorpusStructureDBImpl corpusStructureDB) throws Exception {
        MDIndexer.makeIndex("MDSimpleSearchIndex", corpusStructureDB, null);
    }

    public static void makeIndex(String indexDir, CorpusStructureDBImpl corpusStructureDB, ProgressMonitor progressMonitor) throws Exception {
        MDIndexer.makeIndex(null, indexDir, corpusStructureDB, progressMonitor);
    }

    public static void makeIndex(String rootNodeId, String indexDir, CorpusStructureDBImpl corpusStructureDB) throws Exception {
        MDIndexer.makeIndex(rootNodeId, indexDir, corpusStructureDB, null);
    }

    public static void makeIndex(String rootNodeId, String indexDir, CorpusStructureDBImpl corpusStructureDB, ProgressMonitor progressMonitor) throws Exception {
        MDIndexer.makeIndex(rootNodeId, indexDir, corpusStructureDB, progressMonitor, true);
    }

    public static void removeFromIndex(String rootNodeId, String indexDir, CorpusStructureDB cs) throws Exception {
        List<String> sessions;
        if (rootNodeId == null) {
            throw new Exception("No root node specified");
        }
        Date start = new Date();
        if (cs == null || !cs.getStatus()) {
            throw new Exception("Can't connect to corpus sturcture service " + cs);
        }
        logger.info((Object)("Collecting sessions beneath node with id " + rootNodeId));
        if (rootNodeId == null) {
            rootNodeId = cs.getRootNodeId();
        }
        if ((sessions = Arrays.asList(cs.getSessions(rootNodeId))).size() == 0) {
            throw new Exception("No descendant sessions");
        }
        if (!IndexReader.indexExists((String)indexDir)) {
            throw new Exception("No index found in " + indexDir);
        }
        logger.info((Object)("Opening index in directory: " + indexDir));
        if (IndexReader.isLocked((String)indexDir)) {
            throw new Exception("Indexer is already busy.");
        }
        IndexReader indexReader = IndexReader.open((String)indexDir);
        if (indexReader.numDocs() == 0) {
            throw new Exception("Index contains no documents.");
        }
        logger.info((Object)("Index contains " + indexReader.numDocs() + " IMDI files"));
        logger.info((Object)("Deleting " + sessions.size() + " IMDI files"));
        int totalRemovedDocs = 0;
        for (int i = 0; i < sessions.size(); ++i) {
            int removedDocs = 0;
            try {
                removedDocs = indexReader.deleteDocuments(new Term("id", sessions.get(i)));
                if (removedDocs == 0) {
                    logger.warn((Object)("Index didn't contain IMDI file with id " + sessions.get(i)));
                }
            }
            catch (IOException e) {
                logger.error((Object)("Couldn't delete " + sessions.get(i)), (Throwable)e);
            }
            totalRemovedDocs += removedDocs;
        }
        logger.info((Object)("Deleted " + totalRemovedDocs + " IMDI files"));
        logger.info((Object)("Index contains now " + indexReader.numDocs() + " IMDI files"));
        logger.info((Object)"Closing");
        indexReader.close();
        logger.info((Object)("Deletion took " + (new Date().getTime() - start.getTime()) + " milliseconds"));
        logger.info((Object)("Date of Index Dir : " + new Date(new File(indexDir).lastModified())));
    }

    public static boolean testWriteAccess(String fileName) throws IOException {
        File tmpFile = new File(fileName);
        tmpFile.createNewFile();
        if (!tmpFile.canWrite()) {
            throw new IOException("No write access to directory " + fileName);
        }
        if (tmpFile.isDirectory()) {
            String[] files = tmpFile.list();
            for (int i = 0; i < files.length; ++i) {
                if (new File(tmpFile, files[i]).delete()) continue;
                throw new IOException("Cannot delete file " + files[i]);
            }
        }
        if (!tmpFile.delete()) {
            throw new IOException("Cannot delete temporary directory " + fileName);
        }
        return true;
    }

    public static void updateIndex(String nodeId, String indexDir, CorpusStructureDBImpl db) throws Exception {
        MDIndexer.updateIndex(nodeId, indexDir, db, null);
    }

    public static void updateIndex(String nodeId, String indexDir, CorpusStructureDBImpl db, ProgressMonitor progressMonitor) throws Exception {
        if (IndexReader.indexExists((String)indexDir)) {
            MDIndexer.removeFromIndex(nodeId, indexDir, db);
            MDIndexer.addToIndex(nodeId, indexDir, db, progressMonitor);
        } else {
            logger.warn((Object)"Update called, yet no index exists!");
            MDIndexer.makeIndex(nodeId, indexDir, db);
        }
    }

    private static List getAsNodes(CorpusStructureDBImpl corpusStructureDB, List sessions) {
        ArrayList<Node> nodeList = new ArrayList<Node>();
        urlTable.clear();
        for (int i = 0; i < sessions.size(); ++i) {
            Node node = corpusStructureDB.getNode((String)sessions.get(i));
            if (node != null) {
                URL url = corpusStructureDB.getObjectURL((String)sessions.get(i), ArchiveAccessContext.getFileUrlContext()).toURL();
                if (url != null) {
                    nodeList.add(node);
                    urlTable.put(node, url);
                    continue;
                }
                logger.error((Object)("Couldn't get url of imdi-file for node " + node.getNodeId()));
                continue;
            }
            logger.error((Object)("No node found for id " + sessions.get(i)));
        }
        return nodeList;
    }

    private static XMLReader createXMLReader() throws FactoryConfigurationError {
        XMLReader xmlReader = null;
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
        }
        catch (Exception e) {
            logger.error((Object)("error in setting up parser " + e));
        }
        return xmlReader;
    }

    private static void indexFile(IndexWriter writer, URL url) throws IOException {
        try {
            if (url.getFile().toLowerCase().endsWith(".imdi")) {
                Document document = new Document();
                document.add(new Field("url", url.toString(), Field.Store.YES, Field.Index.NO));
                MDIndexer.parseIMDIFile(url, document);
                writer.addDocument(document);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private static void indexFiles(IndexWriter writer, File file) throws IOException {
        block3: {
            block4: {
                if (!file.canRead()) break block3;
                if (!file.isDirectory()) break block4;
                String[] files = file.list();
                if (files == null) break block3;
                for (int i = 0; i < files.length; ++i) {
                    MDIndexer.indexFiles(writer, new File(file, files[i]));
                }
                break block3;
            }
            URL url = null;
            try {
                url = new URL("file://" + file);
                MDIndexer.indexFile(writer, url);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean indexNode(IndexWriter writer, Node node) throws IOException {
        boolean parsingOK = false;
        Document document = new Document();
        document.add(new Field("id", node.getNodeId(), Field.Store.YES, Field.Index.UN_TOKENIZED));
        parsingOK = MDIndexer.parseIMDIFile((URL)urlTable.get(node), document);
        if (parsingOK) {
            writer.addDocument(document);
        }
        return parsingOK;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static synchronized void makeIndex(String rootNodeId, String indexDir, CorpusStructureDBImpl corpusStructureDB, ProgressMonitor progressMonitor, boolean create) throws Exception {
        IndexWriter writer;
        Date start;
        String tempIndexDir;
        boolean indexExisted;
        block23: {
            block22: {
                indexExisted = IndexReader.indexExists((String)indexDir);
                tempIndexDir = indexDir + (create && indexExisted ? tmp : "");
                start = new Date();
                logger.info((Object)("Opening index in directory: " + tempIndexDir));
                if (create) {
                    MDIndexer.testWriteAccess(tempIndexDir);
                }
                if (new File(tempIndexDir).exists() && IndexReader.isLocked((String)tempIndexDir)) {
                    throw new Exception("Indexer is already busy.");
                }
                writer = new IndexWriter(tempIndexDir, (Analyzer)new MDAnalyzer(), create);
                try {
                    try {
                        if (corpusStructureDB == null || !corpusStructureDB.getStatus()) {
                            logger.error((Object)"failed connecting to CorpusStructureDB ");
                            Object var14_9 = null;
                            break block22;
                        }
                        if (rootNodeId == null) {
                            rootNodeId = corpusStructureDB.getRootNodeId();
                        }
                        logger.info((Object)("Collecting sessions/catalogues beneath node with id " + rootNodeId));
                        List<String> nodeIds = Arrays.asList(corpusStructureDB.getSessionsAndCatalogues(rootNodeId));
                        if (nodeIds.size() == 0) {
                            throw new Exception("No descendant sessions/catalogues");
                        }
                        logger.info((Object)"Getting node info for each session/catalogue (URL, description, etc)");
                        List nodes = MDIndexer.getAsNodes(corpusStructureDB, nodeIds);
                        logger.info((Object)("Indexing " + nodes.size() + " imdi files"));
                        int indexedNodes = 0;
                        for (int i = 0; i < nodes.size(); ++i) {
                            if (progressMonitor != null) {
                                if (progressMonitor.isCanceled()) {
                                    writer.close();
                                    throw new Exception("Fulltext indexing hasn't been completed. Files will be missing in index.");
                                }
                                progressMonitor.setNote("Indexing IMDI session file " + i);
                            }
                            if (MDIndexer.indexNode(writer, (Node)nodes.get(i))) {
                                ++indexedNodes;
                            }
                            if (progressMonitor == null) continue;
                            progressMonitor.setProgress(i * 100 / nodes.size());
                        }
                        logger.info((Object)("Added " + indexedNodes + " imdi files"));
                        logger.info((Object)("Ignored " + (nodes.size() - indexedNodes) + " imdi files"));
                        logger.info((Object)"Optimize index");
                        writer.optimize();
                        break block23;
                    }
                    catch (Exception e) {
                        logger.error((Object)("Couldn't create/update index: " + e.getMessage()), (Throwable)e);
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var14_11 = null;
                    logger.info((Object)"Closing");
                    writer.close();
                    throw throwable;
                }
            }
            logger.info((Object)"Closing");
            writer.close();
            return;
        }
        Object var14_10 = null;
        logger.info((Object)"Closing");
        writer.close();
        if (create && indexExisted) {
            File oldIndex = new File(indexDir);
            logger.info((Object)("Deleting " + oldIndex.getCanonicalPath()));
            if (oldIndex.isDirectory()) {
                String[] files = oldIndex.list();
                for (int i = 0; i < files.length; ++i) {
                    if (new File(oldIndex, files[i]).delete()) continue;
                    logger.info((Object)("Error: couldn't delete " + files[i]));
                }
            }
            if (!oldIndex.delete()) {
                logger.info((Object)"Error: couldn't delete file");
            }
            File tempIndex = new File(tempIndexDir);
            logger.info((Object)("Renaming " + tempIndex.getCanonicalPath() + " to " + oldIndex.getCanonicalPath()));
            if (!tempIndex.renameTo(oldIndex)) {
                logger.info((Object)"Error: couldn't rename file");
            }
        }
        String creationDateString = corpusStructureDB.getAdminKey("CREATION_DATE");
        File dateFile = new File(indexDir, "databasecreationdate");
        if (creationDateString != null) {
            logger.info((Object)("Saving data base creation time into file " + dateFile));
            FileWriter fw = new FileWriter(dateFile);
            fw.write(creationDateString);
            fw.close();
        } else {
            try {
                logger.info((Object)"No creation date in DB found.");
                dateFile.delete();
            }
            catch (Exception e) {
                logger.info((Object)("Warning: Cannot remove date file - " + e.getMessage()));
            }
        }
        logger.info((Object)("Adding took " + (new Date().getTime() - start.getTime()) + " milliseconds"));
        logger.info((Object)("Date of Index Dir : " + new Date(IndexReader.lastModified((String)indexDir))));
    }

    private static boolean parseIMDIFile(URL url, Document document) {
        if (xmlReader == null) {
            xmlReader = MDIndexer.createXMLReader();
        }
        try {
            xmlReader.setContentHandler(new MDIndexerContentHandler(document));
            logger.debug((Object)("MDSearchConfig::read(): parsing file: " + url));
            xmlReader.parse(url.toString());
        }
        catch (SAXException se) {
            logger.error((Object)("SAX error parsing file : " + url + '\n' + se + '\n' + se.getMessage() + "\nIgnoring file"));
            return false;
        }
        catch (IOException ioe) {
            logger.error((Object)("io error parsing file : " + url + '\n' + ioe + "\nIgnoring file"));
            return false;
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return true;
    }
}

