/*
 * Decompiled with CFR 0.152.
 */
package mpi.metadata.search.index;

import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class MDIndexerContentHandler
extends DefaultHandler {
    private Document document;
    private Logger logger;
    private String _elementTextContent = "";

    MDIndexerContentHandler(Document document) {
        this.document = document;
        this.logger = Logger.getLogger(MDIndexerContentHandler.class);
    }

    public void startDocument() throws SAXException {
        this._elementTextContent = "";
    }

    public void characters(char[] ch, int start, int end) {
        this._elementTextContent = this._elementTextContent + new String(ch, start, end);
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (localName.equals("METATRANSCRIPT") || localName.equals("History")) {
            this._elementTextContent = "";
        } else if (!this.getTextContent().equals("")) {
            this.document.add(new Field("content", this.getTextContent(), Field.Store.NO, Field.Index.TOKENIZED));
            this._elementTextContent = "";
        }
    }

    public void ignorableWhitespace(char[] c, int start, int length) throws SAXException {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String _type;
        if (localName.equals("METATRANSCRIPT") && !(_type = atts.getValue("Type")).equals("SESSION") && !_type.equals("CATALOGUE")) {
            this.logger.error((Object)("MDSearchConfig: configuration file  is not of type SESSION/CATALOGUE but " + _type));
            throw new SAXException("configuration file not of type SESSION/CATALOGUE");
        }
    }

    protected String getTextContent() {
        return this._elementTextContent.trim();
    }
}

