/*
 * Decompiled with CFR 0.152.
 */
package mpi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class OurURL {
    private URL url;
    private String urlToString;

    public OurURL(URL url) throws MalformedURLException {
        this.url = new URL(url.getProtocol(), url.getHost(), url.getPort(), OurURL.absDevLet(url.getFile()).replace('\\', '/'));
    }

    public OurURL(String spec) throws MalformedURLException {
        spec = spec.replace('\\', '/');
        if (spec.startsWith("file:")) {
            this.url = new URL("file", "", -1, OurURL.absDevLet(spec.substring(5)));
        } else {
            this.url = new URL(OurURL.encode(spec));
        }
    }

    public OurURL(String protocol, String host, int port, String file) throws MalformedURLException {
        file = file.replace('\\', '/');
        file = OurURL.absDevLet(file);
        if ("http".equals(protocol)) {
            file = OurURL.encode(file);
        }
        this.url = new URL(protocol, host, port, file);
    }

    public OurURL(String protocol, String host, int port, String file, URLStreamHandler handler) throws MalformedURLException {
        file = file.replace('\\', '/');
        file = OurURL.absDevLet(file);
        if ("http".equals(protocol)) {
            file = OurURL.encode(file);
        }
        this.url = new URL(protocol, host, port, file, handler);
    }

    public OurURL(String protocol, String host, String file) throws MalformedURLException {
        file = file.replace('\\', '/');
        file = OurURL.absDevLet(file);
        if ("http".equals(protocol)) {
            file = OurURL.encode(file);
        }
        this.url = new URL(protocol, host, file);
    }

    public OurURL(URL context, String spec) throws MalformedURLException {
        if (context != null) {
            spec = OurURL.encode(spec.replace('\\', '/'));
            this.url = new URL(context, OurURL.absDevLet(spec));
        } else {
            this.url = new OurURL(spec).toURL();
        }
    }

    public OurURL(OurURL context, String spec) throws MalformedURLException {
        if (context != null) {
            spec = OurURL.encode(spec.replace('\\', '/'));
            this.url = new URL(context.toURL(), OurURL.absDevLet(spec));
        } else {
            this.url = new OurURL(spec).toURL();
        }
    }

    public URL toURL() {
        return this.url;
    }

    public String getProtocol() {
        return this.url.getProtocol();
    }

    public int getPort() {
        return this.url.getPort();
    }

    public String getPath() {
        String path = this.url.getPath();
        if (path.length() > 1 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            return path.substring(1);
        }
        return path;
    }

    public String getHost() {
        return this.url.getHost();
    }

    public String getFile() {
        String path = this.url.getPath();
        if (path.length() > 1 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            return path.substring(1);
        }
        return path;
    }

    public boolean sameFile(OurURL url) {
        return this.url.sameFile(url.toURL());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OurURL)) {
            return false;
        }
        return this.url.equals(((OurURL)obj).toURL());
    }

    public Object getContent() throws IOException {
        return this.url.getContent();
    }

    public Object getContent(Class[] classes) throws IOException {
        return this.url.getContent(classes);
    }

    public String getAuthority() {
        return this.url.getAuthority();
    }

    public URLConnection openConnection() throws IOException {
        return this.url.openConnection();
    }

    public InputStream openStream() throws IOException {
        return this.url.openStream();
    }

    public String toString() {
        return OurURL.decode(this.url.toString());
    }

    public String toEncodedString() {
        return this.url.toString();
    }

    public String toDecodedString() {
        return this.toString();
    }

    private static String absDevLet(String s) {
        if (s != null && s.length() > 2 && s.charAt(1) == ':') {
            s = "/" + s;
        }
        if (s.startsWith("file:") && s.length() > 6 && s.charAt(6) == ':') {
            s = "file:/" + s.substring(5);
        }
        return s;
    }

    private static String encode(String s) {
        String r = null;
        r = s.replaceAll(" ", "%20");
        return r;
    }

    private static String decode(String s) {
        String r = null;
        r = s.replaceAll("%20", " ");
        return r;
    }
}

