/*
 * Decompiled with CFR 0.152.
 */
package mpi.imdi.api;

import java.io.File;
import java.util.Vector;
import mpi.imdi.api.IMDIAPIImpl;
import mpi.imdi.api.IMDILink;
import mpi.util.OurURL;

public class TestIMDIAPI {
    private static final String homeDirectory = "/home/broeder/";
    private static final String testDirectory = "/home/broeder/test/imdi_api/";
    private static final String resourceDirectory = "/home/broeder/LAPP/MPI/webapps/lams/src/lams/imdiapi/resources/";
    private static final boolean testChangeWRLinkURL = false;
    private static final boolean testChangeWRLinkSpec = false;
    private static final boolean testRemoveLink = false;
    private static final boolean testBatch = false;

    public static void main(String[] args) {
        boolean invalid = false;
        boolean filecount = false;
        IMDIAPIImpl[] ics = new IMDIAPIImpl[2];
        try {
            ics[0] = new IMDIAPIImpl(null);
            ics[1] = new IMDIAPIImpl(new File("/tmp"));
        }
        catch (Exception e) {
            System.err.println("Error creating IMDIAPIImpl: " + e);
            System.exit(0);
        }
        for (int k = 0; k < 2; ++k) {
            IMDIAPIImpl ic = ics[k];
            Vector invalidFiles = new Vector();
            try {
                int i;
                OurURL testDirURL = new OurURL("file:/home/broeder/test/imdi_api/");
                OurURL mfresource = new OurURL(testDirURL, "MediaFile.mpg");
                OurURL wrresource = new OurURL(testDirURL, "WrittenResource.txt");
                OurURL clresource = new OurURL(testDirURL, "CorpusLink.imdi");
                OurURL ifresource = new OurURL(testDirURL, "InfoFile.txt");
                OurURL mfchanged = new OurURL(testDirURL, "MediaFileCHANGED.mpg");
                OurURL wrchanged = new OurURL(testDirURL, "WrittenResourceCHANGED.txt");
                OurURL clchanged = new OurURL(testDirURL, "CorpusLinkCHANGED.imdi");
                OurURL ifchanged = new OurURL(testDirURL, "InfoFileCHANGED.txt");
                OurURL mffinal = new OurURL(testDirURL, "MediaFileFINAL.mpg");
                OurURL wrfinal = new OurURL(testDirURL, "WrittenResourceFINAL.txt");
                OurURL clfinal = new OurURL(testDirURL, "CorpusLinkFINAL.imdi");
                OurURL iffinal = new OurURL(testDirURL, "InfoFileFINAL.txt");
                OurURL u1 = new OurURL(testDirURL, "route.imdi");
                OurURL u2 = new OurURL(testDirURL, "pewi.imdi");
                OurURL u3 = new OurURL(testDirURL, "remcoSession.imdi");
                OurURL u4 = new OurURL(testDirURL, "remcoCorpus.imdi");
                OurURL u5 = new OurURL(testDirURL, "remcoERROR.imdi");
                OurURL u6 = new OurURL(testDirURL, "MPI.imdi");
                OurURL u7 = new OurURL(testDirURL, "SESSION_ERROR_birthdate_missing.imdi");
                OurURL sessionProfile = new OurURL("file:/home/broeder/LAPP/MPI/webapps/lams/src/lams/imdiapi/resources/SESSION.LAMS.Profile.xml");
                OurURL corpusProfile = new OurURL("file:/home/broeder/LAPP/MPI/webapps/lams/src/lams/imdiapi/resources/CORPUS.LAMS.Profile.xml");
                OurURL styleSheet = new OurURL("file:/home/broeder/LAPP/MPI/webapps/lams/src/lams/imdiapi/resources/IMDI_3_0_REPAIR1.xsl");
                if (ic.openIMDIFile(13, u1) && ic.openIMDIFile(13, u2)) {
                    System.out.println("Opened " + u1.getPath() + ", " + u2.getPath());
                } else {
                    System.out.println("Error opening IMDI files " + u1.getPath() + ", " + u2.getPath());
                }
                if (ic.applyStyleSheet(13, u7, styleSheet)) {
                    System.out.println("Application of xsl to " + u7.toString() + " successfull");
                } else {
                    System.out.println("Application of xsl to " + u7.toString() + " failed");
                }
                if (ic.createIMDIFile(14, u3, 1) && ic.createIMDIFile(14, u4, 2)) {
                    System.out.println("Created\n\t" + u3.getPath() + " and\n\t" + u4.getPath());
                } else {
                    System.out.println("Problem creating\n\t " + u3.getPath() + " and/or\n\t" + u4.getPath());
                }
                if (ic.isIMDIFileType(14, u3, 1)) {
                    System.out.println(u3.getPath() + " is a SESSION file.");
                } else {
                    System.out.println(u3.getPath() + " is not a SESSION file.");
                }
                if (ic.isIMDIFileType(14, u4, 1)) {
                    System.out.println(u4.getPath() + " is a SESSION file.");
                } else {
                    System.out.println(u4.getPath() + " is not a SESSION file.");
                }
                if (ic.createIMDILink(14, u3, mfresource.toString(), "", 5, "") != null) {
                    System.out.println("Linked a MEDIAFILE: " + mfresource);
                } else {
                    System.out.println("Problem linking MEDIAFILE: " + mfresource);
                }
                if (ic.createIMDILink(14, u3, wrresource.toString(), "", 4, "") != null) {
                    System.out.println("Linked a WRITTENRESOURCE: " + wrresource);
                } else {
                    System.out.println("Problem linking WRITTENRESOURCE: " + wrresource);
                }
                if (ic.createIMDILink(14, u4, clresource.toString(), "CORPUSLINK", 2, "") != null) {
                    System.out.println("Linked a SESSION TO A CORPUS: " + clresource);
                } else {
                    System.out.println("Problem linking SESSION TO A CORPUS: " + clresource);
                }
                if (ic.createIMDILink(14, u4, ifresource.toString(), "INFOFILE IN CORPUS", 3, "Corpus") != null) {
                    System.out.println("Linked an INFO FILE in Corpus: " + ifresource);
                } else {
                    System.out.println("Problem linking INFO FILE in Corpus: " + ifresource);
                }
                if (ic.createIMDILink(14, u3, ifresource.toString(), "INFOFILE IN SESSION", 3, "Session.Content.Languages.Language(1)") != null) {
                    System.out.println("Linked an INFO FILE in Session.Content.Languages.Language(1): " + ifresource);
                } else {
                    System.out.println("Problem linking INFO FILE in Session.Content.Languages.Language(1): " + ifresource);
                }
                if (ic.setIMDIValue(14, u3, "Session.Title", "SESSION TITLE")) {
                    System.out.println("Session's Title: " + ic.getIMDIElement(14, u3, "Session.Title"));
                } else {
                    System.out.println("Problem setting Session's Title: " + ic.getIMDIElement(14, u3, "Session.Title"));
                }
                if (ic.setIMDIValue(14, u3, "Session.Actor(1).FullName", "ACTOR FULLNAME")) {
                    System.out.println("1st Actor's Name: " + ic.getIMDIElement(14, u3, "Session.Actor(1).FullName"));
                } else {
                    System.out.println("Problem setting 1st Actor's Name");
                }
                if (ic.setIMDIValue(14, u3, "Session.Actor(1).Description(1).LanguageId", "RFC1766:x-sil-DUT")) {
                    System.out.println("Set the 1st Actor's Description LanguageId: " + ic.getIMDIElement(14, u3, "Session.Actor(1).Description(1).LanguageId"));
                } else {
                    System.out.println("Problem setting 1st Actor's Description LanguageId.");
                }
                IMDILink[] links = ic.getIMDILinks(14, u3, 6);
                for (i = 0; i < links.length; ++i) {
                    System.out.println("Link (in " + u3.getPath() + ") " + i + ": " + links[i].getURL().toString() + " at spec " + links[i].getSpec() + " (nodeType: " + links[i].getNodeType() + ")");
                }
                links = ic.getIMDILinks(14, u4, 6);
                for (i = 0; i < links.length; ++i) {
                    System.out.println("Link (in " + u4.getPath() + ") " + i + ": " + links[i].getURL().toString() + " at spec " + links[i].getSpec() + " (nodeType: " + links[i].getNodeType() + ")");
                }
                links = ic.getIMDILinks(14, u3, 6);
                for (i = 0; i < links.length; ++i) {
                    System.out.println("Link (in " + u3.getPath() + ") " + i + ": " + links[i].getURL().toString() + " at spec " + links[i].getSpec() + " (nodeType: " + links[i].getNodeType() + ")");
                }
                links = ic.getIMDILinks(14, u4, 6);
                for (i = 0; i < links.length; ++i) {
                    System.out.println("Link (in " + u4.getPath() + ") " + i + ": " + links[i].getURL().toString() + " at spec " + links[i].getSpec() + " (nodeType: " + links[i].getNodeType() + ")");
                }
                if (ic.saveIMDIFile(14, u3) && ic.saveIMDIFile(14, u4)) {
                    System.out.println("Saved " + u3.getPath() + " and " + u4.getPath());
                } else {
                    System.out.println("Error saving " + u3.getPath() + " and " + u4.getPath());
                }
                if (ic.isValidIMDIFile(14, u3) && ic.isValidIMDIFile(14, u4)) {
                    System.out.println(u3.getPath() + " and " + u4.getPath() + " are valid IMDI files.");
                } else {
                    System.out.println(u3.getPath() + " and/or " + u4.getPath() + " is an invalid IMDI file.");
                }
                if (ic.isValidIMDIFile(14, sessionProfile) && ic.isValidIMDIFile(14, corpusProfile)) {
                    System.out.println(sessionProfile.getPath() + " and " + corpusProfile.getPath() + " are valid IMDI files.");
                } else {
                    System.out.println(sessionProfile.getPath() + " and/or " + corpusProfile.getPath() + " is an invalid IMDI file.");
                }
                if (ic.closeIMDIFiles(13, true, true)) {
                    System.out.println("Closed IMDI files in workSpace 13.");
                } else {
                    System.out.println("Problem closing IMDI files in workSpace 13.");
                }
                if (ic.closeAllIMDIFiles(true, true)) {
                    System.out.println("Closed ALL IMDI files.");
                } else {
                    System.out.println("Problem closing ALL IMDI files.");
                }
                System.out.println("--- End of tests ---");
                continue;
            }
            catch (Exception e) {
                System.out.println("Exception");
                e.printStackTrace();
            }
        }
    }
}

