/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Component;
import java.awt.Desktop;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.table.AbstractTableModel;
import nl.mpi.arbil.ArbilDragDrop;
import nl.mpi.arbil.ImdiFieldViews;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.ImdiToHtmlConverter;
import nl.mpi.arbil.LinorgBugCatcher;
import nl.mpi.arbil.LinorgFavourites;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.data.ImdiTreeObject;

public class GuiHelper {
    static ArbilDragDrop arbilDragDrop = new ArbilDragDrop();
    public static LinorgBugCatcher linorgBugCatcher = new LinorgBugCatcher();
    static ClipboardOwner clipboardOwner = new ClipboardOwner(){

        public void lostOwnership(Clipboard clipboard, Transferable contents) {
            System.out.println("lost clipboard ownership");
        }
    };
    private static GuiHelper singleInstance = null;

    public static synchronized GuiHelper getSingleInstance() {
        System.out.println("GuiHelper getSingleInstance");
        if (singleInstance == null) {
            singleInstance = new GuiHelper();
        }
        return singleInstance;
    }

    private GuiHelper() {
        LinorgFavourites.getSingleInstance();
    }

    public void saveState(boolean saveWindows) {
        ImdiFieldViews.getSingleInstance().saveViewsToFile();
        if (saveWindows) {
            LinorgWindowManager.getSingleInstance().saveWindowStates();
        }
    }

    public void initViewMenu(JMenu viewMenu) {
        viewMenu.removeAll();
        ButtonGroup viewMenuButtonGroup = new ButtonGroup();
        Enumeration menuItemName = ImdiFieldViews.getSingleInstance().getSavedFieldViewLables();
        while (menuItemName.hasMoreElements()) {
            String currentMenuName = menuItemName.nextElement().toString();
            JRadioButtonMenuItem viewLabelRadioButtonMenuItem = new JRadioButtonMenuItem();
            viewMenuButtonGroup.add(viewLabelRadioButtonMenuItem);
            viewLabelRadioButtonMenuItem.setSelected(ImdiFieldViews.getSingleInstance().getCurrentGlobalViewName().equals(currentMenuName));
            viewLabelRadioButtonMenuItem.setText(currentMenuName);
            viewLabelRadioButtonMenuItem.setName(currentMenuName);
            viewLabelRadioButtonMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        ImdiFieldViews.getSingleInstance().setCurrentGlobalViewName(((Component)evt.getSource()).getName());
                    }
                    catch (Exception ex) {
                        linorgBugCatcher.logError(ex);
                    }
                }
            });
            viewMenu.add(viewLabelRadioButtonMenuItem);
        }
    }

    public void openImdiXmlWindow(Object userObject, boolean formatXml, boolean launchInBrowser) {
        block11: {
            if (userObject instanceof ImdiTreeObject) {
                if (((ImdiTreeObject)userObject).getNeedsSaveToDisk()) {
                    if (0 == JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "The node must be saved first.\nSave now?", "View IMDI XML", 2, -1)) {
                        ((ImdiTreeObject)userObject).saveChangesToCache(true);
                    } else {
                        return;
                    }
                }
                URI nodeUri = ((ImdiTreeObject)userObject).getURI();
                System.out.println("openImdiXmlWindow: " + nodeUri);
                String nodeName = ((ImdiTreeObject)userObject).toString();
                if (formatXml) {
                    try {
                        File tempHtmlFile = new ImdiToHtmlConverter().convertToHtml((ImdiTreeObject)userObject);
                        if (!launchInBrowser) {
                            LinorgWindowManager.getSingleInstance().openUrlWindowOnce(nodeName + " formatted", tempHtmlFile.toURL());
                            break block11;
                        }
                        this.openFileInExternalApplication(tempHtmlFile.toURI());
                    }
                    catch (Exception ex) {
                        linorgBugCatcher.logError(ex);
                    }
                } else {
                    try {
                        LinorgWindowManager.getSingleInstance().openUrlWindowOnce(nodeName + "-xml", nodeUri.toURL());
                    }
                    catch (Exception ex) {
                        linorgBugCatcher.logError(ex);
                    }
                }
            }
        }
    }

    public AbstractTableModel getImdiTableModel(Hashtable rowNodes) {
        ImdiTableModel searchTableModel = new ImdiTableModel();
        searchTableModel.setShowIcons(true);
        searchTableModel.addImdiObjects(rowNodes.elements());
        return searchTableModel;
    }

    public AbstractTableModel getImdiTableModel() {
        ImdiTableModel tempModel = new ImdiTableModel();
        tempModel.setShowIcons(true);
        return tempModel;
    }

    public boolean openFileInExternalApplication(URI targetUri) {
        boolean result = false;
        boolean awtDesktopFound = false;
        try {
            Class.forName("java.awt.Desktop");
            awtDesktopFound = true;
        }
        catch (ClassNotFoundException cnfE) {
            awtDesktopFound = false;
            System.out.println("java.awt.Desktop class not found");
        }
        if (awtDesktopFound) {
            try {
                if (targetUri.getScheme().toLowerCase().equals("file")) {
                    File targetFile = new File(targetUri);
                    targetFile = new File(URLDecoder.decode(targetFile.getAbsolutePath(), "UTF-8"));
                    Desktop.getDesktop().open(targetFile);
                } else {
                    Desktop.getDesktop().browse(targetUri);
                }
                result = true;
            }
            catch (MalformedURLException muE) {
                linorgBugCatcher.logError("awtDesktopFound", muE);
            }
            catch (IOException ioE) {
                linorgBugCatcher.logError("awtDesktopFound", ioE);
            }
        } else {
            String osNameString = null;
            try {
                osNameString = System.getProperty("os.name").toLowerCase();
                String fileString = ImdiTreeObject.isStringLocal(targetUri.getScheme()) ? new File(targetUri).getAbsolutePath() : targetUri.toString();
                Process launchedProcess = null;
                if (osNameString.indexOf("windows") != -1 || osNameString.indexOf("nt") != -1) {
                    launchedProcess = Runtime.getRuntime().exec(new String[]{"cmd", "/c", "start", fileString});
                }
                if (osNameString.equals("windows 95") || osNameString.equals("windows 98")) {
                    launchedProcess = Runtime.getRuntime().exec(new String[]{"command.com", "/C", "start", fileString});
                }
                if (osNameString.indexOf("mac") != -1) {
                    launchedProcess = Runtime.getRuntime().exec(new String[]{"open", fileString});
                }
                if (osNameString.indexOf("linux") != -1) {
                    launchedProcess = Runtime.getRuntime().exec(new String[]{"gnome-open", fileString});
                }
                if (launchedProcess != null) {
                    String line;
                    BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
                    while ((line = errorStreamReader.readLine()) != null) {
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue(line, "Open In External Application");
                        System.out.println("Launched process error stream: \"" + line + "\"");
                    }
                    result = true;
                }
            }
            catch (Exception e) {
                linorgBugCatcher.logError(osNameString, e);
            }
        }
        return result;
    }
}

