/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiIcons;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiTableCellRenderer
extends DefaultTableCellRenderer {
    Object cellObject;
    boolean isCellSelected = false;

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        this.isCellSelected = isSelected;
        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
    }

    public ImdiTableCellRenderer() {
    }

    public ImdiTableCellRenderer(Object cellObject) {
        this.setValue(cellObject);
    }

    protected void setValue(Object value) {
        this.cellObject = value;
        super.setValue(value);
        if (this.cellObject instanceof ImdiField[]) {
            int greyTone = 150;
            super.setForeground(new Color(greyTone, greyTone, greyTone));
        }
        if (!this.isCellSelected) {
            if (this.cellObject instanceof String && this.cellObject.equals("")) {
                super.setBackground(new Color(230, 230, 230));
            }
            if (this.cellObject instanceof ImdiField && ((ImdiField)this.cellObject).fieldNeedsSaveToDisk()) {
                super.setForeground(Color.blue);
            }
        }
    }

    public Icon getIcon() {
        if (this.cellObject instanceof ImdiTreeObject) {
            return ((ImdiTreeObject)this.cellObject).getIcon();
        }
        if (this.cellObject instanceof ImdiTreeObject[]) {
            return ImdiIcons.getSingleInstance().getIconForImdi((ImdiTreeObject[])this.cellObject);
        }
        if (this.cellObject instanceof ImdiField[]) {
            return null;
        }
        return null;
    }

    public String getText() {
        if (this.cellObject instanceof ImdiTreeObject) {
            return ((ImdiTreeObject)this.cellObject).toString();
        }
        if (this.cellObject instanceof ImdiTreeObject[]) {
            String cellText = "";
            Arrays.sort((ImdiTreeObject[])this.cellObject, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String value1 = o1.toString();
                    String value2 = o2.toString();
                    return value1.compareToIgnoreCase(value2);
                }
            });
            boolean hasAddedValues = false;
            for (ImdiTreeObject currentImdiTreeObject : (ImdiTreeObject[])this.cellObject) {
                cellText = cellText + "[" + currentImdiTreeObject.toString() + "],";
                hasAddedValues = true;
            }
            if (hasAddedValues) {
                cellText = cellText.substring(0, cellText.length() - 1);
            }
            return cellText;
        }
        if (this.cellObject instanceof ImdiField[]) {
            return "<multiple values>";
        }
        if (this.cellObject instanceof ImdiField && ((ImdiField)this.cellObject).isRequiredField() && ((ImdiField)this.cellObject).toString().length() == 0) {
            super.setForeground(Color.RED);
            return "<required field>";
        }
        if (this.cellObject instanceof ImdiField && !((ImdiField)this.cellObject).fieldValueValidates()) {
            super.setForeground(Color.RED);
            return super.getText();
        }
        return super.getText();
    }
}

