/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.imageio.ImageIO;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgVersion;
import nl.mpi.arbil.LinorgWindowManager;

public class LinorgBugCatcher {
    private int captureCount = 0;

    public LinorgBugCatcher() {
        File errorLogFile = new File(LinorgSessionStorage.getSingleInstance().storageDirectory, "linorgerror.log");
        if (errorLogFile.exists()) {
            errorLogFile.delete();
        }
        LinorgVersion linorgVersion = new LinorgVersion();
        String currentApplicationVersionMatch = "error-" + linorgVersion.currentMajor + "-" + linorgVersion.currentMinor + "-";
        String currentLogFileMatch = "error-" + linorgVersion.currentMajor + "-" + linorgVersion.currentMinor + "-" + linorgVersion.currentRevision + ".log";
        for (String currentFile : LinorgSessionStorage.getSingleInstance().storageDirectory.list()) {
            if (!currentFile.startsWith(currentApplicationVersionMatch)) continue;
            if (currentFile.startsWith(currentLogFileMatch)) {
                System.out.println("currentLogFileMatch: " + currentFile);
                continue;
            }
            System.out.println("deleting old log file: " + currentFile);
            new File(LinorgSessionStorage.getSingleInstance().storageDirectory, currentFile).delete();
        }
    }

    public File getLogFile() {
        LinorgVersion linorgVersion = new LinorgVersion();
        return new File(LinorgSessionStorage.getSingleInstance().storageDirectory, "error-" + linorgVersion.currentMajor + "-" + linorgVersion.currentMinor + "-" + linorgVersion.currentRevision + ".log");
    }

    public void grabApplicationShot() {
        try {
            Robot robot = new Robot();
            BufferedImage screenShot = robot.createScreenCapture(LinorgWindowManager.getSingleInstance().linorgFrame.getBounds());
            DecimalFormat myFormat = new DecimalFormat("000");
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
            String formattedDate = formatter.format(new Date());
            String formattedCount = myFormat.format(new Integer(this.captureCount));
            ImageIO.write((RenderedImage)screenShot, "JPG", new File(LinorgSessionStorage.getSingleInstance().storageDirectory, "screenshots" + File.separatorChar + formattedDate + "-" + formattedCount + ".jpg"));
            ++this.captureCount;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void logError(Exception exception) {
        this.logError("", exception);
    }

    public void logError(String messageString, Exception exception) {
        try {
            StackTraceElement[] stackTraceElements;
            LinorgVersion linorgVersion = new LinorgVersion();
            System.err.println("exception: " + exception.getMessage());
            System.err.println(messageString);
            exception.printStackTrace();
            FileWriter errorLogFile = new FileWriter(this.getLogFile(), true);
            errorLogFile.append(messageString + System.getProperty("line.separator"));
            errorLogFile.append("Error Date: " + new Date().toString() + System.getProperty("line.separator"));
            errorLogFile.append("Compile Date: " + linorgVersion.compileDate + System.getProperty("line.separator"));
            errorLogFile.append("Current Revision: " + linorgVersion.currentMajor + "-" + linorgVersion.currentMinor + "-" + linorgVersion.currentRevision + System.getProperty("line.separator"));
            errorLogFile.append("Exception Message: " + exception.getMessage() + System.getProperty("line.separator"));
            for (StackTraceElement element : stackTraceElements = exception.getStackTrace()) {
                errorLogFile.append(element.toString() + System.getProperty("line.separator"));
            }
            errorLogFile.append("======================================================================" + System.getProperty("line.separator"));
            errorLogFile.close();
        }
        catch (Exception ex) {
            System.err.println("failed to write to the error log: " + ex.getMessage());
        }
    }
}

