/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;

public class LinorgJournal {
    private static LinorgJournal singleInstance = null;
    ArrayList<HistoryItem> fieldChangeHistory;
    int currentFieldChangeHistoryItem = 0;

    private LinorgJournal() {
    }

    public static synchronized LinorgJournal getSingleInstance() {
        System.out.println("LinorgJournal getSingleInstance");
        if (singleInstance == null) {
            singleInstance = new LinorgJournal();
        }
        return singleInstance;
    }

    public synchronized void recordFieldChange(ImdiField targetField, String oldValue, String newValue, UndoType undoType) {
        if (this.fieldChangeHistory == null) {
            this.fieldChangeHistory = new ArrayList();
            this.currentFieldChangeHistoryItem = 0;
        }
        if (this.currentFieldChangeHistoryItem < this.fieldChangeHistory.size()) {
            this.fieldChangeHistory = new ArrayList<HistoryItem>(this.fieldChangeHistory.subList(0, this.currentFieldChangeHistoryItem));
        }
        HistoryItem historyItem = new HistoryItem();
        historyItem.targetField = targetField;
        historyItem.oldValue = oldValue;
        historyItem.newValue = newValue;
        historyItem.undoType = undoType;
        this.fieldChangeHistory.add(historyItem);
        ++this.currentFieldChangeHistoryItem;
    }

    public boolean canUndo() {
        return this.currentFieldChangeHistoryItem > 0;
    }

    public boolean canRedo() {
        return this.fieldChangeHistory != null && this.currentFieldChangeHistoryItem < this.fieldChangeHistory.size();
    }

    public void undoFromFieldChangeHistory() {
        if (this.canUndo()) {
            HistoryItem changeHistoryItem = this.fieldChangeHistory.get(--this.currentFieldChangeHistoryItem);
            HistoryItem reversedHistoryItem = new HistoryItem();
            reversedHistoryItem.newValue = changeHistoryItem.oldValue;
            reversedHistoryItem.oldValue = changeHistoryItem.newValue;
            reversedHistoryItem.targetField = changeHistoryItem.targetField;
            reversedHistoryItem.undoType = changeHistoryItem.undoType;
            this.makeChangeFromHistoryItem(reversedHistoryItem);
        }
    }

    public void redoFromFieldChangeHistory() {
        if (this.canRedo()) {
            HistoryItem changeHistoryItem = this.fieldChangeHistory.get(this.currentFieldChangeHistoryItem++);
            this.makeChangeFromHistoryItem(changeHistoryItem);
        }
    }

    public void clearFieldChangeHistory() {
        this.fieldChangeHistory = null;
        this.currentFieldChangeHistoryItem = 0;
    }

    private void makeChangeFromHistoryItem(HistoryItem historyItem) {
        String currentValue = null;
        switch (historyItem.undoType) {
            case KeyName: {
                currentValue = historyItem.targetField.getKeyName();
                break;
            }
            case LanguageId: {
                currentValue = historyItem.targetField.getLanguageId();
                break;
            }
            case Value: {
                currentValue = historyItem.targetField.getFieldValue();
            }
        }
        if (currentValue != null && !currentValue.equals(historyItem.oldValue)) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The field value is out of sync with the history item", "Undo/Redo");
            GuiHelper.linorgBugCatcher.logError(new Exception("ChangeFromHistory old value does not match current value"));
        } else {
            switch (historyItem.undoType) {
                case KeyName: {
                    historyItem.targetField.setKeyName(historyItem.newValue, true, true);
                    break;
                }
                case LanguageId: {
                    historyItem.targetField.setLanguageId(historyItem.newValue, true, true);
                    break;
                }
                case Value: {
                    historyItem.targetField.setFieldValue(historyItem.newValue, true, true);
                }
            }
        }
    }

    public boolean saveJournalEntry(String imdiUrl, String imdiNodePath, String oldValue, String newValue, String eventType) {
        boolean returnValue = false;
        try {
            FileWriter journalFile = new FileWriter(new File(LinorgSessionStorage.getSingleInstance().storageDirectory, "linorgjornal.log"), true);
            System.out.println("Journal: " + imdiUrl + "," + imdiNodePath + "," + oldValue + "," + newValue);
            journalFile.append("\"" + imdiUrl + imdiNodePath + "\",\"" + oldValue + "\",\"" + newValue + "\",\"" + eventType + "\"\n");
            journalFile.close();
            returnValue = true;
        }
        catch (Exception ex) {
            returnValue = false;
            GuiHelper.linorgBugCatcher.logError(ex);
            System.err.println("failed to write to the journal: " + ex.getMessage());
        }
        return returnValue;
    }

    private class HistoryItem {
        ImdiField targetField;
        String oldValue;
        String newValue;
        UndoType undoType;

        private HistoryItem() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UndoType {
        Value,
        LanguageId,
        KeyName;

    }
}

