/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgVersion;
import nl.mpi.arbil.LinorgWindowManager;

public class LinorgVersionChecker {
    public boolean forceUpdateCheck() {
        LinorgVersion linorgVersion = new LinorgVersion();
        String currentVersionTxt = "arbil-" + linorgVersion.currentMajor + "-" + linorgVersion.currentMinor + "-current.txt";
        File cachePath = LinorgSessionStorage.getSingleInstance().getSaveLocation("http://www.mpi.nl/tg/j2se/jnlp/arbil/" + currentVersionTxt);
        cachePath.delete();
        return this.checkForUpdate();
    }

    private boolean isLatestVersion() {
        try {
            LinorgVersion linorgVersion = new LinorgVersion();
            int daysTillExpire = 1;
            String currentVersionTxt = "arbil-" + linorgVersion.currentMajor + "-" + linorgVersion.currentMinor + "-current.txt";
            File cachePath = LinorgSessionStorage.getSingleInstance().updateCache("http://www.mpi.nl/tg/j2se/jnlp/arbil/" + currentVersionTxt, daysTillExpire);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(cachePath));
            String serverVersionString = bufferedReader.readLine();
            System.out.println("currentRevision: " + linorgVersion.currentRevision);
            System.out.println("serverVersionString: " + serverVersionString);
            return linorgVersion.currentRevision.compareTo(serverVersionString) >= 0;
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
            return true;
        }
    }

    private boolean doUpdate(String webstartUrlString) {
        try {
            String line;
            Process launchedProcess = Runtime.getRuntime().exec(new String[]{"javaws", "-import", webstartUrlString});
            BufferedReader errorStreamReader = new BufferedReader(new InputStreamReader(launchedProcess.getErrorStream()));
            while ((line = errorStreamReader.readLine()) != null) {
                System.out.println("Launched process error stream: \"" + line + "\"");
            }
            return 0 == launchedProcess.waitFor();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void restartApplication(String webstartUrlString) {
        try {
            Process restartProcess = Runtime.getRuntime().exec(new String[]{"javaws", webstartUrlString});
            if (0 == restartProcess.waitFor()) {
                System.exit(0);
            } else {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("There was an error restarting the application.\nThe update will take effect next time the application is restarted.", null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean checkForUpdate() {
        if (!this.isLatestVersion()) {
            if (this.hasWebStartUrl()) {
                this.checkForAndUpdateViaJavaws();
            } else {
                new Thread("checkForUpdate"){

                    public void run() {
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("There is a new version available.\nPlease go to the website and update via the download link.", null);
                    }
                }.start();
            }
            return true;
        }
        return false;
    }

    public boolean hasWebStartUrl() {
        System.out.println("hasWebStartUrl");
        String webstartUpdateUrl = System.getProperty("nl.mpi.arbil.webstartUpdateUrl");
        System.out.println("webstartUpdateUrl: " + webstartUpdateUrl);
        return null != webstartUpdateUrl;
    }

    public void checkForAndUpdateViaJavaws() {
        new Thread("checkForAndUpdateViaJavaws"){

            public void run() {
                String webstartUrlString = System.getProperty("nl.mpi.arbil.webstartUpdateUrl");
                if (webstartUrlString != null && !LinorgVersionChecker.this.isLatestVersion()) {
                    switch (JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "There is a new version available\nDo you want to update now?", "Arbil", 1, -1)) {
                        case 1: {
                            break;
                        }
                        case 0: {
                            if (LinorgVersionChecker.this.doUpdate(webstartUrlString)) {
                                LinorgVersionChecker.this.restartApplication(webstartUrlString);
                                break;
                            }
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("There was an error updating the application.\nPlease go to the website and update via the download link.", null);
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                }
            }
        }.start();
    }
}

