/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.importexport;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Hashtable;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.data.MetadataBuilder;

public class ArbilCsvImporter {
    ImdiTreeObject destinationCorpusNode;

    public ArbilCsvImporter(ImdiTreeObject destinationCorpusNodeLocal) {
        this.destinationCorpusNode = destinationCorpusNodeLocal;
    }

    public void doImport() {
        File[] selectedFiles = LinorgWindowManager.getSingleInstance().showFileSelectBox("Import CSV", false, true, false);
        if (selectedFiles != null && selectedFiles.length > 0) {
            for (File currentFile : selectedFiles) {
                this.processCsvFile(currentFile);
            }
        }
    }

    private void cleanQuotes(String[] arrayToClean, String fileType) {
        if (arrayToClean.length > 0 && fileType.indexOf("\"") != -1) {
            arrayToClean[0] = arrayToClean[0].replaceAll("^\"", "");
            arrayToClean[arrayToClean.length - 1] = arrayToClean[arrayToClean.length - 1].replaceAll("\"$", "");
        }
    }

    private void processCsvFile(File inputFile) {
        String[] csvHeaders = null;
        String fileType = ",";
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(inputFile));
            String currentLine = "";
            String remainderOfLastLine = "";
            Object stringTokeniser = null;
            while ((currentLine = bufferedReader.readLine()) != null) {
                if (csvHeaders == null) {
                    fileType = "\"\\t\"";
                    csvHeaders = currentLine.split(fileType);
                    if (csvHeaders.length == 1) {
                        fileType = "\t";
                        csvHeaders = currentLine.split(fileType);
                    }
                    if (csvHeaders.length == 1) {
                        fileType = "\",\"";
                        csvHeaders = currentLine.split(fileType);
                    }
                    if (csvHeaders.length == 1) {
                        fileType = ",";
                        csvHeaders = currentLine.split(fileType);
                    }
                    this.cleanQuotes(csvHeaders, fileType);
                    continue;
                }
                boolean skipLine = false;
                if (fileType.contains("\"")) {
                    if (!currentLine.endsWith("\"")) {
                        remainderOfLastLine = remainderOfLastLine + "\n" + currentLine;
                        skipLine = true;
                    } else if (remainderOfLastLine.length() > 0) {
                        currentLine = remainderOfLastLine + "\n" + currentLine;
                        remainderOfLastLine = "";
                    }
                }
                if (skipLine) continue;
                String nodeType = ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Session";
                ImdiTreeObject addedImdiObject = ImdiLoader.getSingleInstance().getImdiObject(null, new MetadataBuilder().addChildNode(this.destinationCorpusNode, nodeType, null, null, null));
                addedImdiObject.waitTillLoaded();
                Hashtable<String, ImdiField[]> addedNodesFields = addedImdiObject.getFields();
                String[] currentLineArray = currentLine.split(fileType);
                this.cleanQuotes(currentLineArray, fileType);
                for (int columnCounter = 0; columnCounter < csvHeaders.length && columnCounter < currentLineArray.length; ++columnCounter) {
                    System.out.println(csvHeaders[columnCounter] + " : " + currentLineArray[columnCounter]);
                    ImdiField[] currentFieldArray = addedNodesFields.get(csvHeaders[columnCounter]);
                    if (currentFieldArray == null) continue;
                    currentFieldArray[0].setFieldValue(currentLineArray[columnCounter], false, true);
                }
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }
}

