/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiToHtmlConverter {
    public void exportImdiToHtml(ImdiTreeObject[] inputImdiArray) {
        File destinationDirectory = LinorgWindowManager.getSingleInstance().showEmptyExportDirectoryDialogue("Export HTML");
        if (destinationDirectory != null) {
            this.copyDependancies(destinationDirectory, false);
            for (ImdiTreeObject currentImdi : inputImdiArray) {
                File destinationFile = new File(destinationDirectory, currentImdi.toString() + ".html");
                int fileCounter = 1;
                while (destinationFile.exists()) {
                    destinationFile = new File(destinationDirectory, currentImdi.toString() + "(" + fileCounter + ").html");
                }
                try {
                    this.transformImdiToHtml(currentImdi, destinationFile);
                }
                catch (Exception exception) {
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot convert IMDI", "HTML Export");
                    GuiHelper.linorgBugCatcher.logError(exception);
                }
            }
        }
        GuiHelper.getSingleInstance().openFileInExternalApplication(destinationDirectory.toURI());
    }

    public File convertToHtml(ImdiTreeObject inputImdi) throws IOException, TransformerException {
        File tempHtmlFile = File.createTempFile("tmp", ".html");
        tempHtmlFile.deleteOnExit();
        this.copyDependancies(tempHtmlFile.getParentFile(), true);
        this.transformImdiToHtml(inputImdi, tempHtmlFile);
        return tempHtmlFile;
    }

    private void transformImdiToHtml(ImdiTreeObject inputImdi, File destinationFile) throws IOException, TransformerException {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        URL xslUrl = this.getClass().getResource("/nl/mpi/arbil/resources/xsl/imdi-viewer.xsl");
        File xslFile = null;
        xslFile = new File(inputImdi.getNodeTemplate().getTemplateDirectory(), "format.xsl");
        if (xslFile != null && xslFile.exists()) {
            xslUrl = xslFile.toURL();
        }
        Transformer transformer = tFactory.newTransformer(new StreamSource(xslUrl.toString()));
        transformer.transform(new StreamSource(inputImdi.getURI().toString()), new StreamResult(new FileOutputStream(destinationFile.getCanonicalPath())));
    }

    private void copyDependancies(File destinationDirectory, boolean deleteOnExit) {
        String[] dependentFiles;
        for (String dependantFileString : dependentFiles = new String[]{"imdi-viewer-open.gif", "imdi-viewer-closed.gif", "imdi-viewer.js", "additTooltip.js", "additPopup.js", "imdi-viewer.css", "additTooltip.css"}) {
            File tempDependantFile = new File(destinationDirectory, dependantFileString);
            if (deleteOnExit) {
                tempDependantFile.deleteOnExit();
            }
            try {
                FileOutputStream outFile = new FileOutputStream(tempDependantFile);
                InputStream inputStream = this.getClass().getResourceAsStream("/nl/mpi/arbil/resources/xsl/" + dependantFileString);
                int bufferLength = 4096;
                byte[] buffer = new byte[bufferLength];
                int bytesread = 0;
                while (bytesread >= 0 && (bytesread = inputStream.read(buffer)) != -1) {
                    outFile.write(buffer, 0, bytesread);
                }
                outFile.close();
            }
            catch (IOException iOException) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot copy requisite file", "HTML Export");
                GuiHelper.linorgBugCatcher.logError(iOException);
            }
        }
    }
}

