/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import nl.mpi.arbil.ArbilMenuBar;
import nl.mpi.arbil.ArbilTreePanels;
import nl.mpi.arbil.ImdiIcons;
import nl.mpi.arbil.LinorgBugCatcher;
import nl.mpi.arbil.LinorgVersion;
import nl.mpi.arbil.LinorgVersionChecker;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.PreviewSplitPanel;

public class LinorgFrame
extends JFrame {
    private JSplitPane mainSplitPane;
    private ArbilMenuBar arbilMenuBar;

    public LinorgFrame() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LinorgFrame.this.arbilMenuBar.performCleanExit();
            }
        });
        this.initComponents();
        PreviewSplitPanel previewSplitPanel = new PreviewSplitPanel();
        this.mainSplitPane.setRightComponent(previewSplitPanel);
        ArbilTreePanels arbilTreePanels = new ArbilTreePanels();
        this.mainSplitPane.setLeftComponent(arbilTreePanels);
        this.arbilMenuBar = new ArbilMenuBar(previewSplitPanel);
        this.setJMenuBar(this.arbilMenuBar);
        this.mainSplitPane.setDividerLocation(0.25);
        LinorgWindowManager.getSingleInstance().loadGuiState(this);
        this.setTitle(new LinorgVersion().applicationTitle + " " + new LinorgVersion().compileDate);
        this.setIconImage(ImdiIcons.getSingleInstance().linorgIcon.getImage());
        this.setVisible(true);
        LinorgWindowManager.getSingleInstance().openIntroductionPage();
        if (this.arbilMenuBar.checkNewVersionAtStartCheckBoxMenuItem.isSelected()) {
            new LinorgVersionChecker().checkForUpdate();
        }
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.setDefaultCloseOperation(0);
        this.setTitle("Arbil");
        this.mainSplitPane.setDividerLocation(100);
        this.mainSplitPane.setDividerSize(5);
        this.mainSplitPane.setName("mainSplitPane");
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.pack();
    }

    public static void main(String[] args) {
        System.setProperty("sun.swing.enableImprovedDragGesture", "true");
        System.setProperty("apple.awt.graphics.UseQuartz", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                try {
                    new LinorgFrame();
                }
                catch (Exception ex) {
                    new LinorgBugCatcher().logError(ex);
                }
            }
        });
    }
}

