/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.clarin.CmdiProfileReader;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.templates.ArbilTemplate;
import org.apache.xmlbeans.SchemaAnnotation;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiTemplate
extends ArbilTemplate {
    String nameSpaceString;
    String[] filterString = new String[]{".CMD.Resources.", ".CMD.Header."};

    public void loadTemplate(String nameSpaceStringLocal) {
        this.vocabularyHashTable = new Hashtable();
        this.nameSpaceString = nameSpaceStringLocal;
        try {
            CmdiProfileReader.CmdiProfile cmdiProfile = CmdiProfileReader.getSingleInstance().getProfile(this.nameSpaceString);
            this.loadedTemplateName = cmdiProfile != null ? cmdiProfile.name : this.nameSpaceString.substring(this.nameSpaceString.lastIndexOf("/") + 1);
            File debugTempFile = File.createTempFile("templatetext", ".tmp");
            debugTempFile.deleteOnExit();
            BufferedWriter debugTemplateFileWriter = new BufferedWriter(new FileWriter(debugTempFile));
            ArrayListGroup arrayListGroup = new ArrayListGroup();
            URI xsdUri = new URI(this.nameSpaceString);
            this.readSchema(xsdUri, arrayListGroup);
            this.childNodePaths = (String[][])arrayListGroup.childNodePathsList.toArray((T[])new String[0][]);
            this.templatesArray = (String[][])arrayListGroup.addableComponentPathsList.toArray((T[])new String[0][]);
            this.resourceNodePaths = (String[][])arrayListGroup.resourceNodePathsList.toArray((T[])new String[0][]);
            this.fieldConstraints = (String[][])arrayListGroup.fieldConstraintList.toArray((T[])new String[0][]);
            this.fieldUsageArray = (String[][])arrayListGroup.fieldUsageDescriptionList.toArray((T[])new String[0][]);
            this.makeGuiNamesUnique();
            String[][] tempSortableArray = (String[][])arrayListGroup.displayNamePreferenceList.toArray((T[])new String[0][]);
            Arrays.sort(tempSortableArray, new Comparator<String[]>(){

                @Override
                public int compare(String[] o1, String[] o2) {
                    return Integer.valueOf(o1[1]) - Integer.valueOf(o2[1]);
                }
            });
            this.preferredNameFields = new String[tempSortableArray.length];
            for (int nameFieldCounter = 0; nameFieldCounter < this.preferredNameFields.length; ++nameFieldCounter) {
                this.preferredNameFields[nameFieldCounter] = tempSortableArray[nameFieldCounter][0];
            }
            for (String[] stringArray : this.templatesArray) {
                System.out.println("loadTemplate: " + stringArray[1] + ":" + stringArray[0]);
                debugTemplateFileWriter.write("<TemplateComponent FileName=\"" + stringArray[0] + "\" DisplayName=\"" + stringArray[1] + "\" />\r\n");
            }
            for (String[] stringArray : this.childNodePaths) {
                System.out.println("loadTemplate: " + stringArray[1] + ":" + stringArray[0]);
                debugTemplateFileWriter.write("<ChildNodePath ChildPath=\"" + stringArray[0] + "\" SubNodeName=\"" + stringArray[1] + "\" />\r\n");
            }
            for (String[] stringArray : this.resourceNodePaths) {
                System.out.println("loadTemplate: " + stringArray[1] + ":" + stringArray[0]);
                debugTemplateFileWriter.write("<ResourceNodePath RefPath=\"" + stringArray[0] + "\" RefNodeName=\"" + stringArray[1] + "\" />\r\n");
            }
            for (String[] stringArray : this.fieldConstraints) {
                System.out.println("loadTemplate: " + stringArray[1] + ":" + stringArray[0]);
                debugTemplateFileWriter.write("<FieldConstraint FieldPath=\"" + stringArray[0] + "\" Constraint=\"" + stringArray[1] + "\" />\r\n");
            }
            for (String[] stringArray : this.preferredNameFields) {
                System.out.println("loadTemplate: " + (String)stringArray);
                debugTemplateFileWriter.write("<TreeNodeNameField FieldsShortName==\"" + (String)stringArray + "\" />\r\n");
            }
            for (String[] stringArray : this.fieldUsageArray) {
                System.out.println("loadTemplate: " + stringArray[1] + ":" + stringArray[0]);
                debugTemplateFileWriter.write("<FieldUsage FieldPath=\"" + stringArray[0] + "\" FieldDescription=\"" + stringArray[1] + "\" />\r\n");
            }
            debugTemplateFileWriter.close();
        }
        catch (URISyntaxException urise) {
            GuiHelper.linorgBugCatcher.logError(urise);
        }
        catch (IOException urise) {
            GuiHelper.linorgBugCatcher.logError(urise);
        }
        this.requiredFields = new String[0];
        this.fieldTriggersArray = new String[0][];
        this.autoFieldsArray = new String[0][];
        this.genreSubgenreArray = new String[0][];
    }

    private void makeGuiNamesUnique() {
        boolean allGuiNamesUnique = false;
        while (!allGuiNamesUnique) {
            allGuiNamesUnique = true;
            for (String[] currentTemplate : this.templatesArray) {
                String currentTemplateGuiName = currentTemplate[1];
                String currentTemplatePath = currentTemplate[0];
                for (String[] secondTemplate : this.templatesArray) {
                    String[] templateToChangePathParts;
                    int pathCount;
                    String templateToChangePath;
                    String templateToChangeGuiName;
                    String secondTemplateGuiName = secondTemplate[1];
                    String secondTemplatePath = secondTemplate[0];
                    if (currentTemplatePath.equals(secondTemplatePath) || !currentTemplateGuiName.equals(secondTemplateGuiName)) continue;
                    allGuiNamesUnique = false;
                    for (String[] templateToChange : this.templatesArray) {
                        templateToChangeGuiName = templateToChange[1];
                        templateToChangePath = templateToChange[0];
                        if (!templateToChangeGuiName.equals(currentTemplateGuiName)) continue;
                        pathCount = templateToChangeGuiName.split("\\.").length;
                        templateToChangePathParts = templateToChangePath.split("\\.");
                        templateToChange[1] = templateToChangePathParts[templateToChangePathParts.length - pathCount - 1] + "." + templateToChangeGuiName;
                    }
                    for (String[] templateToChange : this.childNodePaths) {
                        templateToChangeGuiName = templateToChange[1];
                        templateToChangePath = templateToChange[0];
                        if (!templateToChangeGuiName.equals(currentTemplateGuiName)) continue;
                        pathCount = templateToChangeGuiName.split("\\.").length;
                        templateToChangePathParts = templateToChangePath.split("\\.");
                        templateToChange[1] = templateToChangePathParts[templateToChangePathParts.length - pathCount - 1] + "." + templateToChangeGuiName;
                    }
                }
            }
        }
    }

    @Override
    public Enumeration listTypesFor(Object targetNodeUserObject) {
        String targetNodeXpath = ((ImdiTreeObject)targetNodeUserObject).getURI().getFragment();
        System.out.println("targetNodeXpath: " + targetNodeXpath);
        if (targetNodeXpath != null) {
            targetNodeXpath = targetNodeXpath.replaceAll("\\.[^\\.]+[^\\)]$", "");
            targetNodeXpath = targetNodeXpath.replaceAll("\\(\\d+\\)", "");
        }
        System.out.println("targetNodeXpath: " + targetNodeXpath);
        Vector<String[]> childTypes = new Vector<String[]>();
        if (targetNodeUserObject instanceof ImdiTreeObject) {
            for (String[] childPathString : this.templatesArray) {
                boolean allowEntry = false;
                if (targetNodeXpath == null) {
                    allowEntry = true;
                } else if (childPathString[0].startsWith(targetNodeXpath)) {
                    allowEntry = true;
                }
                if (childPathString[0].equals(targetNodeXpath)) {
                    allowEntry = false;
                }
                for (String currentFilter : this.filterString) {
                    if (!childPathString[0].startsWith(currentFilter)) continue;
                    allowEntry = false;
                }
                if (!allowEntry) continue;
                childTypes.add(new String[]{childPathString[1], childPathString[0]});
            }
            String[][] childTypesArray = (String[][])childTypes.toArray((T[])new String[0][]);
            childTypes.removeAllElements();
            for (String[] currentChildType : childTypesArray) {
                boolean keepChildType = true;
                for (String[] subChildType : childTypesArray) {
                    if (!currentChildType[1].startsWith(subChildType[1]) || currentChildType[1].length() == subChildType[1].length()) continue;
                    keepChildType = false;
                }
                if (!keepChildType) continue;
                childTypes.add(currentChildType);
            }
            Collections.sort(childTypes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    String value1 = ((String[])o1)[0];
                    String value2 = ((String[])o2)[0];
                    return value1.compareTo(value2);
                }
            });
        }
        return childTypes.elements();
    }

    private void readSchema(URI xsdFile, ArrayListGroup arrayListGroup) {
        File schemaFile = xsdFile.getScheme().equals("file") ? new File(xsdFile) : LinorgSessionStorage.getSingleInstance().updateCache(xsdFile.toString(), 100);
        this.templateFile = schemaFile;
        try {
            FileInputStream inputStream = new FileInputStream(schemaFile);
            XmlOptions options = new XmlOptions();
            options.setCharacterEncoding("UTF-8");
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((InputStream)inputStream, (XmlOptions)options)}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), null);
            SchemaType schemaType = sts.documentTypes()[0];
            this.constructXml(schemaType, arrayListGroup, "");
        }
        catch (IOException e) {
            GuiHelper.linorgBugCatcher.logError(this.templateFile.getName(), e);
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not open the required template file: " + this.templateFile.getName(), "Load Clarin Template");
        }
        catch (XmlException e) {
            GuiHelper.linorgBugCatcher.logError(this.templateFile.getName(), (Exception)((Object)e));
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not read the required template file: " + this.templateFile.getName(), "Load Clarin Template");
        }
    }

    private boolean constructXml(SchemaType schemaType, ArrayListGroup arrayListGroup, String pathString) {
        SchemaProperty[] schemaPropertyArray;
        int childCount = 0;
        boolean hasMultipleElementsInOneNode = false;
        this.readControlledVocabularies(schemaType, pathString);
        this.readFieldConstrains(schemaType, pathString, arrayListGroup.fieldConstraintList);
        SchemaParticle topParticle = schemaType.getContentModel();
        this.searchForAnnotations(topParticle, pathString, arrayListGroup);
        for (SchemaProperty schemaProperty : schemaPropertyArray = schemaType.getElementProperties()) {
            ++childCount;
            String localName = schemaProperty.getName().getLocalPart();
            String currentPathString = pathString + "." + localName;
            boolean canHaveMultiple = true;
            if (schemaProperty.getMaxOccurs() == null) {
                canHaveMultiple = true;
            } else if (schemaProperty.getMaxOccurs().toString().equals("unbounded")) {
                canHaveMultiple = true;
            } else {
                boolean bl = canHaveMultiple = schemaProperty.getMaxOccurs().intValue() > 1;
            }
            if (!canHaveMultiple) {
                canHaveMultiple = schemaProperty.getMinOccurs().intValue() != schemaProperty.getMaxOccurs().intValue();
            }
            System.out.println("Found template element: " + currentPathString);
            SchemaType currentSchemaType = schemaProperty.getType();
            String currentNodeMenuName = localName;
            boolean childHasMultipleElementsInOneNode = this.constructXml(currentSchemaType, arrayListGroup, currentPathString);
            if (!hasMultipleElementsInOneNode) {
                hasMultipleElementsInOneNode = childHasMultipleElementsInOneNode;
            }
            if (canHaveMultiple && hasMultipleElementsInOneNode) {
                arrayListGroup.childNodePathsList.add(new String[]{currentPathString, currentNodeMenuName});
            }
            if (canHaveMultiple) {
                arrayListGroup.addableComponentPathsList.add(new String[]{currentPathString, currentNodeMenuName});
            }
            boolean hasResourceAttribute = false;
            for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
                if (!attributesProperty.getName().getLocalPart().equals("ref")) continue;
                hasResourceAttribute = true;
                break;
            }
            if (!hasResourceAttribute) continue;
            arrayListGroup.resourceNodePathsList.add(new String[]{currentPathString, localName});
        }
        if (childCount > 1) {
            hasMultipleElementsInOneNode = true;
        }
        return hasMultipleElementsInOneNode;
    }

    private void searchForAnnotations(SchemaParticle schemaParticle, String nodePath, ArrayListGroup arrayListGroup) {
        if (schemaParticle != null) {
            switch (schemaParticle.getParticleType()) {
                case 3: {
                    for (SchemaParticle schemaParticleChild : schemaParticle.getParticleChildren()) {
                        nodePath = nodePath + "." + schemaParticleChild.getName().getLocalPart();
                        this.searchForAnnotations(schemaParticleChild, nodePath, arrayListGroup);
                    }
                    break;
                }
                case 4: {
                    SchemaLocalElement schemaLocalElement = (SchemaLocalElement)schemaParticle;
                    this.saveAnnotationData(schemaLocalElement, nodePath, arrayListGroup);
                }
            }
        }
    }

    private void saveAnnotationData(SchemaLocalElement schemaLocalElement, String nodePath, ArrayListGroup arrayListGroup) {
        SchemaAnnotation schemaAnnotation = schemaLocalElement.getAnnotation();
        if (schemaAnnotation != null) {
            for (SchemaAnnotation.Attribute annotationAttribute : schemaAnnotation.getAttributes()) {
                System.out.println("  Annotation: " + annotationAttribute.getName() + " : " + annotationAttribute.getValue());
                if ("{http://www.clarin.eu}displaypriority".equals(annotationAttribute.getName().toString())) {
                    arrayListGroup.displayNamePreferenceList.add(new String[]{nodePath, annotationAttribute.getValue()});
                }
                if (!"{http://www.clarin.eu}documentation".equals(annotationAttribute.getName().toString())) continue;
                arrayListGroup.fieldUsageDescriptionList.add(new String[]{nodePath, annotationAttribute.getValue()});
            }
        }
    }

    private void readFieldConstrains(SchemaType schemaType, String nodePath, ArrayList<String[]> fieldConstraintList) {
        switch (schemaType.getBuiltinTypeCode()) {
            case 12: {
                break;
            }
            case 16: {
                fieldConstraintList.add(new String[]{nodePath, "([0-9][0-9][0-9][0-9])((-[0-1][0-9])(-[0-3][0-9])?)?"});
                break;
            }
            case 3: {
                fieldConstraintList.add(new String[]{nodePath, "true|false"});
                break;
            }
            case 6: {
                fieldConstraintList.add(new String[]{nodePath, "[^\\d]+://.*"});
                break;
            }
            case 0: {
                break;
            }
        }
    }

    private void readControlledVocabularies(SchemaType schemaType, String nodePath) {
        if (schemaType.getEnumerationValues() != null) {
            ImdiVocabularies.Vocabulary vocabulary = ImdiVocabularies.getSingleInstance().getEmptyVocabulary(this.nameSpaceString + "#" + schemaType.getName());
            for (XmlAnySimpleType anySimpleType : schemaType.getEnumerationValues()) {
                vocabulary.addEntry(anySimpleType.getStringValue());
            }
            this.vocabularyHashTable.put(nodePath, vocabulary);
        }
    }

    public static void main(String[] args) {
        new CmdiTemplate().loadTemplate("file:/Users/petwit/Desktop/LocalProfiles/clarin.eu_annotation-test_1272022528355.xsd");
    }

    private class ArrayListGroup {
        public ArrayList<String[]> childNodePathsList = new ArrayList();
        public ArrayList<String[]> addableComponentPathsList = new ArrayList();
        public ArrayList<String[]> resourceNodePathsList = new ArrayList();
        public ArrayList<String[]> fieldConstraintList = new ArrayList();
        public ArrayList<String[]> displayNamePreferenceList = new ArrayList();
        public ArrayList<String[]> fieldUsageDescriptionList = new ArrayList();

        private ArrayListGroup() {
        }
    }
}

