/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.BinaryExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.Optimizer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.Token;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.sort.GlobalOrderComparer;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceType;

public final class IdentityComparison
extends BinaryExpression {
    private boolean generateIdEmulation = false;

    public IdentityComparison(Expression expression, int n, Expression expression2) {
        super(expression, n, expression2);
    }

    public void setGenerateIdEmulation(boolean bl) {
        this.generateIdEmulation = bl;
    }

    public boolean isGenerateIdEmulation() {
        return this.generateIdEmulation;
    }

    public Expression typeCheck(StaticContext staticContext, ItemType itemType) throws XPathException {
        this.operand0 = this.operand0.typeCheck(staticContext, itemType);
        this.operand1 = this.operand1.typeCheck(staticContext, itemType);
        if (!this.generateIdEmulation && (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1))) {
            return Literal.makeLiteral(EmptySequence.getInstance());
        }
        RoleLocator roleLocator = new RoleLocator(1, Token.tokens[this.operator], 0, null);
        roleLocator.setSourceLocator(this);
        this.operand0 = TypeChecker.staticTypeCheck(this.operand0, SequenceType.OPTIONAL_NODE, false, roleLocator, staticContext);
        RoleLocator roleLocator2 = new RoleLocator(1, Token.tokens[this.operator], 1, null);
        roleLocator2.setSourceLocator(this);
        this.operand1 = TypeChecker.staticTypeCheck(this.operand1, SequenceType.OPTIONAL_NODE, false, roleLocator2, staticContext);
        return this;
    }

    public Expression optimize(Optimizer optimizer, StaticContext staticContext, ItemType itemType) throws XPathException {
        Expression expression = super.optimize(optimizer, staticContext, itemType);
        if (expression != this && !this.generateIdEmulation && (Literal.isEmptySequence(this.operand0) || Literal.isEmptySequence(this.operand1))) {
            return Literal.makeLiteral(EmptySequence.getInstance());
        }
        return expression;
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = this.getNode(this.operand0, xPathContext);
        if (nodeInfo == null) {
            if (this.generateIdEmulation) {
                return BooleanValue.get(this.getNode(this.operand1, xPathContext) == null);
            }
            return null;
        }
        NodeInfo nodeInfo2 = this.getNode(this.operand1, xPathContext);
        if (nodeInfo2 == null) {
            if (this.generateIdEmulation) {
                return BooleanValue.FALSE;
            }
            return null;
        }
        return BooleanValue.get(this.compareIdentity(nodeInfo, nodeInfo2));
    }

    public boolean effectiveBooleanValue(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = this.getNode(this.operand0, xPathContext);
        if (nodeInfo == null) {
            if (this.generateIdEmulation) {
                return this.getNode(this.operand1, xPathContext) == null;
            }
            return false;
        }
        NodeInfo nodeInfo2 = this.getNode(this.operand1, xPathContext);
        if (nodeInfo2 == null) {
            return false;
        }
        return this.compareIdentity(nodeInfo, nodeInfo2);
    }

    private boolean compareIdentity(NodeInfo nodeInfo, NodeInfo nodeInfo2) {
        switch (this.operator) {
            case 20: {
                return nodeInfo.isSameNodeInfo(nodeInfo2);
            }
            case 37: {
                return GlobalOrderComparer.getInstance().compare(nodeInfo, nodeInfo2) < 0;
            }
            case 38: {
                return GlobalOrderComparer.getInstance().compare(nodeInfo, nodeInfo2) > 0;
            }
        }
        throw new UnsupportedOperationException("Unknown node identity test");
    }

    private NodeInfo getNode(Expression expression, XPathContext xPathContext) throws XPathException {
        return (NodeInfo)expression.evaluateItem(xPathContext);
    }

    public ItemType getItemType(TypeHierarchy typeHierarchy) {
        return BuiltInAtomicType.BOOLEAN;
    }
}

