/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.HttpURLConnection;
import java.net.URI;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import mpi.bcarchive.typecheck.DeepFileType;
import mpi.bcarchive.typecheck.FileType;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.ShibCookieHandler;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;

public class MimeHashQueue {
    private Hashtable processedFilesMTimes;
    private Hashtable<String, String[]> knownMimeTypes;
    private Hashtable<String, Vector<String>> md5SumToDuplicates;
    private Hashtable<String, String> pathToMd5Sums;
    private Vector<ImdiTreeObject> imdiObjectQueue;
    private boolean continueThread = false;
    private static FileType fileType;
    private static DeepFileType deepFileType;
    private static MimeHashQueue singleInstance;
    public boolean checkResourcePermissions = true;

    public static synchronized MimeHashQueue getSingleInstance() {
        if (singleInstance == null) {
            CookieHandler.setDefault(new ShibCookieHandler());
            singleInstance = new MimeHashQueue();
        }
        return singleInstance;
    }

    public MimeHashQueue() {
        System.out.println("MimeHashQueue init");
        this.imdiObjectQueue = new Vector();
        this.continueThread = true;
        new Thread("MimeHashQueue"){

            public void run() {
                int serverPermissionsChecked = 0;
                this.setPriority(1);
                System.out.println("MimeHashQueue run");
                fileType = new FileType();
                deepFileType = new DeepFileType();
                MimeHashQueue.this.loadMd5sumIndex();
                boolean changedSinceLastSave = false;
                while (MimeHashQueue.this.continueThread) {
                    try {
                        1.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        GuiHelper.linorgBugCatcher.logError(ie);
                    }
                    while (MimeHashQueue.this.imdiObjectQueue.size() > 0) {
                        ImdiTreeObject currentImdiObject = (ImdiTreeObject)MimeHashQueue.this.imdiObjectQueue.remove(0);
                        if (!currentImdiObject.isMetaDataNode()) {
                            System.out.println("checking exif");
                            MimeHashQueue.this.addFileAndExifFields(currentImdiObject);
                        }
                        if (currentImdiObject.hasResource() && !currentImdiObject.hasLocalResource()) {
                            System.out.println("checking server permissions " + serverPermissionsChecked++);
                            MimeHashQueue.this.checkServerPermissions(currentImdiObject);
                        } else {
                            File currentFile;
                            System.out.println("checking mime type etc");
                            URI currentPathURI = MimeHashQueue.this.getNodeURI(currentImdiObject);
                            if (currentPathURI != null && currentPathURI.toString().length() > 0 && (currentFile = new File(currentPathURI)).exists()) {
                                long previousMTime = 0L;
                                if (MimeHashQueue.this.processedFilesMTimes.containsKey(currentPathURI.toString())) {
                                    previousMTime = (Long)MimeHashQueue.this.processedFilesMTimes.get(currentPathURI.toString());
                                }
                                long currentMTime = currentFile.lastModified();
                                String[] lastCheckedMimeArray = (String[])MimeHashQueue.this.knownMimeTypes.get(currentPathURI.toString());
                                if (previousMTime != currentMTime || lastCheckedMimeArray == null) {
                                    currentImdiObject.setMimeType(MimeHashQueue.this.getMimeType(currentPathURI));
                                    currentImdiObject.hashString = MimeHashQueue.this.getHash(currentPathURI, currentImdiObject.getURI());
                                    MimeHashQueue.this.processedFilesMTimes.put(currentPathURI.toString(), currentMTime);
                                    changedSinceLastSave = true;
                                } else {
                                    currentImdiObject.hashString = (String)MimeHashQueue.this.pathToMd5Sums.get(currentPathURI.toString());
                                    currentImdiObject.setMimeType(lastCheckedMimeArray);
                                }
                                MimeHashQueue.this.updateAutoFields(currentImdiObject, currentFile);
                                MimeHashQueue.this.updateImdiIconsToMatchingFileNodes(currentPathURI);
                            }
                        }
                        currentImdiObject.clearIcon();
                    }
                    if (!changedSinceLastSave) continue;
                    MimeHashQueue.this.saveMd5sumIndex();
                    changedSinceLastSave = false;
                }
                System.out.println("MimeHashQueue stop");
            }
        }.start();
    }

    protected void finalize() throws Throwable {
        this.continueThread = false;
        super.finalize();
    }

    private void loadMd5sumIndex() {
        System.out.println("MimeHashQueue loadMd5sumIndex");
        try {
            this.knownMimeTypes = (Hashtable)LinorgSessionStorage.getSingleInstance().loadObject("knownMimeTypesV2");
            this.pathToMd5Sums = (Hashtable)LinorgSessionStorage.getSingleInstance().loadObject("pathToMd5Sums");
            this.md5SumToDuplicates = (Hashtable)LinorgSessionStorage.getSingleInstance().loadObject("md5SumToDuplicates");
            this.processedFilesMTimes = (Hashtable)LinorgSessionStorage.getSingleInstance().loadObject("processedFilesMTimesV2");
            System.out.println("loaded md5 and mime from disk");
        }
        catch (Exception ex) {
            this.knownMimeTypes = new Hashtable();
            this.pathToMd5Sums = new Hashtable();
            this.processedFilesMTimes = new Hashtable();
            this.md5SumToDuplicates = new Hashtable();
            System.out.println("load loadMd5sumIndex failed: " + ex.getMessage());
        }
    }

    private void saveMd5sumIndex() {
        System.out.println("MimeHashQueue saveMd5sumIndex");
        try {
            LinorgSessionStorage.getSingleInstance().saveObject(this.knownMimeTypes, "knownMimeTypesV2");
            LinorgSessionStorage.getSingleInstance().saveObject(this.pathToMd5Sums, "pathToMd5Sums");
            LinorgSessionStorage.getSingleInstance().saveObject(this.processedFilesMTimes, "processedFilesMTimesV2");
            LinorgSessionStorage.getSingleInstance().saveObject(this.md5SumToDuplicates, "md5SumToDuplicates");
            System.out.println("saveMd5sumIndex");
        }
        catch (IOException ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    private String getFileSizeString(File targetFile) {
        return targetFile.length() / 1024L + "KB";
    }

    private void updateAutoFields(ImdiTreeObject currentImdiObject, File resourceFile) {
        Set<String> currentNodeFieldNames = currentImdiObject.getFields().keySet();
        for (String[] autoFields : currentImdiObject.getNodeTemplate().autoFieldsArray) {
            int indexOfChar;
            String fieldPath = autoFields[0];
            String fileAttribute = autoFields[1];
            String autoValue = null;
            if (fileAttribute.equals("Size")) {
                if (!currentImdiObject.resourceFileNotFound()) {
                    autoValue = this.getFileSizeString(resourceFile);
                }
            } else if (fileAttribute.equals("MpiMimeType")) {
                autoValue = currentImdiObject.mpiMimeType;
            } else if (fileAttribute.equals("FileType") && (autoValue = FileType.resultToMimeType((String)currentImdiObject.typeCheckerMessage)) != null && (indexOfChar = autoValue.indexOf("/")) > 0) {
                autoValue = autoValue.substring(0, indexOfChar);
            }
            if (autoValue == null) {
                autoValue = "";
            }
            if (autoValue == null) continue;
            for (String currentKeyString : currentNodeFieldNames) {
                ImdiField[] currentFieldArray;
                if (!fieldPath.endsWith(currentKeyString) || (currentFieldArray = currentImdiObject.getFields().get(currentKeyString)) == null || !currentFieldArray[0].getGenericFullXmlPath().equals(fieldPath)) continue;
                for (ImdiField currentField : currentFieldArray) {
                    currentField.setFieldValue(autoValue, true, true);
                }
            }
        }
    }

    private void updateImdiIconsToMatchingFileNodes(URI currentPathURI) {
        int matchesInCache = 0;
        int matchesLocalFileSystem = 0;
        int matchesRemote = 0;
        String currentMd5Sum = this.pathToMd5Sums.get(currentPathURI.toString());
        if (currentMd5Sum != null) {
            Vector<String> duplicatesPaths = this.md5SumToDuplicates.get(currentMd5Sum);
            Vector<ImdiTreeObject> relevantImdiObjects = new Vector<ImdiTreeObject>();
            Enumeration<String> duplicatesPathEnum = duplicatesPaths.elements();
            while (duplicatesPathEnum.hasMoreElements()) {
                String currentDupPath = duplicatesPathEnum.nextElement();
                try {
                    File currentFile = new File(new URI(currentDupPath));
                    if (!currentFile.exists()) continue;
                    ImdiTreeObject currentImdiObject = ImdiLoader.getSingleInstance().getImdiObjectOnlyIfLoaded(new URI(currentDupPath));
                    if (currentImdiObject != null) {
                        relevantImdiObjects.add(currentImdiObject);
                    }
                    if (LinorgSessionStorage.getSingleInstance().pathIsInsideCache(currentFile)) {
                        ++matchesInCache;
                    } else {
                        ++matchesLocalFileSystem;
                    }
                    matchesRemote = 0;
                }
                catch (Exception e) {}
            }
            Enumeration relevantImdiEnum = relevantImdiObjects.elements();
            while (relevantImdiEnum.hasMoreElements()) {
                ImdiTreeObject currentImdiObject = (ImdiTreeObject)relevantImdiEnum.nextElement();
                currentImdiObject.matchesInCache = matchesInCache;
                currentImdiObject.matchesLocalFileSystem = matchesLocalFileSystem;
                currentImdiObject.matchesRemote = matchesRemote;
                currentImdiObject.clearIcon();
            }
        }
    }

    private void addFileAndExifFields(ImdiTreeObject targetLooseFile) {
        File fileObject;
        if (!targetLooseFile.isMetaDataNode() && (fileObject = targetLooseFile.getFile()) != null && fileObject.exists()) {
            try {
                ImdiField[] exifFields;
                int currentFieldId = 1;
                ImdiField sizeField = new ImdiField(currentFieldId++, targetLooseFile, "Size", this.getFileSizeString(fileObject), 0);
                targetLooseFile.addField(sizeField);
                Date mtime = new Date(fileObject.lastModified());
                String mTimeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mtime);
                ImdiField dateField = new ImdiField(currentFieldId++, targetLooseFile, "last modified", mTimeString, 0);
                targetLooseFile.addField(dateField);
                for (ImdiField currentField : exifFields = ImdiSchema.getSingleInstance().getExifMetadata(targetLooseFile, currentFieldId)) {
                    targetLooseFile.addField(currentField);
                }
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(targetLooseFile.getUrlString() + "\n" + fileObject.getAbsolutePath(), ex);
            }
        }
    }

    private String[] getMimeType(URI fileUri) {
        String mpiMimeType = null;
        String typeCheckerMessage = null;
        boolean deep = false;
        if (new File(fileUri).exists()) {
            try {
                InputStream inputStream = fileUri.toURL().openStream();
                if (inputStream != null) {
                    typeCheckerMessage = deep ? deepFileType.checkStream(inputStream, fileUri.toString()) : fileType.checkStream(inputStream, fileUri.toString());
                }
                mpiMimeType = FileType.resultToMPIType(typeCheckerMessage);
            }
            catch (Exception ioe) {
                System.out.println("Cannot read file at URL: " + fileUri + " ioe: " + ioe.getMessage());
            }
            System.out.println(mpiMimeType);
        }
        String[] resultArray = new String[]{mpiMimeType, typeCheckerMessage};
        this.knownMimeTypes.put(fileUri.toString(), resultArray);
        return resultArray;
    }

    private String getHash(URI fileUri, URI nodeUri) {
        long startTime = System.currentTimeMillis();
        System.out.println("getHash: " + fileUri);
        String hashString = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            StringBuffer hexString = new StringBuffer();
            FileInputStream is = new FileInputStream(new File(fileUri));
            byte[] buff = new byte[1024];
            int i = 0;
            while ((i = is.read(buff)) > 0) {
                digest.update(buff, 0, i);
                long downloadDelay = System.currentTimeMillis() - startTime;
                if (downloadDelay > 100L) {
                    throw new Exception("reading file for md5sum is taking too long (" + downloadDelay + ") skipping the file: " + fileUri);
                }
                startTime = System.currentTimeMillis();
            }
            byte[] md5sum = digest.digest();
            for (i = 0; i < md5sum.length; ++i) {
                hexString.append(Integer.toHexString(256 + (md5sum[i] & 0xFF)).substring(1));
            }
            hashString = hexString.toString();
        }
        catch (Exception ex) {
            System.out.println("failed to created hash: " + ex.getMessage());
        }
        if (hashString != null) {
            this.pathToMd5Sums.put(fileUri.toString(), hashString);
            Vector<String> matchingNodes = this.md5SumToDuplicates.get(hashString);
            if (matchingNodes != null) {
                if (!matchingNodes.contains(nodeUri.toString())) {
                    Enumeration<String> otherNodesEnum = matchingNodes.elements();
                    while (otherNodesEnum.hasMoreElements()) {
                        String currentElement = otherNodesEnum.nextElement();
                        Object currentNode = this.processedFilesMTimes.get(currentElement.toString());
                        if (!(currentNode instanceof ImdiTreeObject)) continue;
                        System.out.println("Clearing icon for other node: " + currentNode.toString());
                        ((ImdiTreeObject)currentNode).clearIcon();
                    }
                    matchingNodes.add(fileUri.toString());
                }
            } else {
                System.out.println("creating new vector for: " + hashString);
                Vector<String> nodeVector = new Vector<String>();
                nodeVector.add(nodeUri.toString());
                this.md5SumToDuplicates.put(hashString, nodeVector);
            }
        }
        System.out.println("hashString: " + hashString);
        return hashString;
    }

    private void checkServerPermissions(ImdiTreeObject imdiObject) {
        if (this.checkResourcePermissions) {
            try {
                HttpURLConnection resourceConnection = (HttpURLConnection)imdiObject.getFullResourceURI().toURL().openConnection();
                resourceConnection.setRequestMethod("HEAD");
                resourceConnection.setRequestProperty("Connection", "Close");
                imdiObject.resourceFileServerResponse = resourceConnection.getResponseCode();
                imdiObject.fileNotFound = imdiObject.resourceFileServerResponse == 404 || imdiObject.resourceFileServerResponse == 403;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
    }

    private URI getNodeURI(ImdiTreeObject imdiObject) {
        if (imdiObject.hasResource()) {
            return imdiObject.getFullResourceURI();
        }
        return imdiObject.getURI();
    }

    public void addToQueue(ImdiTreeObject imdiObject) {
        System.out.println("MimeHashQueue addToQueue: " + imdiObject.getUrlString());
        if ((imdiObject.isLocal() && !imdiObject.isMetaDataNode() && !imdiObject.isDirectory() || imdiObject.isImdiChild() && imdiObject.hasResource()) && !this.imdiObjectQueue.contains(imdiObject)) {
            this.imdiObjectQueue.add(imdiObject);
        }
    }

    static {
        singleInstance = null;
    }
}

