/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.LinorgFavourites;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.clarin.CmdiComponentBuilder;
import nl.mpi.arbil.clarin.CmdiProfileReader;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;
import org.w3c.dom.Document;

public class MetadataBuilder {
    public void requestRootAddNode(String nodeType, String nodeTypeDisplayName) {
        ImdiTreeObject imdiTreeObject = new ImdiTreeObject(LinorgSessionStorage.getSingleInstance().getNewImdiFileName(LinorgSessionStorage.getSingleInstance().getSaveLocation(""), nodeType));
        this.requestAddNode(imdiTreeObject, nodeType, nodeTypeDisplayName);
    }

    public void requestAddNode(final ImdiTreeObject destinationNode, final String nodeTypeDisplayNameLocal, final ImdiTreeObject addableNode) {
        new Thread("requestAddNode"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                destinationNode.updateLoadingState(1);
                Object object = destinationNode.domLockObject;
                synchronized (object) {
                    if (addableNode.isMetaDataNode()) {
                        URI addedNodeUri;
                        destinationNode.saveChangesToCache(true);
                        if (addableNode.getURI().getFragment() == null) {
                            addedNodeUri = LinorgSessionStorage.getSingleInstance().getNewImdiFileName(destinationNode.getSubDirectory(), addableNode.getURI().getPath());
                            ImdiTreeObject.getMetadataUtils(addableNode.getURI().toString()).copyMetadataFile(addableNode.getURI(), new File(addedNodeUri), null, true);
                            ImdiTreeObject addedNode = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(addedNodeUri);
                            new CmdiComponentBuilder().removeArchiveHandles(addedNode);
                            destinationNode.metadataUtils.addCorpusLink(destinationNode.getURI(), new URI[]{addedNodeUri});
                            addedNode.loadImdiDom();
                            addedNode.scrollToRequested = true;
                            destinationNode.getParentDomNode().loadImdiDom();
                            TreeHelper.getSingleInstance().updateTreeNodeChildren(destinationNode.getParentDomNode());
                        } else {
                            CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
                            addedNodeUri = componentBuilder.insertFavouriteComponent(destinationNode, addableNode);
                            new CmdiComponentBuilder().removeArchiveHandles(destinationNode);
                        }
                        destinationNode.getParentDomNode().loadImdiDom();
                        String newTableTitleString = "new " + addableNode + " in " + destinationNode;
                        ImdiTableModel imdiTableModel = LinorgWindowManager.getSingleInstance().openFloatingTableOnce(new URI[]{addedNodeUri}, newTableTitleString);
                    } else {
                        String nodeTypeDisplayName = nodeTypeDisplayNameLocal;
                        ImdiTreeObject[] sourceImdiNodeArray = addableNode.isEmptyMetaNode() ? addableNode.getChildArray() : new ImdiTreeObject[]{addableNode};
                        for (ImdiTreeObject currentImdiNode : sourceImdiNodeArray) {
                            String nodeType;
                            if (destinationNode.isCmdiMetaDataNode()) {
                                CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
                                URI addedNodePath = componentBuilder.insertResourceProxy(destinationNode, addableNode);
                                destinationNode.getParentDomNode().loadImdiDom();
                                continue;
                            }
                            String favouriteUrlString = null;
                            URI resourceUrl = null;
                            String mimeType = null;
                            if (currentImdiNode.isArchivableFile() && !currentImdiNode.isMetaDataNode()) {
                                nodeType = ImdiSchema.getSingleInstance().getNodeTypeFromMimeType(currentImdiNode.mpiMimeType);
                                resourceUrl = currentImdiNode.getURI();
                                mimeType = currentImdiNode.mpiMimeType;
                                nodeTypeDisplayName = "Resource";
                            } else {
                                nodeType = LinorgFavourites.getSingleInstance().getNodeType(currentImdiNode, destinationNode);
                                favouriteUrlString = currentImdiNode.getUrlString();
                            }
                            if (nodeType == null) continue;
                            String targetXmlPath = destinationNode.getURI().getFragment();
                            if (nodeType == null) {
                                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot add this type of node", null);
                                continue;
                            }
                            System.out.println("requestAddNode: " + nodeType + " : " + nodeTypeDisplayName + " : " + favouriteUrlString + " : " + resourceUrl);
                            MetadataBuilder.this.processAddNodes(destinationNode, nodeType, targetXmlPath, nodeTypeDisplayName, favouriteUrlString, mimeType, resourceUrl);
                            destinationNode.getParentDomNode().loadImdiDom();
                        }
                    }
                }
                destinationNode.updateLoadingState(-1);
            }
        }.start();
    }

    public void requestAddNode(final ImdiTreeObject destinationNode, final String nodeType, final String nodeTypeDisplayName) {
        new Thread("requestAddNode"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                destinationNode.updateLoadingState(1);
                Object object = destinationNode.domLockObject;
                synchronized (object) {
                    System.out.println("requestAddNode: " + nodeType + " : " + nodeTypeDisplayName);
                    MetadataBuilder.this.processAddNodes(destinationNode, nodeType, destinationNode.getURI().getFragment(), nodeTypeDisplayName, null, null, null);
                    if (destinationNode.getFile().exists()) {
                        destinationNode.getParentDomNode().loadImdiDom();
                    }
                }
                destinationNode.updateLoadingState(-1);
            }
        }.start();
    }

    private void processAddNodes(ImdiTreeObject currentImdiObject, String nodeType, String targetXmlPath, String nodeTypeDisplayName, String favouriteUrlString, String mimeType, URI resourceUri) {
        String newTableTitleString = "new " + nodeTypeDisplayName;
        if (currentImdiObject.isMetaDataNode() && currentImdiObject.getFile().exists()) {
            newTableTitleString = newTableTitleString + " in " + currentImdiObject.toString();
        }
        System.out.println("addQueue:-\nnodeType: " + nodeType + "\ntargetXmlPath: " + targetXmlPath + "\nnodeTypeDisplayName: " + nodeTypeDisplayName + "\nfavouriteUrlString: " + favouriteUrlString + "\nresourceUrl: " + resourceUri + "\nmimeType: " + mimeType);
        URI addedNodeUri = this.addChildNode(currentImdiObject, nodeType, targetXmlPath, resourceUri, mimeType);
        ImdiTreeObject addedImdiObject = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(addedNodeUri);
        if (addedImdiObject != null) {
            if (favouriteUrlString != null) {
                // empty if block
            }
            addedImdiObject.getParentDomNode().loadImdiDom();
            addedImdiObject.getParentDomNode().clearIcon();
            addedImdiObject.getParentDomNode().clearChildIcons();
            addedImdiObject.scrollToRequested = true;
            TreeHelper.getSingleInstance().updateTreeNodeChildren(currentImdiObject.getParentDomNode());
            if (currentImdiObject.getParentDomNode() != addedImdiObject.getParentDomNode()) {
                TreeHelper.getSingleInstance().updateTreeNodeChildren(addedImdiObject.getParentDomNode());
            }
        }
        ImdiTableModel imdiTableModel = LinorgWindowManager.getSingleInstance().openFloatingTableOnce(new URI[]{addedNodeUri}, newTableTitleString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addChildNode(ImdiTreeObject destinationNode, String nodeType, String targetXmlPath, URI resourceUri, String mimeType) {
        System.out.println("addChildNode:: " + nodeType + " : " + resourceUri);
        System.out.println("targetXmlPath:: " + targetXmlPath);
        URI addedNodePath = null;
        destinationNode.updateLoadingState(1);
        Object object = destinationNode.domLockObject;
        synchronized (object) {
            block17: {
                if (destinationNode.getNeedsSaveToDisk()) {
                    destinationNode.saveChangesToCache(false);
                }
                if (nodeType.startsWith(".") && destinationNode.isCmdiMetaDataNode()) {
                    CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
                    addedNodePath = componentBuilder.insertChildComponent(destinationNode, targetXmlPath, nodeType);
                } else if (destinationNode.getNodeTemplate().isImdiChildType(nodeType) || resourceUri != null && destinationNode.isSession()) {
                    System.out.println("adding to current node");
                    try {
                        Document nodDom = new CmdiComponentBuilder().getDocument(destinationNode.getURI());
                        if (nodDom == null) {
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The metadata file could not be opened", "Add Node");
                            break block17;
                        }
                        addedNodePath = ImdiSchema.getSingleInstance().insertFromTemplate(destinationNode.getNodeTemplate(), destinationNode.getURI(), destinationNode.getSubDirectory(), nodeType, targetXmlPath, nodDom, resourceUri, mimeType);
                        destinationNode.bumpHistory();
                        new CmdiComponentBuilder().savePrettyFormatting(nodDom, destinationNode.getFile());
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                } else {
                    System.out.println("adding new node");
                    URI targetFileURI = LinorgSessionStorage.getSingleInstance().getNewImdiFileName(destinationNode.getSubDirectory(), nodeType);
                    if (CmdiProfileReader.pathIsProfile(nodeType)) {
                        CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
                        try {
                            addedNodePath = componentBuilder.createComponentFile(targetFileURI, new URI(nodeType));
                        }
                        catch (URISyntaxException ex) {
                            GuiHelper.linorgBugCatcher.logError(ex);
                            return null;
                        }
                    } else {
                        addedNodePath = ImdiSchema.getSingleInstance().addFromTemplate(new File(targetFileURI), nodeType);
                    }
                    if (destinationNode.getFile().exists()) {
                        destinationNode.metadataUtils.addCorpusLink(destinationNode.getURI(), new URI[]{addedNodePath});
                        destinationNode.getParentDomNode().loadImdiDom();
                    } else {
                        TreeHelper.getSingleInstance().addLocation(addedNodePath);
                        TreeHelper.getSingleInstance().applyRootLocations();
                    }
                }
            }
        }
        destinationNode.updateLoadingState(-1);
        return addedNodePath;
    }
}

