/*
 * Decompiled with CFR 0.152.
 */
package mpi.bcarchive.spider;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Vector;
import mpi.bcarchive.spider.AbstractIMDINodeHandler;
import mpi.bcarchive.spider.IMDIContentHandler;
import mpi.bcarchive.spider.IMDINode;
import mpi.bcarchive.spider.IMDISpider;
import mpi.corpusstructure.AccessInfo;
import mpi.corpusstructure.ArchiveAccessContext;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.ArchiveObjectsDBWriteImpl;
import mpi.corpusstructure.FileInfo;
import mpi.corpusstructure.NodeIdUtils;
import mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class URIDDBReset
extends AbstractIMDINodeHandler {
    private static Logger _logger = Logger.getLogger((String)URIDDBReset.class.getName());
    private ArchiveAccessContext _aac = null;
    private ArchiveObjectsDBWrite _aodbwr = null;
    private boolean _simulation = false;
    private IMDIContentHandler _imdiCH = new IMDIContentHandler();

    public URIDDBReset(ArchiveObjectsDBWrite aodbwr, boolean simulation) {
        this._aac = aodbwr.getArchiveRoots();
        this._aodbwr = aodbwr;
        this._simulation = simulation;
        this._imdiCH.setBlockAbsolute(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ArchiveObjectsDBWriteImpl aodbwr;
        OurURL url = null;
        boolean singleNode = false;
        boolean simulation = false;
        if (args.length != 4 || !args[0].startsWith("file:")) {
            System.out.println("Usage:");
            System.out.println("1st argument: file: URL of start IMDI file");
            System.out.println("              Use 'file:single:...' style URL to disable recursion");
            System.out.println("              Use 'file:simulate:...' style URL to keep DB unchanged");
            System.out.println("2nd argument: jdbc URL for corpusstructure URID/nodeid storage");
            System.out.println("3rd argument: user name for JDBC");
            System.out.println("4th argument: password for JDBC (- for none)");
            System.out.println();
            System.out.println("Collects URIDs mentioned in IMDI files and resets URLs in corpusstructure");
            System.out.println("database for those URIDs to the URLs mentioned in the IMDI files.");
            System.exit(1);
        }
        if (args[0].startsWith("file:single:")) {
            singleNode = true;
            args[0] = "file:" + args[0].substring(12);
        }
        if (args[0].startsWith("file:simulate:")) {
            simulation = true;
            args[0] = "file:" + args[0].substring(14);
        }
        try {
            url = new OurURL(args[0]);
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (url == null) {
            System.out.println("Invalid URL: " + args[0]);
            System.exit(1);
        }
        if (!(aodbwr = new ArchiveObjectsDBWriteImpl(args[1], false, args[2], args[3])).getStatus()) {
            System.out.println("Failed to open DB: " + args[2]);
            System.exit(1);
        }
        URIDDBReset nh = new URIDDBReset(aodbwr, simulation);
        try {
            if (singleNode) {
                _logger.info((Object)("Processing single IMDI Corpus file: " + (nh.handleCorpus(url, null) ? "okay" : "error") + " URL: " + url));
            } else {
                _logger.info((Object)("Recursive IMDI file processing, spider starts at: " + url));
                IMDISpider sp = new IMDISpider();
                sp.run(url, nh, true);
            }
        }
        finally {
            if (aodbwr != null) {
                aodbwr.close();
            }
        }
    }

    public boolean handleCorpus(OurURL imdifile, OurURL parent) {
        return this.handleIMDI(imdifile);
    }

    public boolean handleSession(OurURL imdifile, OurURL corpus) {
        return this.handleIMDI(imdifile);
    }

    public boolean handleLexicon(OurURL imdifile, OurURL parent) {
        _logger.warn((Object)("Lexicon files not supported: " + imdifile));
        return false;
    }

    public boolean handleCatalogue(OurURL imdifile, OurURL parent) {
        _logger.warn((Object)("Catalogue files not supported: " + imdifile));
        return false;
    }

    public boolean handleLinkError(OurURL file, OurURL parent) {
        _logger.warn((Object)("Dead link: " + file + " (from: " + parent + ")"));
        return true;
    }

    public boolean handleParseError(OurURL file, OurURL parent) {
        _logger.warn((Object)("Parse error: " + file));
        return true;
    }

    private synchronized boolean handleIMDI(OurURL url) {
        int context = this._aac.getAccessContextFromURI(url.toString());
        if (context != 1 && context != 2) {
            if (context == 3) {
                _logger.warn((Object)("Local URLs must be file: URLs. Skipped: " + url));
                return false;
            }
            URIDDBReset uRIDDBReset = this;
            _logger.warn((Object)("Skipped non-local IMDI, not below our access context " + this._aac.getRoot(uRIDDBReset._aac.getFileUrlContext()) + ": " + url));
            return true;
        }
        try {
            this._imdiCH.clearLists();
            this._imdiCH.parse(url);
        }
        catch (SAXException saxe) {
            _logger.error((Object)("IMDI parse error: " + saxe + " at: " + url));
            return false;
        }
        catch (IOException ioe) {
            _logger.error((Object)("IMDI I/O error: " + ioe + " at: " + url));
            return false;
        }
        catch (Exception e) {
            _logger.error((Object)("Unexcepted parse exception: " + e + " at: " + url), (Throwable)e);
            return false;
        }
        if (this._imdiCH.getURID() != null) {
            this.addItem2(this._imdiCH.getURID(), url);
        }
        Vector<IMDINode> allLinks = new Vector<IMDINode>();
        Iterator iIter = this._imdiCH.getCorpusLinks().iterator();
        while (iIter.hasNext()) {
            allLinks.add((IMDINode)iIter.next());
        }
        iIter = this._imdiCH.getMediaNodes().iterator();
        while (iIter.hasNext()) {
            allLinks.add((IMDINode)iIter.next());
        }
        iIter = this._imdiCH.getWrittenNodes().iterator();
        while (iIter.hasNext()) {
            allLinks.add((IMDINode)iIter.next());
        }
        iIter = this._imdiCH.getLexiconNodes().iterator();
        while (iIter.hasNext()) {
            allLinks.add((IMDINode)iIter.next());
        }
        iIter = this._imdiCH.getInfoNodes().iterator();
        while (iIter.hasNext()) {
            allLinks.add((IMDINode)iIter.next());
        }
        for (IMDINode node : allLinks) {
            this.addItem2(node.getURID(), node.getURL());
        }
        iIter = null;
        return true;
    }

    private void addItem2(String urid, OurURL url) {
        try {
            this.addItem(urid, url);
        }
        catch (Exception e) {
            _logger.error((Object)("Unexpected error while adding: " + urid + " Exception: " + e + " at: " + url), (Throwable)e);
        }
    }

    private void addItem(String urid, OurURL url) {
        if (urid == null || urid.length() == 0) {
            return;
        }
        if (url.toString().startsWith("notyet")) {
            _logger.info((Object)("Notyet-URL skipped: " + url));
            return;
        }
        String newId = NodeIdUtils.handleToNodeId(urid, this._aac.getHandlePrefix());
        if (!NodeIdUtils.isNodeId(newId)) {
            _logger.warn((Object)("URID outside our prefix, not adding: " + urid));
            return;
        }
        String oldId = this._aodbwr.getObjectId(url);
        if (oldId != null) {
            if (newId.equals(oldId)) {
                _logger.debug((Object)("Object already known: " + newId + " urid: " + urid));
                return;
            }
            _logger.warn((Object)("Object already has OTHER id, not adding! DB has: " + oldId + " file has: " + newId + " file has urid: " + urid));
            return;
        }
        FileInfo fi = new FileInfo(url);
        if (fi.getSize() <= 0L) {
            _logger.warn((Object)("Object not accessible or empty: URID: " + urid + " URL: " + url));
            return;
        }
        if (fi.getSize() == 1L) {
            _logger.info((Object)("Object seems to be remote: URID: " + urid + " URL: " + url));
        }
        if (fi.getSize() == 2L) {
            _logger.info((Object)("Object has unknown size: URID: " + urid + " URL: " + url));
        }
        AccessInfo ai = new AccessInfo("everybody", "nobody");
        URI oldURI = this._aodbwr.getObjectURI(newId);
        URI uri = null;
        try {
            uri = this._aac.stringToURI(url.toString());
        }
        catch (URISyntaxException use) {
            _logger.error((Object)("Invalid URI: " + use + " in: " + url));
            return;
        }
        int context = this._aac.getAccessContextFromURI(uri.toString());
        URIDDBReset uRIDDBReset = this;
        boolean onsite = context == uRIDDBReset._aac.getFileUrlContext();
        uri = this._aac.inTableContext(uri);
        if (oldURI != null) {
            if (this._simulation) {
                _logger.info((Object)("Would have reset URI for: " + newId + " From: " + oldURI + " To: " + uri));
                return;
            }
            if (!this._aodbwr.moveArchiveObject(newId, uri)) {
                _logger.warn((Object)("URI reset failed for item: " + newId + " From: " + oldURI + " To: " + uri));
                return;
            }
            _logger.info((Object)("Reset URI for item: " + newId + " From: " + oldURI + " To: " + uri));
            return;
        }
        _logger.warn((Object)("Re-adding item - no data was known for: " + newId));
        if (this._simulation) {
            _logger.info((Object)("Would have added URI for: " + newId + " for: " + uri));
            return;
        }
        String realId = this._aodbwr.newArchiveObject(newId, uri, new Timestamp(42L), onsite, 1L, new Timestamp(42L), ai, null);
        if (!newId.equals(realId)) {
            _logger.warn((Object)("Tried to add item: " + newId + " but got: " + realId + " for URI: " + uri));
            return;
        }
        _logger.info((Object)("URID URL pair recorded: nodeid: " + newId + " urid: " + urid + " URI: " + uri));
    }
}

