/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Vector;
import mpi.corpusstructure.AccessInfo;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.ArchiveObjectsDBWriteImplHS;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.PushTransactionsHS;
import mpi.corpusstructure.UnknownNodeException;
import mpi.corpusstructure.UpdateInProgressException;
import org.apache.log4j.Logger;

public class AOtoHandle3 {
    private static Logger logger = Logger.getLogger((String)AOtoHandle3.class.getName());
    private ArchiveObjectsDB aodb;
    private ArchiveObjectsDBWrite aodbwr;
    private PushTransactionsHS txnWriter;

    public AOtoHandle3(ArchiveObjectsDBWrite aodbwr, ArchiveObjectsDB aodb) {
        this(aodbwr, aodb, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AOtoHandle3(ArchiveObjectsDBWrite aodbwr, ArchiveObjectsDB aodb, PushTransactionsHS txnWriter) {
        this.aodb = aodb;
        this.aodbwr = aodbwr;
        this.txnWriter = txnWriter;
        try {
            this.copyData();
        }
        finally {
            aodb.close();
            aodbwr.shutdown();
            aodbwr.close();
            if (txnWriter != null) {
                txnWriter.shutdown();
                txnWriter.close();
            }
        }
    }

    private void copyData() {
        long when;
        long startTime = when = System.currentTimeMillis();
        String nodeid = "MPI4711#";
        String prefix = this.aodb.getArchiveRoots().getHandlePrefix();
        String handle = NodeIdUtils.nodeIdToHandle(nodeid, prefix);
        this.aodbwr.setArchiveRoots(this.aodb.getArchiveRoots());
        if (!this.aodbwr.canWrite()) {
            System.out.println("Target database must be writeable!");
            return;
        }
        System.out.println("Reading list of ONSITE archive objects...");
        String[] allnodes = this.aodb.getNewArchiveObjectsSince(null, true, false, false);
        System.out.println("Found " + allnodes.length + " archive objects");
        for (int i = 0; i < allnodes.length; ++i) {
            nodeid = allnodes[i];
            handle = NodeIdUtils.isNodeId(nodeid) ? NodeIdUtils.nodeIdToHandle(nodeid, prefix) : nodeid;
            try {
                this.fillHandle(handle, nodeid);
            }
            catch (UnknownNodeException une) {
                logger.error((Object)("No information available for node id: " + nodeid + " Exception: " + une));
            }
            catch (UpdateInProgressException uipe) {
                logger.error((Object)("Could not create handle " + handle + " Exception: " + uipe));
            }
            catch (IOException ioe) {
                logger.error((Object)("Could not update transaction log for handle " + handle + " Exception: " + ioe));
            }
            if ((i + 1) % 100 == 0) {
                long when2 = System.currentTimeMillis();
                System.out.print("Progress: " + (i + 1) + " of " + allnodes.length + " (" + (when2 - when) + "msec/100) done...   \r");
                when = when2;
            }
            if (this.txnWriter == null || (i + 1) % 5000 != 0) continue;
            try {
                this.txnWriter.sync();
                System.out.println("Updated transaction log timestamp at " + (i + 1));
                continue;
            }
            catch (IOException ioe) {
                logger.error((Object)("Could not update transaction log timestamp at " + (i + 1) + " Exception: " + ioe));
            }
        }
        System.out.println("Progress: " + allnodes.length);
        System.out.println("Done! Time: " + (System.currentTimeMillis() - startTime) / 1000L + " seconds");
    }

    private void fillHandle(String name, String nodeid) throws UnknownNodeException, UpdateInProgressException, IOException {
        Vector values = new Vector();
        URI uri = this.aodb.getObjectURI(nodeid);
        Timestamp crawltime = this.aodb.getObjectTimestamp(nodeid);
        long filesize = this.aodb.getObjectSize(nodeid);
        Timestamp filetime = this.aodb.getObjectFileTime(nodeid);
        boolean onsite = this.aodb.isOnSite(nodeid);
        boolean updateExisting = false;
        AccessInfo ai = null;
        String checksum = this.aodb.getObjectChecksum(nodeid);
        try {
            URI oldURI = this.aodbwr.getObjectURI(name);
            if (oldURI != null) {
                updateExisting = true;
                if (!oldURI.toString().equals(uri.toString())) {
                    logger.debug((Object)("Replaced handle: " + name + " / " + nodeid + " was at: " + oldURI + " now at: " + uri));
                } else {
                    String oldChecksum;
                    Timestamp oldFileTime;
                    Timestamp oldTime = this.aodbwr.getObjectTimestamp(name);
                    if ((oldTime != null && oldTime.equals(crawltime) || oldTime == crawltime) && ((oldFileTime = this.aodbwr.getObjectFileTime(name)) != null && oldFileTime.equals(filetime) || oldFileTime == filetime) && this.aodbwr.getObjectSize(name) == filesize && this.aodbwr.isOnSite(name) == onsite && ((oldChecksum = this.aodbwr.getObjectChecksum(name)) != null && oldChecksum.equals(checksum) || oldChecksum == checksum)) {
                        System.err.print('=');
                        return;
                    }
                    System.err.print('*');
                }
                this.aodbwr.deleteArchiveObject(name);
            } else {
                logger.debug((Object)("New handle: " + name + " / " + nodeid + " at: " + uri));
            }
        }
        catch (UnknownNodeException une) {
            updateExisting = false;
        }
        name = this.aodbwr.newArchiveObject(name, uri, crawltime, onsite, filesize, filetime, ai, checksum);
        if (this.txnWriter == null) {
            return;
        }
        if (updateExisting) {
            this.txnWriter.handleUpdated(name);
        } else {
            this.txnWriter.handleCreated(name);
        }
    }

    public static void main(String[] argv) {
        ArchiveObjectsDBWriteImplHS handleStorage = null;
        PushTransactionsHS transactionWriter = null;
        CorpusStructureDBImpl aoDb = null;
        if (argv.length < 2 || argv.length > 3) {
            System.err.println("Please provide the source corpusstructure server as 1st argument");
            System.err.println("and the directory or filename of the HS config.dct as 2nd argument");
            System.err.println("Add the HS data dir as 3rd argument if you want the Handle Server");
            System.err.println("transaction log to be updated (server must use read_only_txn_queue)");
            System.exit(-1);
        }
        if (!argv[0].matches("[a-zA-Z0-9-.]*")) {
            System.err.println("Invalid source corpusstructure server name: " + argv[0]);
            System.exit(-1);
        }
        if ((aoDb = new CorpusStructureDBImpl("jdbc:postgresql://" + argv[0] + "/corpusstructure", false, null, null)) == null || !aoDb.getStatus()) {
            System.err.println("Source database connection error!");
            System.exit(-1);
        }
        logger.info((Object)"Connection to source database established.");
        if (argv[1].startsWith("HS:")) {
            String[] argv1 = argv[1].split(":", 4);
            if (argv1.length != 4) {
                aoDb.close();
                System.err.println("Handle System login syntax: HS:adminhandle:adminindex:keyfile");
                System.exit(-1);
            }
            String authHandle = argv1[1];
            int authIndex = Integer.valueOf(argv1[2]);
            File keyFile = new File(argv1[3]);
            try {
                handleStorage = new ArchiveObjectsDBWriteImplHS(authHandle, authIndex, keyFile, false);
            }
            catch (IOException ioe) {
                aoDb.close();
                System.err.println("Target Handle System login error: " + ioe);
                System.exit(-1);
            }
        } else {
            handleStorage = new ArchiveObjectsDBWriteImplHS(argv[1]);
        }
        if (handleStorage == null || !handleStorage.getStatus()) {
            aoDb.close();
            System.err.println("Target database connection error!");
            System.exit(-1);
        }
        logger.info((Object)"Connection to target database established.");
        if (argv.length == 3) {
            try {
                transactionWriter = new PushTransactionsHS(new File(argv[2]), false);
            }
            catch (IOException ioe) {
                aoDb.close();
                handleStorage.shutdown();
                System.err.println("Error opening transaction log!");
                System.exit(-1);
            }
        }
        AOtoHandle3 work = new AOtoHandle3(handleStorage, aoDb, transactionWriter);
    }
}

