/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import mpi.bcarchive.spider.IMDIContentHandler;
import mpi.corpusstructure.AccessInfo;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.CorpusNode;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.CorpusStructureDBWrite;
import mpi.corpusstructure.CorpusStructureDBWriteImpl;
import mpi.corpusstructure.FileInfo;
import mpi.corpusstructure.Node;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.UnknownNodeException;
import mpi.util.DBConnection;
import mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class ArchiveTest {
    private static Logger logger = Logger.getLogger((String)ArchiveTest.class.getName());

    private static String addCorpusNode(CorpusStructureDBWrite csdbwr, ArchiveObjectsDBWrite aodbwr, String parentNodeId, OurURL childUrl) {
        CorpusStructureDBWrite csdb = csdbwr;
        ArchiveObjectsDBWrite aodb = aodbwr;
        if (!NodeIdUtils.isNodeId(parentNodeId) || !childUrl.getProtocol().equals("file")) {
            return "Parent must be specified by NodeId, child by file: URL";
        }
        System.out.println("Parent URI: " + aodb.getObjectURI(parentNodeId));
        String vPath = csdb.getCorpusNode(parentNodeId).getCanonicalVPath();
        System.out.println("Parent canonical vPath: " + vPath);
        if (vPath == null && !parentNodeId.equals(csdb.getRootNodeId())) {
            return "Parent node must be linked to the tree";
        }
        IMDIContentHandler imdiCH = new IMDIContentHandler();
        URI childUri = null;
        try {
            childUri = new URI(childUrl.toEncodedString());
        }
        catch (URISyntaxException use) {
            return "Child URI is invalid, exception: " + use;
        }
        FileInfo childInfo = new FileInfo(childUrl);
        try {
            imdiCH.parse(childUrl);
        }
        catch (IOException ioe) {
            return "Cannot read child IMDI corpus file: " + ioe;
        }
        catch (SAXException saxe) {
            return "Cannot parse child IMDI corpus file: " + saxe;
        }
        if (!imdiCH.getImdiType().equals("Corpus")) {
            return "Child must be a local readable corpus IMDI file";
        }
        String childNodeId = aodbwr.newArchiveObject(aodb.getArchiveRoots().uriToTableContext(childUri, aodb.getArchiveRoots().getAccessContextFromURI(childUrl.toString())), new Timestamp(System.currentTimeMillis()), true, childInfo.getSize(), new Timestamp(1L), new AccessInfo("nobody", "nobody"));
        if (childNodeId == null) {
            return "Could not add node for: " + childUrl;
        }
        if (!csdbwr.setNode(childNodeId, 2, "text/x-imdi+xml", imdiCH.getName(), imdiCH.getTitle())) {
            System.out.println("Could not set name / title / format (mimetype) for child: " + childNodeId);
        }
        if (!csdbwr.addLinkToTree(childNodeId, parentNodeId, true, true)) {
            System.out.println("Could not add link to: " + childNodeId);
        }
        System.out.println("Added node: " + childNodeId + " for URL: " + childUrl);
        return null;
    }

    private static void showHelp() {
        System.out.println("Test tool. First argument of ArchiveTest must be a JDBC URL! Example:");
        System.out.println("java PACKAGE.ArchiveTest jdbc:postgresql://HOST:PORT/DB -sql select...");
        System.out.println();
        System.out.println("ArchiveTest options include: ");
        System.out.println();
        System.out.println("-sql QUERY, now also supports statements which update the database");
        System.out.println(" use -user USERNAME -passwd PASSWORD for non read-only SQL queries");
        System.out.println();
        System.out.println("-addnode NODEID URL, to create a node for URL and link it below NODEID");
        System.out.println(" in the database. URL must be the file: URL of a readable IMDI corpus");
        System.out.println(" file. NODEID must already be linked. Use -user USERNAME -passwd PASSWORD");
        System.out.println();
        System.out.println("-fileinfo URL, which checks file size and timestamp in a similar");
        System.out.println(" way as the ArchiveCrawler (useful for crawler log interpretation)");
        System.out.println();
        System.out.println("-translate DATE, to list the NAME paths of all archive objects");
        System.out.println(" which are newer than the given date, as parsed by");
        System.out.println(" java.sql.Timestamp.valueOf(DATE+\" 00:00:00\"), e.g. as a benchmark.");
        System.out.println("-translate NODEID, to list the NAME paths of descendants of a node.");
        System.out.println();
        System.out.println("-list URL [typenumber [format [user]]], to list all resources");
        System.out.println(" which are descendants of URL (use \"all\" to get all resources,");
        System.out.println(" getResourcesFromArchive, or some URL which will be resolved by");
        System.out.println(" getObjectId to a NodeId, to query getDescendants instead...).");
        System.out.println(" Optional constraints are type (-1 for all), format (* for any, default),");
        System.out.println(" user (only files readable by that user, default is *, don't filter).");
        System.out.println(" List contains URL, NodeId, name, type, format.");
        System.out.println();
        System.out.println("-count URL [typenumber [format [user]]], to just count the number");
        System.out.println(" of matching resources");
        System.out.println();
        System.out.println("-getdescendantresources NodeId, list all descendants of a given NodeId,");
        System.out.println(" using getDescendantResources.");
        System.out.println();
        System.out.println("-listparents NodeId, list all direct parents, using getParentNodes.");
        System.out.println();
        System.out.println("-findbynamepath NAMEPATH, to find the NodeId and the VPath");
        System.out.println(" (/ separated list of NodeIds leading to the node) for a given name");
        System.out.println(" path (/ separated list of node names). Useful for AMSDB setup,");
        System.out.println(" as that database stores tables with namepath and nodeid columns");
        System.out.println(" but is never updated by crawler or LAMS, which means that it can");
        System.out.println(" become necessary to find back the NodeId for a given name path.");
        System.out.println(" Parts of the implementation of findbynamepath should become part");
        System.out.println(" of AMS to allow it to repair its own table data.");
    }

    private static void doSQLcommand(DBConnection db, String query) throws SQLException {
        if (db == null) {
            logger.error((Object)"doSQLcommand: No DBConnection");
            return;
        }
        if (query.toUpperCase().startsWith("SELECT")) {
            ResultSet rs = db.getConnection().createStatement().executeQuery(query);
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                for (int i = 0; i < columns; ++i) {
                    System.out.print(rs.getObject(i + 1) + " ");
                }
                System.out.println("");
            }
        } else {
            int changed = db.getConnection().createStatement().executeUpdate(query);
            System.out.println("Updated " + changed + " rows");
            if (db.dbType == 2) {
                System.out.println("Writing HSQLDB back to disk...");
                try {
                    db.getConnection().createStatement().execute("SHUTDOWN COMPACT");
                }
                catch (SQLException sqle) {
                    logger.error((Object)"HSQLDB shutdown error: ", (Throwable)sqle);
                }
                System.out.println("Updated HSQLDB written.");
            }
        }
    }

    private static void namePathList(CorpusStructureDB cs, ArchiveObjectsDB ao, String selection) {
        if (cs == null || ao == null) {
            logger.error((Object)"namePathList: No CSDB / AODB connection");
            System.exit(1);
        }
        String[] archiveobjs = null;
        if (NodeIdUtils.isNodeId(selection)) {
            int type = -1;
            String[] formats = null;
            logger.debug((Object)("archive objects below: " + selection));
            archiveobjs = cs.getDescendants(selection, type, formats, "ignore", true);
        } else {
            logger.debug((Object)("new archive objects since: '" + selection + " 00:00:00'"));
            archiveobjs = ao.getNewArchiveObjectsSince(Timestamp.valueOf(selection + " 00:00:00"), true, false, false);
        }
        String[] results = cs.translateToNamePath(archiveobjs);
        for (int j = 0; j < results.length; ++j) {
            System.out.println(j + " " + archiveobjs[j] + " -> " + results[j]);
        }
    }

    private static int listOrCount(CorpusStructureDB cs, ArchiveObjectsDB ao, boolean countOnly, int type, String format, String who, String urlstr) {
        if (cs == null || ao == null) {
            logger.error((Object)"listOrCount: No CSDB / AODB connection");
            return -1;
        }
        String[] formats = new String[]{format};
        logger.debug((Object)("ArchiveTest: " + (countOnly ? "count" : "list") + " type=" + type + ", formats=" + format + ", user=" + who));
        String[] results = null;
        if (urlstr.equals("all")) {
            results = cs.getResourcesFromArchive(type, formats, who, true, true);
        } else {
            String id = null;
            try {
                id = ao.getObjectId(new OurURL(urlstr));
            }
            catch (MalformedURLException mue) {
                logger.error((Object)("Malformed URL: " + urlstr));
            }
            if (id == null) {
                logger.error((Object)("URL not found in DB: " + urlstr));
                return -1;
            }
            results = cs.getDescendants(id, type, formats, who, true);
        }
        if (results == null) {
            logger.info((Object)"No results");
            return 0;
        }
        if (countOnly) {
            return results.length;
        }
        for (int i = 0; i < results.length; ++i) {
            Node node = cs.getNode(results[i]);
            OurURL hurl = ao.getObjectURL(node.getNodeId(), 1);
            logger.info((Object)(i + ":\t" + hurl + "\t" + node.getNodeId() + "\t" + node.getName() + "\t" + node.getNodeType() + "\t" + node.getFormat()));
        }
        return results.length;
    }

    private static String findByNamePath(ArchiveObjectsDB ao, CorpusStructureDB cs, String namePath) {
        if (ao == null || cs == null) {
            logger.error((Object)"findByNamePath: No CSDB / AODB connection");
            return null;
        }
        Vector<String> nodeIds = new Vector<String>();
        String[] nameParts = namePath.split("/");
        String nodeId = cs.getRootNodeId();
        nodeIds.add(nodeId);
        int level = 1;
        if (nameParts.length < 2 || !nameParts[0].equals("") || !nameParts[level].equals(cs.getNode(nodeId).getName())) {
            logger.info((Object)("namepath length: " + nameParts.length));
            logger.info((Object)("namepart 0: " + nameParts[0]));
            System.out.println("Database only has name paths starting with '/" + cs.getNode(nodeId).getName() + "' not with '" + nameParts[0] + "/" + nameParts[level] + "'");
            return null;
        }
        ++level;
        logger.debug((Object)("Level " + nameParts.length + " search for " + namePath));
        do {
            String[] childIds;
            if ((childIds = cs.getSubnodes(nodeId)) == null) {
                logger.error((Object)("getSubnodes(" + nodeId + ") returned null, search aborted"));
                return null;
            }
            nodeId = null;
            for (int i = 0; i < childIds.length; ++i) {
                try {
                    if (!nameParts[level].equals(cs.getNode(childIds[i]).getName())) continue;
                    if (nodeId != null) {
                        logger.warn((Object)("Ambiguity: Both " + nodeId + " and " + childIds[i] + " have name " + nameParts[level]));
                    }
                    nodeId = childIds[i];
                    continue;
                }
                catch (UnknownNodeException une) {
                    logger.warn((Object)("Dead link in corpusstructure: " + childIds[i]));
                    try {
                        logger.warn((Object)("Archiveobject for " + childIds[i] + " is: " + ao.getObjectSize(childIds[i]) + " byte file at " + ao.getObjectURI(childIds[i])));
                        continue;
                    }
                    catch (UnknownNodeException une2) {
                        logger.warn((Object)("No archiveobject: " + childIds[i]));
                    }
                }
            }
            if (nodeId == null) {
                System.out.println("No child with name '" + nameParts[level] + "' found, search aborted");
                return null;
            }
            nodeIds.add(nodeId);
        } while (nameParts.length > ++level);
        Enumeration partEnum = nodeIds.elements();
        String vPath = "";
        while (partEnum.hasMoreElements()) {
            String anId = (String)partEnum.nextElement();
            String theInfo = "";
            vPath = !partEnum.hasMoreElements() ? vPath + " --> " : vPath + "/";
            vPath = vPath + anId;
            try {
                theInfo = "" + ao.getObjectSize(anId) + " bytes,\tURL: " + ao.getObjectURI(anId);
            }
            catch (UnknownNodeException une) {
                theInfo = "no archiveobject";
            }
            System.out.println("" + anId + "   \t'" + cs.getNode(anId).getName() + "'  --> " + theInfo);
        }
        logger.debug((Object)("Query: " + namePath));
        logger.debug((Object)("vPath: " + vPath));
        System.out.println("Found: " + nodeId);
        System.out.println("Canonical vpath of this node: " + cs.getCanonicalVPath(nodeId));
        return vPath;
    }

    private static void listParents(CorpusStructureDB cs, ArchiveObjectsDB ao, String nodeId) {
        if (cs == null || ao == null) {
            logger.error((Object)"listParents: No CSDB / AODB connection");
            return;
        }
        String[] parentIds = null;
        try {
            parentIds = cs.getParentNodes(nodeId);
        }
        catch (UnknownNodeException une) {
            System.out.println("No such node - no parent nodes: " + nodeId);
            return;
        }
        if (parentIds == null || parentIds.length == 0) {
            System.out.println("Nothing links to node " + nodeId);
            return;
        }
        logger.debug((Object)("Number of files linking to " + nodeId + " is: " + parentIds.length));
        for (int i = 0; i < parentIds.length; ++i) {
            String theInfo = "";
            String anId = parentIds[i];
            try {
                theInfo = "" + ao.getObjectSize(anId) + " bytes, \tURL: " + ao.getObjectURI(anId);
            }
            catch (UnknownNodeException une) {
                theInfo = "no archiveobject";
            }
            System.out.println(anId + "   \t--> " + theInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            logger.error((Object)"ArchiveTest: No arguments");
            System.out.println("ArchiveTest must have at least a dbname and a base URL or another option as arguments");
            System.out.println("ArchiveTest -help shows a list of the supported options");
            System.exit(1);
        }
        String user = null;
        String passwd = null;
        String dbname = args[0];
        int ai = 1;
        if (dbname.startsWith("-help") || dbname.startsWith("--help")) {
            ai = 0;
        } else if (args.length < 2) {
            logger.error((Object)"ArchiveTest: No arguments");
            System.out.println("ArchiveTest must have at least a dbname and a base URL or another option as arguments");
            System.out.println("ArchiveTest -help shows a list of the supported options");
            System.exit(1);
        }
        while (ai < args.length) {
            if (args[ai].equals("-user")) {
                user = args[ai + 1];
                ai += 2;
                continue;
            }
            if (args[ai].equals("-passwd")) {
                passwd = args[ai + 1];
                ai += 2;
                continue;
            }
            if (args[ai].equals("-deleteArchiveObjectsTable")) {
                if (args.length > ai + 1 && args[ai + 1].equals("positively")) {
                    long whence = System.currentTimeMillis() + 10000L;
                    System.out.println("Will delete the whole archiveobjects table!");
                    while (System.currentTimeMillis() < whence) {
                        long n = whence - System.currentTimeMillis();
                        System.out.print("" + n + " msec left to abort\r");
                    }
                    System.out.println("\nDeleting archiveobjects table...");
                    CorpusStructureDBWriteImpl csdbwr = new CorpusStructureDBWriteImpl(dbname, false, user, passwd);
                    csdbwr.deleteArchiveObjectsTable(42);
                    System.out.println("Writing changes to disk...");
                    csdbwr.shutdown();
                    System.out.println("Table deleted.");
                    System.exit(0);
                } else {
                    System.out.println("Please confirm by providing the magic string after -deleteArchiveObjectsTable.");
                }
                System.exit(1);
                continue;
            }
            if (args[ai].equals("-addnode")) {
                if (args.length <= ai + 2) {
                    System.out.println("Addnode requires a parent NodeId and a child file: URL as parameters.");
                    System.exit(1);
                }
                String parentNodeId = args[ai + 1];
                OurURL childUrl = null;
                try {
                    childUrl = new OurURL(args[ai + 2]);
                }
                catch (MalformedURLException mue) {
                    System.out.println("Child URL is invalid, exception: " + mue);
                    System.exit(1);
                }
                CorpusStructureDBWriteImpl csdbwri = new CorpusStructureDBWriteImpl(dbname, false, user, passwd);
                String result = ArchiveTest.addCorpusNode(csdbwri, csdbwri, parentNodeId, childUrl);
                if (result != null) {
                    System.out.println("Error: " + result);
                }
                csdbwri.shutdown();
                csdbwri.close();
                System.exit(result != null ? 1 : 0);
                continue;
            }
            if (args[ai].equals("-sql")) {
                Object var10_30;
                String query = args[ai + 1];
                ai += 2;
                while (ai < args.length) {
                    query = query + " " + args[ai];
                    ++ai;
                }
                DBConnection db = null;
                try {
                    try {
                        db = new DBConnection(dbname, user, passwd, "ArchiveTest:main()");
                        logger.info((Object)("SQL query: " + query));
                        ArchiveTest.doSQLcommand(db, query);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        logger.error((Object)"Exception: ", (Throwable)e);
                        System.exit(1);
                        var10_30 = null;
                        if (db == null) continue;
                        db.close();
                        continue;
                    }
                    var10_30 = null;
                    if (db == null) continue;
                    db.close();
                    continue;
                }
                catch (Throwable throwable) {
                    var10_30 = null;
                    if (db == null) throw throwable;
                    db.close();
                    throw throwable;
                }
            }
            if (args[ai].equals("-fileinfo")) {
                try {
                    FileInfo fi = new FileInfo(new OurURL(args[ai + 1]));
                    System.out.println("File info for URL: " + args[ai + 1]);
                    if (fi.getSize() == 0L && fi.getTime() == 0L) {
                        System.out.println("File is not accessible");
                    } else {
                        System.out.println("File size: " + fi.getSize());
                        System.out.println("File date: " + new Timestamp(fi.getTime()));
                    }
                    System.exit(0);
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    System.out.println("-fileinfo requires an URL as argument");
                }
                catch (MalformedURLException mue) {
                    System.out.println("No valid URL: " + args[ai + 1]);
                }
                System.exit(1);
                continue;
            }
            if (args[ai].equals("-translate")) {
                Object var12_33;
                CorpusStructureDBImpl db = new CorpusStructureDBImpl(dbname, false, user, passwd);
                try {
                    try {
                        ArchiveTest.namePathList(db, db, args[ai + 1]);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        logger.error((Object)("ArchiveTest: error: " + e));
                        e.printStackTrace();
                        System.exit(1);
                        var12_33 = null;
                        db.close();
                        continue;
                    }
                    var12_33 = null;
                    db.close();
                    continue;
                }
                catch (Throwable throwable) {
                    var12_33 = null;
                    db.close();
                    throw throwable;
                }
            }
            if (args[ai].equals("-list") || args[ai].equals("-count")) {
                long end;
                Object var16_36;
                int type = 92;
                String format = "*";
                String who = "ignore";
                boolean countOnly = args[ai].equals("-count");
                String urlstr = args[ai + 1];
                if (args.length > ai + 2) {
                    type = Integer.parseInt(args[ai + 2]);
                }
                if (args.length > ai + 3) {
                    format = args[ai + 3];
                }
                if (args.length > ai + 4) {
                    who = args[ai + 4];
                }
                CorpusStructureDBImpl db = new CorpusStructureDBImpl(dbname, false, user, passwd);
                long start = System.currentTimeMillis();
                int nresults = -1;
                try {
                    try {
                        nresults = ArchiveTest.listOrCount(db, db, countOnly, type, format, who, urlstr);
                        System.exit(0);
                    }
                    catch (Exception e) {
                        logger.error((Object)("ArchiveTest: error: " + e));
                        e.printStackTrace();
                        var16_36 = null;
                        end = System.currentTimeMillis();
                        logger.info((Object)("Took " + (end - start) + " ms, nresults=" + nresults));
                        db.close();
                    }
                    var16_36 = null;
                    end = System.currentTimeMillis();
                    logger.info((Object)("Took " + (end - start) + " ms, nresults=" + nresults));
                    db.close();
                }
                catch (Throwable throwable) {
                    var16_36 = null;
                    end = System.currentTimeMillis();
                    logger.info((Object)("Took " + (end - start) + " ms, nresults=" + nresults));
                    db.close();
                    throw throwable;
                }
                System.exit(1);
                continue;
            }
            if (args[ai].equals("-test") || args[ai].equals("-getdescendantresources")) {
                Object var20_38;
                CorpusStructureDBImpl cs = new CorpusStructureDBImpl(dbname, false, user, passwd);
                if (cs == null) {
                    logger.error((Object)"getDescendantResources: No CSDB connection");
                    System.exit(1);
                }
                try {
                    try {
                        CorpusNode[] nodeids = cs.getDescendantResources(args[ai + 1], true, "ignore", "ignore");
                        if (nodeids == null) {
                            logger.warn((Object)"getDescendantResources returned null");
                        } else {
                            for (int i = 0; i < nodeids.length; ++i) {
                                logger.info((Object)(nodeids[i].getNodeId() + " " + nodeids[i].getName()));
                            }
                        }
                        System.exit(0);
                    }
                    catch (Exception e) {
                        logger.error((Object)"ArchiveTest: error: ", (Throwable)e);
                        System.exit(1);
                        var20_38 = null;
                        cs.close();
                        continue;
                    }
                    var20_38 = null;
                    cs.close();
                    continue;
                }
                catch (Throwable throwable) {
                    var20_38 = null;
                    cs.close();
                    throw throwable;
                }
            }
            if (args[ai].equals("-findbynamepath")) {
                Object var22_39;
                if (ai + 1 >= args.length) {
                    logger.error((Object)"ArchiveTest: no name path given");
                    System.exit(1);
                }
                CorpusStructureDBImpl db = new CorpusStructureDBImpl(dbname, false, user, passwd);
                String namePath = args[ai + 1];
                ai += 2;
                while (ai < args.length) {
                    namePath = namePath + " " + args[ai];
                    ++ai;
                }
                try {
                    System.exit(ArchiveTest.findByNamePath(db, db, namePath) == null ? 1 : 0);
                    var22_39 = null;
                    db.close();
                    continue;
                }
                catch (Throwable throwable) {
                    var22_39 = null;
                    db.close();
                    throw throwable;
                }
            }
            if (args[ai].equals("-listparents")) {
                Object var24_40;
                if (ai + 1 >= args.length || !NodeIdUtils.isNodeId(args[ai + 1])) {
                    logger.error((Object)"ArchiveTest: no nodeId given");
                    System.exit(1);
                }
                CorpusStructureDBImpl db = new CorpusStructureDBImpl(dbname, false, user, passwd);
                try {
                    ArchiveTest.listParents(db, db, args[ai + 1]);
                    var24_40 = null;
                    db.close();
                }
                catch (Throwable throwable) {
                    var24_40 = null;
                    db.close();
                    throw throwable;
                }
                System.exit(0);
                continue;
            }
            if (args[ai].startsWith("-help") || args[ai].startsWith("--help")) {
                ArchiveTest.showHelp();
                System.exit(0);
                continue;
            }
            if (args[ai].startsWith("-")) {
                System.out.println("Option not recognized, please read -help screen: " + args[ai]);
                System.exit(1);
                continue;
            }
            System.out.println("Option not recognized, please read -help screen: " + args[ai]);
            System.exit(1);
        }
    }
}

