/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.net.URI;
import java.sql.Timestamp;
import java.util.Hashtable;
import java.util.TreeSet;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.CorpusNode;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.Node;
import mpi.corpusstructure.UnknownNodeException;
import org.apache.log4j.Logger;

public class ConsistencyCheck {
    private static Logger logger = Logger.getLogger((String)ConsistencyCheck.class.getName());
    private static ArchiveObjectsDB ao;
    private static CorpusStructureDB cs;
    private static Hashtable subnodeHash;
    private static int subnodeCount;
    private static TreeSet badParentsNC;
    private static TreeSet badParentsSN;
    private static TreeSet badChildrenNC;

    private static String[] getSubnodes(String nodeid) throws UnknownNodeException {
        String[] result = (String[])subnodeHash.get(nodeid);
        if (result != null) {
            return result;
        }
        result = cs.getSubnodes(nodeid);
        if (result == null) {
            return result;
        }
        if (subnodeCount > 350000) {
            logger.info((Object)("CS: Flushed getSubnodes cache, had " + subnodeCount + " subnodes of " + subnodeHash.size() + " nodes"));
            subnodeHash.clear();
            subnodeCount = 0;
        }
        subnodeCount += result.length;
        subnodeHash.put(nodeid, result);
        return result;
    }

    private static int checkNodeAO(String nodeid) throws UnknownNodeException {
        URI uri = ao.getObjectURI(nodeid);
        int shouldBeLinked = 1;
        boolean isAccessible = ao.isAccessible(nodeid);
        if (uri == null || !uri.toString().startsWith("http")) {
            if (isAccessible) {
                logger.error((Object)("AO: Bad accessible URI, not http:  " + uri + " " + nodeid));
            } else {
                logger.info((Object)("AO: Bad inaccessible URI, not http:  " + uri + " " + nodeid));
            }
            shouldBeLinked = -1;
        } else if (!isAccessible) {
            logger.info((Object)("AO: Normal URI but inaccessible:  " + uri + " " + nodeid));
            shouldBeLinked = 0;
        }
        if (ao.getObjectTimestamp(nodeid) == null) {
            logger.warn((Object)("AO: No crawltime:       " + uri + " " + nodeid));
        }
        if (ao.getObjectFileTime(nodeid) == null) {
            if (isAccessible) {
                logger.info((Object)("AO: No file time known for accessible URI: " + uri + " " + nodeid));
            }
            if (!isAccessible) {
                logger.debug((Object)("AO: No file time known for inaccessible URI: " + uri + " " + nodeid));
            }
            if (shouldBeLinked > 0) {
                shouldBeLinked = 0;
            }
        }
        return shouldBeLinked;
    }

    private static void checkNodeCS(String nodeid, int relevance) {
        Node node = null;
        try {
            node = cs.getNode(nodeid);
        }
        catch (UnknownNodeException une) {
            // empty catch block
        }
        if (node == null) {
            String vp = null;
            try {
                vp = cs.getCanonicalVPath(nodeid);
            }
            catch (UnknownNodeException une) {
                // empty catch block
            }
            if (vp == null) {
                if (relevance == 0) {
                    logger.info((Object)("CS: Not fully accessible unlinked node has no corpusnode data: " + nodeid));
                }
                if (relevance == 1) {
                    logger.info((Object)("CS: Normal unlinked node has no corpusnode data: " + nodeid));
                }
            } else {
                if (relevance == 0) {
                    logger.warn((Object)("CS: Not fully accessible but linked node has no corpusnode data: " + nodeid + " canonical vpath: " + vp));
                }
                if (relevance == 1) {
                    logger.error((Object)("CS: Normal linked node has no corpusnode data: " + nodeid + " canonical vpath: " + vp));
                }
            }
            return;
        }
        String info = " CN[resource " + node.getName() + " ...]";
        if (node.getNodeType() == 1 || node.getNodeType() == 2 || node.getNodeType() == 128) {
            info = " CN[name=" + node.getName() + " title=" + node.getTitle() + "]";
        }
        info = info + " " + nodeid;
        CorpusNode cnode = null;
        String canonicalPath = null;
        String[] vpaths = null;
        try {
            cnode = cs.getCorpusNode(nodeid);
            canonicalPath = cnode.getCanonicalVPath();
            vpaths = cnode.getVPaths();
        }
        catch (UnknownNodeException une) {
            // empty catch block
        }
        if (vpaths == null || vpaths.length == 0) {
            if (relevance == 0) {
                logger.info((Object)("CS: Not fully accessible node is not linked: " + info));
            }
            if (relevance == 1) {
                logger.info((Object)("CS: Normal node is not linked: " + info));
            }
            boolean hasParents = true;
            try {
                String[] parents = cs.getParentNodes(nodeid);
                if (parents == null || parents.length == 0) {
                    hasParents = false;
                }
            }
            catch (UnknownNodeException une) {
                hasParents = false;
            }
            if (hasParents) {
                logger.error((Object)("CS: Node has no canonical path but has parents: " + nodeid));
            }
            return;
        }
        URI uri = null;
        try {
            uri = ao.getObjectURI(nodeid);
        }
        catch (Exception e) {
            // empty catch block
        }
        info = " uri: " + (uri == null ? "NONE" : uri.toString()) + info;
        if (node.getNodeType() == 1 || node.getNodeType() == 2 || node.getNodeType() == 128) {
            int leafCount = 0;
            try {
                String[] subs = ConsistencyCheck.getSubnodes(nodeid);
                if (subs != null) {
                    leafCount = subs.length;
                }
            }
            catch (Exception e) {
                logger.error((Object)("CS: Node getSubnodes error: " + e + " for node: " + info));
            }
            if (leafCount < 1) {
                if (relevance == 0) {
                    logger.info((Object)("CS: Not fully accessible " + (node.getNodeType() == 2 ? "CORPUS" : (node.getNodeType() == 2 ? "SESSION" : "CATALOGUE")) + " is empty: " + info));
                }
                if (relevance == 1) {
                    logger.warn((Object)("CS: Normal accessible " + (node.getNodeType() == 2 ? "CORPUS" : (node.getNodeType() == 2 ? "SESSION" : "CATALOGUE")) + " is empty: " + info));
                }
            }
        }
        if (relevance == 0) {
            logger.warn((Object)("CS: Dead link / not fully accessible: " + info));
        }
        if (relevance == -1) {
            logger.error((Object)("CS: Bad node, should not be linked: " + info));
        }
        if (!(cs.getRootNodeId().equals(nodeid) || canonicalPath != null && canonicalPath.length() >= 1)) {
            logger.error((Object)("CS: No or empty canonical vpath for: " + nodeid + " --> " + canonicalPath + info));
        }
        if (relevance == 0 || relevance == -1) {
            String pinfo = "";
            try {
                String[] parents = cs.getParentNodes(nodeid);
                if (parents != null && parents.length > 0) {
                    pinfo = parents[0];
                }
            }
            catch (UnknownNodeException une) {
                // empty catch block
            }
            if (pinfo.length() > 0) {
                URI puri = null;
                try {
                    puri = ao.getObjectURI(pinfo);
                }
                catch (Exception e) {
                    // empty catch block
                }
                pinfo = pinfo + " uri: " + (puri == null ? "NONE" : puri.toString());
            } else {
                pinfo = "UNKNOWN";
            }
            logger.info((Object)("CS: Parent of previous " + (relevance == 0 ? "Dead link" : "Bad node") + " is: " + pinfo));
        }
        if (vpaths.length == 1) {
            return;
        }
        String[] parents = null;
        try {
            parents = cs.getParentNodes(nodeid);
        }
        catch (UnknownNodeException une) {
            logger.error((Object)("CS: Exception in getParentNodes: " + une + " for node: " + info));
        }
        if (parents == null || parents.length < 1) {
            logger.error((Object)("CS: Node is linked but has no parents?: " + info));
            return;
        }
        if (parents.length > 1) {
            String parentString = "" + parents.length;
            for (int i = 0; i < parents.length; ++i) {
                parentString = parentString + ", " + parents[i];
            }
            if (relevance == 0) {
                logger.debug((Object)("CS: Not fully accessible node has several direct parents: " + info + " P[" + parentString + "]"));
            }
            if (relevance == 1) {
                if (ao.isOnSite(nodeid)) {
                    logger.warn((Object)("CS: Local node has several direct parents: " + info + " P[" + parentString + "]"));
                } else {
                    logger.info((Object)("CS: Remote node has several direct parents: " + info + " P[" + parentString + "]"));
                }
            }
        }
        for (int i = 0; i < parents.length; ++i) {
            String[] childrenOfParent = null;
            try {
                childrenOfParent = ConsistencyCheck.getSubnodes(parents[i]);
            }
            catch (UnknownNodeException une) {
                logger.error((Object)("CS: Node getSubnodes error: " + une + " for node: " + parents[i] + " which is a parent of: " + nodeid));
                badParentsSN.add(parents[i]);
            }
            boolean found = false;
            for (int j = 0; childrenOfParent != null && j < childrenOfParent.length && !found; ++j) {
                if (!nodeid.equals(childrenOfParent[j])) continue;
                found = true;
            }
            if (found) continue;
            if (uri == null) {
                try {
                    uri = ao.getObjectURI(nodeid);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            logger.error((Object)("CS: Node is no child of its parent?: " + nodeid + " parent: " + parents[i] + " node info:" + info));
            badParentsNC.add(parents[i]);
            badChildrenNC.add(nodeid);
        }
    }

    private static void listBadOnes() {
        StringBuffer onebad = new StringBuffer("CS: Bad parents which are good children:");
        StringBuffer twobad = new StringBuffer("CS: Bad parents which are also bad children:");
        boolean oneused = false;
        boolean twoused = false;
        for (String badParent : badParentsNC) {
            if (badChildrenNC.contains(badParent)) {
                twobad.append(" ").append(badParent);
                twoused = true;
                continue;
            }
            onebad.append(" ").append(badParent);
            oneused = true;
        }
        if (oneused) {
            logger.error((Object)onebad.append(" .").toString());
        } else {
            logger.info((Object)onebad.append(" None.").toString());
        }
        if (twoused) {
            logger.error((Object)twobad.append(" .").toString());
        } else {
            logger.info((Object)twobad.append(" None.").toString());
        }
        onebad.setLength(0);
        oneused = false;
        twobad.setLength(0);
        twoused = false;
        onebad.append("CS: Bad children which are good parents:");
        for (String badChild : badChildrenNC) {
            if (badParentsNC.contains(badChild)) continue;
            onebad.append(" ").append(badChild);
            oneused = true;
        }
        if (oneused) {
            logger.error((Object)onebad.append(" .").toString());
        } else {
            logger.info((Object)onebad.append(" None.").toString());
        }
        onebad.setLength(0);
        oneused = false;
        twobad.setLength(0);
        twoused = false;
        if (!badParentsSN.isEmpty()) {
            onebad.append("CS: Parents with getSubnodes problems which are NOT bad parents:");
            twobad.append("CS: Parents with getSubnodes problems which are also bad parents:");
            for (String badParent : badParentsSN) {
                if (badParentsNC.contains(badParent)) {
                    twobad.append(" ").append(badParent);
                    continue;
                }
                onebad.append(" ").append(badParent);
            }
            if (oneused) {
                logger.error((Object)onebad.append(" .").toString());
            } else {
                logger.info((Object)onebad.append(" None.").toString());
            }
            if (twoused) {
                logger.error((Object)twobad.append(" .").toString());
            } else {
                logger.info((Object)twobad.append(" None.").toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("ConsistencyCheck must have at least a dbname as argument");
            System.out.println("Optional parameters: -user NAME -passwd PASS -limit NUMBER");
            System.out.println("Use option -node NODEID to check only one node.");
            System.exit(1);
        }
        String user = null;
        String passwd = null;
        String node = null;
        String dbname = args[0];
        int limit = 0x40000000;
        int ai = 1;
        while (ai < args.length) {
            if (args[ai].equals("-limit")) {
                limit = Integer.parseInt(args[ai + 1]);
                ai += 2;
                continue;
            }
            if (args[ai].equals("-user")) {
                user = args[ai + 1];
                ai += 2;
                continue;
            }
            if (args[ai].equals("-passwd")) {
                passwd = args[ai + 1];
                ai += 2;
                continue;
            }
            if (args[ai].equals("-node")) {
                node = args[ai + 1];
                ai += 2;
                continue;
            }
            System.out.println("Option ignored: " + args[ai]);
            ++ai;
        }
        CorpusStructureDBImpl db = new CorpusStructureDBImpl(dbname, false, user, passwd);
        if (db == null) {
            System.out.println("Cannot connect to CS DB. Give no options to get a help message.");
            System.exit(1);
        }
        ao = db;
        cs = db;
        db = null;
        try {
            String[] archiveobjs = new String[]{node};
            if (node == null) {
                archiveobjs = ao.getNewArchiveObjectsSince(Timestamp.valueOf("1970-01-01 00:00:00"), false, false, false);
            }
            if (archiveobjs.length > 1) {
                logger.info((Object)("Checking " + archiveobjs.length + " nodes"));
            }
            if (node != null) {
                logger.info((Object)("Checking node " + node));
            }
            for (int i = 0; i < archiveobjs.length && i < limit; ++i) {
                try {
                    int relevance = ConsistencyCheck.checkNodeAO(archiveobjs[i]);
                    ConsistencyCheck.checkNodeCS(archiveobjs[i], relevance);
                }
                catch (Exception e) {
                    logger.error((Object)("XX: Exception: " + e + " while checking node: " + archiveobjs[i]));
                    e.printStackTrace();
                }
                if ((i + 1) % 1000 != 0) continue;
                String max = null;
                max = limit < archiveobjs.length ? "first " + limit + " of all " + archiveobjs.length + " nodes" : "all " + archiveobjs.length + " nodes";
                logger.info((Object)("XX: Done with " + (i + 1) + " nodes out of " + max));
                System.err.println("Done with " + (i + 1) + " nodes out of " + max);
            }
            Object var12_13 = null;
            ao.close();
            cs.close();
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            ao.close();
            cs.close();
            ConsistencyCheck.listBadOnes();
            throw throwable;
        }
        ConsistencyCheck.listBadOnes();
        System.exit(0);
    }

    static {
        subnodeHash = new Hashtable();
        subnodeCount = 0;
        badParentsNC = new TreeSet();
        badParentsSN = new TreeSet();
        badChildrenNC = new TreeSet();
    }
}

