/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.ProgressMonitor;
import mpi.bcarchive.spider.IMDIContentHandler;
import mpi.bcarchive.spider.IMDINode;
import mpi.corpusstructure.AccessInfo;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.CorpusStructureDB;
import mpi.corpusstructure.CorpusStructureDBWrite;
import mpi.corpusstructure.FileInfo;
import mpi.corpusstructure.Node;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.UnknownNodeException;
import mpi.corpusstructure.UpdateInProgressException;
import mpi.imdidb.IMDIDB;
import mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class FileHandlers {
    private static Logger logger = Logger.getLogger((String)FileHandlers.class.getName());
    private String ourhost;
    private String ourdomain;
    private int accessContext;
    private ProgressMonitor progressMonitor;
    private IMDIContentHandler imdiCH;
    private CorpusStructureDB cs = null;
    private CorpusStructureDBWrite cswr = null;
    private ArchiveObjectsDB ao = null;
    private ArchiveObjectsDBWrite aowr = null;
    private ArchiveObjectsDBWrite aowr2 = null;
    private IMDIDB imdidb = null;
    private boolean followHTTPlinks = false;
    private boolean checkHTTPheaders = false;
    private boolean bootstrap = false;
    private boolean createFromScratch = false;
    private int uridBasedIdCount = 0;
    private int freshIdCount = 0;
    private String lastErrorMessage = null;
    private Hashtable visitedNodes = new Hashtable();
    private Hashtable allSessionsHash = new Hashtable();
    Hashtable childLinkHash = new Hashtable();
    Hashtable badIMDIHash = new Hashtable();

    public FileHandlers(String hostname, String domainname, int context, boolean allowAbsolute, ProgressMonitor progressInfo) {
        this.ourhost = hostname;
        this.ourdomain = domainname;
        this.accessContext = context;
        this.imdiCH = new IMDIContentHandler();
        if (allowAbsolute) {
            this.imdiCH.setBlockAbsolute(false);
        }
        this.progressMonitor = progressInfo;
    }

    public void setDatabases(CorpusStructureDB corpusStructure, ArchiveObjectsDB archiveObjects, CorpusStructureDBWrite corpusStructureWrite, ArchiveObjectsDBWrite archiveObjectsWrite, ArchiveObjectsDBWrite archiveObjectsMirror, IMDIDB imdiMetadata) {
        this.cs = corpusStructure;
        this.ao = archiveObjects;
        this.cswr = corpusStructureWrite;
        this.aowr = archiveObjectsWrite;
        this.aowr2 = archiveObjectsMirror;
        this.imdidb = imdiMetadata;
    }

    public void setHttpMode(boolean followRemoteLinks, boolean checkHeaders) {
        this.followHTTPlinks = followRemoteLinks;
        this.checkHTTPheaders = checkHeaders;
    }

    public void setBootstrapMode(boolean rebuildStructure, boolean ignoreOldArchiveObjects) {
        this.bootstrap = rebuildStructure;
        this.createFromScratch = this.bootstrap && ignoreOldArchiveObjects;
    }

    public static void setLogger(Logger l) {
        logger = l;
    }

    public String getLastErrorMessage() {
        return this.lastErrorMessage;
    }

    public Hashtable getBadIMDIHash() {
        return this.badIMDIHash;
    }

    public Hashtable getChildLinkHash() {
        return this.childLinkHash;
    }

    public Hashtable getSessionsHash() {
        return this.allSessionsHash;
    }

    public boolean inOurDomain(OurURL url) {
        if (url.getProtocol().equals("file")) {
            return true;
        }
        String host = url.getHost();
        if (host.equals(this.ourhost)) {
            return true;
        }
        String domain = host.substring(host.indexOf(".") + 1);
        return domain.equals(this.ourdomain);
    }

    public boolean isSameFile(OurURL url1, OurURL url2) {
        return url1.sameFile(url2);
    }

    public String generateName(OurURL url) {
        String name = url.toString();
        int sp = (name = name.replaceAll("\\\\", "/")).lastIndexOf(47);
        if (sp + 1 < name.length()) {
            return name.substring(sp + 1);
        }
        int preSlash = (name = name.replaceAll("^[a-zA-Z0-9]+:[/]+", "")).indexOf(47);
        if (preSlash > 0) {
            name = name.substring(0, preSlash);
        }
        return name.replaceAll("[./]", "_");
    }

    public OurURL fetchURL(IMDINode imdiNode) {
        OurURL url = imdiNode.getURL();
        if (this.createFromScratch) {
            return url;
        }
        if (url.toString().indexOf(32) != -1) {
            logger.warn((Object)("fetchURL: Whitespace in URL: '" + url + "'"));
            try {
                url = new OurURL(url.toString().substring(0, url.toString().indexOf(32)));
            }
            catch (MalformedURLException mue) {
                logger.warn((Object)("fetchURL: Truncate failed: " + mue));
            }
        }
        String prefix = this.ao.getArchiveRoots().getHandlePrefix();
        String urid = imdiNode.getURID();
        if (prefix == null) {
            if (urid != null) {
                logger.info((Object)("fetchURL: No local Handle System, ignored URID: " + urid + " URL: " + url));
            }
            return url;
        }
        if (!(url != null && this.inOurDomain(url) || prefix.equals(NodeIdUtils.handleToPrefix(urid)))) {
            if (urid != null) {
                logger.debug((Object)("fetchURL: Remote node has remote URID: " + urid + " URL: " + url));
            }
            return url;
        }
        return this.ao.getArchiveRoots().fetchURL(imdiNode, this.accessContext, this.ao);
    }

    public String fetchNodeId(IMDINode imdiNode, boolean onsite) {
        int nodeId;
        if (!this.createFromScratch) {
            return null;
        }
        String prefix = this.ao.getArchiveRoots().getHandlePrefix();
        if (prefix == null) {
            return null;
        }
        if (!prefix.equals(NodeIdUtils.handleToPrefix(imdiNode.getURID()))) {
            if (onsite) {
                logger.warn((Object)("fetchNodeId: Foreign URID ignored, local=" + prefix + " URID=" + imdiNode.getURID()));
            } else {
                logger.debug((Object)("fetchNodeId: Remote node with remote URID: " + imdiNode.getURID()));
            }
            return null;
        }
        if (!onsite) {
            logger.debug((Object)("fetchNodeId: Odd, remote node has URID with our prefix: " + imdiNode.getURID()));
        }
        if ((nodeId = NodeIdUtils.handleToNode(imdiNode.getURID(), prefix)) >= 0) {
            return NodeIdUtils.TONODEID(nodeId);
        }
        return null;
    }

    public boolean handleIMDIFile(IMDINode imdiNode, String parentNodeId, boolean linkExists, boolean alwaysUpdateImdi) {
        try {
            return this.handleIMDIFile_(imdiNode, parentNodeId, linkExists, alwaysUpdateImdi);
        }
        catch (Exception e) {
            this.lastErrorMessage = "handleIMDIFile: generic error adding file: " + imdiNode.getURL() + " --> " + e;
            logger.error((Object)this.lastErrorMessage, (Throwable)e);
            return false;
        }
    }

    public boolean handleResourceFile(Resource resource, String parentNodeId, boolean linkExists) {
        try {
            return this.handleResourceFile_(resource, parentNodeId, linkExists);
        }
        catch (Exception e) {
            this.lastErrorMessage = "handleResourceFile: generic error adding file: " + resource.getURL() + " --> " + e;
            logger.error((Object)this.lastErrorMessage, (Throwable)e);
            return false;
        }
    }

    private void addLink(String parentNodeId, String nodeId, boolean canonical, boolean childIsIMDI) {
        if (parentNodeId == null) {
            logger.info((Object)("addLink: Null parentNodeId for nodeId: " + nodeId));
            return;
        }
        HashSet<String> entries = (HashSet<String>)this.childLinkHash.get(parentNodeId);
        if (entries == null) {
            entries = new HashSet<String>();
        }
        String nodeIdToAdd = nodeId;
        if (!canonical) {
            nodeIdToAdd = "!" + nodeId;
            if (entries.contains(nodeId)) {
                logger.debug((Object)("2nd link ignored: " + parentNodeId + " -> " + nodeId));
                this.addBadIMDI(parentNodeId, nodeId);
                return;
            }
        }
        if (!entries.add(nodeIdToAdd)) {
            if (canonical) {
                logger.warn((Object)("2nd canonical link ignored: " + parentNodeId + " -> " + nodeId));
                this.addBadIMDI(parentNodeId, nodeId);
            } else {
                logger.warn((Object)("Nth link ignored: " + parentNodeId + " -> " + nodeId));
                this.addBadIMDI(parentNodeId, nodeId);
            }
            return;
        }
        this.childLinkHash.put(parentNodeId, entries);
        if (!this.bootstrap) {
            try {
                this.cswr.addLinkToTree(nodeId, parentNodeId, canonical, childIsIMDI);
            }
            catch (UnknownNodeException une) {
                logger.error((Object)("addLinkToTree " + (canonical ? "(canonical) " : "") + "failed, unconnected area? " + parentNodeId + " -> " + nodeId + (childIsIMDI ? "(IMDI)" : "resource")));
            }
        }
    }

    private void addBadIMDI(String parent, String child) {
        HashSet<String> entries = (HashSet<String>)this.badIMDIHash.get(parent);
        if (entries == null) {
            entries = new HashSet<String>();
        }
        entries.add(child);
        this.badIMDIHash.put(parent, entries);
    }

    private boolean handleIMDIFile_(IMDINode imdiNode, String parentNodeId, boolean linkExists, boolean alwaysUpdateImdi) {
        block133: {
            Vector<IMDINode> foundIMDIFiles = null;
            Vector<Resource> foundResourceFiles = null;
            boolean fileNeedsUpdate = true;
            if (this.progressMonitor != null && this.progressMonitor.isCanceled()) {
                return false;
            }
            OurURL url = this.fetchURL(imdiNode);
            try {
                boolean oldArchiveObjectsEntry;
                String myNodeId = (String)this.visitedNodes.get(url.toString());
                if (myNodeId != null) {
                    if (!linkExists) {
                        this.addLink(parentNodeId, myNodeId, false, true);
                    }
                    return true;
                }
                boolean onsite = this.inOurDomain(url);
                long lmt = 0L;
                long filesize = 0L;
                Timestamp filetime = null;
                if (url.getProtocol().equals("file") || this.followHTTPlinks || this.checkHTTPheaders) {
                    FileInfo fi = new FileInfo(url);
                    lmt = fi.getTime();
                    filesize = fi.getSize();
                    if (lmt > 0L) {
                        filetime = new Timestamp(lmt);
                    }
                }
                if ((myNodeId = !this.bootstrap ? this.ao.getObjectId(url) : null) != null) {
                    boolean isAccessible;
                    this.visitedNodes.put(url.toString(), myNodeId);
                    boolean wasAccessible = this.ao.isAccessible(myNodeId);
                    boolean bl = isAccessible = lmt != 0L || filesize > 0L;
                    if (!(url.getProtocol().equals("file") || this.followHTTPlinks || this.checkHTTPheaders)) {
                        logger.info((Object)("Remote IMDI file assumed to be unchanged: " + url));
                        isAccessible = wasAccessible;
                        if (isAccessible) {
                            filesize = 1L;
                        }
                    }
                    if (isAccessible != wasAccessible) {
                        this.aowr.setArchiveObjectFileInfo(myNodeId, filesize, filetime);
                        if (this.aowr2 != null) {
                            try {
                                this.aowr2.setArchiveObjectFileInfo(NodeIdUtils.nodeIdToHandle(myNodeId, this.ao.getArchiveRoots().getHandlePrefix()), filesize, filetime);
                            }
                            catch (UnknownNodeException une) {
                                logger.error((Object)("Cannot update Handle System entry for IMDI, URID not yet known there: " + une));
                            }
                        }
                    }
                    if (!isAccessible) {
                        if (wasAccessible) {
                            String[] orphans = null;
                            logger.warn((Object)("IMDI File URL became inaccessible: " + url));
                            logger.info((Object)("try deleting corpusnode nodeid=" + myNodeId));
                            try {
                                long one = System.currentTimeMillis();
                                orphans = this.cswr.deleteLinksRecursively(myNodeId);
                                logger.debug((Object)("deleteLinksRecursively took " + (System.currentTimeMillis() - one) + " msec, nodeid=" + myNodeId));
                            }
                            catch (UnknownNodeException une) {
                                if (this.ao.getObjectSize(myNodeId) > 1L) {
                                    logger.warn((Object)("Node not known in CORPUSSTRUCTURE table: " + myNodeId));
                                }
                                logger.debug((Object)("Placeholder node was not known in CORPUSSTRUCTURE table: " + myNodeId));
                            }
                            try {
                                this.cswr.deleteCorpusNode(myNodeId);
                            }
                            catch (UnknownNodeException une) {
                                logger.info((Object)("Deleting IMDI type node failed, node was not known in CORPUSNODES table: " + myNodeId));
                            }
                            try {
                                this.imdidb.deleteIMDINode(myNodeId);
                                logger.info((Object)("deleting metadata for nodeid=" + myNodeId));
                            }
                            catch (UnknownNodeException un) {
                                // empty catch block
                            }
                            if (orphans != null) {
                                for (int i = 0; i < orphans.length; ++i) {
                                    String id = orphans[i];
                                    try {
                                        this.imdidb.deleteIMDINode(id);
                                        logger.info((Object)("deleting metadata for nodeid=" + id));
                                        continue;
                                    }
                                    catch (UnknownNodeException un) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                        if (!linkExists) {
                            this.addLink(parentNodeId, myNodeId, true, true);
                        }
                        return true;
                    }
                    if (wasAccessible) {
                        if (lmt > this.ao.getObjectTimestamp(myNodeId).getTime()) {
                            fileNeedsUpdate = true;
                        } else {
                            fileNeedsUpdate = false;
                            if (filesize == 1L) {
                                logger.warn((Object)("File probably unchanged, cannot re-read anyway because of access problems: " + url));
                            } else if (alwaysUpdateImdi) {
                                logger.debug((Object)("File unchanged, re-reading anyway: " + url));
                                fileNeedsUpdate = true;
                            }
                        }
                        if (url.getProtocol().equals("file") || this.checkHTTPheaders || this.followHTTPlinks) {
                            Timestamp oldTime = this.ao.getObjectFileTime(myNodeId);
                            long oldSize = this.ao.getObjectSize(myNodeId);
                            if (filesize != oldSize || filetime != null && !filetime.equals(oldTime)) {
                                logger.info((Object)("IMDI file properties changed: " + oldSize + " bytes, " + oldTime + " -> " + filesize + " bytes, " + filetime + " for " + myNodeId + ", " + url));
                                if (filetime == null) {
                                    filetime = oldTime;
                                }
                                fileNeedsUpdate = true;
                                this.aowr.setArchiveObjectFileInfo(myNodeId, filesize, filetime);
                                if (this.aowr2 != null) {
                                    try {
                                        this.aowr2.setArchiveObjectFileInfo(NodeIdUtils.nodeIdToHandle(myNodeId, this.ao.getArchiveRoots().getHandlePrefix()), filesize, filetime);
                                    }
                                    catch (UnknownNodeException une) {
                                        logger.error((Object)("Cannot update Handle System entry for IMDI file, URID not yet known there: " + une));
                                    }
                                }
                            }
                        }
                    } else {
                        fileNeedsUpdate = true;
                    }
                }
                if (this.bootstrap) {
                    logger.debug((Object)("ArchiveCrawler: check IMDI file: " + url));
                }
                if (myNodeId == null) {
                    Timestamp whence = new Timestamp(System.currentTimeMillis());
                    URI tabUri = null;
                    try {
                        tabUri = this.ao.getArchiveRoots().uriToTableContext(new URI(url.toEncodedString()), this.accessContext);
                    }
                    catch (URISyntaxException use) {
                        logger.error((Object)("handleIMDIFile: could not create DB URI from " + url));
                        return false;
                    }
                    AccessInfo ai = new AccessInfo("cleared", "cleared");
                    if (!onsite && filesize > 0L) {
                        ai.setReadRule("everybody");
                        ai.setWriteRule("nobody");
                    }
                    if ((myNodeId = this.fetchNodeId(imdiNode, onsite)) != null) {
                        String expectedId = myNodeId;
                        if (this.freshIdCount > 0) {
                            logger.error((Object)("handleIMDIFile: Cannot restore URIDs while allocating new URIDs from scratch - ID found: " + myNodeId + " in: " + url));
                            return false;
                        }
                        ++this.uridBasedIdCount;
                        logger.debug((Object)("handleIMDIFile: Re-using URID from file: URID=" + imdiNode.getURID() + " URL=" + url));
                        myNodeId = this.aowr.newArchiveObject(myNodeId, tabUri, whence, onsite, filesize, filetime, ai, null);
                        if (!expectedId.equals(myNodeId)) {
                            logger.error((Object)("handleIMDIFile: Failed to enter URL to DB under URID-suggested ID=" + expectedId + " using new ID=" + myNodeId + " instead for URL=" + url));
                        }
                    } else {
                        if (this.uridBasedIdCount > 0) {
                            logger.error((Object)("handleIMDIFile: Cannot allocate fresh URIDs while known URIDs are used, re-run crawler later for: " + url));
                            return false;
                        }
                        ++this.freshIdCount;
                        myNodeId = this.aowr.newArchiveObject(tabUri, whence, onsite, filesize, filetime, ai);
                        if (!(parentNodeId != null || myNodeId != null && myNodeId.equals(this.cswr.getRootNodeId()))) {
                            logger.error((Object)("handleIMDIFile: Tried to seed the DB with a top node but got NodeId=" + myNodeId + " while only " + this.cswr.getRootNodeId() + " is allowed! Aborting..."));
                            throw new IllegalStateException("Could not create top node as " + this.cswr.getRootNodeId() + " but got " + myNodeId + " instead, giving up!");
                        }
                    }
                    oldArchiveObjectsEntry = false;
                    if (myNodeId == null) {
                        logger.error((Object)("handleIMDIFile: Could not get new nodeId for " + url));
                        return false;
                    }
                    if (this.aowr2 != null) {
                        try {
                            this.aowr2.newArchiveObject(NodeIdUtils.nodeIdToHandle(myNodeId, this.ao.getArchiveRoots().getHandlePrefix()), tabUri, whence, onsite, filesize, filetime, ai, null);
                        }
                        catch (UpdateInProgressException upe) {
                            logger.error((Object)("handleIMDIFile: Cannot add URID for IMDI, Handle System update in progress: " + upe));
                        }
                    }
                    this.visitedNodes.put(url.toString(), myNodeId);
                } else {
                    oldArchiveObjectsEntry = true;
                }
                if (!linkExists) {
                    this.addLink(parentNodeId, myNodeId, true, true);
                }
                if (!fileNeedsUpdate) {
                    try {
                        Node node = this.cs.getNode(myNodeId);
                    }
                    catch (UnknownNodeException une) {
                        logger.debug((Object)("// no update but have to parse file to recreate corpusnodes data: " + myNodeId + " url: " + url));
                        fileNeedsUpdate = true;
                    }
                }
                if (!fileNeedsUpdate) {
                    String[] childrenInDB = this.cs.getSubnodes(myNodeId);
                    logger.debug((Object)("// no update: " + url + ", " + childrenInDB.length + " subnodes of " + myNodeId));
                    for (int i = 0; i < childrenInDB.length; ++i) {
                        OurURL curl = this.ao.getObjectURL(childrenInDB[i], this.accessContext);
                        if (curl == null) {
                            logger.warn((Object)("Node has no valid URL at the moment: " + childrenInDB[i] + " forced reparse of parent: " + myNodeId));
                            try {
                                this.cswr.deleteCorpusNode(myNodeId);
                            }
                            catch (UnknownNodeException une) {
                                // empty catch block
                            }
                            logger.info((Object)("Forced update for node: " + myNodeId));
                            return this.handleIMDIFile(imdiNode, parentNodeId, linkExists, true);
                        }
                        int cNodeType = -1;
                        String cFormat = null;
                        String cHandle = NodeIdUtils.nodeIdToHandle(childrenInDB[i], this.ao.getArchiveRoots().getHandlePrefix());
                        IMDINode cImdi = new IMDINode(curl, null, null, cHandle);
                        try {
                            Node node = this.cs.getNode(childrenInDB[i]);
                            cNodeType = node.getNodeType();
                            cFormat = node.getFormat();
                            cImdi = new IMDINode(curl, null, cFormat, cHandle);
                        }
                        catch (UnknownNodeException ne) {
                            logger.info((Object)("Node was only in ArchiveObjects, not in CorpusNodes, re-adding: " + childrenInDB[i] + " at: " + curl));
                            if (curl.toString().toLowerCase().endsWith(".imdi")) {
                                this.handleIMDIFile(cImdi, myNodeId, true, true);
                            } else {
                                logger.warn((Object)("Discovered resource file without CorpusNodes data, assuming unknown INFO_FILE: " + curl));
                                Resource resource = new Resource(cImdi, 4);
                                this.handleResourceFile(resource, myNodeId, true);
                            }
                            cNodeType = 42;
                        }
                        if (cNodeType == 2 || cNodeType == 1 || cNodeType == 128) {
                            this.handleIMDIFile(cImdi, myNodeId, true, alwaysUpdateImdi);
                            continue;
                        }
                        if (cNodeType == 4 || cNodeType == 16 || cNodeType == 8 || cNodeType == 64) {
                            Resource resource = new Resource(cImdi, cNodeType);
                            this.handleResourceFile(resource, myNodeId, true);
                            continue;
                        }
                        if (cNodeType == 42) continue;
                        logger.error((Object)("handleIMDIFile: UNKNOWN node type: " + cNodeType + " for node: " + curl));
                    }
                    return true;
                }
                if (onsite || this.followHTTPlinks) {
                    int k;
                    if (!this.bootstrap && oldArchiveObjectsEntry) {
                        try {
                            this.cswr.deleteCorpusNode(myNodeId);
                        }
                        catch (UnknownNodeException un) {
                            logger.info((Object)("Node had no CORPUSNODE data: " + myNodeId));
                        }
                        try {
                            long one = System.currentTimeMillis();
                            this.imdidb.deleteIMDINode(myNodeId);
                            logger.debug((Object)("Purged IMDIMD_ data for: " + myNodeId + " (" + (System.currentTimeMillis() - one) + " msec)"));
                        }
                        catch (UnknownNodeException un) {
                            // empty catch block
                        }
                    }
                    try {
                        this.imdiCH.clearLists();
                        this.imdiCH.parse(url);
                    }
                    catch (SAXException saxe) {
                        logger.error((Object)("Cannot parse IMDI file, subtree skipped. Error: " + saxe + " URL: " + url), (Throwable)saxe);
                        return false;
                    }
                    if (imdiNode.getURID() != null && this.imdiCH.getURID() != null && !this.imdiCH.getURID().substring(this.imdiCH.getURID().lastIndexOf(":") + 1).equals(imdiNode.getURID().substring(imdiNode.getURID().lastIndexOf(":") + 1))) {
                        logger.error((Object)("IMDI file has SelfHandle " + this.imdiCH.getURID() + " but link to here uses URID: " + imdiNode.getURID() + " Subtree skipped. URL: " + url));
                        return false;
                    }
                    if (this.imdiCH.getImdiType().equals("Corpus")) {
                        this.cswr.setNode(myNodeId, 2, "text/x-imdi+xml", this.imdiCH.getName(), this.imdiCH.getTitle());
                    } else if (this.imdiCH.getImdiType().equals("Session")) {
                        this.cswr.setNode(myNodeId, 1, "text/x-imdi+xml", this.imdiCH.getName(), this.imdiCH.getTitle());
                        this.allSessionsHash.put(myNodeId, url);
                    } else if (this.imdiCH.getImdiType().equals("Catalogue")) {
                        this.cswr.setNode(myNodeId, 128, "text/x-imdi+xml", this.imdiCH.getName(), this.imdiCH.getTitle());
                        this.allSessionsHash.put(myNodeId, url);
                    } else {
                        logger.warn((Object)("Neither Corpus nor Session nor Catalogue, no corpusnode created: " + url));
                    }
                    foundIMDIFiles = new Vector<IMDINode>(this.imdiCH.getCorpusLinks().size());
                    Iterator iIter = this.imdiCH.getCorpusLinks().iterator();
                    while (iIter.hasNext()) {
                        foundIMDIFiles.add((IMDINode)iIter.next());
                    }
                    if (this.imdiCH.getCatalogueLink() != null) {
                        foundIMDIFiles.add(this.imdiCH.getCatalogueLink());
                    }
                    foundResourceFiles = new Vector<Resource>(this.imdiCH.getMediaNodes().size() + this.imdiCH.getWrittenNodes().size() + this.imdiCH.getInfoNodes().size());
                    for (IMDINode iNode : this.imdiCH.getMediaNodes()) {
                        foundResourceFiles.add(new Resource(iNode, 16));
                    }
                    for (IMDINode iNode : this.imdiCH.getWrittenNodes()) {
                        foundResourceFiles.add(new Resource(iNode, 8));
                    }
                    for (IMDINode iNode : this.imdiCH.getLexiconNodes()) {
                        foundResourceFiles.add(new Resource(iNode, 64));
                    }
                    for (IMDINode iNode : this.imdiCH.getInfoNodes()) {
                        foundResourceFiles.add(new Resource(iNode, 4));
                    }
                    iIter = null;
                    if (this.bootstrap && foundIMDIFiles.size() > 0) {
                        logger.debug((Object)("// update: " + foundIMDIFiles.size() + " IMDI files, " + foundResourceFiles.size() + " resource files "));
                    }
                    if (!this.bootstrap) {
                        String[] childrenInDB = this.cs.getSubnodes(myNodeId);
                        logger.debug((Object)("// update: imdi=" + foundIMDIFiles.size() + " res=" + foundResourceFiles.size() + " db=" + childrenInDB.length + " subnodes of node=" + myNodeId + " url=" + url));
                        for (int i = 0; i < childrenInDB.length; ++i) {
                            String[] orphans = null;
                            String cNodeId = childrenInDB[i];
                            Node cn = null;
                            try {
                                cn = this.cs.getNode(cNodeId);
                            }
                            catch (UnknownNodeException une) {
                                // empty catch block
                            }
                            OurURL curl = null;
                            try {
                                curl = this.ao.getObjectURL(cNodeId, this.accessContext);
                            }
                            catch (UnknownNodeException une) {
                                // empty catch block
                            }
                            if (curl == null) {
                                logger.warn((Object)("Node has no valid URL at the moment: " + childrenInDB[i] + " child of " + myNodeId));
                                cn = null;
                            }
                            String cHandle = NodeIdUtils.nodeIdToHandle(cNodeId, this.ao.getArchiveRoots().getHandlePrefix());
                            IMDINode cImdi = new IMDINode(curl, null, null, cHandle);
                            int nodeType = -1;
                            if (cn != null) {
                                nodeType = cn.getNodeType();
                                cImdi = new IMDINode(curl, null, cn.getFormat(), cHandle);
                            }
                            if (nodeType == 2 || nodeType == 1 || nodeType == 128) {
                                boolean found = false;
                                for (int j = 0; j < foundIMDIFiles.size(); ++j) {
                                    if (!this.isSameFile(this.fetchURL((IMDINode)foundIMDIFiles.get(j)), curl)) continue;
                                    found = true;
                                    cImdi = (IMDINode)foundIMDIFiles.get(j);
                                    foundIMDIFiles.removeElementAt(j);
                                    break;
                                }
                                if (!found) {
                                    logger.info((Object)("ArchiveCrawler: IMDI link removed: " + curl));
                                    try {
                                        long one = System.currentTimeMillis();
                                        orphans = this.cswr.removeLink(myNodeId, cNodeId);
                                        logger.debug((Object)("// removeLink " + myNodeId + ", " + cNodeId + " took " + (System.currentTimeMillis() - one) + " msec"));
                                    }
                                    catch (UnknownNodeException une) {
                                        logger.warn((Object)("ArchiveCrawler: Link removal failed: " + une));
                                    }
                                } else {
                                    this.handleIMDIFile(cImdi, myNodeId, true, alwaysUpdateImdi);
                                }
                            } else if (nodeType == 16 || nodeType == 8 || nodeType == 4 || nodeType == 64) {
                                boolean found = false;
                                for (int j = 0; j < foundResourceFiles.size(); ++j) {
                                    if (!this.isSameFile(this.fetchURL((Resource)foundResourceFiles.get(j)), curl)) continue;
                                    found = true;
                                    cImdi = (IMDINode)foundResourceFiles.get(j);
                                    foundResourceFiles.removeElementAt(j);
                                    break;
                                }
                                if (!found) {
                                    logger.info((Object)("ArchiveCrawler: Resource link removed: " + curl));
                                    try {
                                        long one = System.currentTimeMillis();
                                        orphans = this.cswr.removeLink(myNodeId, cNodeId);
                                        logger.debug((Object)("// removeLink " + myNodeId + ", " + cNodeId + " took " + (System.currentTimeMillis() - one) + " msec"));
                                    }
                                    catch (UnknownNodeException une) {
                                        logger.warn((Object)("ArchiveCrawler: Resource link removal failed: " + une));
                                    }
                                } else {
                                    Resource resource = new Resource(cImdi, nodeType);
                                    this.handleResourceFile(resource, myNodeId, true);
                                }
                            } else {
                                logger.warn((Object)("ArchiveCrawler: unknown node type, link removed: " + curl));
                                try {
                                    long one = System.currentTimeMillis();
                                    orphans = this.cswr.removeLink(myNodeId, cNodeId);
                                    logger.debug((Object)("// removeLink " + myNodeId + ", " + cNodeId + " took " + (System.currentTimeMillis() - one) + " msec"));
                                }
                                catch (UnknownNodeException une) {
                                    logger.warn((Object)("ArchiveCrawler: Unknown link removal failed: " + une));
                                }
                            }
                            if (orphans == null) continue;
                            for (int j = 0; j < orphans.length; ++j) {
                                String id = orphans[j];
                                logger.info((Object)("Removing orphan: " + id));
                                try {
                                    this.imdidb.deleteIMDINode(id);
                                    continue;
                                }
                                catch (UnknownNodeException un) {
                                    // empty catch block
                                }
                            }
                            orphans = null;
                        }
                        if (oldArchiveObjectsEntry) {
                            Timestamp whence = new Timestamp(System.currentTimeMillis());
                            this.aowr.setObjectCrawlTime(myNodeId, whence);
                            if (this.aowr2 != null) {
                                try {
                                    this.aowr2.setObjectCrawlTime(NodeIdUtils.nodeIdToHandle(myNodeId, this.ao.getArchiveRoots().getHandlePrefix()), whence);
                                }
                                catch (UnknownNodeException une) {
                                    logger.error((Object)("Cannot update Handle System entry for node, URID not yet known there: " + une));
                                }
                            }
                        }
                    }
                    for (k = 0; k < foundIMDIFiles.size(); ++k) {
                        this.handleIMDIFile((IMDINode)foundIMDIFiles.get(k), myNodeId, false, true);
                    }
                    for (k = 0; k < foundResourceFiles.size(); ++k) {
                        Resource resource = (Resource)foundResourceFiles.get(k);
                        this.handleResourceFile(resource, myNodeId, false);
                    }
                    break block133;
                }
                logger.warn((Object)("Creating dummy corpusnode for node not reachable with current settings: " + myNodeId));
                int dummyType = 2;
                if (url.toString().toLowerCase().indexOf("/metadata/") != -1) {
                    dummyType = 1;
                }
                if (imdiNode.getPath() != null && imdiNode.getPath().toLowerCase().indexOf("catalogue") != -1) {
                    dummyType = 128;
                }
                if (onsite) {
                    this.cswr.setNode(myNodeId, dummyType, "Unknown", "external link? " + myNodeId, "external node - crawl in online mode to continue");
                } else {
                    this.cswr.setNode(myNodeId, dummyType, "Unknown", "dead link? " + myNodeId, "unreachable node - add file or fix access rights and try again");
                }
            }
            catch (FileNotFoundException fnfe) {
                String errMessage = fnfe.getMessage();
                if (errMessage == null) {
                    errMessage = "undefined error";
                }
                this.lastErrorMessage = (errMessage = errMessage.toLowerCase()).indexOf("no such file") != -1 || errMessage.indexOf("file not found") != -1 ? "handleIMDIFile: IO ERROR: File not found: " + url : (errMessage.indexOf("permission denied") != -1 || errMessage.indexOf("access denied") != -1 ? "handleIMDIFile: IO ERROR: Access denied: " + url : "handleIMDIFile: IO problem for: " + url + "\nERROR: " + fnfe);
                logger.error((Object)this.lastErrorMessage);
                return false;
            }
            catch (IOException ioe) {
                this.lastErrorMessage = "handleIMDIFile: IO error parsing file: " + url + '\n' + ioe;
                logger.error((Object)this.lastErrorMessage);
                return false;
            }
        }
        return true;
    }

    private boolean handleResourceFile_(Resource resource, String parentNodeId, boolean linkExists) {
        OurURL url = this.fetchURL(resource);
        if (url == null) {
            logger.warn((Object)("Cannot get URL, skipped resource: URID=" + resource.getURID() + " raw URL=" + resource.getURL()));
            return false;
        }
        String myNodeId = (String)this.visitedNodes.get(url.toString());
        if (myNodeId != null) {
            if (!linkExists) {
                this.addLink(parentNodeId, myNodeId, false, false);
            }
            return true;
        }
        long filesize = 0L;
        Timestamp filetime = null;
        if (url.getProtocol().equals("file") || this.checkHTTPheaders) {
            FileInfo fi = new FileInfo(url);
            long lmt = fi.getTime();
            filesize = fi.getSize();
            if (lmt > 0L) {
                filetime = new Timestamp(lmt);
            }
        }
        if (!this.bootstrap) {
            myNodeId = this.ao.getObjectId(url);
        }
        if (myNodeId != null) {
            this.updateResourceNode(url, myNodeId, resource, filesize, filetime);
        } else {
            logger.debug((Object)("handleResourceFile: add resource: " + url));
            myNodeId = this.createResourceNode(url, resource, filesize, filetime);
            if (myNodeId == null) {
                return false;
            }
            linkExists = false;
        }
        this.visitedNodes.put(url.toString(), myNodeId);
        if (!linkExists) {
            this.addLink(parentNodeId, myNodeId, true, false);
        }
        return true;
    }

    private void updateResourceNode(OurURL url, String myNodeId, Resource resource, long filesize, Timestamp filetime) {
        boolean isAccessible;
        boolean wasAccessible = this.ao.isAccessible(myNodeId);
        if (url.getProtocol().equals("file") || this.checkHTTPheaders) {
            isAccessible = filetime != null || filesize > 0L;
        } else {
            logger.info((Object)("Resource file accessibility assumed to be unchanged for " + url));
            isAccessible = wasAccessible;
        }
        if (wasAccessible != isAccessible) {
            this.aowr.setArchiveObjectFileInfo(myNodeId, filesize, filetime);
            if (this.aowr2 != null) {
                try {
                    this.aowr2.setArchiveObjectFileInfo(NodeIdUtils.nodeIdToHandle(myNodeId, this.ao.getArchiveRoots().getHandlePrefix()), filesize, filetime);
                }
                catch (UnknownNodeException une) {
                    logger.error((Object)("Cannot update Handle System entry for resource, URID not yet known there: " + une));
                }
            }
        }
        if (!isAccessible && wasAccessible) {
            logger.warn((Object)("Resource File URL became inaccessible: " + url));
        }
        if (isAccessible && !wasAccessible) {
            logger.debug((Object)("Resource File URL became accessible: " + url));
        }
        if (isAccessible && wasAccessible && (url.getProtocol().equals("file") || this.checkHTTPheaders)) {
            Timestamp oldTime = this.ao.getObjectFileTime(myNodeId);
            long oldSize = this.ao.getObjectSize(myNodeId);
            if (filesize != oldSize || filetime != null && !filetime.equals(oldTime)) {
                if (oldSize > 1L) {
                    logger.warn((Object)("Resource properties changed: " + oldSize + " bytes, " + oldTime + " -> " + filesize + " bytes, " + filetime + " for " + myNodeId + ", " + url));
                } else {
                    logger.info((Object)("Resource properties changed: [placeholder], " + oldTime + " -> " + filesize + " bytes, " + filetime + " for " + myNodeId + ", " + url));
                }
                if (filetime == null) {
                    filetime = oldTime;
                }
                this.aowr.setArchiveObjectFileInfo(myNodeId, filesize, filetime);
                if (this.aowr2 != null) {
                    try {
                        this.aowr2.setArchiveObjectFileInfo(NodeIdUtils.nodeIdToHandle(myNodeId, this.ao.getArchiveRoots().getHandlePrefix()), filesize, filetime);
                    }
                    catch (UnknownNodeException une) {
                        logger.error((Object)("Cannot update Handle System entry for resource, URID not yet known there: " + une));
                    }
                }
            }
        }
        String resName = this.generateName(url);
        try {
            Node node = this.cs.getNode(myNodeId);
            if (resource.getType() != node.getNodeType() || resource.getFormat() != null && !resource.getFormat().equals(node.getFormat()) || !resName.equals(node.getName()) || !url.toString().equals(node.getTitle())) {
                logger.debug((Object)("Corpusnodes info changed for resource: " + myNodeId + " URL: " + url));
                this.cswr.setNode(myNodeId, resource.getType(), resource.getFormat(), resName, url.toString());
            }
        }
        catch (UnknownNodeException une) {
            logger.debug((Object)("Recreated corpusnodes entry for resource: " + myNodeId + " URL: " + url));
            this.cswr.setNode(myNodeId, resource.getType(), resource.getFormat(), resName, url.toString());
        }
    }

    private String createResourceNode(OurURL url, Resource resource, long filesize, Timestamp filetime) {
        String myNodeId;
        Timestamp whence = new Timestamp(System.currentTimeMillis());
        URI tabUri = null;
        try {
            tabUri = this.ao.getArchiveRoots().uriToTableContext(new URI(url.toEncodedString()), this.accessContext);
        }
        catch (URISyntaxException use) {
            logger.error((Object)("createResourceNode: could not create DB URI from " + url));
            return null;
        }
        AccessInfo ai = new AccessInfo("cleared", "cleared");
        boolean onsite = this.inOurDomain(url);
        if (!onsite && filesize > 0L) {
            ai.setReadRule("everybody");
            ai.setWriteRule("nobody");
        }
        if ((myNodeId = this.fetchNodeId(resource, onsite)) != null) {
            String expectedId = myNodeId;
            if (this.freshIdCount > 0) {
                logger.error((Object)("createResourceNode: Cannot restore URIDs while allocating new URIDs from scratch - ID found: " + myNodeId + " in: " + url));
                return null;
            }
            ++this.uridBasedIdCount;
            logger.debug((Object)("createResourceNode: Re-using URID from file: URID=" + resource.getURID() + " URL=" + url));
            myNodeId = this.aowr.newArchiveObject(myNodeId, tabUri, whence, onsite, filesize, filetime, ai, null);
            if (!expectedId.equals(myNodeId)) {
                logger.error((Object)("createResourceNode: Failed to enter URL to DB under URID-suggested ID=" + expectedId + " using new ID=" + myNodeId + " instead for URL=" + url));
            }
        } else {
            if (this.uridBasedIdCount > 0) {
                logger.error((Object)("createResourceNode: Cannot allocate fresh URIDs while known URIDs are used, re-run crawler later for: " + url));
                return null;
            }
            ++this.freshIdCount;
            myNodeId = this.aowr.newArchiveObject(tabUri, whence, onsite, filesize, filetime, ai);
        }
        if (myNodeId == null) {
            logger.error((Object)("createResourceNode: Error adding new node to ArchiveObjectDB: " + url));
            return null;
        }
        if (this.aowr2 != null) {
            try {
                this.aowr2.newArchiveObject(NodeIdUtils.nodeIdToHandle(myNodeId, this.ao.getArchiveRoots().getHandlePrefix()), tabUri, whence, onsite, filesize, filetime, ai, null);
            }
            catch (UpdateInProgressException upe) {
                logger.error((Object)("Cannot add URID for resource, Handle System update in progress: " + upe));
            }
        }
        String name = this.generateName(url);
        this.cswr.setNode(myNodeId, resource.getType(), resource.getFormat(), name, url.toString());
        return myNodeId;
    }

    class Resource
    extends IMDINode {
        int type;

        Resource(IMDINode in, int theType) {
            super(in.getURL(), in.getPath(), in.getFormat(), in.getURID());
            this.type = theType;
            in = null;
        }

        public int getType() {
            return this.type;
        }
    }
}

