/*
 * Decompiled with CFR 0.152.
 */
package mpi.corpusstructure;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.GregorianCalendar;
import mpi.corpusstructure.ArchiveObjectsDBWrite;
import mpi.corpusstructure.ArchiveObjectsDBWriteImpl;
import mpi.corpusstructure.NodeIdUtils;
import mpi.util.OurURL;

public class VersionArchiveSorter {
    File mainDirectory = null;
    ArchiveObjectsDBWrite aodbwr = null;

    private static void logs(String what) {
        System.out.println(what);
    }

    private void log(String what) {
        System.out.println(what);
    }

    public VersionArchiveSorter(File dir, ArchiveObjectsDBWrite ao) {
        this.mainDirectory = dir;
        this.aodbwr = ao;
    }

    public void sortFiles(boolean sim) {
        File[] allFiles = this.mainDirectory.listFiles();
        if (allFiles == null || !sim && !this.mainDirectory.canWrite()) {
            throw new IllegalArgumentException("Directory must be writeable if non-simulation mode");
        }
        if (allFiles.length == 0) {
            return;
        }
        for (int i = 0; i < allFiles.length; ++i) {
            File oneFile = allFiles[i];
            if (oneFile.isDirectory()) continue;
            if (!oneFile.canRead()) {
                this.log("Skipped unreadable file: " + oneFile.getName());
                continue;
            }
            try {
                this.sortOne(oneFile, sim);
                continue;
            }
            catch (NullPointerException npe) {
                this.log("Got null pointer while processing: " + oneFile);
            }
        }
    }

    private void sortOne(File oneFile, boolean simulate) {
        String nodeprefix;
        String basename;
        String nodeId = null;
        String targetname = basename = oneFile.getName();
        String targetDirName = null;
        try {
            OurURL fileURL = new OurURL(oneFile.getAbsoluteFile().toURL());
            if (this.aodbwr != null) {
                nodeId = this.aodbwr.getObjectId(fileURL);
            }
        }
        catch (MalformedURLException mue) {
            this.log("Bad file name: " + oneFile + " Exception: " + mue);
            return;
        }
        if (nodeId != null && !basename.startsWith(nodeprefix = "v" + NodeIdUtils.TOINT(nodeId) + "__.")) {
            targetname = nodeprefix + basename;
        }
        long when = oneFile.lastModified();
        GregorianCalendar whenCal = new GregorianCalendar();
        whenCal.setTimeInMillis(when);
        int month = 1 + whenCal.get(2) - 0;
        int year = whenCal.get(1);
        targetDirName = "" + year + "-" + (month < 10 ? "0" : "") + month;
        File subDir = new File(oneFile.getParentFile(), targetDirName);
        if (!simulate && !subDir.isDirectory()) {
            subDir.mkdir();
            if (!subDir.isDirectory() || !subDir.canWrite()) {
                this.log("Cannot make or write directory: " + subDir);
                return;
            }
        }
        File targetFile = new File(subDir, targetname);
        if (simulate) {
            this.log("Would have moved file to: " + targetDirName + "/" + targetname);
        } else if (oneFile.renameTo(targetFile)) {
            this.log("Moved file to: " + targetDirName + "/" + targetname);
            targetFile.setLastModified(when);
        } else {
            this.log("Failed to move file to: " + targetDirName + "/" + targetname);
            targetFile = null;
        }
        if (targetFile == null || this.aodbwr == null || nodeId == null) {
            return;
        }
        URI targetURI = this.aodbwr.getArchiveRoots().inTableContext(targetFile.toURI());
        if (simulate) {
            this.log("Would have updated DB " + nodeId + " to: " + targetURI);
        } else if (this.aodbwr.moveArchiveObject(nodeId, targetURI)) {
            this.log("Updated DB " + nodeId + " to: " + targetURI);
        } else {
            this.log("Failed to update DB " + nodeId + " to: " + targetURI);
        }
    }

    public static void main(String[] args) {
        File dir = null;
        ArchiveObjectsDBWriteImpl aodbwr = null;
        boolean simulate = false;
        if (args.length < 1 || !args[0].startsWith("/")) {
            VersionArchiveSorter.logs("First argument must be an absolute directory");
            return;
        }
        if (args.length == 2 && args[1].equals("nodb")) {
            aodbwr = null;
        } else if (args.length > 1) {
            if (args.length != 4 || !args[1].startsWith("jdbc:")) {
                VersionArchiveSorter.logs("Further arguments must be JDBC-URL user pass");
                VersionArchiveSorter.logs("To skip DB access, use 'nodb' as second argument.");
                VersionArchiveSorter.logs("Without DB access, URID links could break!");
                VersionArchiveSorter.logs("Use '-' as pass argument if there is no password.");
                return;
            }
            if (args[3].equals("-")) {
                args[3] = null;
            }
            if ((aodbwr = new ArchiveObjectsDBWriteImpl(args[1], false, args[2], args[3])) == null || !aodbwr.canWrite()) {
                VersionArchiveSorter.logs("Failed to open DB for writing");
                return;
            }
        }
        dir = new File(args[0]);
        if (!(dir != null && dir.isDirectory() && dir.canRead() && dir.isAbsolute())) {
            VersionArchiveSorter.logs("No readable absolute directory specified");
            return;
        }
        VersionArchiveSorter me = new VersionArchiveSorter(dir, aodbwr);
        if (!dir.canWrite()) {
            VersionArchiveSorter.logs("Warning: Simulation mode, directory not writeable!");
            simulate = true;
        }
        if (!simulate && aodbwr == null) {
            VersionArchiveSorter.logs("Please do always use a DB unless you are in simulation mode!");
            VersionArchiveSorter.logs("No DB, no simulation mode: If you want to abort, do it now.");
            long whence = System.currentTimeMillis() + 60000L;
            while (System.currentTimeMillis() < whence) {
                System.out.print("Will continue in " + (whence - System.currentTimeMillis()) + " msec\r");
            }
            VersionArchiveSorter.logs("Continuing without DB!");
        }
        me.sortFiles(simulate);
        if (aodbwr != null) {
            aodbwr.close();
            aodbwr.shutdown();
        }
        VersionArchiveSorter.logs("Done with sorting");
    }
}

