/*
 * Decompiled with CFR 0.152.
 */
package mpi.versioning.manager;

import java.io.File;
import java.net.MalformedURLException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Vector;
import mpi.corpusstructure.ArchiveAccessContext;
import mpi.corpusstructure.ArchiveObjectsDB;
import mpi.corpusstructure.CorpusStructureDBImpl;
import mpi.corpusstructure.NodeIdUtils;
import mpi.corpusstructure.UnknownNodeException;
import mpi.imdi.api.IMDIDom;
import mpi.imdi.api.IMDILink;
import mpi.util.DBConnection;
import mpi.util.OurURL;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class VersioningAPI {
    private String versionsTable = "versions";
    private static Logger logger = Logger.getLogger((String)VersioningAPI.class.getName());
    private DBConnection dbCon = null;
    private boolean writeable = false;
    private PreparedStatement getAllSTM = null;
    private PreparedStatement isRetiredSTM = null;
    private PreparedStatement getTimestampSTM = null;
    private PreparedStatement getPreviousSTM = null;
    private PreparedStatement getNextSTM = null;
    private PreparedStatement setNewerSTM = null;
    private PreparedStatement linkNewerSTM = null;
    private PreparedStatement setOlderSTM = null;
    private PreparedStatement linkOlderSTM = null;
    private PreparedStatement setRetiredSTM = null;
    private PreparedStatement addRetiredSTM = null;

    public VersioningAPI(String jdbcURL) {
        this.dbCon = new DBConnection(jdbcURL, "VersioningAPI/readonly");
        if (!this.prepareStatements(false)) {
            this.close();
        }
    }

    public VersioningAPI(String jdbcURL, String user, String pass) {
        this.dbCon = new DBConnection(jdbcURL, user, pass, "VersioningAPI/writeable");
        if (this.getStatus("open writeable connection")) {
            this.writeable = true;
        }
        this.initDB();
        if (!this.prepareStatements(true)) {
            this.close();
        }
        if (!this.getStatus("verify writeable connection")) {
            this.writeable = false;
        }
    }

    public boolean getStatus(String what) {
        if (this.dbCon != null && this.dbCon.getStatus()) {
            return true;
        }
        logger.error((Object)("Versioning: DB connection problem in " + what));
        return false;
    }

    public void close() {
        if (this.dbCon != null) {
            this.unprepareStatements();
            this.dbCon.close();
        }
        this.dbCon = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        logger.info((Object)("shutdown called for: " + this.dbCon.toString()));
        if (this.dbCon == null) {
            logger.info((Object)"shutdown: DB already closed");
            return;
        }
        if (this.dbCon.dbType != 2) {
            logger.info((Object)"shutdown: Ignored, no HSQLDB database");
            return;
        }
        if (!this.writeable) {
            logger.error((Object)"shutdown: ignored, read-only connection");
            return;
        }
        DBConnection dBConnection = this.dbCon;
        synchronized (dBConnection) {
            try {
                Statement s = this.dbCon.getConnection().createStatement();
                s.execute("SHUTDOWN COMPACT");
                s.close();
            }
            catch (NullPointerException npe) {
                logger.error((Object)"shutdown: Null pointer exception: ", (Throwable)npe);
            }
            catch (SQLException sqle) {
                if (sqle.toString().indexOf("is shutdown") != -1) {
                    logger.info((Object)"shutdown: database already shutdown");
                }
                logger.error((Object)("shutdown: SQLException: " + sqle), (Throwable)sqle);
            }
            this.dbCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean initDB() {
        SQLException e222;
        boolean bl;
        ResultSet rs;
        Statement statement;
        block21: {
            if (!this.getStatus("initDB")) {
                return false;
            }
            if (!this.writeable) {
                logger.error((Object)"initDB requires write-enabled connection");
                return false;
            }
            statement = null;
            rs = null;
            boolean noTable = true;
            statement = this.dbCon.getConnection().createStatement();
            try {
                rs = statement.executeQuery("SELECT count (*)  FROM " + this.versionsTable);
                if (rs.next()) {
                    noTable = false;
                }
            }
            catch (SQLException sqle1) {
                // empty catch block
            }
            if (noTable) {
                logger.warn((Object)"initDB: table is not existing - creating it...");
                statement.execute("CREATE " + this.dbCon.tableType + " TABLE " + this.versionsTable + "( nodeid VARCHAR PRIMARY KEY " + ", olderversion VARCHAR " + ", newerversion VARCHAR " + ", retired " + this.dbCon.boolType + ", creation_ts TIMESTAMP DEFAULT CURRENT_TIMESTAMP NOT NULL " + ")");
            }
            bl = true;
            Object var6_8 = null;
            if (rs == null) break block21;
            try {
                rs.close();
            }
            catch (SQLException e222) {
                // empty catch block
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e222) {
                // empty catch block
            }
        }
        return bl;
        catch (SQLException sqle2) {
            SQLException e222;
            boolean bl2;
            block23: {
                try {
                    logger.error((Object)"initDB: SQL exception ", (Throwable)sqle2);
                    bl2 = false;
                    Object var6_9 = null;
                    if (rs == null) break block23;
                }
                catch (Throwable throwable) {
                    block25: {
                        SQLException e222;
                        Object var6_10 = null;
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (SQLException e222) {
                                // empty catch block
                            }
                        }
                        if (statement == null) break block25;
                        try {
                            statement.close();
                        }
                        catch (SQLException e222) {}
                    }
                    throw throwable;
                }
                try {
                    rs.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e222) {
                    // empty catch block
                }
            }
            return bl2;
        }
    }

    private boolean prepareStatements(boolean write) {
        try {
            this.getAllSTM = this.dbCon.getConnection().prepareStatement("SELECT nodeid FROM " + this.versionsTable + " WHERE retired=?");
            this.isRetiredSTM = this.dbCon.getConnection().prepareStatement("SELECT retired FROM " + this.versionsTable + " WHERE nodeid=?");
            this.getTimestampSTM = this.dbCon.getConnection().prepareStatement("SELECT creation_ts FROM " + this.versionsTable + " WHERE nodeid=?");
            this.getPreviousSTM = this.dbCon.getConnection().prepareStatement("SELECT olderversion FROM " + this.versionsTable + " WHERE nodeid=?");
            this.getNextSTM = this.dbCon.getConnection().prepareStatement("SELECT newerversion FROM " + this.versionsTable + " WHERE nodeid=?");
            if (!write) {
                return true;
            }
            this.setNewerSTM = this.dbCon.getConnection().prepareStatement("UPDATE " + this.versionsTable + " SET newerversion = ? WHERE nodeid = ?");
            this.linkNewerSTM = this.dbCon.getConnection().prepareStatement("INSERT INTO " + this.versionsTable + " (newerversion, nodeid, olderversion, retired) " + "VALUES (?, ?, null, false)");
            this.setOlderSTM = this.dbCon.getConnection().prepareStatement("UPDATE " + this.versionsTable + " SET olderversion = ? WHERE nodeid = ?");
            this.linkOlderSTM = this.dbCon.getConnection().prepareStatement("INSERT INTO " + this.versionsTable + " (nodeid, olderversion, newerversion, retired) " + "VALUES (?, ?, null, false)");
            this.setRetiredSTM = this.dbCon.getConnection().prepareStatement("UPDATE " + this.versionsTable + " SET retired = ? WHERE nodeid = ?");
            this.addRetiredSTM = this.dbCon.getConnection().prepareStatement("INSERT INTO " + this.versionsTable + " (retired, nodeid, olderversion, newerversion) " + "VALUES (?, ?, null, null)");
            return true;
        }
        catch (SQLException sqle) {
            logger.error((Object)("createStatements: SQLException: " + sqle), (Throwable)sqle);
            return false;
        }
    }

    private boolean unprepareStatements() {
        try {
            if (this.getAllSTM != null) {
                this.getAllSTM.close();
            }
            this.getAllSTM = null;
            if (this.isRetiredSTM != null) {
                this.isRetiredSTM.close();
            }
            this.isRetiredSTM = null;
            if (this.getTimestampSTM != null) {
                this.getTimestampSTM.close();
            }
            this.getTimestampSTM = null;
            if (this.getPreviousSTM != null) {
                this.getPreviousSTM.close();
            }
            this.getPreviousSTM = null;
            if (this.getNextSTM != null) {
                this.getNextSTM.close();
            }
            this.getNextSTM = null;
            if (this.setNewerSTM != null) {
                this.setNewerSTM.close();
            }
            this.setNewerSTM = null;
            if (this.linkNewerSTM != null) {
                this.linkNewerSTM.close();
            }
            this.linkNewerSTM = null;
            if (this.setOlderSTM != null) {
                this.setOlderSTM.close();
            }
            this.setOlderSTM = null;
            if (this.linkOlderSTM != null) {
                this.linkOlderSTM.close();
            }
            this.linkOlderSTM = null;
            if (this.setRetiredSTM != null) {
                this.setRetiredSTM.close();
            }
            this.setRetiredSTM = null;
            if (this.addRetiredSTM != null) {
                this.addRetiredSTM.close();
            }
            this.addRetiredSTM = null;
            return true;
        }
        catch (SQLException sqle) {
            logger.error((Object)("unprepareStatements: SQLException: " + sqle), (Throwable)sqle);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setVersionSQL(String oldId, String newId, PreparedStatement stm, String what) {
        try {
            PreparedStatement preparedStatement = stm;
            synchronized (preparedStatement) {
                stm.clearParameters();
                stm.setString(1, newId);
                stm.setString(2, oldId);
                int n = stm.executeUpdate();
                if (n == 1) {
                    return true;
                }
                if (n > 1) {
                    logger.warn((Object)("setVersionSQL: Unexpected n=" + n + " for " + what + "(" + oldId + ", " + newId + ")"));
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("setVersionSQL: SQLException " + sqle + " for " + what + "(" + oldId + ", " + newId + ")"), (Throwable)sqle);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setFlagSQL(String nodeId, boolean flag, PreparedStatement stm, String what) {
        try {
            PreparedStatement preparedStatement = stm;
            synchronized (preparedStatement) {
                stm.clearParameters();
                stm.setBoolean(1, flag);
                stm.setString(2, nodeId);
                int n = stm.executeUpdate();
                if (n == 1) {
                    return true;
                }
                if (n > 1) {
                    logger.warn((Object)("setFlagSQL: Unexpected n=" + n + " for " + what + " at: " + nodeId));
                }
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)("setFlagSQL: SQLException " + sqle + " for " + what + " at: " + nodeId), (Throwable)sqle);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getStringSQL(String nodeId, PreparedStatement stm, String what) {
        block15: {
            block14: {
                rs = null;
                try {
                    try {
                        var5_5 = stm;
                        synchronized (var5_5) {
                            stm.clearParameters();
                            stm.setString(1, nodeId);
                            rs = stm.executeQuery();
                            if (rs.next()) {
                                var6_7 = rs.getString(1);
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 13] lbl11 : MonitorExitStatement: MONITOREXIT : var5_5
                                var9_8 = null;
                                if (rs == null) return var6_7;
                                break block14;
                            }
                            break block15;
                        }
                    }
                    catch (SQLException sqle) {
                        VersioningAPI.logger.error((Object)("getStringSQL: SQLException " + sqle + " for " + what + " at: " + nodeId), (Throwable)sqle);
                        var9_10 = null;
                        if (rs == null) return null;
                        try {
                            rs.close();
                            return null;
                        }
                        catch (SQLException e) {
                            return null;
                        }
                    }
                }
                catch (Throwable var8_16) {
                    var9_11 = null;
                    if (rs == null) throw var8_16;
                    ** try [egrp 4[TRYBLOCK] [9 : 148->158)] { 
lbl32:
                    // 1 sources

                    rs.close();
                    throw var8_16;
lbl34:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    throw var8_16;
                }
            }
            ** try [egrp 4[TRYBLOCK] [9 : 148->158)] { 
lbl39:
            // 1 sources

            rs.close();
            return var6_7;
lbl41:
            // 1 sources

            catch (SQLException e) {
                // empty catch block
            }
            return var6_7;
        }
        var9_9 = null;
        if (rs == null) return null;
        try {}
        catch (SQLException e) {}
        rs.close();
        return null;
        return null;
    }

    private boolean badNodeId(String node, String why) {
        if (node == null) {
            logger.warn((Object)("badNodeId null in " + why));
            return true;
        }
        if (node.indexOf(92) != -1) {
            logger.warn((Object)("badNodeId with backslash in " + why));
            return true;
        }
        if (node.indexOf(39) != -1) {
            logger.warn((Object)("badNodeId with quote in " + why));
            return true;
        }
        return false;
    }

    public boolean addNewVersionOf(String oldNodeId, String newNodeId) {
        if (!this.getStatus("addNewVersionOf")) {
            return false;
        }
        if (!this.writeable) {
            logger.error((Object)"addNewVersionOf requires write-enabled connection");
            return false;
        }
        if (this.badNodeId(oldNodeId, "addNewVersionOf/1") || this.badNodeId(newNodeId, "addNewVersionOf/2")) {
            return false;
        }
        if (this.getNewerVersion(oldNodeId) != null) {
            return false;
        }
        if (this.getOlderVersion(newNodeId) != null) {
            return false;
        }
        if (oldNodeId.equals(newNodeId)) {
            logger.warn((Object)("addNewVersionOf: Link between 2 equal versions ignored: " + newNodeId));
            return true;
        }
        if (!this.setVersionSQL(oldNodeId, newNodeId, this.setNewerSTM, "addNewVersionOf:updateold") && !this.setVersionSQL(oldNodeId, newNodeId, this.linkNewerSTM, "addNewVersionOf:addold")) {
            logger.warn((Object)("addNewVersionOf: Failed to link OLD=" + oldNodeId + " new=" + newNodeId));
            return false;
        }
        if (!this.setVersionSQL(newNodeId, oldNodeId, this.setOlderSTM, "addNewVersionOf:updatenew") && !this.setVersionSQL(oldNodeId, newNodeId, this.linkOlderSTM, "addNewVersionOf:addnew")) {
            logger.warn((Object)("addNewVersionOf: Failed to link old=" + oldNodeId + " NEW=" + newNodeId));
            return false;
        }
        return true;
    }

    public boolean setVersionStatus(String nodeId, boolean retired) {
        if (!this.getStatus("setVersionStatus")) {
            return false;
        }
        if (!this.writeable) {
            logger.error((Object)"setVersionStatus requires write-enabled connection");
            return false;
        }
        if (this.badNodeId(nodeId, "setVersionStatus")) {
            return false;
        }
        if (!this.setFlagSQL(nodeId, retired, this.setRetiredSTM, "setVersionStatus/set") && !this.setFlagSQL(nodeId, retired, this.addRetiredSTM, "setVersionStatus/add")) {
            logger.warn((Object)("setVersionStatus: Failed to store flag for " + nodeId));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isRetired(String nodeId) {
        block17: {
            block16: {
                result = null;
                if (this.badNodeId(nodeId, "isRetired")) {
                    return true;
                }
                if (!this.getStatus("isRetired")) {
                    return true;
                }
                rs = null;
                try {
                    try {
                        var4_4 = this.isRetiredSTM;
                        synchronized (var4_4) {
                            this.isRetiredSTM.clearParameters();
                            this.isRetiredSTM.setString(1, nodeId);
                            rs = this.isRetiredSTM.executeQuery();
                            if (rs.next()) {
                                var5_6 = rs.getBoolean(1);
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 15] lbl16 : MonitorExitStatement: MONITOREXIT : var4_4
                                var8_7 = null;
                                if (rs == null) return var5_6;
                                break block16;
                            }
                            break block17;
                        }
                    }
                    catch (SQLException sqle) {
                        VersioningAPI.logger.error((Object)("isRetired: SQLException " + sqle + " for node: " + nodeId), (Throwable)sqle);
                        var8_9 = null;
                        if (rs == null) return false;
                        try {
                            rs.close();
                            return false;
                        }
                        catch (SQLException e) {
                            return false;
                        }
                    }
                }
                catch (Throwable var7_15) {
                    var8_10 = null;
                    if (rs == null) throw var7_15;
                    ** try [egrp 4[TRYBLOCK] [9 : 171->180)] { 
lbl37:
                    // 1 sources

                    rs.close();
                    throw var7_15;
lbl39:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    throw var7_15;
                }
            }
            ** try [egrp 4[TRYBLOCK] [9 : 171->180)] { 
lbl44:
            // 1 sources

            rs.close();
            return var5_6;
lbl46:
            // 1 sources

            catch (SQLException e) {
                // empty catch block
            }
            return var5_6;
        }
        var8_8 = null;
        if (rs == null) return false;
        try {}
        catch (SQLException e) {}
        rs.close();
        return false;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Timestamp getDateOfVersion(String nodeId) {
        block17: {
            block16: {
                result = null;
                if (this.badNodeId(nodeId, "getDateOfVersion")) {
                    return null;
                }
                if (!this.getStatus("getDateOfVersion")) {
                    return null;
                }
                rs = null;
                try {
                    try {
                        var4_4 = this.isRetiredSTM;
                        synchronized (var4_4) {
                            this.getTimestampSTM.clearParameters();
                            this.getTimestampSTM.setString(1, nodeId);
                            rs = this.getTimestampSTM.executeQuery();
                            if (rs.next()) {
                                var5_6 = rs.getTimestamp(1);
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 15] lbl16 : MonitorExitStatement: MONITOREXIT : var4_4
                                var8_7 = null;
                                if (rs == null) return var5_6;
                                break block16;
                            }
                            break block17;
                        }
                    }
                    catch (SQLException sqle) {
                        VersioningAPI.logger.error((Object)("getDateOfVersion: SQLException " + sqle + " for node: " + nodeId), (Throwable)sqle);
                        var8_9 = null;
                        if (rs == null) return null;
                        try {
                            rs.close();
                            return null;
                        }
                        catch (SQLException e) {
                            return null;
                        }
                    }
                }
                catch (Throwable var7_15) {
                    var8_10 = null;
                    if (rs == null) throw var7_15;
                    ** try [egrp 4[TRYBLOCK] [9 : 171->180)] { 
lbl37:
                    // 1 sources

                    rs.close();
                    throw var7_15;
lbl39:
                    // 1 sources

                    catch (SQLException e) {
                        // empty catch block
                    }
                    throw var7_15;
                }
            }
            ** try [egrp 4[TRYBLOCK] [9 : 171->180)] { 
lbl44:
            // 1 sources

            rs.close();
            return var5_6;
lbl46:
            // 1 sources

            catch (SQLException e) {
                // empty catch block
            }
            return var5_6;
        }
        var8_8 = null;
        if (rs == null) return null;
        try {}
        catch (SQLException e) {}
        rs.close();
        return null;
        return null;
    }

    public String getOlderVersion(String nodeId) {
        Object result = null;
        if (this.badNodeId(nodeId, "getOlderVersion")) {
            return null;
        }
        if (!this.getStatus("getOlderVersion")) {
            return null;
        }
        return this.getStringSQL(nodeId, this.getPreviousSTM, "getOlderVersion");
    }

    public String getNewerVersion(String nodeId) {
        Object result = null;
        if (this.badNodeId(nodeId, "getNewerVersion")) {
            return null;
        }
        if (!this.getStatus("getNewerVersion")) {
            return null;
        }
        return this.getStringSQL(nodeId, this.getNextSTM, "getNewerVersion");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector listAllVersions(boolean retired) {
        ResultSet rs = null;
        Vector<String> results = new Vector<String>();
        PreparedStatement preparedStatement = this.getAllSTM;
        synchronized (preparedStatement) {
            this.getAllSTM.clearParameters();
            this.getAllSTM.setBoolean(1, retired);
            rs = this.getAllSTM.executeQuery();
            while (rs.next()) {
                results.add(rs.getString(1));
            }
        }
        Object var7_7 = null;
        if (rs == null) return results;
        try {
            rs.close();
            return results;
        }
        catch (SQLException e) {}
        return results;
        {
            catch (SQLException sqle) {
                logger.error((Object)("listAllVersions: SQLException " + sqle), (Throwable)sqle);
                Object var7_8 = null;
                if (rs == null) return results;
                try {
                    rs.close();
                    return results;
                }
                catch (SQLException e) {}
                return results;
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (rs == null) throw throwable;
            try {
                rs.close();
                throw throwable;
            }
            catch (SQLException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getNewestVersion(String nodeId) {
        if (!this.getStatus("getNewestVersion")) {
            return nodeId;
        }
        String node = nodeId;
        String newNode;
        while ((newNode = this.getNewerVersion(node)) != null) {
            node = newNode;
        }
        return node;
    }

    public String getOldestVersion(String nodeId) {
        if (!this.getStatus("getOldestVersion")) {
            return nodeId;
        }
        String node = nodeId;
        String oldNode;
        while ((oldNode = this.getOlderVersion(node)) != null) {
            node = oldNode;
        }
        return node;
    }

    public Vector getAllVersions(String nodeId, boolean showRetired) {
        Vector<String> result = new Vector<String>();
        if (!this.getStatus("getAllVersions")) {
            return result;
        }
        String where = this.getOldestVersion(nodeId);
        if (showRetired || !this.isRetired(where)) {
            result.add(where);
        }
        while ((where = this.getNewerVersion(where)) != null) {
            if (!showRetired && this.isRetired(where)) continue;
            result.add(where);
        }
        return result;
    }

    private static String getNodeURL(ArchiveObjectsDB aodb, String nodeId) {
        if (!NodeIdUtils.isNodeId(nodeId) || aodb == null) {
            return "notyet://nodeid/" + nodeId;
        }
        try {
            OurURL where = aodb.getObjectURL(nodeId, ArchiveAccessContext.getFileUrlContext());
            return where == null ? "notyet://nullurl/" + nodeId : where.toString();
        }
        catch (UnknownNodeException une) {
            return "notyet://unknownid/" + nodeId;
        }
    }

    private static String showVersionInfo(VersioningAPI vdb, String nodeId) {
        String newer;
        StringBuffer result = new StringBuffer();
        String older = vdb.getOlderVersion(nodeId);
        if (older != null) {
            result.append("supersedes: ").append(older);
            String oldest = vdb.getOldestVersion(nodeId);
            if (!older.equals(oldest)) {
                result.append(" oldest: ").append(oldest);
            }
        }
        if ((newer = vdb.getNewerVersion(nodeId)) != null) {
            if (older != null) {
                result.append(" ");
            }
            result.append("replacedby: ").append(newer);
            String newest = vdb.getNewestVersion(nodeId);
            if (!newer.equals(newest)) {
                result.append(" newest: ").append(newest);
            }
        }
        Timestamp when = vdb.getDateOfVersion(nodeId);
        when.setTime(when.getTime() + 50L - (when.getTime() + 50L) % 100L);
        result.append(" date: ").append(when);
        return result.toString();
    }

    public static void main(String[] args) {
        String nodeURL;
        String infoText;
        String nodeId;
        int i;
        if (args.length == 0 || args[0] == null || !args[0].startsWith("jdbc") && !args[0].startsWith("java")) {
            System.out.println("Running VersioningAPI as command line tool requires a JDBC URL as 1st option");
            System.out.println("Example: jdbc:postgresql://SERVER.mpi.nl:5432/corpusstructure");
            System.out.println("Optional 2nd option: Directory for creation of version lists as IMDI");
            System.out.println("Note: Will use the same JDBC URL to fetch URIDs and URLs");
            return;
        }
        File targetDir = null;
        IMDIDom iEdit = null;
        Document retiredIMDI = null;
        Document versionedIMDI = null;
        OurURL baseURL = null;
        CorpusStructureDBImpl aodb = null;
        if (args.length == 2) {
            targetDir = new File(args[1]);
            if (!targetDir.canWrite() || !targetDir.isDirectory()) {
                System.out.println("2nd option, if given, must be a writeable directory");
                return;
            }
            iEdit = new IMDIDom();
            retiredIMDI = iEdit.createIMDIDOM(2);
            iEdit.setIMDIValue(retiredIMDI, "Corpus.Name", "RetiredNodes");
            iEdit.setIMDIValue(retiredIMDI, "Corpus.Title", "List of retired nodes known in the versioning database");
            versionedIMDI = iEdit.createIMDIDOM(2);
            iEdit.setIMDIValue(versionedIMDI, "Corpus.Name", "VersionedNodes");
            iEdit.setIMDIValue(versionedIMDI, "Corpus.Title", "List of version relations listed in the versioning database");
            try {
                baseURL = new OurURL(new File(targetDir, "any.imdi").toURL());
            }
            catch (MalformedURLException mue) {
                System.out.println("Malformed target dir URL, maybe bad chars in '" + targetDir + "'?");
                return;
            }
            aodb = new CorpusStructureDBImpl(args[0]);
            IMDILink.setResolver((ArchiveObjectsDB)aodb, (int)ArchiveAccessContext.getFileUrlContext(), (boolean)true);
        }
        System.out.println("Versioning info from database: " + args[0]);
        VersioningAPI vdb = new VersioningAPI(args[0]);
        System.out.println("\nRetired:");
        Vector allv = vdb.listAllVersions(true);
        for (i = 0; i < allv.size(); ++i) {
            nodeId = (String)allv.elementAt(i);
            infoText = VersioningAPI.showVersionInfo(vdb, nodeId);
            System.out.println(nodeId + " retired:   " + infoText);
            if (retiredIMDI == null || aodb == null || iEdit == null) continue;
            nodeURL = VersioningAPI.getNodeURL(aodb, nodeId);
            iEdit.createIMDILink(retiredIMDI, baseURL, nodeURL, "Retired " + infoText, 3, "Corpus");
        }
        System.out.println("\nActive:");
        allv = vdb.listAllVersions(false);
        for (i = 0; i < allv.size(); ++i) {
            nodeId = (String)allv.elementAt(i);
            infoText = VersioningAPI.showVersionInfo(vdb, nodeId);
            System.out.println(nodeId + " " + infoText);
            if (versionedIMDI == null || aodb == null || iEdit == null) continue;
            nodeURL = VersioningAPI.getNodeURL(aodb, nodeId);
            iEdit.createIMDILink(versionedIMDI, baseURL, nodeURL, infoText, 3, "Corpus");
        }
        vdb.close();
        if (targetDir != null && iEdit != null && retiredIMDI != null && versionedIMDI != null) {
            if (!iEdit.writeDOM(retiredIMDI, new File(targetDir, "retired-versions.imdi"), true)) {
                System.out.println("Failed to write retired-versions.imdi to " + targetDir);
            }
            if (!iEdit.writeDOM(versionedIMDI, new File(targetDir, "version-relations.imdi"), true)) {
                System.out.println("Failed to write version-relations.imdi to " + targetDir);
            }
        }
    }
}

