/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.dom;

import net.sf.saxon.Configuration;
import net.sf.saxon.dom.NodeWrapper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DocumentWrapper
extends NodeWrapper
implements DocumentInfo {
    protected Configuration config;
    protected String baseURI;
    protected int documentNumber;
    protected boolean level3 = false;

    public DocumentWrapper(Node node, String string, Configuration configuration) {
        super(node, null, 0);
        if (node.getNodeType() != 9 && node.getNodeType() != 11) {
            throw new IllegalArgumentException("Node must be a DOM Document or DocumentFragment");
        }
        this.node = node;
        this.nodeKind = (short)9;
        this.baseURI = string;
        this.docWrapper = this;
        this.setConfiguration(configuration);
    }

    public NodeWrapper wrap(Node node) {
        if (node == this.node) {
            return this;
        }
        if (node.getOwnerDocument() == this.node) {
            return this.makeWrapper(node, this);
        }
        throw new IllegalArgumentException("DocumentWrapper#wrap: supplied node does not belong to the wrapped DOM document");
    }

    public void setConfiguration(Configuration configuration) {
        this.config = configuration;
        this.documentNumber = configuration.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public NodeInfo selectID(String string) {
        if (this.node instanceof Document) {
            Element element = ((Document)this.node).getElementById(string);
            if (element == null) {
                return null;
            }
            return this.wrap(element);
        }
        return null;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        if (!(nodeInfo instanceof DocumentWrapper)) {
            return false;
        }
        return this.node == ((DocumentWrapper)nodeInfo).node;
    }

    public String[] getUnparsedEntity(String string) {
        return null;
    }
}

