/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import nl.mpi.arbil.DownloadAbortFlag;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.importexport.ShibbolethNegotiator;

public class LinorgSessionStorage {
    public File storageDirectory = null;
    private File localCacheDirectory = null;
    private static LinorgSessionStorage singleInstance = null;
    public boolean trackTableSelection = false;
    public boolean useLanguageIdInColumnName = false;

    public static synchronized LinorgSessionStorage getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new LinorgSessionStorage();
        }
        return singleInstance;
    }

    private LinorgSessionStorage() {
        String[] storageDirectoryArray;
        for (String currentStorageDirectory : storageDirectoryArray = this.getLocationOptions()) {
            File storageFile = new File(currentStorageDirectory);
            if (!storageFile.exists()) continue;
            System.out.println("existing storage directory found: " + currentStorageDirectory);
            this.storageDirectory = storageFile;
            break;
        }
        String testedStorageDirectories = "";
        if (this.storageDirectory == null) {
            for (String currentStorageDirectory : storageDirectoryArray) {
                File storageFile;
                if (currentStorageDirectory.startsWith("null") || (storageFile = new File(currentStorageDirectory)).exists()) continue;
                storageFile.mkdir();
                if (!storageFile.exists()) {
                    testedStorageDirectories = testedStorageDirectories + currentStorageDirectory + "\n";
                    System.out.println("failed to create: " + currentStorageDirectory);
                    continue;
                }
                System.out.println("created new storage directory: " + currentStorageDirectory);
                this.storageDirectory = storageFile;
                break;
            }
        }
        if (this.storageDirectory == null) {
            JOptionPane.showMessageDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Could not create a working directory in any of the potential location:\n" + testedStorageDirectories + "Please check that you have write permissions in at least one of these locations.\nThe application will now exit.", "Arbil Critical Error", 0);
            System.exit(-1);
        }
        this.trackTableSelection = this.loadBoolean("trackTableSelection", false);
        this.useLanguageIdInColumnName = this.loadBoolean("useLanguageIdInColumnName", false);
        System.out.println("storageDirectory: " + this.storageDirectory);
    }

    public void changeCacheDirectory(File preferedCacheDirectory, boolean moveFiles) {
        File fromDirectory = this.getCacheDirectory();
        if (!(preferedCacheDirectory.getAbsolutePath().contains("ArbilWorkingFiles") || preferedCacheDirectory.getAbsolutePath().contains(".arbil/imdicache") || this.localCacheDirectory.getAbsolutePath().contains(".linorg/imdicache"))) {
            preferedCacheDirectory = new File(preferedCacheDirectory, "ArbilWorkingFiles");
        }
        if (!moveFiles || 0 == JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Moving files from:\n" + fromDirectory + "\nto:\n" + preferedCacheDirectory + "\n" + "Arbil will need to close in order to change the working directory.\nDo you wish to continue?", "Arbil", 2, -1)) {
            if (moveFiles) {
                this.saveString("cacheDirectory", preferedCacheDirectory.getAbsolutePath());
                this.changeStorageDirectory(fromDirectory, preferedCacheDirectory);
            } else {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not change to the requested location.", null);
            }
        }
    }

    public void changeStorageDirectory(String preferedDirectory) {
        if (0 == JOptionPane.showConfirmDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Arbil will need to close in order to move the storage directory.\nDo you wish to continue?", "Arbil", 2, -1)) {
            File fromDirectory = this.storageDirectory;
            File toDirectory = new File(preferedDirectory);
            this.storageDirectory = new File(preferedDirectory);
            this.changeStorageDirectory(fromDirectory, toDirectory);
        }
    }

    private void changeStorageDirectory(File fromDirectory, File toDirectory) {
        String toDirectoryUriString = toDirectory.toURI().toString().replaceAll("/$", "");
        String fromDirectoryUriString = fromDirectory.toURI().toString().replaceAll("/$", "");
        System.out.println("toDirectoryUriString: " + toDirectoryUriString);
        System.out.println("fromDirectoryUriString: " + fromDirectoryUriString);
        try {
            toDirectoryUriString = URLDecoder.decode(toDirectoryUriString, "UTF-8");
            fromDirectoryUriString = URLDecoder.decode(fromDirectoryUriString, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            GuiHelper.linorgBugCatcher.logError(uee);
        }
        boolean success = fromDirectory.renameTo(toDirectory);
        if (!success) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not move the existing files to the requested location.", null);
        } else {
            try {
                Vector<String> locationsList = new Vector<String>();
                ImdiTreeObject[][] arr$ = new ImdiTreeObject[][]{TreeHelper.getSingleInstance().remoteCorpusNodes, TreeHelper.getSingleInstance().localCorpusNodes, TreeHelper.getSingleInstance().localFileNodes, TreeHelper.getSingleInstance().favouriteNodes};
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    ImdiTreeObject[] currentTreeArray;
                    for (ImdiTreeObject currentLocation : currentTreeArray = arr$[i$]) {
                        String currentLocationString = URLDecoder.decode(currentLocation.getUrlString(), "UTF-8");
                        System.out.println("currentLocationString: " + currentLocationString);
                        System.out.println("prefferedDirectoryUriString: " + toDirectoryUriString);
                        System.out.println("storageDirectoryUriString: " + fromDirectoryUriString);
                        locationsList.add(currentLocationString.replace(fromDirectoryUriString, toDirectoryUriString));
                    }
                }
                LinorgSessionStorage.getSingleInstance().saveStringArray("locationsList", locationsList.toArray(new String[0]));
                System.out.println("updated locationsList");
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
            TreeHelper.getSingleInstance().loadLocationsList();
            JOptionPane.showOptionDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "The requested files have been moved, Arbil will now exit.", "Arbil", 0, -1, null, new String[]{"Exit"}, "Exit");
            System.exit(0);
        }
    }

    public String[] getLocationOptions() {
        String[] locationOptions;
        for (String currentLocationOption : locationOptions = new String[]{System.getProperty("user.home") + File.separatorChar + "Local Settings" + File.separatorChar + "Application Data" + File.separatorChar + ".arbil" + File.separatorChar, System.getenv("APPDATA") + File.separatorChar + ".arbil" + File.separatorChar, System.getProperty("user.home") + File.separatorChar + ".arbil" + File.separatorChar, System.getenv("USERPROFILE") + File.separatorChar + ".arbil" + File.separatorChar, System.getProperty("user.dir") + File.separatorChar + ".arbil" + File.separatorChar, System.getenv("APPDATA") + File.separatorChar + ".linorg" + File.separatorChar, System.getProperty("user.home") + File.separatorChar + ".linorg" + File.separatorChar, System.getenv("USERPROFILE") + File.separatorChar + ".linorg" + File.separatorChar, System.getProperty("user.dir") + File.separatorChar + ".linorg" + File.separatorChar}) {
            System.out.println("LocationOption: " + currentLocationOption);
        }
        return locationOptions;
    }

    public boolean pathIsInFavourites(File fullTestFile) {
        String favouritesString = "favourites";
        int foundPos = fullTestFile.getPath().indexOf(favouritesString) + favouritesString.length();
        if (foundPos == -1) {
            return false;
        }
        if (foundPos > fullTestFile.getPath().length()) {
            return false;
        }
        File testFile = new File(fullTestFile.getPath().substring(0, foundPos));
        return this.getFavouritesDir().equals(testFile);
    }

    public URI getOriginatingUri(URI locationInCacheURI) {
        URI returnUri = null;
        String uriPath = locationInCacheURI.getPath();
        System.out.println("uriPath: " + uriPath);
        int foundPos = uriPath.indexOf("imdicache");
        if (foundPos == -1) {
            return null;
        }
        uriPath = uriPath.substring(foundPos);
        String[] uriParts = uriPath.split("/", 4);
        try {
            if (uriParts[1].toLowerCase().equals("http")) {
                returnUri = new URI(uriParts[1], uriParts[2], "/" + uriParts[3], null);
                System.out.println("returnUri: " + returnUri);
            }
        }
        catch (URISyntaxException urise) {
            GuiHelper.linorgBugCatcher.logError(urise);
        }
        return returnUri;
    }

    public boolean pathIsInsideCache(File fullTestFile) {
        File cacheDirectory = this.getCacheDirectory();
        for (File testFile = fullTestFile; testFile != null; testFile = testFile.getParentFile()) {
            if (!testFile.equals(cacheDirectory)) continue;
            return true;
        }
        return false;
    }

    public File getFavouritesDir() {
        File favDirectory = new File(this.storageDirectory, "favourites");
        boolean favDirExists = favDirectory.exists();
        if (!favDirExists) {
            favDirExists = favDirectory.mkdir();
        }
        return favDirectory;
    }

    public File getCacheDirectory() {
        if (this.localCacheDirectory == null) {
            String localCacheDirectoryPathString = this.loadString("cacheDirectory");
            if (localCacheDirectoryPathString != null) {
                this.localCacheDirectory = new File(localCacheDirectoryPathString);
            } else {
                try {
                    File localWorkingDirectory;
                    this.localCacheDirectory = localWorkingDirectory = (File)this.loadObject("cacheDirectory");
                }
                catch (Exception exception) {
                    this.localCacheDirectory = new File(this.storageDirectory, "imdicache");
                }
                this.saveString("cacheDirectory", this.localCacheDirectory.getAbsolutePath());
            }
            boolean cacheDirExists = this.localCacheDirectory.exists();
            if (!cacheDirExists) {
                boolean bl = this.localCacheDirectory.mkdirs();
            }
        }
        return this.localCacheDirectory;
    }

    public void saveObject(Serializable object, String filename) throws IOException {
        System.out.println("saveObject: " + filename);
        ObjectOutputStream objstream = new ObjectOutputStream(new FileOutputStream(new File(this.storageDirectory, filename)));
        objstream.writeObject(object);
        objstream.close();
    }

    public Object loadObject(String filename) throws Exception {
        System.out.println("loadObject: " + filename);
        Object object = null;
        ObjectInputStream objstream = new ObjectInputStream(new FileInputStream(new File(this.storageDirectory, filename)));
        object = objstream.readObject();
        objstream.close();
        if (object == null) {
            throw new Exception("Loaded object is null");
        }
        return object;
    }

    public String[] loadStringArray(String filename) {
        try {
            String strLine;
            ArrayList<String> stringArrayList = new ArrayList<String>();
            FileInputStream fstream = new FileInputStream(new File(this.storageDirectory, filename + ".config"));
            DataInputStream in = new DataInputStream(fstream);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            while ((strLine = br.readLine()) != null) {
                stringArrayList.add(strLine);
            }
            in.close();
            return stringArrayList.toArray(new String[0]);
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
    }

    public void saveStringArray(String filename, String[] storableValue) {
        try {
            FileWriter fstream = new FileWriter(new File(this.storageDirectory, filename + ".config"));
            BufferedWriter out = new BufferedWriter(fstream);
            for (String currentString : storableValue) {
                out.write(currentString + "\r\n");
            }
            out.close();
        }
        catch (Exception exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
    }

    public String loadString(String filename) {
        Properties configObject = this.getConfig();
        String stringProperty = configObject.getProperty("nl.mpi.arbil." + filename);
        return stringProperty;
    }

    public void saveString(String filename, String storableValue) {
        Properties configObject = this.getConfig();
        configObject.setProperty("nl.mpi.arbil." + filename, storableValue);
        this.saveConfig(configObject);
    }

    public boolean loadBoolean(String filename, boolean defaultValue) {
        Properties configObject = this.getConfig();
        String stringProperty = configObject.getProperty("nl.mpi.arbil." + filename);
        if (stringProperty == null) {
            stringProperty = new Boolean(defaultValue).toString();
            this.saveBoolean(filename, defaultValue);
        }
        return stringProperty.equalsIgnoreCase("true");
    }

    public void saveBoolean(String filename, boolean storableValue) {
        Properties configObject = this.getConfig();
        configObject.setProperty("nl.mpi.arbil." + filename, new Boolean(storableValue).toString());
        this.saveConfig(configObject);
    }

    private Properties getConfig() {
        Properties propertiesObject = new Properties();
        try {
            FileInputStream propertiesInStream = new FileInputStream(new File(this.storageDirectory, "arbil.config"));
            propertiesObject.load(propertiesInStream);
            propertiesInStream.close();
        }
        catch (IOException ioe) {
            this.saveConfig(propertiesObject);
        }
        return propertiesObject;
    }

    private void saveConfig(Properties configObject) {
        try {
            FileOutputStream propertiesOutputStream = new FileOutputStream(new File(this.storageDirectory, "arbil.config"));
            configObject.store(propertiesOutputStream, null);
            propertiesOutputStream.close();
        }
        catch (IOException ioe) {
            GuiHelper.linorgBugCatcher.logError(ioe);
        }
    }

    public File updateCache(String pathString, int expireCacheDays) {
        boolean fileNeedsUpdate;
        File targetFile = this.getSaveLocation(pathString);
        boolean bl = fileNeedsUpdate = !targetFile.exists();
        if (!fileNeedsUpdate) {
            Date lastModified = new Date(targetFile.lastModified());
            Date expireDate = new Date(System.currentTimeMillis());
            System.out.println("updateCache: " + expireDate + " : " + lastModified + " : " + targetFile.getAbsolutePath());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(expireDate);
            calendar.add(5, -expireCacheDays);
            expireDate.setTime(calendar.getTime().getTime());
            System.out.println("updateCache: " + expireDate + " : " + lastModified + " : " + targetFile.getAbsolutePath());
            fileNeedsUpdate = expireDate.after(lastModified);
            System.out.println("fileNeedsUpdate: " + fileNeedsUpdate);
        }
        System.out.println("fileNeedsUpdate: " + fileNeedsUpdate);
        return this.updateCache(pathString, null, fileNeedsUpdate, new DownloadAbortFlag());
    }

    public File updateCache(String pathString, ShibbolethNegotiator shibbolethNegotiator, boolean expireCacheCopy, DownloadAbortFlag abortFlag) {
        File cachePath = this.getSaveLocation(pathString);
        try {
            this.saveRemoteResource(new URL(pathString), cachePath, shibbolethNegotiator, expireCacheCopy, abortFlag);
        }
        catch (MalformedURLException mul) {
            GuiHelper.linorgBugCatcher.logError(mul);
        }
        return cachePath;
    }

    public boolean replaceCacheCopy(String pathString) {
        File cachePath = this.getSaveLocation(pathString);
        boolean fileDownloadedBoolean = false;
        try {
            fileDownloadedBoolean = this.saveRemoteResource(new URL(pathString), cachePath, null, true, new DownloadAbortFlag());
        }
        catch (MalformedURLException mul) {
            GuiHelper.linorgBugCatcher.logError(mul);
        }
        return fileDownloadedBoolean;
    }

    public File getExportPath(String pathString, String destinationDirectory) {
        System.out.println("pathString: " + pathString);
        System.out.println("destinationDirectory: " + destinationDirectory);
        String cachePath = pathString;
        for (String testDirectory : new String[]{"imdicache", "ArbilWorkingFiles"}) {
            if (!pathString.contains(testDirectory)) continue;
            cachePath = destinationDirectory + cachePath.substring(cachePath.lastIndexOf(testDirectory) + testDirectory.length());
        }
        File returnFile = new File(cachePath);
        if (!returnFile.getParentFile().exists()) {
            returnFile.getParentFile().mkdirs();
        }
        return returnFile;
    }

    public URI getNewImdiFileName(File parentDirectory, String nodeType) {
        String suffixString = nodeType.toLowerCase().contains("clarin") ? ".cmdi" : ".imdi";
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmss");
        int fileCounter = 0;
        File returnFile = new File(parentDirectory, formatter.format(new Date()) + suffixString);
        while (returnFile.exists()) {
            returnFile = new File(parentDirectory, formatter.format(new Date()) + fileCounter++ + suffixString);
        }
        return returnFile.toURI();
    }

    public File getSaveLocation(String pathString) {
        File returnFile;
        try {
            pathString = URLDecoder.decode(pathString, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            GuiHelper.linorgBugCatcher.logError(uee);
        }
        pathString = pathString.replace("//", "/");
        for (String searchString : new String[]{".linorg/imdicache", ".arbil/imdicache", ".linorg\\imdicache", ".arbil\\imdicache", "ArbilWorkingFiles"}) {
            if (pathString.indexOf(searchString) <= -1) continue;
            GuiHelper.linorgBugCatcher.logError(new Exception("Recursive path error (about to be corrected) in: " + pathString));
            pathString = pathString.substring(pathString.lastIndexOf(searchString) + searchString.length());
        }
        String cachePath = pathString.replace(":/", "/").replace("//", "/");
        while (cachePath.contains(":")) {
            cachePath = cachePath.replace(":", "_");
        }
        if ((cachePath = cachePath.replaceAll("/xsd$", ".xsd")).matches(".*/[^.]*$")) {
            cachePath = cachePath + ".dat";
        }
        if (!(returnFile = new File(this.getCacheDirectory(), cachePath)).getParentFile().exists()) {
            returnFile.getParentFile().mkdirs();
        }
        return returnFile;
    }

    public boolean saveRemoteResource(URL targetUrl, File destinationFile, ShibbolethNegotiator shibbolethNegotiator, boolean expireCacheCopy, DownloadAbortFlag abortFlag) {
        boolean downloadSucceeded = false;
        if (destinationFile.length() == 0L) {
            destinationFile.delete();
        }
        if (destinationFile.exists() && !expireCacheCopy && destinationFile.length() > 0L) {
            System.out.println("this resource is already in the cache");
        } else {
            try {
                URLConnection urlConnection = targetUrl.openConnection();
                HttpURLConnection httpConnection = null;
                if (urlConnection instanceof HttpURLConnection) {
                    httpConnection = (HttpURLConnection)urlConnection;
                    if (shibbolethNegotiator != null) {
                        httpConnection = shibbolethNegotiator.getShibbolethConnection((HttpURLConnection)urlConnection);
                    }
                    System.out.println("Code: " + httpConnection.getResponseCode() + ", Message: " + httpConnection.getResponseMessage());
                }
                if (httpConnection != null && httpConnection.getResponseCode() != 200) {
                    System.out.println("non 200 response, skipping file");
                } else {
                    File tempFile = File.createTempFile(destinationFile.getName(), "tmp", destinationFile.getParentFile());
                    tempFile.deleteOnExit();
                    int bufferLength = 3072;
                    FileOutputStream outFile = new FileOutputStream(tempFile);
                    System.out.println("getting file");
                    InputStream stream = urlConnection.getInputStream();
                    byte[] buffer = new byte[bufferLength];
                    int bytesread = 0;
                    int totalRead = 0;
                    while (bytesread >= 0 && !abortFlag.abortDownload) {
                        bytesread = stream.read(buffer);
                        totalRead += bytesread;
                        if (bytesread == -1) break;
                        outFile.write(buffer, 0, bytesread);
                    }
                    outFile.close();
                    if (tempFile.length() > 0L && !abortFlag.abortDownload) {
                        if (destinationFile.exists()) {
                            destinationFile.delete();
                        }
                        tempFile.renameTo(destinationFile);
                        downloadSucceeded = true;
                    }
                    System.out.println("Downloaded: " + totalRead / 0x100000 + " Mb");
                }
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
        return downloadSucceeded;
    }
}

