/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.templates;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.clarin.CmdiProfileReader;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ArbilTemplate {
    public File templateFile;
    Hashtable<String, ImdiVocabularies.Vocabulary> vocabularyHashTable = null;
    public String loadedTemplateName;
    public String[] preferredNameFields;
    public String[][] fieldTriggersArray;
    public String[][] genreSubgenreArray;
    public String[] requiredFields;
    public String[][] fieldConstraints;
    String[][] childNodePaths;
    String[][] fieldUsageArray;
    String[][] resourceNodePaths;
    String[][] templatesArray;
    String[][] rootTemplatesArray;
    public String[][] autoFieldsArray;

    public boolean pathCanHaveResource(String nodePath) {
        if (nodePath == null) {
            if (this.resourceNodePaths.length > 0) {
                return true;
            }
        } else {
            nodePath = nodePath.replaceAll("\\(\\d+\\)", "");
            for (String[] currentPath : this.resourceNodePaths) {
                if (!currentPath[0].equals(nodePath)) continue;
                return true;
            }
        }
        return false;
    }

    public String pathIsChildNode(String nodePath) {
        for (String[] pathString : this.childNodePaths) {
            if (!nodePath.endsWith(pathString[0])) continue;
            return pathString[1];
        }
        return null;
    }

    public boolean pathIsDeleteableField(String nodePath) {
        nodePath = nodePath.substring(1) + ".xml";
        for (String[] pathString : this.templatesArray) {
            if (!pathString[0].equals(nodePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isImdiChildType(String childType) {
        boolean returnValue = false;
        if (childType != null) {
            if (CmdiProfileReader.pathIsProfile(childType)) {
                returnValue = false;
            } else {
                returnValue = true;
                childType = (childType + ".xml").substring(1);
                for (String[] currentTemplate : this.rootTemplatesArray) {
                    if (!childType.equals(currentTemplate[0])) continue;
                    returnValue = false;
                }
            }
        }
        return returnValue;
    }

    private Vector getSubnodesFromTemplatesDir(String nodepath) {
        Vector<String[]> returnVector = new Vector<String[]>();
        System.out.println("getSubnodesOf: " + nodepath);
        String targetNodePath = nodepath.substring(0, nodepath.lastIndexOf(")") + 1);
        nodepath = nodepath.replaceAll("\\(\\d*?\\)", "\\(x\\)");
        System.out.println("nodepath: " + nodepath);
        System.out.println("targetNodePath: " + targetNodePath);
        for (String[] currentTemplate : this.templatesArray) {
            if (currentTemplate[0].endsWith("Session.xml") || currentTemplate[0].endsWith("Catalogue.xml") || !currentTemplate[0].startsWith(nodepath.substring(1)) || targetNodePath.replaceAll("[^(]*", "").length() < currentTemplate[0].replaceAll("[^(]*", "").length()) continue;
            String currentValue = currentTemplate[0].replaceFirst("\\.xml$", "");
            returnVector.add(new String[]{currentTemplate[1], "." + currentValue});
        }
        return returnVector;
    }

    public Enumeration listTypesFor(Object targetNodeUserObject) {
        Vector childTypes = new Vector();
        if (targetNodeUserObject instanceof ImdiTreeObject) {
            String xpath = ImdiSchema.getNodePath((ImdiTreeObject)targetNodeUserObject);
            childTypes = this.getSubnodesFromTemplatesDir(xpath);
            if (((ImdiTreeObject)targetNodeUserObject).isCorpus()) {
                for (String[] currentTemplate : this.rootTemplatesArray) {
                    boolean suppressEntry = false;
                    if (currentTemplate[1].equals("Catalogue") && ((ImdiTreeObject)targetNodeUserObject).hasCatalogue()) {
                        suppressEntry = true;
                    }
                    if (suppressEntry) continue;
                    childTypes.add(new String[]{currentTemplate[1], "." + currentTemplate[0].replaceFirst("\\.xml$", "")});
                }
            }
        } else {
            for (String[] currentTemplate : this.rootTemplatesArray) {
                if (currentTemplate[1].equals("Catalogue")) continue;
                childTypes.add(new String[]{"Unattached " + currentTemplate[1], "." + currentTemplate[0].replaceFirst("\\.xml$", "")});
            }
        }
        Collections.sort(childTypes, new Comparator(){

            public int compare(Object o1, Object o2) {
                String value1 = ((String[])o1)[0];
                String value2 = ((String[])o2)[0];
                return value1.compareTo(value2);
            }
        });
        return childTypes.elements();
    }

    public String getHelpStringForField(String fieldName) {
        fieldName = fieldName.replaceAll("\\([0-9]+\\)\\.", ".");
        for (String[] currentUsageArray : this.fieldUsageArray) {
            if (!currentUsageArray[0].equals(fieldName)) continue;
            return currentUsageArray[1];
        }
        return "No usage description found in this template for: " + fieldName;
    }

    public ImdiVocabularies.Vocabulary getFieldVocabulary(String nodePath) {
        if (this.vocabularyHashTable != null) {
            return this.vocabularyHashTable.get(nodePath);
        }
        return null;
    }

    public boolean readTemplate(File templateConfigFile, String templateName) {
        this.templateFile = templateConfigFile;
        try {
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            SAXParser saxParser = saxParserFactory.newSAXParser();
            XMLReader xmlReader = saxParser.getXMLReader();
            xmlReader.setFeature("http://xml.org/sax/features/validation", false);
            xmlReader.setFeature("http://xml.org/sax/features/namespaces", true);
            xmlReader.setContentHandler(new DefaultHandler(){
                ArrayList<String> requiredFieldsList = new ArrayList();
                ArrayList<String[]> genreSubgenreList = new ArrayList();
                ArrayList<String[]> fieldConstraintList = new ArrayList();
                ArrayList<String[]> fieldTriggersList = new ArrayList();
                ArrayList<String[]> childNodePathsList = new ArrayList();
                ArrayList<String[]> templateComponentList = new ArrayList();
                ArrayList<String[]> rootTemplateComponentList = new ArrayList();
                ArrayList<String[]> fieldUsageList = new ArrayList();
                ArrayList<String[]> autoFieldsList = new ArrayList();
                ArrayList<String> preferredNameFieldsList = new ArrayList();

                public void startElement(String uri, String name, String qName, Attributes atts) {
                    String displayName;
                    String fileName;
                    String fieldPath;
                    String description;
                    if (name.equals("RequiredField")) {
                        String vocabName = atts.getValue("FieldPath");
                        this.requiredFieldsList.add(vocabName);
                    }
                    if (name.equals("GenreSubgenre")) {
                        String subgenre = atts.getValue("Subgenre");
                        String genre = atts.getValue("Genre");
                        description = atts.getValue("Description");
                        this.genreSubgenreList.add(new String[]{subgenre, genre, description});
                    }
                    if (name.equals("FieldConstraint")) {
                        fieldPath = atts.getValue("FieldPath");
                        String constraint = atts.getValue("Constraint");
                        this.fieldConstraintList.add(new String[]{fieldPath, constraint});
                    }
                    if (name.equals("FieldTrigger")) {
                        String sourceFieldPath = atts.getValue("SourceFieldPath");
                        String targetFieldPath = atts.getValue("TargetFieldPath");
                        description = atts.getValue("SourceFieldValue");
                        this.fieldTriggersList.add(new String[]{sourceFieldPath, targetFieldPath, description});
                    }
                    if (name.equals("ChildNodePath")) {
                        String childPath = atts.getValue("ChildPath");
                        String subNodeName = atts.getValue("SubNodeName");
                        this.childNodePathsList.add(new String[]{childPath, subNodeName});
                    }
                    if (name.equals("TemplateComponent")) {
                        fileName = atts.getValue("FileName");
                        displayName = atts.getValue("DisplayName");
                        this.templateComponentList.add(new String[]{fileName, displayName});
                    }
                    if (name.equals("RootTemplateComponent")) {
                        fileName = atts.getValue("FileName");
                        displayName = atts.getValue("DisplayName");
                        this.rootTemplateComponentList.add(new String[]{fileName, displayName});
                    }
                    if (name.equals("FieldUsage")) {
                        fieldPath = atts.getValue("FieldPath");
                        String fieldDescription = atts.getValue("FieldDescription");
                        this.fieldUsageList.add(new String[]{fieldPath, fieldDescription});
                    }
                    if (name.equals("AutoField")) {
                        fieldPath = atts.getValue("FieldPath");
                        String fileAttribute = atts.getValue("FileAttribute");
                        this.autoFieldsList.add(new String[]{fieldPath, fileAttribute});
                    }
                    if (name.equals("TreeNodeNameField")) {
                        String fieldsShortName = atts.getValue("FieldsShortName");
                        this.preferredNameFieldsList.add(fieldsShortName);
                    }
                }

                public void endDocument() throws SAXException {
                    super.endDocument();
                    ArbilTemplate.this.requiredFields = this.requiredFieldsList.toArray(new String[0]);
                    ArbilTemplate.this.genreSubgenreArray = (String[][])this.genreSubgenreList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.fieldConstraints = (String[][])this.fieldConstraintList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.fieldTriggersArray = (String[][])this.fieldTriggersList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.childNodePaths = (String[][])this.childNodePathsList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.templatesArray = (String[][])this.templateComponentList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.rootTemplatesArray = (String[][])this.rootTemplateComponentList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.fieldUsageArray = (String[][])this.fieldUsageList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.autoFieldsArray = (String[][])this.autoFieldsList.toArray((T[])new String[0][]);
                    ArbilTemplate.this.preferredNameFields = this.preferredNameFieldsList.toArray(new String[0]);
                }
            });
            this.loadedTemplateName = templateName;
            URL internalTemplateName = ImdiSchema.class.getResource("/nl/mpi/arbil/resources/templates/" + templateName + ".xml");
            if (templateConfigFile.exists()) {
                xmlReader.parse(templateConfigFile.getPath());
            } else if (templateName.equals("Sign Language") || templateName.equals("template_cmdi")) {
                xmlReader.parse(internalTemplateName.toExternalForm());
            } else {
                this.loadedTemplateName = "Default";
                xmlReader.parse(ImdiSchema.class.getResource("/nl/mpi/arbil/resources/templates/template.xml").toExternalForm());
            }
            return true;
        }
        catch (Exception ex) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The required template could not be read.", "Load Template");
            GuiHelper.linorgBugCatcher.logError("A template could not be read.", ex);
            return false;
        }
    }

    public String getTemplateName() {
        return this.loadedTemplateName;
    }

    public File getTemplateDirectory() {
        File currentTemplateDirectory = new File(ArbilTemplateManager.getSingleInstance().getTemplateDirectory(), this.loadedTemplateName);
        if (!currentTemplateDirectory.exists()) {
            currentTemplateDirectory.mkdir();
        }
        return currentTemplateDirectory;
    }

    public File getTemplateComponentDirectory() {
        File currentTemplateComponentDirectory = new File(this.getTemplateDirectory(), "components");
        if (!currentTemplateComponentDirectory.exists()) {
            currentTemplateComponentDirectory.mkdir();
        }
        return currentTemplateComponentDirectory;
    }
}

