/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Container;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.util.Hashtable;
import java.util.TooManyListenersException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiTable;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.ImdiTree;
import nl.mpi.arbil.LinorgFavourites;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgSplitPanel;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;
import nl.mpi.arbil.importexport.ImportExportDialog;

public class ArbilDragDrop {
    public DataFlavor imdiObjectFlavour = new DataFlavor(ImdiTreeObject.class, "ImdiTreeObject");
    public ImdiObjectSelection imdiObjectSelection = new ImdiObjectSelection();

    public void addDrag(JTable tableSource) {
        tableSource.setDragEnabled(true);
        tableSource.setTransferHandler(this.imdiObjectSelection);
    }

    public void addDrag(JTree treeSource) {
        treeSource.setDragEnabled(true);
        treeSource.setTransferHandler(this.imdiObjectSelection);
        treeSource.addTreeSelectionListener(this.imdiObjectSelection);
        DropTarget target = treeSource.getDropTarget();
        try {
            target.addDropTargetListener(new DropTargetAdapter(){

                public void dragOver(DropTargetDragEvent dtdEvent) {
                    System.out.println("imdiObjectSelection.dropAllowed: " + ArbilDragDrop.this.imdiObjectSelection.dropAllowed);
                    if (ArbilDragDrop.this.imdiObjectSelection.dropAllowed) {
                        dtdEvent.acceptDrag(dtdEvent.getDropAction());
                    } else {
                        dtdEvent.rejectDrag();
                    }
                }

                public void drop(DropTargetDropEvent e) {
                }
            });
        }
        catch (TooManyListenersException ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public void addDrag(JList listSource) {
        listSource.setDragEnabled(true);
        listSource.setTransferHandler(this.imdiObjectSelection);
    }

    public void addTransferHandler(JComponent targetComponent) {
        targetComponent.setTransferHandler(this.imdiObjectSelection);
    }

    public class ImdiObjectSelection
    extends TransferHandler
    implements Transferable,
    TreeSelectionListener {
        long dragStartMilliSeconds;
        DataFlavor[] flavors;
        ImdiTreeObject[] draggedImdiObjects;
        DefaultMutableTreeNode[] draggedTreeNodes;
        public boolean selectionContainsArchivableLocalFile;
        public boolean selectionContainsLocalFile;
        public boolean selectionContainsLocalDirectory;
        public boolean selectionContainsImdiResource;
        public boolean selectionContainsImdiCorpus;
        public boolean selectionContainsImdiInCache;
        public boolean selectionContainsImdiCatalogue;
        public boolean selectionContainsImdiSession;
        public boolean selectionContainsImdiChild;
        public boolean selectionContainsLocal;
        public boolean selectionContainsRemote;
        public boolean selectionContainsFavourite;
        private JComponent currentDropTarget;
        public boolean dropAllowed;

        public ImdiObjectSelection() {
            this.flavors = new DataFlavor[]{ArbilDragDrop.this.imdiObjectFlavour};
            this.selectionContainsArchivableLocalFile = false;
            this.selectionContainsLocalFile = false;
            this.selectionContainsLocalDirectory = false;
            this.selectionContainsImdiResource = false;
            this.selectionContainsImdiCorpus = false;
            this.selectionContainsImdiInCache = false;
            this.selectionContainsImdiCatalogue = false;
            this.selectionContainsImdiSession = false;
            this.selectionContainsImdiChild = false;
            this.selectionContainsLocal = false;
            this.selectionContainsRemote = false;
            this.selectionContainsFavourite = false;
            this.currentDropTarget = null;
            this.dropAllowed = false;
        }

        public void valueChanged(TreeSelectionEvent evt) {
            if (evt.getSource() == this.currentDropTarget) {
                System.out.println("Drag target selection change: " + evt.getSource().toString());
                if (evt.getSource() instanceof ImdiTree) {
                    this.dropAllowed = this.canDropToTarget((ImdiTree)evt.getSource());
                }
            }
        }

        private boolean canDropToTarget(ImdiTree dropTree) {
            ImdiTreeObject currentLeadSelection = dropTree.getLeadSelectionNode();
            if (currentLeadSelection == null) {
                if (TreeHelper.getSingleInstance().componentIsTheFavouritesTree(this.currentDropTarget)) {
                    System.out.println("favourites tree check");
                    return !this.selectionContainsFavourite;
                }
                if (TreeHelper.getSingleInstance().componentIsTheLocalCorpusTree(this.currentDropTarget)) {
                    System.out.println("local corpus tree check");
                    return !this.selectionContainsFavourite && (this.selectionContainsImdiCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession);
                }
                System.out.println("no tree check");
                return false;
            }
            System.out.println("currentLeadSelection: " + currentLeadSelection.toString());
            if (TreeHelper.getSingleInstance().componentIsTheLocalCorpusTree(this.currentDropTarget)) {
                if (currentLeadSelection.isCmdiMetaDataNode()) {
                    if (currentLeadSelection.getParentDomNode().nodeTemplate == null) {
                        System.out.println("no template for drop target node");
                        return false;
                    }
                    System.out.println("Drop to CMDI: " + currentLeadSelection.getURI().getFragment());
                    return currentLeadSelection.getParentDomNode().nodeTemplate.pathCanHaveResource(currentLeadSelection.getURI().getFragment());
                }
                if (currentLeadSelection.isDirectory) {
                    return false;
                }
                if (currentLeadSelection.isCorpus()) {
                    if (this.selectionContainsImdiCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession) {
                        return true;
                    }
                } else {
                    if (currentLeadSelection.isCatalogue()) {
                        return false;
                    }
                    if (currentLeadSelection.isSession() ? this.selectionContainsArchivableLocalFile || this.selectionContainsImdiChild && this.selectionContainsFavourite : currentLeadSelection.isImdiChild() && (this.selectionContainsLocalFile || this.selectionContainsImdiChild && this.selectionContainsFavourite)) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }

        public void exportToClipboard(JComponent comp, Clipboard clip, int action) throws IllegalStateException {
            System.out.println("exportToClipboard: " + comp);
            this.createTransferable(null);
            if (comp instanceof ImdiTree) {
                ImdiTree sourceTree = (ImdiTree)comp;
                ImdiTreeObject[] selectedImdiNodes = sourceTree.getSelectedNodes();
                if (selectedImdiNodes != null) {
                    sourceTree.copyNodeUrlToClipboard(selectedImdiNodes);
                }
            } else if (comp instanceof ImdiTable) {
                ImdiTable sourceTable = (ImdiTable)comp;
                sourceTable.copySelectedTableRowsToClipBoard();
            } else {
                super.exportToClipboard(comp, clip, action);
            }
        }

        public int getSourceActions(JComponent c) {
            System.out.println("getSourceActions");
            if (c instanceof JTree) {
                JTree jTree = (JTree)c;
                if (jTree.getSelectionCount() > 1 || jTree.getSelectionCount() == 1 && jTree.getSelectionPath().getPathCount() > 1) {
                    return 1;
                }
            } else {
                if (c instanceof JTable) {
                    return 1;
                }
                if (c instanceof JList) {
                    return 1;
                }
            }
            return 0;
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavor) {
            System.out.println("canImport: " + comp);
            this.currentDropTarget = null;
            this.dropAllowed = false;
            if (comp instanceof JTree) {
                if (TreeHelper.getSingleInstance().componentIsTheLocalCorpusTree(comp)) {
                    System.out.println("localcorpustree so can drop here");
                    if (this.selectionContainsArchivableLocalFile || this.selectionContainsImdiCorpus || this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession || this.selectionContainsImdiChild) {
                        System.out.println("dragged contents are acceptable");
                        this.currentDropTarget = comp;
                        this.dropAllowed = this.canDropToTarget((ImdiTree)comp);
                        return true;
                    }
                }
                if (TreeHelper.getSingleInstance().componentIsTheFavouritesTree(comp)) {
                    System.out.println("favourites tree so can drop here");
                    if (this.selectionContainsImdiCatalogue || this.selectionContainsImdiSession || this.selectionContainsImdiChild) {
                        System.out.println("dragged contents are acceptable");
                        this.currentDropTarget = comp;
                        this.dropAllowed = this.canDropToTarget((ImdiTree)comp);
                        return true;
                    }
                }
            } else {
                this.dropAllowed = null != this.findImdiDropableTarget(comp);
                System.out.println("dropAllowed: " + this.dropAllowed);
                return this.dropAllowed;
            }
            System.out.println("canImport false");
            return false;
        }

        private Container findImdiDropableTarget(Container tempCom) {
            while (tempCom != null) {
                if (tempCom instanceof LinorgSplitPanel || tempCom instanceof JDesktopPane) {
                    System.out.println("canImport true");
                    return tempCom;
                }
                tempCom = tempCom.getParent();
            }
            return null;
        }

        public Transferable createTransferable(JComponent comp) {
            this.dragStartMilliSeconds = System.currentTimeMillis();
            this.draggedImdiObjects = null;
            this.draggedTreeNodes = null;
            this.selectionContainsArchivableLocalFile = false;
            this.selectionContainsLocalFile = false;
            this.selectionContainsLocalDirectory = false;
            this.selectionContainsImdiResource = false;
            this.selectionContainsImdiCorpus = false;
            this.selectionContainsImdiCatalogue = false;
            this.selectionContainsImdiSession = false;
            this.selectionContainsImdiChild = false;
            this.selectionContainsLocal = false;
            this.selectionContainsRemote = false;
            this.selectionContainsFavourite = false;
            if (comp instanceof ImdiTree) {
                ImdiTree draggedTree = (ImdiTree)comp;
                this.draggedImdiObjects = new ImdiTreeObject[draggedTree.getSelectionCount()];
                this.draggedTreeNodes = new DefaultMutableTreeNode[draggedTree.getSelectionCount()];
                for (int selectedCount = 0; selectedCount < draggedTree.getSelectionCount(); ++selectedCount) {
                    DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)draggedTree.getSelectionPaths()[selectedCount].getLastPathComponent();
                    if (parentNode.getUserObject() instanceof ImdiTreeObject) {
                        this.draggedImdiObjects[selectedCount] = (ImdiTreeObject)parentNode.getUserObject();
                        this.draggedTreeNodes[selectedCount] = parentNode;
                        continue;
                    }
                    this.draggedImdiObjects[selectedCount] = null;
                    this.draggedTreeNodes[selectedCount] = null;
                }
                this.classifyTransferableContents();
                return this;
            }
            if (comp instanceof ImdiTable) {
                this.draggedImdiObjects = ((ImdiTable)comp).getSelectedRowsFromTable();
                this.classifyTransferableContents();
                return this;
            }
            if (comp instanceof JList) {
                Object[] selectedValues = ((JList)comp).getSelectedValues();
                this.draggedImdiObjects = new ImdiTreeObject[selectedValues.length];
                for (int selectedNodeCounter = 0; selectedNodeCounter < selectedValues.length; ++selectedNodeCounter) {
                    if (!(selectedValues[selectedNodeCounter] instanceof ImdiTreeObject)) continue;
                    this.draggedImdiObjects[selectedNodeCounter] = (ImdiTreeObject)selectedValues[selectedNodeCounter];
                }
                this.classifyTransferableContents();
                return this;
            }
            return null;
        }

        private void classifyTransferableContents() {
            System.out.println("classifyTransferableContents");
            for (ImdiTreeObject currentDraggedObject : this.draggedImdiObjects) {
                if (currentDraggedObject.isLocal()) {
                    this.selectionContainsLocal = true;
                    System.out.println("selectionContainsLocal");
                    if (currentDraggedObject.isDirectory()) {
                        this.selectionContainsLocalDirectory = true;
                        System.out.println("selectionContainsLocalDirectory");
                    } else if (!currentDraggedObject.isMetaDataNode()) {
                        this.selectionContainsLocalFile = true;
                        System.out.println("selectionContainsLocalFile");
                        if (currentDraggedObject.isArchivableFile()) {
                            this.selectionContainsArchivableLocalFile = true;
                            System.out.println("selectionContainsArchivableLocalFile");
                        }
                    }
                } else {
                    this.selectionContainsRemote = true;
                    System.out.println("selectionContainsRemote");
                }
                if (!currentDraggedObject.isMetaDataNode()) continue;
                if (currentDraggedObject.isLocal() && LinorgSessionStorage.getSingleInstance().pathIsInsideCache(currentDraggedObject.getFile())) {
                    this.selectionContainsImdiInCache = true;
                    System.out.println("selectionContainsImdiInCache");
                }
                if (currentDraggedObject.isImdiChild()) {
                    this.selectionContainsImdiChild = true;
                    System.out.println("selectionContainsImdiChild");
                    if (currentDraggedObject.hasResource()) {
                        this.selectionContainsImdiResource = true;
                        System.out.println("selectionContainsImdiResource");
                    }
                } else if (currentDraggedObject.isSession()) {
                    this.selectionContainsImdiSession = true;
                    System.out.println("selectionContainsImdiSession");
                } else if (currentDraggedObject.isCatalogue()) {
                    this.selectionContainsImdiCatalogue = true;
                    System.out.println("selectionContainsImdiCatalogue");
                } else if (currentDraggedObject.isCorpus()) {
                    this.selectionContainsImdiCorpus = true;
                    System.out.println("selectionContainsImdiCorpus");
                }
                if (!currentDraggedObject.isFavorite()) continue;
                this.selectionContainsFavourite = true;
                System.out.println("selectionContainsFavourite");
            }
        }

        public boolean importData(JComponent comp, Transferable t) {
            block24: {
                if (System.currentTimeMillis() - this.dragStartMilliSeconds < 100L) {
                    return false;
                }
                try {
                    System.out.println("importData: " + comp.toString());
                    if (comp instanceof ImdiTable && this.draggedImdiObjects == null) {
                        ((ImdiTable)comp).pasteIntoSelectedTableRowsFromClipBoard();
                        break block24;
                    }
                    if (this.draggedImdiObjects == null) break block24;
                    if (comp instanceof JTree && this.canDropToTarget((ImdiTree)comp)) {
                        System.out.println("comp: " + comp.getName());
                        for (int draggedCounter = 0; draggedCounter < this.draggedImdiObjects.length; ++draggedCounter) {
                            System.out.println("dragged: " + this.draggedImdiObjects[draggedCounter].toString());
                        }
                        if (TreeHelper.getSingleInstance().componentIsTheFavouritesTree(this.currentDropTarget)) {
                            boolean resultValue = LinorgFavourites.getSingleInstance().toggleFavouritesList(this.draggedImdiObjects, true);
                            this.createTransferable(null);
                            return resultValue;
                        }
                        JTree dropTree = (JTree)comp;
                        DefaultMutableTreeNode targetNode = TreeHelper.getSingleInstance().getLocalCorpusTreeSingleSelection();
                        TreeHelper.getSingleInstance().addToSortQueue(targetNode);
                        Object dropTargetUserObject = targetNode.getUserObject();
                        Vector<ImdiTreeObject> importNodeList = new Vector<ImdiTreeObject>();
                        Hashtable imdiNodesDeleteList = new Hashtable();
                        System.out.println("to: " + dropTargetUserObject.toString());
                        if (dropTargetUserObject instanceof ImdiTreeObject && (((ImdiTreeObject)dropTargetUserObject).getParentDomNode().isCmdiMetaDataNode() || ((ImdiTreeObject)dropTargetUserObject).getParentDomNode().isSession()) && this.selectionContainsArchivableLocalFile && this.selectionContainsLocalFile && !this.selectionContainsLocalDirectory && !this.selectionContainsImdiResource && !this.selectionContainsImdiCorpus && !this.selectionContainsImdiSession && !this.selectionContainsImdiChild && this.selectionContainsLocal && !this.selectionContainsRemote) {
                            System.out.println("ok to add local file");
                            for (int draggedCounter = 0; draggedCounter < this.draggedImdiObjects.length; ++draggedCounter) {
                                System.out.println("dragged: " + this.draggedImdiObjects[draggedCounter].toString());
                                ((ImdiTreeObject)dropTargetUserObject).requestAddNode("Resource", this.draggedImdiObjects[draggedCounter]);
                            }
                            this.createTransferable(null);
                            return true;
                        }
                        if (this.selectionContainsArchivableLocalFile || this.selectionContainsLocalDirectory || this.selectionContainsImdiResource || this.selectionContainsImdiCorpus && this.selectionContainsImdiSession) break block24;
                        System.out.println("ok to move local IMDI");
                        for (int draggedCounter = 0; draggedCounter < this.draggedImdiObjects.length; ++draggedCounter) {
                            System.out.println("dragged: " + this.draggedImdiObjects[draggedCounter].toString());
                            if (this.draggedImdiObjects[draggedCounter].isImdiChild() && !ImdiSchema.getSingleInstance().nodeCanExistInNode((ImdiTreeObject)dropTargetUserObject, this.draggedImdiObjects[draggedCounter])) continue;
                            boolean draggedIntoSelf = false;
                            for (DefaultMutableTreeNode ancestorNode = targetNode; ancestorNode != null; ancestorNode = (DefaultMutableTreeNode)ancestorNode.getParent()) {
                                if (!this.draggedTreeNodes[draggedCounter].equals(ancestorNode)) continue;
                                draggedIntoSelf = true;
                                System.out.println("found ancestor: " + this.draggedTreeNodes[draggedCounter] + ":" + ancestorNode);
                            }
                            if (draggedIntoSelf) continue;
                            if (this.draggedImdiObjects[draggedCounter].isFavorite()) {
                                ((ImdiTreeObject)dropTargetUserObject).requestAddNode(this.draggedImdiObjects[draggedCounter].toString(), this.draggedImdiObjects[draggedCounter]);
                                continue;
                            }
                            if (!this.draggedImdiObjects[draggedCounter].isLocal() || !LinorgSessionStorage.getSingleInstance().pathIsInsideCache(this.draggedImdiObjects[draggedCounter].getFile())) {
                                importNodeList.add(this.draggedImdiObjects[draggedCounter]);
                                continue;
                            }
                            String targetNodeName = dropTargetUserObject instanceof ImdiTreeObject ? targetNode.getUserObject().toString() : ((JLabel)targetNode.getUserObject()).getText();
                            int detailsOption = JOptionPane.showOptionDialog(LinorgWindowManager.getSingleInstance().linorgFrame, "Move " + this.draggedTreeNodes[draggedCounter].getUserObject().toString() + " to " + targetNodeName, "Arbil", 0, -1, null, new Object[]{"Move", "Cancel"}, "Cancel");
                            if (detailsOption != 0) continue;
                            boolean addNodeResult = true;
                            addNodeResult = dropTargetUserObject instanceof ImdiTreeObject ? ((ImdiTreeObject)dropTargetUserObject).addCorpusLink(this.draggedImdiObjects[draggedCounter]) : TreeHelper.getSingleInstance().addLocation(this.draggedImdiObjects[draggedCounter].getURI());
                            if (!addNodeResult || this.draggedTreeNodes[draggedCounter] == null) continue;
                            if (this.draggedTreeNodes[draggedCounter].getParent().equals(this.draggedTreeNodes[draggedCounter].getRoot())) {
                                System.out.println("dragged from root");
                                TreeHelper.getSingleInstance().removeLocation(this.draggedImdiObjects[draggedCounter]);
                                TreeHelper.getSingleInstance().applyRootLocations();
                                continue;
                            }
                            ImdiTreeObject parentImdi = (ImdiTreeObject)((DefaultMutableTreeNode)this.draggedTreeNodes[draggedCounter].getParent()).getUserObject();
                            System.out.println("removeing from parent: " + parentImdi);
                            if (!imdiNodesDeleteList.containsKey(parentImdi)) {
                                imdiNodesDeleteList.put(parentImdi, new Vector());
                            }
                            ((Vector)imdiNodesDeleteList.get(parentImdi)).add(this.draggedImdiObjects[draggedCounter]);
                        }
                        if (importNodeList.size() > 0) {
                            try {
                                ImportExportDialog importExportDialog = new ImportExportDialog(dropTree);
                                if (dropTargetUserObject instanceof ImdiTreeObject) {
                                    importExportDialog.setDestinationNode((ImdiTreeObject)dropTargetUserObject);
                                }
                                importExportDialog.copyToCache(importNodeList);
                            }
                            catch (Exception e) {
                                System.out.println(e.getMessage());
                            }
                        }
                        for (ImdiTreeObject currentParent : imdiNodesDeleteList.keySet()) {
                            System.out.println("deleting by corpus link");
                            ImdiTreeObject[] imdiNodeArray = ((Vector)imdiNodesDeleteList.get(currentParent)).toArray(new ImdiTreeObject[0]);
                            currentParent.deleteCorpusLink(imdiNodeArray);
                        }
                        if (dropTargetUserObject instanceof ImdiTreeObject) {
                            ((ImdiTreeObject)dropTargetUserObject).saveChangesToCache(false);
                            ((ImdiTreeObject)dropTargetUserObject).reloadNode();
                        } else {
                            TreeHelper.getSingleInstance().applyRootLocations();
                        }
                        this.createTransferable(null);
                        return true;
                    }
                    Container imdiSplitPanel = this.findImdiDropableTarget(comp);
                    if (imdiSplitPanel instanceof LinorgSplitPanel) {
                        LinorgSplitPanel targetPanel = (LinorgSplitPanel)imdiSplitPanel;
                        ImdiTableModel dropTableModel = (ImdiTableModel)targetPanel.imdiTable.getModel();
                        dropTableModel.addImdiObjects(this.draggedImdiObjects);
                        this.createTransferable(null);
                        return true;
                    }
                    if (imdiSplitPanel instanceof JDesktopPane) {
                        LinorgWindowManager.getSingleInstance().openFloatingTableOnce(this.draggedImdiObjects, null);
                        this.createTransferable(null);
                        return true;
                    }
                }
                catch (Exception ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            }
            this.createTransferable(null);
            return false;
        }

        public Object getTransferData(DataFlavor flavor) {
            System.out.println("getTransferData");
            if (this.isDataFlavorSupported(flavor)) {
                return this.draggedImdiObjects;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            System.out.println("getTransferDataFlavors");
            return this.flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            System.out.println("isDataFlavorSupported");
            return this.flavors[0].equals(flavor);
        }
    }
}

