/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.MetadataFile;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.transform.TransformerException;
import mpi.imdi.api.IMDIDom;
import mpi.imdi.api.IMDILink;
import mpi.util.OurURL;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.MetadataFile.MetadataUtils;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class ImdiUtils
implements MetadataUtils {
    public static IMDIDom api = new IMDIDom();

    private boolean isCatalogue(URI sourceURI) {
        try {
            OurURL inUrlLocal = new OurURL(sourceURI.toURL());
            Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
            return null != XPathAPI.selectSingleNode((Node)nodDom, (String)"/:METATRANSCRIPT/:Catalogue");
        }
        catch (MalformedURLException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (TransformerException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        return false;
    }

    private boolean isSession(URI sourceURI) {
        try {
            OurURL inUrlLocal = new OurURL(sourceURI.toURL());
            Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
            return null != XPathAPI.selectSingleNode((Node)nodDom, (String)"/:METATRANSCRIPT/:Session");
        }
        catch (MalformedURLException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        catch (TransformerException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
        }
        return false;
    }

    public boolean addCorpusLink(URI nodeURI, URI[] linkURI) {
        try {
            OurURL inUrlLocal = new OurURL(nodeURI.toURL());
            Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
            if (nodDom == null) {
                GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API", "Add Link");
                return false;
            }
            int nodeType = 2;
            for (URI currentLinkUri : linkURI) {
                if (this.isCatalogue(currentLinkUri)) {
                    nodeType = 8;
                }
                if (this.isSession(currentLinkUri)) {
                    nodeType = 1;
                }
                api.createIMDILink(nodDom, inUrlLocal, currentLinkUri.toString(), "", nodeType, "");
            }
            api.writeDOM(nodDom, new File(nodeURI), true);
            return true;
        }
        catch (MalformedURLException ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
            return true;
        }
    }

    public boolean copyMetadataFile(URI sourceURI, File destinationFile, URI[] linksToUpdate, boolean updateLinks) {
        try {
            OurURL inUrlLocal = new OurURL(sourceURI.toURL());
            OurURL destinationUrl = new OurURL(destinationFile.toURL());
            Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
            if (nodDom == null) {
                GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API", "Copy IMDI File");
                return false;
            }
            IMDILink[] links = api.getIMDILinks(nodDom, inUrlLocal, 6);
            if (links != null && updateLinks) {
                for (IMDILink currentLink : links) {
                    if (linksToUpdate != null) {
                        for (URI updatableLink : linksToUpdate) {
                            try {
                                if (!currentLink.getRawURL().toURL().toURI().equals(updatableLink)) continue;
                                api.changeIMDILink(nodDom, destinationUrl, currentLink);
                            }
                            catch (URISyntaxException exception) {
                                GuiHelper.linorgBugCatcher.logError(exception);
                            }
                        }
                        continue;
                    }
                    api.changeIMDILink(nodDom, destinationUrl, currentLink);
                }
            }
            boolean removeIdAttributes = true;
            api.writeDOM(nodDom, destinationFile, removeIdAttributes);
            return true;
        }
        catch (IOException e) {
            GuiHelper.linorgBugCatcher.logError(e);
            return false;
        }
    }

    public boolean moveMetadataFile(URI sourceURI, File destinationFile, boolean updateLinks) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public boolean removeCorpusLink(URI nodeURI, URI[] linkURI) {
        try {
            OurURL destinationUrl = new OurURL(nodeURI.toString());
            Document nodDom = api.loadIMDIDocument(destinationUrl, false);
            if (nodDom == null) {
                GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API", "Remove IMDI Links");
                return false;
            }
            IMDILink[] allImdiLinks = api.getIMDILinks(nodDom, destinationUrl, 6);
            if (allImdiLinks != null) {
                for (IMDILink currentLink : allImdiLinks) {
                    for (URI currentUri : linkURI) {
                        try {
                            if (!currentUri.equals(currentLink.getRawURL().toURL().toURI())) continue;
                            api.removeIMDILink(nodDom, currentLink);
                        }
                        catch (URISyntaxException exception) {
                            GuiHelper.linorgBugCatcher.logError(exception);
                        }
                    }
                }
                boolean removeIdAttributes = true;
                api.writeDOM(nodDom, new File(nodeURI), removeIdAttributes);
                return true;
            }
        }
        catch (MalformedURLException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading links via the IMDI API", "Get Links");
        }
        return false;
    }

    public URI[] getCorpusLinks(URI nodeURI) {
        try {
            OurURL destinationUrl = new OurURL(nodeURI.toString());
            Document nodDom = api.loadIMDIDocument(destinationUrl, false);
            IMDILink[] allImdiLinks = api.getIMDILinks(nodDom, destinationUrl, 6);
            if (allImdiLinks != null) {
                URI[] returnUriArray = new URI[allImdiLinks.length];
                for (int linkCount = 0; linkCount < allImdiLinks.length; ++linkCount) {
                    try {
                        returnUriArray[linkCount] = allImdiLinks[linkCount].getRawURL().toURL().toURI();
                        continue;
                    }
                    catch (URISyntaxException exception) {
                        GuiHelper.linorgBugCatcher.logError(exception);
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading one of the links via the IMDI API", "Get Links");
                    }
                }
                return returnUriArray;
            }
        }
        catch (MalformedURLException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading links via the IMDI API", "Get Links");
        }
        return null;
    }
}

