/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.data.ImdiTreeObject;

class JListToolTip
extends JToolTip {
    JPanel jPanel;
    Object targetObject;
    String preSpaces = "      ";

    public JListToolTip() {
        this.setLayout(new BorderLayout());
        this.jPanel = new JPanel();
        this.jPanel.setLayout(new BoxLayout(this.jPanel, 1));
        this.add((Component)this.jPanel, "Center");
        this.jPanel.setBackground(this.getBackground());
        this.jPanel.setBorder(this.getBorder());
    }

    private String truncateString(String inputString) {
        if (inputString.length() > 100) {
            inputString = inputString.substring(0, 100) + "...";
        }
        return inputString + " ";
    }

    private void addIconLabel(Object tempObject) {
        JLabel jLabel = new JLabel(this.truncateString(tempObject.toString()));
        if (tempObject instanceof ImdiTreeObject) {
            jLabel.setIcon(((ImdiTreeObject)tempObject).getIcon());
        }
        jLabel.doLayout();
        this.jPanel.add(jLabel);
    }

    private void addDetailLabel(String labelString) {
        JLabel jLabel = new JLabel(this.truncateString(labelString));
        jLabel.doLayout();
        this.jPanel.add(jLabel);
    }

    private void addTabbedLabel(String labelString) {
        this.addDetailLabel(this.preSpaces + labelString);
    }

    private void addDetailLabel(String prefixString, ImdiField[] tempFieldArray) {
        if (tempFieldArray != null) {
            for (ImdiField tempField : tempFieldArray) {
                String labelString = tempField.toString();
                this.addTabbedLabel(prefixString + labelString);
            }
        }
    }

    private void addLabelsForImdiObject(ImdiTreeObject tempObject) {
        if (tempObject.isMetaDataNode()) {
            Hashtable<String, ImdiField[]> tempFields = tempObject.getFields();
            this.addDetailLabel("Name: ", tempFields.get("Name"));
            this.addDetailLabel("Title: ", tempFields.get("Title"));
            this.addDetailLabel("Description: ", tempFields.get("Description"));
            this.addTabbedLabel("Template: " + tempObject.getNodeTemplate().getTemplateName());
            this.addDetailLabel("Format: ", tempFields.get("Format"));
        } else if (!tempObject.isDirectory()) {
            this.addTabbedLabel("Unattached file");
            if (tempObject.isArchivableFile()) {
                this.addTabbedLabel("Archivable file");
            } else {
                this.addTabbedLabel("Not archivable");
                this.addTabbedLabel("Type checker message:\n\"" + tempObject.typeCheckerMessage + "\"");
            }
        }
        if (tempObject.hasResource() || !tempObject.isMetaDataNode() && !tempObject.isDirectory()) {
            this.addTabbedLabel("Copies in cache: " + tempObject.matchesInCache);
            this.addTabbedLabel("Copies on local file system: " + tempObject.matchesLocalFileSystem);
            this.addTabbedLabel("Copies on server: ?");
        }
        if (!tempObject.isLocal()) {
            this.addTabbedLabel("Remote file (read only)");
        } else if (tempObject.hasResource()) {
            if (tempObject.resourceFileNotFound()) {
                this.addTabbedLabel("Resource file not found");
            }
        } else if (tempObject.isMetaDataNode()) {
            this.addTabbedLabel("Local file (editable)");
            if (tempObject.fileNotFound) {
                this.addTabbedLabel("File not found");
            }
        }
        if (tempObject.hasHistory()) {
            this.addTabbedLabel("History of changes are available");
        }
        if (tempObject.getNeedsSaveToDisk()) {
            this.addTabbedLabel("Unsaved changes");
        }
        if (tempObject.isFavorite()) {
            this.addTabbedLabel("Available in the favourites menu");
        }
    }

    public void updateList() {
        this.jPanel.removeAll();
        if (this.targetObject != null) {
            if (this.targetObject instanceof Object[]) {
                for (int childCounter = 0; childCounter < ((Object[])this.targetObject).length; ++childCounter) {
                    this.addIconLabel(((Object[])this.targetObject)[childCounter]);
                }
                if (((Object[])this.targetObject)[0] != null && ((Object[])this.targetObject)[0] instanceof ImdiField) {
                    this.addDetailLabel(((ImdiField)((Object[])this.targetObject)[0]).parentImdi.getNodeTemplate().getHelpStringForField(((ImdiField)((Object[])this.targetObject)[0]).getFullXmlPath()));
                }
            } else if (this.targetObject instanceof ImdiTreeObject) {
                this.addIconLabel(this.targetObject);
                this.addLabelsForImdiObject((ImdiTreeObject)this.targetObject);
            } else {
                this.addDetailLabel(this.targetObject.toString());
                if (this.targetObject instanceof ImdiField) {
                    this.addDetailLabel(((ImdiField)this.targetObject).parentImdi.getNodeTemplate().getHelpStringForField(((ImdiField)this.targetObject).getFullXmlPath()));
                }
            }
            this.jPanel.doLayout();
            this.doLayout();
        }
    }

    public String getTipText() {
        return "";
    }

    public Dimension getPreferredSize() {
        return this.jPanel.getPreferredSize();
    }

    public void setTartgetObject(Object targetObjectLocal) {
        this.targetObject = targetObjectLocal;
    }
}

