/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.Component;
import java.awt.Container;
import java.io.File;
import java.net.URI;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.data.ImdiTreeObject;

public class LinorgHyperlinkListener
implements HyperlinkListener {
    public void hyperlinkUpdate(HyperlinkEvent evt) {
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            JEditorPane pane = (JEditorPane)evt.getSource();
            HTMLDocument doc = (HTMLDocument)pane.getDocument();
            System.out.println("# of Components in JTextPane: " + pane.getComponentCount());
            if (evt.getDescription().startsWith("arbilscript:")) {
                String[] commandsArray;
                ImdiTreeObject currentImdiObject = null;
                String arbilscriptString = evt.getDescription().substring("arbilscript:".length());
                System.out.println("acting on arbilscript: " + arbilscriptString);
                for (String commandString : commandsArray = arbilscriptString.split("&")) {
                    System.out.println("commandString: " + commandString);
                    if (commandString.startsWith("add=")) {
                        String nodeTypeString = commandString.substring("add=".length());
                        System.out.println("nodeTypeString: " + nodeTypeString);
                        currentImdiObject = this.addNode(currentImdiObject, nodeTypeString, "Wizard Corpus", null, null, null);
                    }
                    if (!commandString.startsWith("set=")) continue;
                    String[] fieldCommand = commandString.substring("set=".length()).split(":");
                    System.out.println("set: " + fieldCommand[0] + " = " + fieldCommand[1]);
                    this.setField(currentImdiObject, fieldCommand[0], fieldCommand[1]);
                }
                for (int i = 0; i < pane.getComponentCount(); ++i) {
                    Container c = (Container)pane.getComponent(i);
                    System.out.println(c.getComponentCount());
                    Component swingComponentOfHTMLInputType = c.getComponent(0);
                    System.out.println(swingComponentOfHTMLInputType.getClass().getName());
                    if (swingComponentOfHTMLInputType instanceof JTextField) {
                        JTextField tf = (JTextField)swingComponentOfHTMLInputType;
                        System.out.println(tf.getName());
                        System.out.println(tf.getText());
                        System.out.println(tf.getAction());
                        System.out.println(swingComponentOfHTMLInputType.getName());
                        System.out.println(swingComponentOfHTMLInputType.getName());
                        System.out.println(swingComponentOfHTMLInputType.getName());
                        String formCommandString = swingComponentOfHTMLInputType.getName();
                        System.out.println("formCommandString: " + formCommandString);
                        if (formCommandString == null || !formCommandString.startsWith("arbilscript:set=")) continue;
                        String nodeTypeString = formCommandString.substring("arbilscript:set=".length());
                        System.out.println("nodeTypeString: " + nodeTypeString);
                        currentImdiObject = this.addNode(currentImdiObject, nodeTypeString, tf.getText(), null, null, null);
                        continue;
                    }
                    if (!(swingComponentOfHTMLInputType instanceof JButton)) continue;
                }
            } else if (evt.getURL() != null) {
                LinorgWindowManager.getSingleInstance().openUrlWindowOnce(evt.getURL().toString(), evt.getURL());
            }
        }
    }

    private void setField(ImdiTreeObject currentImdiObject, String fieldPath, String FieldValue) {
        for (ImdiField[] currentField : currentImdiObject.getFields().values()) {
            if (!currentField[0].getFullXmlPath().endsWith(fieldPath)) continue;
            currentField[0].setFieldValue(FieldValue, true, true);
        }
    }

    private ImdiTreeObject addNode(ImdiTreeObject parentNode, String nodeType, String nodeTypeDisplayName, String targetXmlPath, URI resourceUri, String mimeType) {
        ImdiTreeObject addedImdiObject;
        System.out.println("wizard add node: " + nodeType);
        System.out.println("adding into: " + parentNode);
        if (parentNode == null) {
            URI targetFileURI = LinorgSessionStorage.getSingleInstance().getNewImdiFileName(LinorgSessionStorage.getSingleInstance().getCacheDirectory(), nodeType);
            targetFileURI = ImdiSchema.getSingleInstance().addFromTemplate(new File(targetFileURI), nodeType);
            addedImdiObject = ImdiLoader.getSingleInstance().getImdiObject(null, targetFileURI);
            TreeHelper.getSingleInstance().addLocation(targetFileURI);
            TreeHelper.getSingleInstance().applyRootLocations();
        } else {
            parentNode.saveChangesToCache(true);
            addedImdiObject = ImdiLoader.getSingleInstance().getImdiObject(null, parentNode.addChildNode(nodeType, targetXmlPath, resourceUri, mimeType));
        }
        addedImdiObject.waitTillLoaded();
        ImdiTableModel imdiTableModel = LinorgWindowManager.getSingleInstance().openFloatingTableOnce(new ImdiTreeObject[]{addedImdiObject}, nodeTypeDisplayName);
        return addedImdiObject;
    }
}

