/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin;

import java.io.File;
import java.util.ArrayList;
import javax.swing.JProgressBar;
import nl.mpi.arbil.LinorgSessionStorage;
import org.apache.commons.digester.Digester;

public class CmdiProfileReader {
    public ArrayList<CmdiProfile> cmdiProfileArray = null;
    String profilesUrlString = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles";
    static CmdiProfileReader singleInstance = null;

    public static void main(String[] args) {
        new CmdiProfileReader();
    }

    public static synchronized CmdiProfileReader getSingleInstance() {
        if (singleInstance == null) {
            singleInstance = new CmdiProfileReader();
        }
        return singleInstance;
    }

    public static boolean pathIsProfile(String pathString) {
        return pathString.startsWith("http") && pathString.contains("clarin") || pathString.endsWith(".xsd") || pathString.endsWith("/xsd");
    }

    public CmdiProfile getProfile(String XsdHref) {
        for (CmdiProfile currentProfile : this.cmdiProfileArray) {
            if (!currentProfile.getXsdHref().equals(XsdHref)) continue;
            return currentProfile;
        }
        return null;
    }

    private CmdiProfileReader() {
        this.loadProfiles();
        for (CmdiProfile currentCmdiProfile : this.cmdiProfileArray) {
            System.out.println("checking profile exists on disk: " + currentCmdiProfile.getXsdHref());
            LinorgSessionStorage.getSingleInstance().updateCache(currentCmdiProfile.getXsdHref(), 90);
        }
    }

    public void refreshProfiles(JProgressBar progressBar) {
        progressBar.setIndeterminate(true);
        progressBar.setString("");
        LinorgSessionStorage.getSingleInstance().updateCache(this.profilesUrlString, 0);
        this.loadProfiles();
        progressBar.setIndeterminate(false);
        progressBar.setMinimum(0);
        progressBar.setMaximum(this.cmdiProfileArray.size() + 1);
        progressBar.setValue(1);
        for (CmdiProfile currentCmdiProfile : this.cmdiProfileArray) {
            progressBar.setString(currentCmdiProfile.name);
            System.out.println("resaving profile to disk: " + currentCmdiProfile.getXsdHref());
            LinorgSessionStorage.getSingleInstance().updateCache(currentCmdiProfile.getXsdHref(), 0);
            progressBar.setValue(progressBar.getValue() + 1);
        }
        progressBar.setString("");
        progressBar.setValue(0);
    }

    public void loadProfiles() {
        File profileXmlFile = LinorgSessionStorage.getSingleInstance().updateCache(this.profilesUrlString, 10);
        try {
            Digester digester = new Digester();
            digester.push((Object)this);
            digester.addCallMethod("profileDescriptions/profileDescription", "addProfile", 6);
            digester.addCallParam("profileDescriptions/profileDescription/id", 0);
            digester.addCallParam("profileDescriptions/profileDescription/description", 1);
            digester.addCallParam("profileDescriptions/profileDescription/name", 2);
            digester.addCallParam("profileDescriptions/profileDescription/registrationDate", 3);
            digester.addCallParam("profileDescriptions/profileDescription/creatorName", 4);
            digester.addCallParam("profileDescriptions/profileDescription/ns2:href", 5);
            this.cmdiProfileArray = new ArrayList();
            digester.parse(profileXmlFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addProfile(String id, String description, String name, String registrationDate, String creatorName, String href) {
        CmdiProfile cmdiProfile = new CmdiProfile();
        cmdiProfile.id = id;
        cmdiProfile.description = description;
        cmdiProfile.name = name;
        cmdiProfile.registrationDate = registrationDate;
        cmdiProfile.creatorName = creatorName;
        cmdiProfile.href = href;
        this.cmdiProfileArray.add(cmdiProfile);
    }

    public class CmdiProfile {
        public String id;
        public String description;
        public String name;
        public String registrationDate;
        public String creatorName;
        public String href;

        public String getXsdHref() {
            return this.href + "/xsd";
        }
    }
}

