/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.TableCellEditor;
import nl.mpi.arbil.ControlledVocabularyComboBox;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiTable;
import nl.mpi.arbil.ImdiTableCellRenderer;
import nl.mpi.arbil.ImdiVocabularies;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.data.ImdiTreeObject;

public class ImdiChildCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    ImdiTable parentTable = null;
    Rectangle parentCellRect = null;
    ImdiTreeObject registeredOwner = null;
    JPanel editorPanel;
    JLabel button;
    String fieldName;
    Component editorComponent = null;
    Object[] cellValue;
    int languageSelectWidth = 100;
    int selectedField = -1;
    JTextArea[] fieldEditors = null;
    JTextField[] keyEditorFields = null;
    JComboBox[] fieldLanguageBoxs = null;
    Vector<Component> componentsWithFocusListners = new Vector();
    private String defaultLanguageDropDownValue = "<select>";

    public ImdiChildCellEditor() {
        this.button = new JLabel("...");
        this.editorPanel = new JPanel();
        this.button.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent evt) {
            }

            public void keyPressed(KeyEvent evt) {
            }

            public void keyReleased(KeyEvent evt) {
                if (!ImdiChildCellEditor.this.cellHasControlledVocabulary() && ImdiChildCellEditor.this.isStartLongFieldKey(evt)) {
                    ImdiChildCellEditor.this.startEditorMode(true, 65535, '\uffff');
                } else if (!(evt.isActionKey() || evt.isMetaDown() || evt.isAltDown() || evt.isAltGraphDown() || evt.isControlDown() || evt.getKeyCode() == 16 || evt.getKeyCode() == 17 || evt.getKeyCode() == 18 || evt.getKeyCode() == 157 || evt.getKeyCode() == 27)) {
                    ImdiChildCellEditor.this.startEditorMode(false, evt.getKeyCode(), evt.getKeyChar());
                }
            }
        });
        this.button.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                ImdiChildCellEditor.this.parentTable.checkPopup(evt, false);
            }

            public void mousePressed(MouseEvent evt) {
                ImdiChildCellEditor.this.parentTable.checkPopup(evt, false);
            }

            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 1) {
                    ImdiChildCellEditor.this.startEditorMode(ImdiChildCellEditor.this.isStartLongFieldModifier(evt), 65535, '\uffff');
                } else {
                    ImdiChildCellEditor.this.parentTable.checkPopup(evt, false);
                }
            }
        });
    }

    private boolean requiresLongFieldEditor() {
        boolean requiresLongFieldEditor = false;
        if (this.cellValue instanceof ImdiField[]) {
            FontMetrics fontMetrics = this.button.getGraphics().getFontMetrics();
            double availableWidth = this.parentCellRect.getWidth() + 20.0;
            ImdiField[] iterableFields = this.selectedField == -1 ? (ImdiField[])this.cellValue : new ImdiField[]{((ImdiField[])this.cellValue)[this.selectedField]};
            for (ImdiField currentField : iterableFields) {
                String fieldValue = currentField.getFieldValue();
                if (fieldValue.contains("\n")) {
                    requiresLongFieldEditor = true;
                    break;
                }
                int requiredWidth = fontMetrics.stringWidth(fieldValue);
                System.out.println("requiredWidth: " + requiredWidth + " availableWidth: " + availableWidth);
                String fieldLanguageId = currentField.getLanguageId();
                if (fieldLanguageId != null) {
                    requiredWidth += this.languageSelectWidth;
                }
                if (!((double)requiredWidth > availableWidth)) continue;
                requiresLongFieldEditor = true;
                break;
            }
        }
        return requiresLongFieldEditor;
    }

    private boolean isCellEditable() {
        boolean returnValue = false;
        if (this.cellValue instanceof ImdiField[]) {
            ImdiTreeObject parentObject = ((ImdiField[])this.cellValue)[0].parentImdi;
            returnValue = parentObject.isLocal() && parentObject.isMetaDataNode() && ((ImdiField[])this.cellValue)[0].fieldID != null;
        }
        return returnValue;
    }

    private boolean isStartLongFieldKey(KeyEvent evt) {
        return this.isStartLongFieldModifier(evt) && (evt.getKeyCode() == 10 || evt.getKeyCode() == 32);
    }

    private boolean isStartLongFieldModifier(InputEvent evt) {
        return evt.isAltDown() || evt.isControlDown();
    }

    private void removeAllFocusListners() {
        while (this.componentsWithFocusListners.size() > 0) {
            Component currentComponent = this.componentsWithFocusListners.remove(0);
            if (currentComponent == null) continue;
            System.out.println("removeAllFocusListners:currentComponent:" + currentComponent.getClass());
            for (FocusListener currentListner : currentComponent.getFocusListeners()) {
                currentComponent.removeFocusListener(currentListner);
            }
        }
    }

    private void addFocusListener(Component targetComponent) {
        this.componentsWithFocusListners.add(targetComponent);
        targetComponent.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                boolean oppositeIsParent = false;
                try {
                    boolean bl = oppositeIsParent = e.getComponent().equals(e.getOppositeComponent().getParent()) || e.getComponent().getParent().equals(e.getOppositeComponent());
                    if (!oppositeIsParent && e.getComponent().getParent() != null && !e.getOppositeComponent().getParent().equals(ImdiChildCellEditor.this.editorPanel)) {
                        ImdiChildCellEditor.this.stopCellEditing();
                    }
                }
                catch (Exception ex) {
                    System.out.println("OppositeComponent or parent container not set");
                }
            }
        });
    }

    public void updateEditor(ImdiTreeObject parentImdiObject) {
        if (this.cellValue instanceof ImdiField[]) {
            this.cellValue = parentImdiObject.getFields().get(this.fieldName);
            for (int cellFieldCounter = 0; cellFieldCounter < this.cellValue.length; ++cellFieldCounter) {
                this.fieldEditors[cellFieldCounter].setText(((ImdiField[])this.cellValue)[cellFieldCounter].getFieldValue());
                if (this.fieldLanguageBoxs[cellFieldCounter] != null) {
                    boolean selectedValueFound = false;
                    for (int itemCounter = 0; itemCounter < this.fieldLanguageBoxs[cellFieldCounter].getItemCount(); ++itemCounter) {
                        ImdiVocabularies.VocabularyItem currentObject = (ImdiVocabularies.VocabularyItem)this.fieldLanguageBoxs[cellFieldCounter].getItemAt(itemCounter);
                        if (!(currentObject instanceof ImdiVocabularies.VocabularyItem)) continue;
                        ImdiVocabularies.VocabularyItem currentItem = currentObject;
                        System.out.println(currentItem.languageCode);
                        if (!currentItem.languageCode.equals(((ImdiField[])this.cellValue)[cellFieldCounter].getLanguageId())) continue;
                        this.fieldLanguageBoxs[cellFieldCounter].setSelectedIndex(itemCounter);
                        selectedValueFound = true;
                    }
                    if (!selectedValueFound) {
                        this.fieldLanguageBoxs[cellFieldCounter].addItem(this.defaultLanguageDropDownValue);
                        this.fieldLanguageBoxs[cellFieldCounter].setSelectedItem(this.defaultLanguageDropDownValue);
                    }
                }
                if (this.keyEditorFields[cellFieldCounter] == null) continue;
                this.keyEditorFields[cellFieldCounter].setText(((ImdiField[])this.cellValue)[cellFieldCounter].getKeyName());
            }
        }
    }

    private JComboBox getLanguageIdBox(final int cellFieldIndex) {
        ImdiField cellField = (ImdiField)this.cellValue[cellFieldIndex];
        String fieldLanguageId = cellField.getLanguageId();
        if (fieldLanguageId != null) {
            System.out.println("Has LanguageId");
            final JComboBox<Object> comboBox = new JComboBox<Object>();
            Object selectedItem = null;
            comboBox.setEditable(false);
            Object[] languageItemArray = cellField.getLanguageList();
            Arrays.sort(languageItemArray);
            for (Object currentItem : languageItemArray) {
                comboBox.addItem(currentItem);
                if (!fieldLanguageId.equals(((ImdiVocabularies.VocabularyItem)currentItem).languageCode)) continue;
                selectedItem = currentItem;
            }
            if (selectedItem != null) {
                System.out.println("selectedItem: " + selectedItem);
                comboBox.setSelectedItem(selectedItem);
            } else {
                comboBox.addItem(this.defaultLanguageDropDownValue);
                comboBox.setSelectedItem(this.defaultLanguageDropDownValue);
            }
            comboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    try {
                        ImdiField cellField = (ImdiField)ImdiChildCellEditor.this.cellValue[cellFieldIndex];
                        cellField.setLanguageId(((ImdiVocabularies.VocabularyItem)comboBox.getSelectedItem()).languageCode, true, false);
                        comboBox.removeItem(ImdiChildCellEditor.this.defaultLanguageDropDownValue);
                    }
                    catch (Exception ex) {
                        GuiHelper.linorgBugCatcher.logError(ex);
                    }
                }
            });
            if (this.parentCellRect != null) {
                comboBox.setPreferredSize(new Dimension(this.languageSelectWidth, this.parentCellRect.height));
            }
            return comboBox;
        }
        return null;
    }

    private String getEditorText(int lastKeyInt, char lastKeyChar, String currentCellString) {
        switch (lastKeyInt) {
            case 127: {
                currentCellString = "";
                break;
            }
            case 8: {
                currentCellString = "";
                break;
            }
            case 155: {
                break;
            }
            case 27: {
                break;
            }
            case 144: {
                break;
            }
            case 20: {
                break;
            }
            case 65535: {
                break;
            }
            default: {
                if (lastKeyChar == '\uffff') break;
                currentCellString = currentCellString + lastKeyChar;
            }
        }
        return currentCellString;
    }

    private boolean cellHasControlledVocabulary() {
        return ((ImdiField)this.cellValue[0]).hasVocabulary();
    }

    public void startLongfieldEditor(JTable table, Object value, boolean isSelected, int row, int column) {
        this.getTableCellEditorComponent(table, value, isSelected, row, column);
        this.startEditorMode(true, 65535, '\uffff');
    }

    private void startEditorMode(boolean ctrlDown, int lastKeyInt, char lastKeyChar) {
        System.out.println("startEditorMode: " + this.selectedField + " lastKeyInt: " + lastKeyInt + " lastKeyChar: " + lastKeyChar);
        this.removeAllFocusListners();
        if (this.cellValue instanceof ImdiField[]) {
            if (this.cellHasControlledVocabulary()) {
                if (this.isCellEditable()) {
                    System.out.println("Has Vocabulary");
                    ControlledVocabularyComboBox cvComboBox = new ControlledVocabularyComboBox((ImdiField)this.cellValue[this.selectedField]);
                    this.editorPanel.remove(this.button);
                    this.editorPanel.add(cvComboBox);
                    this.editorPanel.doLayout();
                    cvComboBox.setPopupVisible(true);
                    cvComboBox.addPopupMenuListener(new PopupMenuListener(){

                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                        }

                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            ImdiChildCellEditor.this.fireEditingStopped();
                        }

                        public void popupMenuCanceled(PopupMenuEvent e) {
                            ImdiChildCellEditor.this.fireEditingStopped();
                        }
                    });
                    this.editorComponent = cvComboBox;
                    this.addFocusListener(cvComboBox);
                    this.addFocusListener(cvComboBox.getEditor().getEditorComponent());
                    cvComboBox.getEditor().getEditorComponent().requestFocusInWindow();
                }
            } else if (!(ctrlDown || this.selectedField == -1 || this.requiresLongFieldEditor() && this.getEditorText(lastKeyInt, lastKeyChar, "anystring").length() != 0)) {
                if (this.isCellEditable()) {
                    this.editorPanel.remove(this.button);
                    this.editorPanel.setLayout(new BoxLayout(this.editorPanel, 0));
                    String currentCellString = this.cellValue[this.selectedField].toString();
                    JTextField editorTextField = new JTextField(this.getEditorText(lastKeyInt, lastKeyChar, currentCellString));
                    this.editorPanel.setBorder(null);
                    editorTextField.setBorder(null);
                    editorTextField.setMinimumSize(new Dimension(50, (int)editorTextField.getMinimumSize().getHeight()));
                    this.editorPanel.add(editorTextField);
                    editorTextField.addKeyListener(new KeyListener(){

                        public void keyTyped(KeyEvent evt) {
                            if (ImdiChildCellEditor.this.isStartLongFieldKey(evt)) {
                                ImdiChildCellEditor.this.startEditorMode(true, 65535, '\uffff');
                            }
                        }

                        public void keyPressed(KeyEvent evt) {
                        }

                        public void keyReleased(KeyEvent evt) {
                        }
                    });
                    this.addFocusListener(editorTextField);
                    JComboBox fieldLanguageBox = this.getLanguageIdBox(this.selectedField);
                    if (fieldLanguageBox != null) {
                        this.editorPanel.add(fieldLanguageBox);
                        this.addFocusListener(fieldLanguageBox);
                    }
                    editorTextField.addFocusListener(new FocusListener(){

                        public void focusGained(FocusEvent e) {
                            ((JTextField)ImdiChildCellEditor.this.editorComponent).setCaretPosition(((JTextField)ImdiChildCellEditor.this.editorComponent).getText().length());
                        }

                        public void focusLost(FocusEvent e) {
                        }
                    });
                    this.editorPanel.doLayout();
                    editorTextField.requestFocusInWindow();
                    this.editorComponent = editorTextField;
                }
            } else {
                this.fireEditingStopped();
                int titleCount = 1;
                JTextArea focusedTabTextArea = null;
                JTabbedPane tabPane = new JTabbedPane();
                this.fieldEditors = new JTextArea[this.cellValue.length];
                this.keyEditorFields = new JTextField[this.cellValue.length];
                this.fieldLanguageBoxs = new JComboBox[this.cellValue.length];
                for (int cellFieldCounter = 0; cellFieldCounter < this.cellValue.length; ++cellFieldCounter) {
                    String keyName;
                    final int cellFieldIndex = cellFieldCounter;
                    this.fieldEditors[cellFieldIndex] = new JTextArea();
                    if (focusedTabTextArea == null || this.selectedField == cellFieldCounter) {
                        focusedTabTextArea = this.fieldEditors[cellFieldIndex];
                    }
                    this.fieldEditors[cellFieldIndex].setEditable(((ImdiField)this.cellValue[cellFieldIndex]).parentImdi.getParentDomNode().isLocal());
                    FocusListener editorFocusListener = new FocusListener(){

                        public void focusGained(FocusEvent e) {
                        }

                        public void focusLost(FocusEvent e) {
                            ImdiField cellField = (ImdiField)ImdiChildCellEditor.this.cellValue[cellFieldIndex];
                            if (cellField.parentImdi.getParentDomNode().isLocal()) {
                                cellField.setFieldValue(ImdiChildCellEditor.this.fieldEditors[cellFieldIndex].getText(), true, false);
                                if (ImdiChildCellEditor.this.keyEditorFields[cellFieldIndex] != null) {
                                    cellField.setKeyName(ImdiChildCellEditor.this.keyEditorFields[cellFieldIndex].getText(), true, false);
                                }
                            }
                        }
                    };
                    this.fieldEditors[cellFieldIndex].addFocusListener(editorFocusListener);
                    if (this.selectedField == cellFieldIndex || this.selectedField == -1 && cellFieldIndex == 0) {
                        this.fieldEditors[cellFieldIndex].setText(this.getEditorText(lastKeyInt, lastKeyChar, ((ImdiField)this.cellValue[cellFieldIndex]).getFieldValue()));
                    } else {
                        this.fieldEditors[cellFieldIndex].setText(((ImdiField)this.cellValue[cellFieldIndex]).getFieldValue());
                    }
                    this.fieldEditors[cellFieldIndex].setLineWrap(true);
                    this.fieldEditors[cellFieldIndex].setWrapStyleWord(true);
                    JPanel tabPanel = new JPanel();
                    JPanel tabTitlePanel = new JPanel();
                    tabPanel.setLayout(new BorderLayout());
                    tabTitlePanel.setLayout(new BoxLayout(tabTitlePanel, 3));
                    this.fieldLanguageBoxs[cellFieldIndex] = this.getLanguageIdBox(cellFieldIndex);
                    if (this.fieldLanguageBoxs[cellFieldIndex] != null) {
                        JPanel languagePanel = new JPanel(new BorderLayout());
                        languagePanel.add((Component)new JLabel("Language:"), "Before");
                        languagePanel.add((Component)this.fieldLanguageBoxs[cellFieldIndex], "Center");
                        tabTitlePanel.add(languagePanel);
                    }
                    if ((keyName = ((ImdiField)this.cellValue[cellFieldIndex]).getKeyName()) != null) {
                        JPanel keyNamePanel = new JPanel(new BorderLayout());
                        this.keyEditorFields[cellFieldIndex] = new JTextField(((ImdiField[])this.cellValue)[cellFieldCounter].getKeyName());
                        this.keyEditorFields[cellFieldIndex].addFocusListener(editorFocusListener);
                        this.keyEditorFields[cellFieldIndex].setEditable(((ImdiField)this.cellValue[cellFieldIndex]).parentImdi.getParentDomNode().isLocal());
                        keyNamePanel.add((Component)new JLabel("Key Name:"), "Before");
                        keyNamePanel.add((Component)this.keyEditorFields[cellFieldIndex], "Center");
                        tabTitlePanel.add(keyNamePanel);
                    }
                    tabPanel.add((Component)tabTitlePanel, "First");
                    tabPanel.add((Component)new JScrollPane(this.fieldEditors[cellFieldIndex]), "Center");
                    tabPane.add(this.fieldName + " " + titleCount++, tabPanel);
                }
                this.registeredOwner.registerContainer(this);
                JInternalFrame editorFrame = LinorgWindowManager.getSingleInstance().createWindow(this.fieldName + " in " + this.registeredOwner, tabPane);
                editorFrame.addInternalFrameListener(new InternalFrameAdapter(){

                    public void internalFrameClosed(InternalFrameEvent e) {
                        ImdiChildCellEditor.this.registeredOwner.removeContainer(this);
                        super.internalFrameClosed(e);
                        ImdiChildCellEditor.this.parentTable.requestFocusInWindow();
                    }
                });
                if (this.selectedField != -1) {
                    tabPane.setSelectedIndex(this.selectedField);
                } else {
                    tabPane.setSelectedIndex(0);
                }
                focusedTabTextArea.requestFocusInWindow();
                this.fireEditingStopped();
            }
        } else if (this.cellValue instanceof ImdiTreeObject[]) {
            LinorgWindowManager.getSingleInstance().openFloatingTableOnce((ImdiTreeObject[])this.cellValue, this.fieldName + " in " + this.registeredOwner);
        } else {
            try {
                throw new Exception("Edit cell type not supported");
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        }
    }

    public Object getCellEditorValue() {
        if (this.selectedField != -1) {
            if (this.editorComponent != null) {
                if (this.editorComponent instanceof ControlledVocabularyComboBox) {
                    ((ImdiField[])this.cellValue)[this.selectedField].setFieldValue(((ControlledVocabularyComboBox)this.editorComponent).getCurrentValue(), true, false);
                } else if (this.editorComponent instanceof JTextField) {
                    ((ImdiField[])this.cellValue)[this.selectedField].setFieldValue(((JTextField)this.editorComponent).getText(), true, false);
                }
            }
            return this.cellValue[this.selectedField];
        }
        return this.cellValue;
    }

    private void convertCellValue(Object value) {
        if (value instanceof ImdiField) {
            this.fieldName = ((ImdiField)value).getTranslateFieldName();
            this.cellValue = ((ImdiField)value).parentImdi.getFields().get(this.fieldName);
            for (int cellFieldCounter = 0; cellFieldCounter < this.cellValue.length; ++cellFieldCounter) {
                System.out.println("selectedField: " + this.cellValue[cellFieldCounter] + " : " + value);
                if (!this.cellValue[cellFieldCounter].equals(value)) continue;
                System.out.println("selectedField found");
                this.selectedField = cellFieldCounter;
            }
        } else {
            this.cellValue = (Object[])value;
            if (this.cellValue[0] instanceof ImdiField) {
                this.fieldName = ((ImdiField[])this.cellValue)[0].getTranslateFieldName();
            }
        }
        if (this.cellValue[0] instanceof ImdiField) {
            this.registeredOwner = ((ImdiField)this.cellValue[0]).parentImdi;
        }
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.parentTable = (ImdiTable)table;
        this.parentCellRect = this.parentTable.getCellRect(row, column, false);
        ImdiTableCellRenderer cellRenderer = new ImdiTableCellRenderer(value);
        this.convertCellValue(value);
        this.button.setText(cellRenderer.getText());
        this.button.setForeground(cellRenderer.getForeground());
        this.button.setIcon(cellRenderer.getIcon());
        this.editorPanel.setBackground(table.getSelectionBackground());
        this.editorPanel.setLayout(new BorderLayout());
        this.editorPanel.add(this.button);
        this.addFocusListener(this.button);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ImdiChildCellEditor.this.button.requestFocusInWindow();
            }
        });
        return this.editorPanel;
    }
}

