/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.clarin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.data.ImdiTreeObject;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class CmdiComponentBuilder {
    private Document getDocument(File inputFile) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = inputFile == null ? documentBuilder.newDocument() : documentBuilder.parse(inputFile);
        return document;
    }

    private void savePrettyFormatting(Document document, File outputFile) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            FileOutputStream fileOutputStream = new FileOutputStream(outputFile);
            StreamResult xmlOutput = new StreamResult(fileOutputStream);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(dOMSource, xmlOutput);
            xmlOutput.getOutputStream().close();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            GuiHelper.linorgBugCatcher.logError(illegalArgumentException);
        }
        catch (TransformerException transformerException) {
            GuiHelper.linorgBugCatcher.logError(transformerException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            System.out.println(transformerFactoryConfigurationError.getMessage());
        }
        catch (FileNotFoundException notFoundException) {
            GuiHelper.linorgBugCatcher.logError(notFoundException);
        }
        catch (IOException iOException) {
            GuiHelper.linorgBugCatcher.logError(iOException);
        }
    }

    public URI insertResourceProxy(ImdiTreeObject targetNode, ImdiTreeObject resourceNode) {
        String targetXmlPath = targetNode.getURI().getFragment();
        System.out.println("insertResourceProxy: " + targetXmlPath);
        File cmdiNodeFile = targetNode.getFile();
        String nodeFragment = "";
        String resourceProxyId = UUID.randomUUID().toString();
        try {
            SchemaType schemaType = this.getFirstSchemaType(targetNode.getNodeTemplate().templateFile);
            Document targetDocument = this.getDocument(cmdiNodeFile);
            try {
                try {
                    Node documentNode = this.selectSingleNode(targetDocument, targetXmlPath);
                    documentNode.getAttributes().getNamedItem("ref").setNodeValue(resourceProxyId);
                }
                catch (TransformerException exception) {
                    GuiHelper.linorgBugCatcher.logError(exception);
                    return null;
                }
                Node addedResourceNode = this.insertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, ".CMD.Resources.ResourceProxyList", ".CMD.Resources.ResourceProxyList.ResourceProxy");
                addedResourceNode.getAttributes().getNamedItem("id").setNodeValue(resourceProxyId);
                for (Node childNode = addedResourceNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                    String localName = childNode.getLocalName();
                    if ("ResourceType".equals(localName)) {
                        childNode.setTextContent(resourceNode.mpiMimeType);
                    }
                    if (!"ResourceRef".equals(localName)) continue;
                    childNode.setTextContent(resourceNode.getUrlString());
                }
            }
            catch (Exception exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            targetNode.bumpHistory();
            this.savePrettyFormatting(targetDocument, cmdiNodeFile);
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        catch (ParserConfigurationException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        catch (SAXException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        return targetNode.getURI();
    }

    public URI insertChildComponent(ImdiTreeObject targetNode, String targetXmlPath, String cmdiComponentId) {
        System.out.println("insertChildComponent: " + cmdiComponentId);
        System.out.println("targetXmlPath: " + targetXmlPath);
        if (targetXmlPath == null) {
            targetXmlPath = cmdiComponentId.replaceAll("\\.[^.]+$", "");
        } else if (targetXmlPath.replaceAll("\\(\\d+\\)", "").length() == cmdiComponentId.length()) {
            targetXmlPath = targetXmlPath.replaceAll("\\.[^.]+$", "");
        }
        String[] cmdiComponentArray = cmdiComponentId.split("\\.");
        String[] targetXmlPathArray = targetXmlPath.replaceAll("\\(\\d+\\)", "").split("\\.");
        for (int pathPartCounter = targetXmlPathArray.length; pathPartCounter < cmdiComponentArray.length - 1; ++pathPartCounter) {
            System.out.println("adding missing path component: " + cmdiComponentArray[pathPartCounter]);
            targetXmlPath = targetXmlPath + "." + cmdiComponentArray[pathPartCounter];
        }
        System.out.println("trimmed targetXmlPath: " + targetXmlPath);
        File cmdiNodeFile = targetNode.getFile();
        String nodeFragment = "";
        try {
            SchemaType schemaType = this.getFirstSchemaType(targetNode.getNodeTemplate().templateFile);
            Document targetDocument = this.getDocument(cmdiNodeFile);
            try {
                Node AddedNode = this.insertSectionToXpath(targetDocument, targetDocument.getFirstChild(), schemaType, targetXmlPath, cmdiComponentId);
                nodeFragment = this.convertNodeToNodePath(targetDocument, AddedNode, targetXmlPath);
            }
            catch (Exception exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            targetNode.bumpHistory();
            this.savePrettyFormatting(targetDocument, cmdiNodeFile);
        }
        catch (IOException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        catch (ParserConfigurationException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        catch (SAXException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
        try {
            System.out.println("nodeFragment: " + nodeFragment);
            return new URI(targetNode.getURI().toString().split("#")[0] + "#" + nodeFragment);
        }
        catch (URISyntaxException exception) {
            GuiHelper.linorgBugCatcher.logError(exception);
            return null;
        }
    }

    private Node selectSingleNode(Document targetDocument, String targetXpath) throws TransformerException {
        String tempXpath = targetXpath.replaceAll("\\.", "/:");
        tempXpath = tempXpath.replaceAll("\\(", "[");
        tempXpath = tempXpath.replaceAll("\\)", "]");
        System.out.println("tempXpath: " + tempXpath);
        return XPathAPI.selectSingleNode((Node)targetDocument, (String)tempXpath);
    }

    private Node insertSectionToXpath(Document targetDocument, Node documentNode, SchemaType schemaType, String targetXpath, String xsdPath) throws Exception {
        System.out.println("insertSectionToXpath");
        System.out.println("xsdPath: " + xsdPath);
        System.out.println("targetXpath: " + targetXpath);
        SchemaProperty foundProperty = null;
        String strippedXpath = null;
        if (targetXpath == null) {
            documentNode = documentNode.getParentNode();
        } else {
            try {
                documentNode = this.selectSingleNode(targetDocument, targetXpath);
            }
            catch (TransformerException exception) {
                GuiHelper.linorgBugCatcher.logError(exception);
                return null;
            }
            strippedXpath = targetXpath.replaceAll("\\(\\d+\\)", "");
        }
        System.out.println("strippedXpath: " + strippedXpath);
        for (String currentPathComponent : xsdPath.split("\\.")) {
            if (currentPathComponent.length() <= 0) continue;
            System.out.println("currentPathComponent: " + currentPathComponent);
            foundProperty = null;
            for (SchemaProperty schemaProperty : schemaType.getProperties()) {
                String currentName = schemaProperty.getName().getLocalPart();
                if (!currentPathComponent.equals(currentName)) continue;
                foundProperty = schemaProperty;
                break;
            }
            if (foundProperty == null) {
                throw new Exception("failed to find the path in the schema: " + currentPathComponent);
            }
            schemaType = foundProperty.getType();
            System.out.println("foundProperty: " + foundProperty.getName().getLocalPart());
        }
        System.out.println("Adding destination sub nodes node to: " + documentNode.getLocalName());
        return this.constructXml(foundProperty, xsdPath, targetDocument, null, documentNode);
    }

    private String convertNodeToNodePath(Document targetDocument, Node documentNode, String targetXmlPath) {
        System.out.println("Calculating the added fragment");
        int siblingCouter = 1;
        for (Node siblingNode = documentNode.getPreviousSibling(); siblingNode != null; siblingNode = siblingNode.getPreviousSibling()) {
            if (!documentNode.getLocalName().equals(siblingNode.getLocalName())) continue;
            ++siblingCouter;
        }
        String nodeFragment = documentNode.getNodeName();
        String nodePathString = targetXmlPath + "." + nodeFragment + "(" + siblingCouter + ")";
        System.out.println("nodeFragment: " + nodePathString);
        System.out.println("targetXmlPath: " + targetXmlPath);
        return nodePathString;
    }

    public URI createComponentFile(URI cmdiNodeFile, URI xsdFile) {
        System.out.println("createComponentFile: " + cmdiNodeFile + " : " + xsdFile);
        try {
            Document workingDocument = this.getDocument(null);
            this.readSchema(workingDocument, xsdFile);
            this.savePrettyFormatting(workingDocument, new File(cmdiNodeFile));
        }
        catch (IOException e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        catch (ParserConfigurationException e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        catch (SAXException e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        return cmdiNodeFile;
    }

    private SchemaType getFirstSchemaType(File schemaFile) {
        try {
            FileInputStream inputStream = new FileInputStream(schemaFile);
            XmlOptions options = new XmlOptions();
            options.setCharacterEncoding("UTF-8");
            SchemaTypeSystem sts = XmlBeans.compileXsd((XmlObject[])new XmlObject[]{XmlObject.Factory.parse((InputStream)inputStream, (XmlOptions)options)}, (SchemaTypeLoader)XmlBeans.getBuiltinTypeSystem(), null);
            return sts.documentTypes()[0];
        }
        catch (IOException e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
        catch (XmlException e) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not read the XML Schema", "Error inserting node");
            GuiHelper.linorgBugCatcher.logError((Exception)((Object)e));
        }
        return null;
    }

    private void readSchema(Document workingDocument, URI xsdFile) {
        File schemaFile = LinorgSessionStorage.getSingleInstance().updateCache(xsdFile.toString(), 5);
        SchemaType schemaType = this.getFirstSchemaType(schemaFile);
        this.constructXml(schemaType.getElementProperties()[0], "documentTypes", workingDocument, xsdFile.toString(), null);
    }

    private Element appendNode(Document workingDocument, String nameSpaceUri, Node parentElement, SchemaProperty schemaProperty) {
        Element currentElement = workingDocument.createElementNS("http://www.clarin.eu/cmd", schemaProperty.getName().getLocalPart());
        SchemaType currentSchemaType = schemaProperty.getType();
        for (SchemaProperty attributesProperty : currentSchemaType.getAttributeProperties()) {
            currentElement.setAttribute(attributesProperty.getName().getLocalPart(), attributesProperty.getDefaultText());
        }
        if (parentElement == null) {
            currentElement.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            currentElement.setAttribute("xsi:schemaLocation", "http://www.clarin.eu/cmd " + nameSpaceUri);
            workingDocument.appendChild(currentElement);
        } else {
            parentElement.appendChild(currentElement);
        }
        return currentElement;
    }

    private Node constructXml(SchemaProperty currentSchemaProperty, String pathString, Document workingDocument, String nameSpaceUri, Node parentElement) {
        Element currentElement;
        Element returnNode = null;
        String currentPathString = pathString + "." + currentSchemaProperty.getName().getLocalPart();
        System.out.println("Found Element: " + currentPathString);
        SchemaType currentSchemaType = currentSchemaProperty.getType();
        returnNode = currentElement = this.appendNode(workingDocument, nameSpaceUri, parentElement, currentSchemaProperty);
        for (SchemaProperty schemaProperty : currentSchemaType.getElementProperties()) {
            if (schemaProperty.getMinOccurs() == BigInteger.ZERO) continue;
            this.constructXml(schemaProperty, currentPathString, workingDocument, nameSpaceUri, currentElement);
        }
        return returnNode;
    }

    private void printoutDocument(Document workingDocument) {
        try {
            TransformerFactory tranFactory = TransformerFactory.newInstance();
            Transformer transformer = tranFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource src = new DOMSource(workingDocument);
            StreamResult dest = new StreamResult(System.out);
            transformer.transform(src, dest);
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
    }

    public void testWalk() {
        try {
            Document workingDocument = this.getDocument(null);
            this.readSchema(workingDocument, new URI("http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/profiles/clarin.eu:cr1:p_1264769926773/xsd"));
            this.printoutDocument(workingDocument);
        }
        catch (Exception e) {
            GuiHelper.linorgBugCatcher.logError(e);
        }
    }

    public static void main(String[] args) {
        new CmdiComponentBuilder().testWalk();
    }
}

