/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import mpi.imdi.api.IMDIDom;
import mpi.imdi.api.IMDIElement;
import mpi.imdi.api.IMDILink;
import mpi.util.OurURL;
import nl.mpi.arbil.GuiHelper;
import nl.mpi.arbil.ImdiChildCellEditor;
import nl.mpi.arbil.ImdiField;
import nl.mpi.arbil.ImdiIcons;
import nl.mpi.arbil.ImdiTableModel;
import nl.mpi.arbil.ImdiTreeNodeSorter;
import nl.mpi.arbil.LinorgBugCatcher;
import nl.mpi.arbil.LinorgFavourites;
import nl.mpi.arbil.LinorgJournal;
import nl.mpi.arbil.LinorgSessionStorage;
import nl.mpi.arbil.LinorgWindowManager;
import nl.mpi.arbil.MimeHashQueue;
import nl.mpi.arbil.TreeHelper;
import nl.mpi.arbil.clarin.CmdiComponentBuilder;
import nl.mpi.arbil.clarin.CmdiComponentLinkReader;
import nl.mpi.arbil.clarin.CmdiProfileReader;
import nl.mpi.arbil.data.ImdiLoader;
import nl.mpi.arbil.data.ImdiSchema;
import nl.mpi.arbil.templates.ArbilTemplate;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImdiTreeObject
implements Comparable {
    public static IMDIDom api = new IMDIDom();
    public ArbilTemplate nodeTemplate;
    private static Vector listDiscardedOfAttributes = new Vector();
    private boolean debugOn = false;
    private Hashtable<String, ImdiField[]> fieldHashtable;
    private ImdiTreeObject[] childArray = new ImdiTreeObject[0];
    public boolean imdiDataLoaded;
    public int resourceFileServerResponse = -1;
    public String hashString;
    public String mpiMimeType = null;
    public String typeCheckerMessage;
    public int matchesInCache;
    public int matchesRemote;
    public int matchesLocalFileSystem;
    public boolean fileNotFound;
    private boolean needsSaveToDisk;
    private String nodeText;
    private String lastNodeText = "loading imdi...";
    private URI nodeUri;
    public ImdiField resourceUrlField;
    public CmdiComponentLinkReader cmdiComponentLinkReader = null;
    public boolean isDirectory;
    private ImageIcon icon;
    private boolean nodeEnabled;
    private String[][] childLinks = new String[0][0];
    private Vector containersOfThisNode;
    private int isLoadingCount = 0;
    private final Object loadingCountLock = new Object();
    public boolean lockedByLoadingThread = false;
    public boolean hasArchiveHandle = false;
    public Vector<String[]> addQueue;
    public boolean scrollToRequested = false;
    private ImdiTreeObject domParentImdi = null;
    public String xmlNodeId = null;
    public File thumbnailFile = null;
    private final Object domLockObject = new Object();

    protected ImdiTreeObject(URI localUri) {
        this.containersOfThisNode = new Vector();
        this.addQueue = new Vector();
        this.nodeUri = localUri;
        this.initNodeVariables();
    }

    public void setNodeText(String localNodeText) {
        if (this.nodeText == null) {
            this.nodeText = localNodeText;
        }
    }

    private String urlEncodePath(String inputPath) {
        String encodedString = null;
        try {
            for (String inputStringPart : inputPath.split("/")) {
                encodedString = encodedString == null ? URLEncoder.encode(inputStringPart, "UTF-8") : encodedString + "/" + URLEncoder.encode(inputStringPart, "UTF-8");
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        return encodedString;
    }

    public static URI conformStringToUrl(String inputUrlString) {
        URI returnUrl = null;
        try {
            if (!(inputUrlString.toLowerCase().startsWith("http") || inputUrlString.toLowerCase().startsWith("file:") || inputUrlString.toLowerCase().startsWith("."))) {
                returnUrl = new File(inputUrlString).toURI();
            } else {
                int protocolEndIndex = inputUrlString.startsWith(".") ? 0 : inputUrlString.indexOf(":/");
                String protocolComponent = inputUrlString.substring(0, protocolEndIndex);
                String remainingComponents = inputUrlString.substring(protocolEndIndex + 1);
                String[] pathComponentArray = remainingComponents.split("#");
                String pathComponent = pathComponentArray[0];
                String fragmentComponent = null;
                if (pathComponentArray.length > 1) {
                    fragmentComponent = pathComponentArray[1];
                }
                returnUrl = new URI(protocolComponent, pathComponent, fragmentComponent);
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        return ImdiTreeObject.normaliseURI(returnUrl);
    }

    public static URI normaliseURI(URI inputURI) {
        boolean isUncPath = inputURI.toString().toLowerCase().startsWith("file:////");
        URI returnURI = inputURI.normalize();
        if (isUncPath) {
            try {
                returnURI = new URI("file:////" + returnURI.toString().substring("file:/".length()));
            }
            catch (URISyntaxException urise) {
                GuiHelper.linorgBugCatcher.logError(urise);
            }
        }
        return returnURI;
    }

    public static boolean isImdiNode(Object unknownObj) {
        if (unknownObj == null) {
            return false;
        }
        return unknownObj instanceof ImdiTreeObject;
    }

    public static boolean isStringLocal(String urlString) {
        return !urlString.startsWith("http");
    }

    public static boolean isPathHistoryFile(String urlString) {
        return ImdiTreeObject.isPathMetadata(urlString.replaceAll("mdi.[0-9]*$", "mdi"));
    }

    public static boolean isPathMetadata(String urlString) {
        return ImdiTreeObject.isPathImdi(urlString) || ImdiTreeObject.isPathCmdi(urlString);
    }

    public static boolean isPathImdi(String urlString) {
        return urlString.endsWith(".imdi");
    }

    public static boolean isPathCmdi(String urlString) {
        return urlString.endsWith(".cmdi");
    }

    public static boolean isStringImdiChild(String urlString) {
        return urlString.contains("#.METATRANSCRIPT") || urlString.contains("#.CMD");
    }

    public static void requestRootAddNode(String nodeType, String nodeTypeDisplayName) {
        ImdiTreeObject imdiTreeObject = new ImdiTreeObject(LinorgSessionStorage.getSingleInstance().getNewImdiFileName(LinorgSessionStorage.getSingleInstance().getSaveLocation(""), nodeType));
        imdiTreeObject.requestAddNode(nodeType, nodeTypeDisplayName);
    }

    public boolean getNeedsSaveToDisk() {
        if (this.needsSaveToDisk && !this.getParentDomNode().needsSaveToDisk) {
            this.needsSaveToDisk = false;
        }
        return this.needsSaveToDisk;
    }

    public boolean hasChangedFields() {
        boolean fieldsHaveChanges = false;
        for (ImdiField[] currentFieldArray : this.fieldHashtable.values()) {
            for (ImdiField currentField : currentFieldArray) {
                if (!currentField.fieldNeedsSaveToDisk()) continue;
                fieldsHaveChanges = true;
            }
        }
        return fieldsHaveChanges;
    }

    public void setImdiNeedsSaveToDisk(ImdiField originatingField, boolean updateUI) {
        if (this.resourceUrlField != null && this.resourceUrlField.equals(originatingField)) {
            this.hashString = null;
            this.mpiMimeType = null;
            this.thumbnailFile = null;
            this.typeCheckerMessage = null;
            MimeHashQueue.getSingleInstance().addToQueue(this);
        }
        boolean imdiNeedsSaveToDisk = this.hasChangedFields();
        if (this.isMetaDataNode() && !this.isImdiChild()) {
            if (!imdiNeedsSaveToDisk) {
                for (ImdiTreeObject childNode : this.getAllChildren()) {
                    if (!childNode.needsSaveToDisk) continue;
                    imdiNeedsSaveToDisk = true;
                }
            }
            if (this.needsSaveToDisk != imdiNeedsSaveToDisk) {
                if (imdiNeedsSaveToDisk) {
                    ImdiLoader.getSingleInstance().addNodeNeedingSave(this);
                } else {
                    ImdiLoader.getSingleInstance().removeNodesNeedingSave(this);
                }
                this.needsSaveToDisk = imdiNeedsSaveToDisk;
            }
        } else {
            this.needsSaveToDisk = imdiNeedsSaveToDisk;
            this.getParentDomNode().setImdiNeedsSaveToDisk(null, updateUI);
        }
        if (updateUI) {
            this.clearIcon();
        }
    }

    public String getAnyMimeType() {
        ImdiField[] formatField;
        if (this.mpiMimeType == null && this.hasResource() && (formatField = this.fieldHashtable.get("Format")) != null && formatField.length > 0) {
            return formatField[0].getFieldValue();
        }
        return this.mpiMimeType;
    }

    public void setMimeType(String[] typeCheckerMessageArray) {
        this.mpiMimeType = typeCheckerMessageArray[0];
        this.typeCheckerMessage = typeCheckerMessageArray[1];
        if (!this.isMetaDataNode() && this.isLocal() && this.mpiMimeType != null) {
            ImdiField mimeTypeField = new ImdiField(this, "Format", this.mpiMimeType);
            mimeTypeField.fieldID = "x" + this.fieldHashtable.size();
            this.addField(mimeTypeField);
        }
    }

    private void initNodeVariables() {
        if (this.childArray != null) {
            for (ImdiTreeObject currentNode : this.childArray) {
                if (!currentNode.isImdiChild()) continue;
                currentNode.initNodeVariables();
            }
        }
        this.fieldHashtable = new Hashtable();
        this.imdiDataLoaded = false;
        this.hashString = null;
        this.matchesInCache = 0;
        this.matchesRemote = 0;
        this.matchesLocalFileSystem = 0;
        this.fileNotFound = false;
        this.needsSaveToDisk = false;
        this.isDirectory = false;
        this.icon = null;
        this.nodeEnabled = true;
        if (this.nodeUri != null) {
            File fileObject;
            if (!this.isMetaDataNode() && this.isLocal() && (fileObject = this.getFile()) != null) {
                this.nodeText = fileObject.getName();
                this.isDirectory = fileObject.isDirectory();
            }
            if (!this.isMetaDataNode() && this.nodeText == null) {
                this.nodeText = this.getUrlString();
            }
        }
    }

    public void reloadNode() {
        System.out.println("reloadNode: " + this.isLoading());
        this.getParentDomNode().needsSaveToDisk = false;
        ImdiLoader.getSingleInstance().requestReload(this.getParentDomNode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void loadImdiDom() {
        System.out.println("loadImdiDom: " + this.nodeUri.toString());
        if (this.getParentDomNode() != this) {
            this.getParentDomNode().loadImdiDom();
        } else {
            Object object = this.domLockObject;
            synchronized (object) {
                this.initNodeVariables();
                if (!this.isMetaDataNode() && !this.isDirectory() && this.isLocal()) {
                    MimeHashQueue.getSingleInstance().addToQueue(this);
                    this.imdiDataLoaded = true;
                }
                if (this.isDirectory()) {
                    this.getDirectoryLinks();
                    this.imdiDataLoaded = true;
                }
                if (this.isMetaDataNode()) {
                    Document nodDom = null;
                    if (this.isLocal() && !this.getFile().exists() && new File(this.getFile().getAbsolutePath() + ".0").exists()) {
                        try {
                            FileOutputStream outFile = new FileOutputStream(this.getFile());
                            FileInputStream inputStream = new FileInputStream(new File(this.getFile().getAbsolutePath() + ".0"));
                            int bufferLength = 4096;
                            byte[] buffer = new byte[bufferLength];
                            int bytesread = 0;
                            while (bytesread >= 0 && (bytesread = ((InputStream)inputStream).read(buffer)) != -1) {
                                outFile.write(buffer, 0, bytesread);
                            }
                            outFile.close();
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Missing file has been recovered from the last history item.", "Recover History");
                        }
                        catch (IOException iOException) {
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Could not copy file when recovering from the last history file.", "Recover History");
                            GuiHelper.linorgBugCatcher.logError(iOException);
                        }
                    }
                    try {
                        OurURL inUrlLocal = null;
                        inUrlLocal = new OurURL(this.nodeUri.toURL());
                        nodDom = api.loadIMDIDocument(inUrlLocal, false);
                        if (this.isLocal() && this.getFile().exists() && nodDom == null) {
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The IMDI API could not load the file\n" + this.getUrlString(), "Load IMDI File");
                            GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                        }
                        if (nodDom == null) {
                            File nodeFile = this.getFile();
                            if (nodeFile != null && nodeFile.exists()) {
                                this.nodeText = "Could not load IMDI";
                            } else {
                                this.nodeText = "File not found";
                                this.fileNotFound = true;
                            }
                        } else {
                            this.nodeText = "unknown";
                            if (this.isCmdiMetaDataNode()) {
                                this.cmdiComponentLinkReader = new CmdiComponentLinkReader();
                                this.cmdiComponentLinkReader.readLinks(this.getURI());
                            } else {
                                this.cmdiComponentLinkReader = null;
                            }
                            Vector<String[]> childLinksTemp = new Vector<String[]>();
                            Hashtable<ImdiTreeObject, HashSet<ImdiTreeObject>> parentChildTree = new Hashtable<ImdiTreeObject, HashSet<ImdiTreeObject>>();
                            ImdiSchema.getSingleInstance().iterateChildNodes(this, childLinksTemp, nodDom.getFirstChild(), "", parentChildTree, 0);
                            this.childLinks = (String[][])childLinksTemp.toArray((T[])new String[0][]);
                            for (ImdiTreeObject currentNode : parentChildTree.keySet()) {
                                ImdiTreeObject[] oldChildArray = currentNode.childArray;
                                currentNode.childArray = parentChildTree.get(currentNode).toArray(new ImdiTreeObject[0]);
                                List<ImdiTreeObject> currentChildList = Arrays.asList(currentNode.childArray);
                                for (ImdiTreeObject currentOldChild : oldChildArray) {
                                    if (currentChildList.indexOf(currentOldChild) != -1) continue;
                                    for (Object currentContainer : currentOldChild.getRegisteredContainers()) {
                                        if (currentContainer instanceof ImdiChildCellEditor) {
                                            ((ImdiChildCellEditor)currentContainer).stopCellEditing();
                                        }
                                        if (currentContainer instanceof ImdiTableModel) {
                                            ((ImdiTableModel)currentContainer).removeImdiObjects(new ImdiTreeObject[]{currentOldChild});
                                        }
                                        if (!(currentContainer instanceof DefaultMutableTreeNode)) continue;
                                        DefaultMutableTreeNode currentTreeNode = (DefaultMutableTreeNode)currentContainer;
                                        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)currentContainer).getParent();
                                        if (parentNode != null) {
                                            TreeHelper.getSingleInstance().addToSortQueue(parentNode);
                                            continue;
                                        }
                                        TreeHelper.getSingleInstance().addToSortQueue(currentTreeNode);
                                    }
                                }
                            }
                        }
                    }
                    catch (Exception mue) {
                        GuiHelper.linorgBugCatcher.logError(mue);
                    }
                    nodDom = null;
                    this.imdiDataLoaded = true;
                }
            }
        }
    }

    private void getDirectoryLinks() {
        File[] dirLinkArray = null;
        File nodeFile = this.getFile();
        if (nodeFile != null) {
            dirLinkArray = nodeFile.listFiles();
            Vector<ImdiTreeObject> childLinksTemp = new Vector<ImdiTreeObject>();
            for (int linkCount = 0; linkCount < dirLinkArray.length; ++linkCount) {
                try {
                    URI childURI = dirLinkArray[linkCount].toURI();
                    ImdiTreeObject currentImdi = ImdiLoader.getSingleInstance().getImdiObjectWithoutLoading(childURI);
                    if (!TreeHelper.getSingleInstance().showHiddenFilesInTree && currentImdi.getFile().isHidden()) continue;
                    childLinksTemp.add(currentImdi);
                    continue;
                }
                catch (Exception ex) {
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue(dirLinkArray[linkCount] + " could not be loaded in\n" + this.nodeUri.toString(), "Load Directory");
                    new LinorgBugCatcher().logError(ex);
                }
            }
            this.childArray = childLinksTemp.toArray(new ImdiTreeObject[0]);
        }
    }

    public int getChildCount() {
        return this.childArray.length;
    }

    public ImdiTreeObject[] getAllChildren() {
        Vector<ImdiTreeObject> allChildren = new Vector<ImdiTreeObject>();
        this.getAllChildren(allChildren);
        return allChildren.toArray(new ImdiTreeObject[0]);
    }

    public void getAllChildren(Vector<ImdiTreeObject> allChildren) {
        System.out.println("getAllChildren: " + this.getUrlString());
        if (this.isSession() || this.isCatalogue() || this.isImdiChild() || this.isCmdiMetaDataNode()) {
            for (ImdiTreeObject currentChild : this.childArray) {
                currentChild.getAllChildren(allChildren);
                allChildren.add(currentChild);
            }
        }
    }

    public ImdiTreeObject[] getChildArray() {
        return this.childArray;
    }

    public ImdiTreeObject[] getChildNodesArray(String childType) {
        for (ImdiTreeObject currentNode : this.childArray) {
            if (!currentNode.toString().equals(childType)) continue;
            return currentNode.getChildArray();
        }
        return null;
    }

    public ArbilTemplate getNodeTemplate() {
        if (this.nodeTemplate != null && !this.isCorpus()) {
            return this.nodeTemplate;
        }
        if (this.isImdiChild()) {
            return this.getParentDomNode().getNodeTemplate();
        }
        return ArbilTemplateManager.getSingleInstance().getCurrentTemplate();
    }

    public File getSubDirectory() {
        String currentFileName = this.getFile().getParent();
        if (ImdiTreeObject.isPathImdi(this.nodeUri.getPath()) || ImdiTreeObject.isPathCmdi(this.nodeUri.getPath())) {
            File destinationDir = new File(currentFileName = currentFileName + File.separatorChar + this.getFile().getName().substring(0, this.getFile().getName().length() - 5));
            if (!destinationDir.exists()) {
                destinationDir.mkdir();
            }
            return destinationDir;
        }
        return new File(this.getFile().getParent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI addChildNode(String nodeType, String targetXmlPath, URI resourceUri, String mimeType) {
        System.out.println("addChildNode:: " + nodeType + " : " + resourceUri);
        System.out.println("targetXmlPath:: " + targetXmlPath);
        if (this.needsSaveToDisk) {
            this.saveChangesToCache(true);
        }
        URI addedNodePath = null;
        if (nodeType.startsWith(".") && this.isCmdiMetaDataNode()) {
            CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
            addedNodePath = componentBuilder.insertChildComponent(this, targetXmlPath, nodeType);
        } else if (this.getNodeTemplate().isImdiChildType(nodeType) || resourceUri != null && this.isSession()) {
            System.out.println("adding to current node");
            ImdiTreeObject destinationNode = this;
            try {
                Object componentBuilder = this.domLockObject;
                synchronized (componentBuilder) {
                    OurURL inUrlLocal = new OurURL(this.nodeUri.toURL());
                    System.out.println("inUrlLocal: " + inUrlLocal);
                    Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
                    if (nodDom == null) {
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The IMDI file could not be opened via the IMDI API", "Add Node");
                        GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                    } else {
                        addedNodePath = ImdiSchema.getSingleInstance().insertFromTemplate(this.getNodeTemplate(), this.getURI(), this.getSubDirectory(), nodeType, targetXmlPath, nodDom, resourceUri, mimeType);
                        this.bumpHistory();
                        api.writeDOM(nodDom, this.getFile(), false);
                    }
                }
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
            }
        } else {
            System.out.println("adding new node");
            URI targetFileURI = LinorgSessionStorage.getSingleInstance().getNewImdiFileName(this.getSubDirectory(), nodeType);
            if (CmdiProfileReader.pathIsProfile(nodeType)) {
                CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
                try {
                    addedNodePath = componentBuilder.createComponentFile(targetFileURI, new URI(nodeType));
                }
                catch (URISyntaxException ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                    return null;
                }
            } else {
                addedNodePath = ImdiSchema.getSingleInstance().addFromTemplate(new File(targetFileURI), nodeType);
            }
            ImdiTreeObject destinationNode = ImdiLoader.getSingleInstance().getImdiObject(null, targetFileURI);
            if (this.getFile().exists()) {
                this.addCorpusLink(destinationNode);
                this.reloadNode();
            } else {
                TreeHelper.getSingleInstance().addLocation(destinationNode.getURI());
                TreeHelper.getSingleInstance().applyRootLocations();
            }
        }
        return addedNodePath;
    }

    public boolean containsFieldValue(String fieldName, String searchValue) {
        boolean findResult = false;
        ImdiField[] currentFieldArray = this.fieldHashtable.get(fieldName);
        if (currentFieldArray != null) {
            for (ImdiField currentField : currentFieldArray) {
                System.out.println("containsFieldValue: " + currentField.fieldValue + ":" + searchValue);
                if (!currentField.fieldValue.toLowerCase().contains(searchValue.toLowerCase())) continue;
                return true;
            }
        }
        System.out.println("result: " + findResult + ":" + this);
        return findResult;
    }

    public boolean containsFieldValue(String searchValue) {
        boolean findResult = false;
        for (ImdiField[] currentFieldArray : this.fieldHashtable.values()) {
            for (ImdiField currentField : currentFieldArray) {
                System.out.println("containsFieldValue: " + currentField.fieldValue + ":" + searchValue);
                if (!currentField.fieldValue.toLowerCase().contains(searchValue.toLowerCase())) continue;
                return true;
            }
        }
        System.out.println("result: " + findResult + ":" + this);
        return findResult;
    }

    public boolean getNodeEnabled() {
        return this.nodeEnabled;
    }

    public boolean canHaveChildren() {
        return this.childArray.length > 0;
    }

    private void getAllFields(Vector<ImdiField[]> allFields) {
        System.out.println("getAllFields: " + this.toString());
        allFields.addAll(this.fieldHashtable.values());
        for (ImdiTreeObject currentChild : this.childArray) {
            if (!currentChild.isImdiChild()) continue;
            currentChild.getAllFields(allFields);
        }
    }

    public void deleteFeilds(ImdiField[] targetImdiFields) {
        ArrayList<String> domIdList = new ArrayList<String>();
        for (ImdiField currentField : targetImdiFields) {
            domIdList.add(currentField.fieldID);
        }
        this.deleteFromDomViaId(domIdList.toArray(new String[0]));
    }

    public void deleteCorpusLink(ImdiTreeObject[] targetImdiNodes) {
        ArrayList<String> fieldIdList = new ArrayList<String>();
        String linkIdString = null;
        for (String[] stringArray : this.childLinks) {
            String currentChildPath = stringArray[0];
            for (ImdiTreeObject currentImdiNode : targetImdiNodes) {
                if (!currentChildPath.equals(currentImdiNode.getUrlString())) continue;
                linkIdString = stringArray[1];
                fieldIdList.add(linkIdString);
            }
        }
        if (fieldIdList.size() > 0) {
            this.deleteFromDomViaId(fieldIdList.toArray(new String[0]));
        }
        for (String[] stringArray : targetImdiNodes) {
            if (!stringArray.isCatalogue()) continue;
            this.deleteCatalogueLink();
        }
        this.clearIcon();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCatalogueLink() {
        try {
            if (this.needsSaveToDisk) {
                this.saveChangesToCache(false);
            }
            Object object = this.domLockObject;
            synchronized (object) {
                OurURL inUrlLocal = new OurURL(this.nodeUri.toURL());
                Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
                if (nodDom == null) {
                    GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error loading via the IMDI API", "Remove Catalogue");
                } else {
                    api.createIMDILink(nodDom, null, "", "", 8, "");
                    this.bumpHistory();
                    api.writeDOM(nodDom, this.getFile(), false);
                    this.reloadNode();
                }
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFromDomViaId(String[] domIdArray) {
        try {
            if (this.needsSaveToDisk) {
                this.saveChangesToCache(false);
            }
            Object object = this.domLockObject;
            synchronized (object) {
                OurURL inUrlLocal = new OurURL(this.nodeUri.toURL());
                Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
                if (nodDom == null) {
                    GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error removing via the IMDI API", "Remove");
                } else {
                    for (String currentImdiDomId : domIdArray) {
                        IMDIElement target = new IMDIElement(null, currentImdiDomId);
                        api.removeIMDIElement(nodDom, target);
                    }
                    this.bumpHistory();
                    api.writeDOM(nodDom, this.getFile(), false);
                    this.reloadNode();
                }
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public boolean hasCatalogue() {
        for (ImdiTreeObject childNode : this.childArray) {
            if (!childNode.isCatalogue()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addCorpusLink(ImdiTreeObject targetImdiNode) {
        boolean linkAlreadyExists = false;
        if (targetImdiNode.isCatalogue() && this.hasCatalogue()) {
            return false;
        }
        for (String[] currentLinkPair : this.childLinks) {
            String currentChildPath = currentLinkPair[0];
            if (!targetImdiNode.waitTillLoaded()) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error adding node, could not wait for file to load", "Loading Error");
                return false;
            }
            if (!currentChildPath.equals(targetImdiNode.getUrlString())) continue;
            linkAlreadyExists = true;
        }
        if (targetImdiNode.getUrlString().equals(this.getUrlString())) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot link or move a node into itself", null);
            return false;
        }
        if (linkAlreadyExists) {
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue(targetImdiNode + " already exists in " + this + " and will not be added again", null);
            return false;
        }
        if (this.needsSaveToDisk) {
            this.saveChangesToCache(true);
        }
        try {
            Object len$ = this.domLockObject;
            synchronized (len$) {
                OurURL inUrlLocal = new OurURL(this.nodeUri.toURL());
                Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
                if (nodDom == null) {
                    GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API", "Add Link");
                    return false;
                }
                int nodeType = 2;
                if (targetImdiNode.isSession()) {
                    nodeType = 1;
                } else if (targetImdiNode.isCatalogue()) {
                    nodeType = 8;
                }
                System.out.println("createIMDILink: " + targetImdiNode.getUrlString());
                api.createIMDILink(nodDom, inUrlLocal, targetImdiNode.getUrlString(), "", nodeType, "");
                this.bumpHistory();
                api.writeDOM(nodDom, this.getFile(), false);
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImdiFileNodeIds() {
        if (this.getParentDomNode() != this) {
            this.getParentDomNode().updateImdiFileNodeIds();
        } else {
            System.out.println("updateImdiFileNodeIds");
            try {
                Object object = this.domLockObject;
                synchronized (object) {
                    OurURL inUrlLocal = new OurURL(this.nodeUri.toURL());
                    Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
                    if (nodDom == null) {
                        GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API", "Update IMDI");
                        return;
                    }
                    api.writeDOM(nodDom, this.getFile(), true);
                    Document nodDomSecondLoad = api.loadIMDIDocument(inUrlLocal, false, null);
                    if (nodDom == null) {
                        GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API", "Update IMDI");
                        return;
                    }
                    api.writeDOM(nodDomSecondLoad, this.getFile(), false);
                }
                this.loadImdiDom();
            }
            catch (Exception mue) {
                GuiHelper.linorgBugCatcher.logError(mue);
                System.out.println("Invalid input URL: " + mue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportImdiFile(File exportFile) {
        try {
            Object object = this.domLockObject;
            synchronized (object) {
                Document nodDom = api.loadIMDIDocument(new OurURL(this.nodeUri.toURL()), false);
                if (nodDom == null) {
                    GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API", "Export IMDI");
                } else {
                    api.writeDOM(nodDom, exportFile, true);
                }
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public void pasteIntoNode() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transfer = clipboard.getContents(null);
        try {
            String clipBoardString = "";
            Object clipBoardData = transfer.getTransferData(DataFlavor.stringFlavor);
            if (clipBoardData != null) {
                clipBoardString = clipBoardData.toString();
                System.out.println("clipBoardString: " + clipBoardString);
                if (this.isCorpus()) {
                    if (ImdiTreeObject.isPathMetadata(clipBoardString) || ImdiTreeObject.isStringImdiChild(clipBoardString)) {
                        ImdiTreeObject clipboardNode = ImdiLoader.getSingleInstance().getImdiObject(null, ImdiTreeObject.conformStringToUrl(clipBoardString));
                        if (LinorgSessionStorage.getSingleInstance().pathIsInsideCache(clipboardNode.getFile())) {
                            if (!ImdiTreeObject.isStringImdiChild(clipBoardString) || this.isSession() || this.isImdiChild()) {
                                if (this.getFile().exists()) {
                                    this.requestAddNode("copy of " + clipboardNode, clipboardNode);
                                } else {
                                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The target node's file does not exist", null);
                                }
                            } else {
                                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot paste session subnodes into a corpus", null);
                            }
                        } else {
                            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("The target file is not in the cache", null);
                        }
                    } else {
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Pasted string is not and IMDI file", null);
                    }
                } else {
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Only corpus branches can be pasted into at this stage", null);
                }
            }
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
        }
    }

    public boolean requestAddNode(String nodeTypeDisplayName, ImdiTreeObject addableImdiNode) {
        if (this.isCmdiMetaDataNode()) {
            CmdiComponentBuilder componentBuilder = new CmdiComponentBuilder();
            URI addedNodePath = componentBuilder.insertResourceProxy(this, addableImdiNode);
            return true;
        }
        boolean returnValue = true;
        ImdiTreeObject[] sourceImdiNodeArray = addableImdiNode.isEmptyMetaNode() ? addableImdiNode.getChildArray() : new ImdiTreeObject[]{addableImdiNode};
        for (ImdiTreeObject currentImdiNode : sourceImdiNodeArray) {
            String nodeType;
            String favouriteUrlString = null;
            String resourceUrl = null;
            String mimeType = null;
            if (currentImdiNode.isArchivableFile() && !currentImdiNode.isMetaDataNode()) {
                nodeType = ImdiSchema.getSingleInstance().getNodeTypeFromMimeType(currentImdiNode.mpiMimeType);
                resourceUrl = currentImdiNode.getUrlString();
                mimeType = currentImdiNode.mpiMimeType;
                nodeTypeDisplayName = "Resource";
            } else {
                nodeType = LinorgFavourites.getSingleInstance().getNodeType(currentImdiNode, this);
                favouriteUrlString = currentImdiNode.getUrlString();
            }
            if (nodeType == null) {
                returnValue = false;
            }
            String targetXmlPath = this.nodeUri.getFragment();
            if (nodeType == null) {
                LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Cannot add this type of node", null);
                continue;
            }
            System.out.println("requestAddNode: " + nodeType + " : " + nodeTypeDisplayName + " : " + favouriteUrlString + " : " + resourceUrl);
            this.getParentDomNode().addQueue.add(new String[]{nodeType, targetXmlPath, nodeTypeDisplayName, favouriteUrlString, resourceUrl, mimeType});
            ImdiLoader.getSingleInstance().requestReload(this);
        }
        return returnValue;
    }

    public void requestAddNode(String nodeType, String nodeTypeDisplayName) {
        System.out.println("requestAddNode: " + nodeType + " : " + nodeTypeDisplayName);
        this.getParentDomNode().addQueue.add(new String[]{nodeType, this.nodeUri.getFragment(), nodeTypeDisplayName, null, null, null});
        ImdiLoader.getSingleInstance().requestReload(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChangesToCache(boolean updateUI) {
        if (this.isImdiChild()) {
            this.getParentDomNode().saveChangesToCache(updateUI);
            return;
        }
        System.out.println("saveChangesToCache");
        LinorgJournal.getSingleInstance().clearFieldChangeHistory();
        OurURL inUrlLocal = null;
        if (!this.isLocal()) {
            System.out.println("should not try to save remote files");
            return;
        }
        System.out.println("tempUrlString: " + this.getFile());
        try {
            Object object = this.domLockObject;
            synchronized (object) {
                inUrlLocal = new OurURL(this.nodeUri.toURL());
                Document nodDom = api.loadIMDIDocument(inUrlLocal, false);
                if (nodDom == null) {
                    GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                    LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API", "Save IMDI");
                } else {
                    System.out.println("writeDOM");
                    Vector<ImdiField[]> allFields = new Vector<ImdiField[]>();
                    this.getAllFields(allFields);
                    Vector<ImdiField> addedFields = new Vector<ImdiField>();
                    Enumeration<Object> fieldsEnum = allFields.elements();
                    while (fieldsEnum.hasMoreElements()) {
                        ImdiField[] currentFieldArray = fieldsEnum.nextElement();
                        for (int fieldCounter = 0; fieldCounter < currentFieldArray.length; ++fieldCounter) {
                            ImdiField currentField = currentFieldArray[fieldCounter];
                            if (!currentField.fieldNeedsSaveToDisk()) continue;
                            if (currentField.fieldID == null) {
                                addedFields.add(currentField);
                                continue;
                            }
                            System.out.println("trying to save: " + currentField.fieldID + " : " + currentField.getFieldValue());
                            String keyName = currentField.getKeyName();
                            if (keyName != null) {
                                api.setKeyValuePair(nodDom, currentField.fieldID, keyName, currentField.getFieldValue());
                            } else {
                                IMDIElement changedElement = new IMDIElement(null, currentField.fieldID);
                                changedElement.setValue(currentField.getFieldValue());
                                IMDIElement ie = api.setIMDIElement(nodDom, changedElement);
                                System.out.println("ie spec: " + ie.getSpec());
                                System.out.println("ie.id: " + ie.getDomId());
                                System.out.println("ie.spec: " + ie.getSpec());
                            }
                            String fieldLanguageId = currentField.getLanguageId();
                            if (fieldLanguageId == null) continue;
                            IMDILink changedLink = api.getIMDILink(nodDom, null, currentField.fieldID);
                            System.out.println("trying to save language id: " + fieldLanguageId);
                            changedLink.setLanguageId(fieldLanguageId);
                            api.changeIMDILink(nodDom, null, changedLink);
                            LinorgJournal.getSingleInstance().saveJournalEntry(currentField.parentImdi.getUrlString(), currentField.xmlPath + ":LanguageId", fieldLanguageId, "", "save");
                        }
                    }
                    fieldsEnum = addedFields.elements();
                    while (fieldsEnum.hasMoreElements()) {
                        ImdiField currentField = (ImdiField)fieldsEnum.nextElement();
                    }
                    this.bumpHistory();
                    api.writeDOM(nodDom, this.getFile(), true);
                    nodDom = api.loadIMDIDocument(inUrlLocal, false);
                    if (nodDom == null) {
                        GuiHelper.linorgBugCatcher.logError(new Exception(api.getMessage()));
                        LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error reading via the IMDI API after save", "Update IMDI");
                    } else {
                        api.writeDOM(nodDom, this.getFile(), false);
                    }
                }
            }
        }
        catch (Exception mue) {
            GuiHelper.linorgBugCatcher.logError(mue);
            LinorgWindowManager.getSingleInstance().addMessageDialogToQueue("Error saving via the IMDI API", "Save Error");
        }
    }

    public void addField(ImdiField fieldToAdd) {
        ImdiField[] currentFieldsArray = this.fieldHashtable.get(fieldToAdd.getTranslateFieldName());
        if (currentFieldsArray == null) {
            currentFieldsArray = new ImdiField[]{fieldToAdd};
        } else {
            ImdiField[] appendedFieldsArray = new ImdiField[currentFieldsArray.length + 1];
            System.arraycopy(currentFieldsArray, 0, appendedFieldsArray, 0, currentFieldsArray.length);
            appendedFieldsArray[appendedFieldsArray.length - 1] = fieldToAdd;
            currentFieldsArray = appendedFieldsArray;
        }
        this.fieldHashtable.put(fieldToAdd.getTranslateFieldName(), currentFieldsArray);
        if (fieldToAdd.xmlPath.endsWith(".ResourceLink") && fieldToAdd.parentImdi.isImdiChild()) {
            this.resourceUrlField = fieldToAdd;
            MimeHashQueue.getSingleInstance().addToQueue(this);
        }
    }

    public Hashtable<String, ImdiField[]> getFields() {
        return this.fieldHashtable;
    }

    public int compareTo(Object o) throws ClassCastException {
        ImdiTreeNodeSorter imdiTreeNodeSorter = new ImdiTreeNodeSorter();
        return imdiTreeNodeSorter.compare(this, o);
    }

    public synchronized void notifyLoaded() {
        System.out.println("notifyAll");
        this.getParentDomNode().notifyAll();
    }

    public synchronized boolean waitTillLoaded() {
        System.out.println("waitTillLoaded");
        if (this.isLoading()) {
            System.out.println("isLoading");
            try {
                this.getParentDomNode().wait();
                System.out.println("wait");
                if (this.isLoading()) {
                    System.out.println("but still loading");
                }
            }
            catch (Exception ex) {
                GuiHelper.linorgBugCatcher.logError(ex);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLoadingState(int countChange) {
        if (this != this.getParentDomNode()) {
            this.getParentDomNode().updateLoadingState(countChange);
        } else {
            Object object = this.loadingCountLock;
            synchronized (object) {
                this.isLoadingCount += countChange;
            }
            System.out.println("isLoadingCount: " + this.isLoadingCount);
            if (!this.isLoading()) {
                this.clearChildIcons();
                this.clearIcon();
            }
        }
    }

    public boolean isLoading() {
        return this.getParentDomNode().isLoadingCount > 0;
    }

    public String toString() {
        if (this.isLoading()) {
            return this.lastNodeText;
        }
        if (this.lastNodeText.equals("loading imdi...") && this.getParentDomNode().imdiDataLoaded) {
            this.lastNodeText = "                      ";
        }
        boolean foundPreferredNameField = false;
        block2: for (String currentPreferredName : this.getNodeTemplate().preferredNameFields) {
            ImdiField[] currentFieldArray = this.fieldHashtable.get(currentPreferredName);
            if (currentFieldArray == null) continue;
            for (ImdiField currentField : currentFieldArray) {
                if (currentField == null || currentField.toString().trim().length() <= 0) continue;
                this.nodeText = currentField.toString();
                System.out.println("nodeText: " + this.nodeText);
                foundPreferredNameField = true;
                break block2;
            }
        }
        if (!foundPreferredNameField && this.isCmdiMetaDataNode() && this.domParentImdi == this && this.nodeTemplate != null) {
            this.nodeText = "unnamed (" + this.nodeTemplate.getTemplateName() + ")";
        }
        if (this.hasResource()) {
            String resourcePathString = this.getFullResourceURI().toString();
            int lastIndex = resourcePathString.lastIndexOf("/");
            resourcePathString = resourcePathString.substring(lastIndex + 1);
            try {
                resourcePathString = URLDecoder.decode(resourcePathString, "UTF-8");
            }
            catch (UnsupportedEncodingException encodingException) {
                GuiHelper.linorgBugCatcher.logError(encodingException);
            }
            this.nodeText = resourcePathString;
        }
        if (this.nodeText != null) {
            File nodeFile;
            if (this.isMetaDataNode() && (nodeFile = this.getFile()) != null && !this.isHeadRevision()) {
                this.nodeText = this.nodeText + " (rev:" + this.getHistoryLabelStringForFile(nodeFile) + ")";
            }
            this.lastNodeText = this.nodeText;
        }
        if (this.lastNodeText.length() == 0) {
            this.lastNodeText = "                      ";
        }
        return this.lastNodeText;
    }

    public boolean isArchivableFile() {
        return this.mpiMimeType != null;
    }

    public boolean hasResource() {
        return this.resourceUrlField != null;
    }

    public boolean hasLocalResource() {
        if (!this.hasResource()) {
            return false;
        }
        if (this.resourceUrlField.fieldValue.toLowerCase().startsWith("http")) {
            return false;
        }
        return this.isLocal();
    }

    public boolean resourceFileNotFound() {
        if (this.hasLocalResource()) {
            if (this.resourceUrlField.fieldValue.length() == 0) {
                return true;
            }
            try {
                return !new File(this.getFullResourceURI()).exists();
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    private String getResource() {
        return this.resourceUrlField.fieldValue;
    }

    public boolean hasHistory() {
        if (!this.isLocal()) {
            return false;
        }
        return !this.isImdiChild() && new File(this.getFile().getAbsolutePath() + ".0").exists();
    }

    private String getHistoryLabelStringForFile(File historyFile) {
        Date mtime = new Date(historyFile.lastModified());
        String mTimeString = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(mtime);
        return mTimeString;
    }

    private boolean isHeadRevision() {
        return !new File(this.getFile().getAbsolutePath() + ".x").exists();
    }

    public String[][] getHistoryList() {
        File currentHistoryFile;
        Vector<String[]> historyVector = new Vector<String[]>();
        int versionCounter = 0;
        if (!this.isHeadRevision()) {
            historyVector.add(new String[]{"Last Save", ".x"});
        }
        do {
            if ((currentHistoryFile = new File(this.getFile().getAbsolutePath() + "." + versionCounter)).exists()) {
                String mTimeString = this.getHistoryLabelStringForFile(currentHistoryFile);
                historyVector.add(new String[]{mTimeString, "." + versionCounter});
            }
            ++versionCounter;
        } while (currentHistoryFile.exists());
        return (String[][])historyVector.toArray((T[])new String[][]{new String[0]});
    }

    public boolean resurrectHistory(String historyVersion) {
        try {
            if (historyVersion.equals(".x")) {
                this.getFile().delete();
                new File(this.getFile().getAbsolutePath() + ".x").renameTo(this.getFile());
            } else {
                int len;
                LinorgWindowManager.getSingleInstance().offerUserToSaveChanges();
                if (!new File(this.getFile().getAbsolutePath() + ".x").exists()) {
                    this.getFile().renameTo(new File(this.getFile().getAbsolutePath() + ".x"));
                } else {
                    this.getFile().delete();
                }
                FileInputStream hisoryFile = new FileInputStream(new File(this.getFile().getAbsolutePath() + historyVersion));
                FileOutputStream activeVersionFile = new FileOutputStream(this.getFile(), true);
                byte[] copyBuffer = new byte[1024];
                while ((len = ((InputStream)hisoryFile).read(copyBuffer)) > 0) {
                    ((OutputStream)activeVersionFile).write(copyBuffer, 0, len);
                }
                ((InputStream)hisoryFile).close();
                ((OutputStream)activeVersionFile).close();
            }
            ImdiLoader.getSingleInstance().requestReload(this.getParentDomNode());
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public void bumpHistory() {
        int versionCounter = 0;
        File headVersion = this.getFile();
        if (new File(this.getFile().getAbsolutePath() + ".x").exists()) {
            ++versionCounter;
            headVersion = new File(this.getFile().getAbsolutePath() + ".x");
        }
        while (new File(this.getFile().getAbsolutePath() + "." + versionCounter).exists()) {
            ++versionCounter;
        }
        while (versionCounter >= 0) {
            File lastFile = new File(this.getFile().getAbsolutePath() + "." + versionCounter);
            File nextFile = new File(this.getFile().getAbsolutePath() + "." + --versionCounter);
            if (versionCounter >= 0) {
                nextFile.renameTo(lastFile);
                System.out.println("renaming: " + nextFile + " : " + lastFile);
                continue;
            }
            headVersion.renameTo(lastFile);
            System.out.println("renaming: " + headVersion + " : " + lastFile);
        }
    }

    public URI getFullResourceURI() {
        try {
            boolean isUncPath;
            String targetUriString = this.resourceUrlField.fieldValue;
            URI targetUri = new URI(null, targetUriString, null);
            URI resourceUri = this.nodeUri.resolve(targetUri);
            if (!targetUri.equals(resourceUri) && (isUncPath = this.nodeUri.toString().toLowerCase().startsWith("file:////"))) {
                try {
                    resourceUri = new URI("file:////" + resourceUri.toString().substring("file:/".length()));
                }
                catch (URISyntaxException urise) {
                    GuiHelper.linorgBugCatcher.logError(urise);
                }
            }
            return resourceUri;
        }
        catch (Exception urise) {
            GuiHelper.linorgBugCatcher.logError(urise);
            System.out.println("URISyntaxException: " + urise.getMessage());
            return null;
        }
    }

    public String getUrlString() {
        return this.nodeUri.toString();
    }

    public ImdiTreeObject getParentDomNode() {
        if (this.domParentImdi == null) {
            if (this.nodeUri.getFragment() != null) {
                try {
                    this.domParentImdi = ImdiLoader.getSingleInstance().getImdiObject(null, new URI(this.nodeUri.toString().split("#")[0]));
                }
                catch (URISyntaxException ex) {
                    GuiHelper.linorgBugCatcher.logError(ex);
                }
            } else {
                this.domParentImdi = this;
            }
        }
        return this.domParentImdi;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean isMetaDataNode() {
        if (this.nodeUri != null) {
            if (this.isImdiChild()) {
                return true;
            }
            return ImdiTreeObject.isPathMetadata(this.nodeUri.getPath());
        }
        return false;
    }

    public boolean isCmdiMetaDataNode() {
        if (this.nodeUri != null) {
            if (this.isImdiChild()) {
                return this.getParentDomNode().isCmdiMetaDataNode();
            }
            return ImdiTreeObject.isPathCmdi(this.nodeUri.getPath());
        }
        return false;
    }

    public boolean isImdiChild() {
        return ImdiTreeObject.isStringImdiChild(this.getUrlString());
    }

    public boolean isSession() {
        ImdiField[] nameFields = this.fieldHashtable.get("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Session" + ImdiSchema.imdiPathSeparator + "Name");
        }
        return false;
    }

    public boolean isEmptyMetaNode() {
        return this.getFields().size() == 0;
    }

    public boolean isCatalogue() {
        ImdiField[] nameFields = this.fieldHashtable.get("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Catalogue" + ImdiSchema.imdiPathSeparator + "Name");
        }
        return false;
    }

    public boolean isCorpus() {
        if (this.isCmdiMetaDataNode()) {
            return false;
        }
        ImdiField[] nameFields = this.fieldHashtable.get("Name");
        if (nameFields != null) {
            return nameFields[0].xmlPath.equals(ImdiSchema.imdiPathSeparator + "METATRANSCRIPT" + ImdiSchema.imdiPathSeparator + "Corpus" + ImdiSchema.imdiPathSeparator + "Name");
        }
        return false;
    }

    public boolean isLocal() {
        if (this.nodeUri != null) {
            return ImdiTreeObject.isStringLocal(this.nodeUri.getScheme());
        }
        return false;
    }

    public URI getURI() {
        try {
            return this.nodeUri;
        }
        catch (Exception ex) {
            GuiHelper.linorgBugCatcher.logError(ex);
            return null;
        }
    }

    public File getFile() {
        if (this.nodeUri.getScheme().toLowerCase().equals("file")) {
            try {
                return new File(new URI(this.nodeUri.toString().split("#")[0]));
            }
            catch (Exception urise) {
                System.err.println("nodeUri: " + this.nodeUri);
                GuiHelper.linorgBugCatcher.logError(urise);
            }
        }
        return null;
    }

    public String getParentDirectory() {
        String parentPath = this.getUrlString().substring(0, this.getUrlString().lastIndexOf("/")) + "/";
        return parentPath;
    }

    public void registerContainer(Object containerToAdd) {
        if (!this.getParentDomNode().imdiDataLoaded && !this.isLoading()) {
            ImdiLoader.getSingleInstance().requestReload(this.getParentDomNode());
        }
        if (containerToAdd != null) {
            this.containersOfThisNode.add(containerToAdd);
        }
    }

    public Object[] getRegisteredContainers() {
        if (this.containersOfThisNode != null && this.containersOfThisNode.size() > 0) {
            return this.containersOfThisNode.toArray();
        }
        return new Object[0];
    }

    public void removeContainer(Object containerToRemove) {
        this.containersOfThisNode.remove(containerToRemove);
    }

    public void clearChildIcons() {
        for (ImdiTreeObject currentChild : this.childArray) {
            currentChild.clearChildIcons();
            currentChild.clearIcon();
        }
    }

    public void clearIcon() {
        this.icon = ImdiIcons.getSingleInstance().getIconForImdi(this);
        Enumeration containersIterator = this.containersOfThisNode.elements();
        while (containersIterator.hasMoreElements()) {
            try {
                Object currentContainer = containersIterator.nextElement();
                if (currentContainer instanceof ImdiTableModel) {
                    ((ImdiTableModel)currentContainer).requestReloadTableData();
                }
                if (currentContainer instanceof ImdiChildCellEditor) {
                    ((ImdiChildCellEditor)currentContainer).updateEditor(this);
                }
                if (!(currentContainer instanceof DefaultMutableTreeNode)) continue;
                DefaultMutableTreeNode currentTreeNode = (DefaultMutableTreeNode)currentContainer;
                DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)((DefaultMutableTreeNode)currentContainer).getParent();
                if (parentNode != null) {
                    TreeHelper.getSingleInstance().addToSortQueue(parentNode);
                    continue;
                }
                TreeHelper.getSingleInstance().addToSortQueue(currentTreeNode);
            }
            catch (NoSuchElementException noSuchElementException) {}
        }
    }

    public boolean isFavorite() {
        if (!this.isLocal()) {
            return false;
        }
        return LinorgSessionStorage.getSingleInstance().pathIsInFavourites(this.getFile());
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            return ImdiIcons.getSingleInstance().loadingIcon;
        }
        return this.icon;
    }
}

